/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutRegular;
import ucar.nc2.iosp.hdf4.H4header;
import ucar.nc2.iosp.hdf4.HdfEos;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.hdf5.H5tiledLayout;
import ucar.nc2.iosp.hdf5.H5tiledLayoutBB;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.unidata.io.RandomAccessFile;

public class H5iosp
extends AbstractIOServiceProvider {
    public static final String IOSP_MESSAGE_INCLUDE_ORIGINAL_ATTRIBUTES = "IncludeOrgAttributes";
    static boolean debug = false;
    static boolean debugPos = false;
    static boolean debugHeap = false;
    static boolean debugFilter = false;
    static boolean debugFilterDetails = false;
    static boolean debugString = false;
    static boolean debugFilterIndexer = false;
    static boolean debugChunkIndexer = false;
    static boolean debugVlen = false;
    static boolean debugStructure = false;
    static boolean skipEos = false;
    private static Logger log = LoggerFactory.getLogger(H5iosp.class);
    private H5header headerParser;
    private boolean isEos;
    boolean includeOriginalAttributes = false;

    public static void setDebugFlags(DebugFlags debugFlag) {
        debug = debugFlag.isSet("H5iosp/read");
        debugPos = debugFlag.isSet("H5iosp/filePos");
        debugHeap = debugFlag.isSet("H5iosp/Heap");
        debugFilter = debugFlag.isSet("H5iosp/filter");
        debugFilterIndexer = debugFlag.isSet("H5iosp/filterIndexer");
        debugChunkIndexer = debugFlag.isSet("H5iosp/chunkIndexer");
        debugVlen = debugFlag.isSet("H5iosp/vlen");
        skipEos = debugFlag.isSet("HdfEos/turnOff");
        H5header.setDebugFlags(debugFlag);
        H4header.setDebugFlags(debugFlag);
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return H5header.isValidFile(raf);
    }

    @Override
    public String getFileTypeId() {
        if (this.isEos) {
            return "HDF5-EOS";
        }
        if (this.headerParser.isNetcdf4) {
            return DataFormatType.NETCDF4.toString();
        }
        return DataFormatType.HDF5.toString();
    }

    @Override
    public String getFileTypeDescription() {
        return "Hierarchical Data Format, version 5";
    }

    public void getEosInfo(Formatter f) throws IOException {
        NetcdfFile ncfile = this.headerParser.ncfile;
        Group eosInfo = ncfile.getRootGroup().findGroup("HDFEOS_INFORMATION");
        if (eosInfo != null) {
            HdfEos.getEosInfo(ncfile, eosInfo, f);
        } else {
            f.format("Cant find GROUP '%s'", "HDFEOS_INFORMATION");
        }
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.headerParser = new H5header(this.raf, ncfile, this);
        this.headerParser.read(null);
        Group eosInfo = ncfile.getRootGroup().findGroup("HDFEOS_INFORMATION");
        if (eosInfo != null && !skipEos) {
            this.isEos = HdfEos.amendFromODL(ncfile, eosInfo);
        }
        ncfile.finish();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        H5header.Vinfo vinfo = (H5header.Vinfo)v2.getSPobject();
        return this.readData(v2, vinfo.dataPos, section);
    }

    private Array readData(Variable v2, long dataPos, Section wantSection) throws IOException, InvalidRangeException {
        Object data;
        Layout layout;
        H5header.Vinfo vinfo = (H5header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        if (vinfo.useFillValue) {
            Object pa = IospHelper.makePrimitiveArray((int)wantSection.computeSize(), dataType, vinfo.getFillValue());
            if (dataType == DataType.CHAR) {
                pa = IospHelper.convertByteToChar((byte[])pa);
            }
            return Array.factory(dataType.getPrimitiveClassType(), wantSection.getShape(), pa);
        }
        if (vinfo.mfp != null) {
            if (debugFilter) {
                System.out.println("read variable filtered " + v2.getFullName() + " vinfo = " + vinfo);
            }
            assert (vinfo.isChunked);
            ByteOrder bo = vinfo.typeInfo.endian == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            layout = new H5tiledLayoutBB(v2, wantSection, this.raf, vinfo.mfp.getFilters(), bo);
            data = IospHelper.readDataFill(layout, v2.getDataType(), vinfo.getFillValue());
        } else {
            if (debug) {
                System.out.println("read variable " + v2.getFullName() + " vinfo = " + vinfo);
            }
            DataType readDtype = v2.getDataType();
            int elemSize = v2.getElementSize();
            Object fillValue = vinfo.getFillValue();
            int endian = vinfo.typeInfo.endian;
            wantSection = Section.fill(wantSection, v2.getShape());
            if (vinfo.typeInfo.hdfType == 2) {
                readDtype = vinfo.mdt.timeType;
                elemSize = readDtype.getSize();
                fillValue = vinfo.getFillValueDefault(readDtype);
            } else if (vinfo.typeInfo.hdfType == 8) {
                H5header.TypeInfo baseInfo = vinfo.typeInfo.base;
                readDtype = baseInfo.dataType;
                elemSize = readDtype.getSize();
                fillValue = vinfo.getFillValueDefault(readDtype);
                endian = baseInfo.endian;
            } else if (vinfo.typeInfo.hdfType == 9) {
                elemSize = vinfo.typeInfo.byteSize;
                endian = vinfo.typeInfo.endian;
                wantSection = wantSection.removeVlen();
            }
            layout = vinfo.isChunked ? new H5tiledLayout((H5header.Vinfo)v2.getSPobject(), readDtype, wantSection) : new LayoutRegular(dataPos, elemSize, v2.getShape(), wantSection);
            data = this.readData(vinfo, v2, layout, readDtype, wantSection.getShape(), fillValue, endian);
        }
        if (data instanceof Array) {
            return (Array)data;
        }
        if (dataType == DataType.STRUCTURE) {
            return this.convertStructure((Structure)v2, layout, wantSection.getShape(), (byte[])data);
        }
        return Array.factory(dataType.getPrimitiveClassType(), wantSection.getShape(), data);
    }

    private Object readData(H5header.Vinfo vinfo, Variable v, Layout layout, DataType dataType, int[] shape, Object fillValue, int endian) throws IOException, InvalidRangeException {
        H5header.TypeInfo typeInfo = vinfo.typeInfo;
        if (typeInfo.hdfType == 2) {
            Object data = IospHelper.readDataFill(this.raf, layout, dataType, fillValue, endian, true);
            Array timeArray = Array.factory(dataType.getPrimitiveClassType(), shape, data);
            String[] stringData = new String[(int)timeArray.getSize()];
            int count = 0;
            while (timeArray.hasNext()) {
                long time = timeArray.nextLong();
                stringData[count++] = CalendarDate.of(time).toString();
            }
            return Array.factory(String.class, shape, (Object)stringData);
        }
        if (typeInfo.hdfType == 8) {
            Object data = IospHelper.readDataFill(this.raf, layout, dataType, fillValue, endian);
            return Array.factory(dataType.getPrimitiveClassType(), shape, data);
        }
        if (typeInfo.hdfType == 9 && !typeInfo.isVString) {
            DataType readType = dataType;
            if (typeInfo.isVString) {
                readType = DataType.BYTE;
            } else if (typeInfo.base.hdfType == 7) {
                readType = DataType.LONG;
            }
            Object[] data = new Object[(int)layout.getTotalNelems()];
            int count = 0;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    long address = chunk.getSrcPos() + (long)(layout.getElemSize() * i);
                    Array vlenArray = this.headerParser.getHeapDataArray(address, readType, endian);
                    data[count++] = typeInfo.base.hdfType == 7 ? this.convertReference(vlenArray) : vlenArray;
                }
            }
            return new ArrayObject(data[0].getClass(), shape, data);
        }
        if (dataType == DataType.STRUCTURE) {
            int recsize = layout.getElemSize();
            long size = (long)recsize * layout.getTotalNelems();
            byte[] byteArray = new byte[(int)size];
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                if (debugStructure) {
                    System.out.println(" readStructure " + v.getFullName() + " chunk= " + chunk + " index.getElemSize= " + layout.getElemSize());
                }
                this.raf.seek(chunk.getSrcPos());
                this.raf.read(byteArray, (int)chunk.getDestElem() * recsize, chunk.getNelems() * recsize);
            }
            return this.convertStructure((Structure)v, layout, shape, byteArray);
        }
        return this.readDataPrimitive(layout, dataType, shape, fillValue, endian, true);
    }

    Array convertReference(Array refArray) throws IOException {
        int nelems = (int)refArray.getSize();
        Index ima = refArray.getIndex();
        String[] result = new String[nelems];
        for (int i = 0; i < nelems; ++i) {
            long reference = refArray.getLong(ima.set(i));
            String name = this.headerParser.getDataObjectName(reference);
            String string = result[i] = name != null ? name : Long.toString(reference);
            if (!debugVlen) continue;
            System.out.printf(" convertReference 0x%x to %s %n", reference, result[i]);
        }
        return Array.factory(String.class, new int[]{nelems}, (Object)result);
    }

    private ArrayStructure convertStructure(Structure s, Layout layout, int[] shape, byte[] byteArray) throws IOException, InvalidRangeException {
        boolean hasHeap = false;
        StructureMembers sm = s.makeStructureMembers();
        for (StructureMembers.Member m : sm.getMembers()) {
            Variable v2 = s.findVariable(m.getName());
            H5header.Vinfo vm = (H5header.Vinfo)v2.getSPobject();
            if (vm.typeInfo.endian >= 0) {
                m.setDataObject(vm.typeInfo.endian == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            }
            m.setDataParam((int)vm.dataPos);
            if (v2.getDataType() != DataType.STRING && !v2.isVariableLength()) continue;
            hasHeap = true;
        }
        int recsize = layout.getElemSize();
        sm.setStructureSize(recsize);
        ByteBuffer bb = ByteBuffer.wrap(byteArray);
        ArrayStructureBB asbb = new ArrayStructureBB(sm, shape, bb, 0);
        if (hasHeap) {
            int destPos = 0;
            int i = 0;
            while ((long)i < layout.getTotalNelems()) {
                this.convertHeap(asbb, destPos, sm);
                destPos += layout.getElemSize();
                ++i;
            }
        }
        return asbb;
    }

    void convertHeap(ArrayStructureBB asbb, int pos, StructureMembers sm) throws IOException, InvalidRangeException {
        ByteBuffer bb = asbb.getByteBuffer();
        for (StructureMembers.Member m : sm.getMembers()) {
            if (m.getDataType() == DataType.STRING) {
                m.setDataObject(ByteOrder.nativeOrder());
                int size = m.getSize();
                int destPos = pos + m.getDataParam();
                String[] result = new String[size];
                for (int i = 0; i < size; ++i) {
                    result[i] = this.headerParser.readHeapString(bb, destPos + i * 16);
                }
                int index = asbb.addObjectToHeap(result);
                bb.order(ByteOrder.nativeOrder());
                bb.putInt(destPos, index);
                continue;
            }
            if (!m.isVariableLength()) continue;
            int destPos = pos + m.getDataParam();
            bb.order(ByteOrder.LITTLE_ENDIAN);
            ByteOrder bo = (ByteOrder)m.getDataObject();
            int endian = bo.equals(ByteOrder.LITTLE_ENDIAN) ? 1 : 0;
            Array vlenArray = this.headerParser.readHeapVlen(bb, destPos, m.getDataType(), endian);
            int index = asbb.addObjectToHeap(vlenArray);
            bb.order(ByteOrder.nativeOrder());
            bb.putInt(destPos, index);
        }
    }

    Object readDataPrimitive(Layout layout, DataType dataType, int[] shape, Object fillValue, int endian, boolean convertChar) throws IOException, InvalidRangeException {
        if (dataType == DataType.STRING) {
            int size = (int)layout.getTotalNelems();
            String[] sa = new String[size];
            int count = 0;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    sa[count++] = this.headerParser.readHeapString(chunk.getSrcPos() + (long)(layout.getElemSize() * i));
                }
            }
            return sa;
        }
        if (dataType == DataType.OPAQUE) {
            ArrayObject opArray = new ArrayObject(ByteBuffer.class, shape);
            assert (new Section(shape).computeSize() == layout.getTotalNelems());
            int count = 0;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                int recsize = layout.getElemSize();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    byte[] pa = new byte[recsize];
                    this.raf.seek(chunk.getSrcPos() + (long)(i * recsize));
                    this.raf.read(pa, 0, recsize);
                    ((Array)opArray).setObject(count++, (Object)ByteBuffer.wrap(pa));
                }
            }
            return opArray;
        }
        return IospHelper.readDataFill(this.raf, layout, dataType, fillValue, endian, convertChar);
    }

    private StructureData readStructure(Structure s, ArrayStructureW asw, long dataPos) throws IOException, InvalidRangeException {
        StructureDataW sdata = new StructureDataW(asw.getStructureMembers());
        if (debug) {
            System.out.println(" readStructure " + s.getFullName() + " dataPos = " + dataPos);
        }
        for (Variable v2 : s.getVariables()) {
            H5header.Vinfo vinfo = (H5header.Vinfo)v2.getSPobject();
            if (debug) {
                System.out.println(" readStructureMember " + v2.getFullName() + " vinfo = " + vinfo);
            }
            Array dataArray = this.readData(v2, dataPos + vinfo.dataPos, v2.getShapeAsSection());
            sdata.setMemberData(v2.getShortName(), dataArray);
        }
        return sdata;
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        this.raf = null;
        this.headerParser.close();
    }

    @Override
    public String toStringDebug(Object o) {
        if (o instanceof Variable) {
            Variable v = (Variable)o;
            H5header.Vinfo vinfo = (H5header.Vinfo)v.getSPobject();
            return vinfo.toString();
        }
        return null;
    }

    @Override
    public String getDetailInfo() {
        ByteArrayOutputStream ff = new ByteArrayOutputStream(100000);
        try {
            FakeNetcdfFile ncfile = new FakeNetcdfFile();
            H5header detailParser = new H5header(this.raf, ncfile, this);
            detailParser.read(new PrintStream(ff));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Formatter f = new Formatter();
        f.format("%s", super.getDetailInfo());
        f.format("%s", ff.toString());
        return f.toString();
    }

    @Override
    public Object sendIospMessage(Object message) {
        if (message.toString().equals(IOSP_MESSAGE_INCLUDE_ORIGINAL_ATTRIBUTES)) {
            this.includeOriginalAttributes = true;
            return null;
        }
        if (message.toString().equals("header")) {
            return this.headerParser;
        }
        if (message.toString().equals("headerEmpty")) {
            FakeNetcdfFile ncfile = new FakeNetcdfFile();
            H5header headerEmpty = new H5header(this.raf, ncfile, this);
            return headerEmpty;
        }
        return super.sendIospMessage(message);
    }

    NetcdfFile getNetcdfFile() {
        return this.headerParser.ncfile;
    }

    private static class FakeNetcdfFile
    extends NetcdfFile {
        private FakeNetcdfFile() {
        }
    }
}

