/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.wmo;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.util.StringUtil2;

public class CommonCodeTable
implements Comparable<CommonCodeTable> {
    private static final Logger logger = LoggerFactory.getLogger(CommonCodeTable.class);
    private static final Map<Integer, CommonCodeTable> tableMap = new HashMap<Integer, CommonCodeTable>();
    public final String tableName;
    public final int type;
    public final List<TableEntry> entries = new ArrayList<TableEntry>();
    private Map<Integer, String> map = null;
    private static final char badDash = '\u00ad';

    public static String getCenterName(int center_id, int edition) {
        String result;
        String string = result = edition == 1 ? CommonCodeTable.getTableValue(1, center_id) : CommonCodeTable.getTableValue(11, center_id);
        if (result != null) {
            return result;
        }
        if (center_id == 0) {
            return "WMO standard table";
        }
        return "Unknown center=" + center_id;
    }

    public static String getCenterNameBufr(int center_id, int edition) {
        String result;
        String string = result = edition < 4 ? CommonCodeTable.getTableValue(1, center_id) : CommonCodeTable.getTableValue(11, center_id);
        if (result != null) {
            return result;
        }
        if (center_id == 0) {
            return "WMO standard table";
        }
        return "Unknown center=" + center_id;
    }

    public static String getSubCenterName(int center_id, int subcenter_id) {
        return CommonCodeTable.getTableValue(12, center_id, subcenter_id);
    }

    public static String getDataSubcategoy(int cat, int subcat) {
        return CommonCodeTable.getTableValue(13, cat, subcat);
    }

    public static CommonCodeTable getTable(int tableNo) {
        CommonCodeTable cct = tableMap.get(tableNo);
        if (cct == null) {
            Table want = null;
            for (Table t : Table.values()) {
                if (t.num != tableNo) continue;
                want = t;
                break;
            }
            if (want == null) {
                throw new IllegalStateException("Unknown wmo common code table number= " + tableNo);
            }
            try {
                cct = CommonCodeTable.readCommonCodes(want);
                tableMap.put(tableNo, cct);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cant open wmo common code table " + (Object)((Object)want));
            }
        }
        return cct;
    }

    public static String getTableValue(int tableNo, int code) {
        CommonCodeTable cct = CommonCodeTable.getTable(tableNo);
        if (cct == null) {
            logger.error("WMO common table {} is not implemented", tableNo);
            return null;
        }
        TableEntry te = cct.get(code);
        if (te == null) {
            return null;
        }
        return te.value;
    }

    public static String getTableValue(int tableNo, int code, int code2) {
        CommonCodeTable cct = CommonCodeTable.getTable(tableNo);
        TableEntry te = cct.get(code, code2);
        if (te == null) {
            return null;
        }
        return te.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CommonCodeTable readCommonCodes(Table version) throws IOException {
        InputStream ios = null;
        try {
            Document doc;
            Class<CommonCodeTable> c = CommonCodeTable.class;
            ios = c.getResourceAsStream(version.getResourceName());
            if (ios == null) {
                throw new IllegalStateException("CommonCodeTable cant open " + version.getResourceName());
            }
            try {
                SAXBuilder builder = new SAXBuilder();
                doc = builder.build(ios);
            }
            catch (JDOMException e) {
                throw new IOException(e.getMessage());
            }
            Element root = doc.getRootElement();
            String previousValue = null;
            CommonCodeTable ct = new CommonCodeTable(version.name(), version.getTableType());
            String[] elems = version.getElemNames();
            List featList = root.getChildren(version.getRootElemName());
            for (Element elem : featList) {
                String code;
                String line;
                if (version.type == 1) {
                    Element statusElem;
                    String status;
                    line = elem.getChildTextNormalize("No");
                    code = elem.getChildTextNormalize(elems[0]);
                    String code2 = elems[1] != null ? elem.getChildTextNormalize(elems[1]) : null;
                    String value = elem.getChildTextNormalize(elems[2]);
                    if ((value == null || value.length() == 0) && elems[3] != null) {
                        value = elem.getChildTextNormalize(elems[3]);
                    }
                    String string = status = (statusElem = elem.getChild("Status")) == null ? null : statusElem.getTextNormalize();
                    if (value != null && value.equals(")")) {
                        value = previousValue;
                    }
                    ct.add(line, code, code2, value, status);
                    previousValue = value;
                    continue;
                }
                line = elem.getChildTextNormalize("No");
                code = elem.getChildTextNormalize(elems[0]);
                String value = elem.getChildTextNormalize(elems[1]);
                String code2 = elem.getChildTextNormalize(elems[2]);
                String value2 = elem.getChildTextNormalize(elems[3]);
                Element statusElem = elem.getChild("Status");
                String status = statusElem == null ? null : statusElem.getTextNormalize();
                ct.add(line, code, value, code2, value2, status);
            }
            ios.close();
            CommonCodeTable commonCodeTable = ct;
            return commonCodeTable;
        }
        finally {
            if (ios != null) {
                ios.close();
            }
        }
    }

    CommonCodeTable(String name, int type) {
        this.tableName = name;
        this.type = type;
    }

    void add(String line, String code, String code2, String value, String status) {
        this.entries.add(new TableEntry(line, code, code2, value, status));
    }

    void add(String line, String code, String value, String code2, String value2, String status) {
        this.entries.add(new TableEntry(line, code, value, code2, value2, status));
    }

    TableEntry get(int code) {
        for (TableEntry p : this.entries) {
            if (p.code != code) continue;
            return p;
        }
        return null;
    }

    TableEntry get(int code, int code2) {
        for (TableEntry p : this.entries) {
            if (p.code != code || p.code2 != code2) continue;
            return p;
        }
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<Integer, String> getMap() {
        if (this.map == null) {
            this.map = new HashMap<Integer, String>(this.entries.size() * 2);
            for (TableEntry p : this.entries) {
                this.map.put(p.code, p.value);
            }
        }
        return this.map;
    }

    @Override
    public int compareTo(CommonCodeTable o) {
        return this.tableName.compareTo(o.tableName);
    }

    String state() {
        HashSet<Integer> set = new HashSet<Integer>();
        int max = 0;
        int dups = 0;
        for (TableEntry entry : this.entries) {
            if (entry.comment != null) continue;
            if (entry.code > max) {
                max = entry.code;
            }
            if (set.contains(entry.code)) {
                ++dups;
                continue;
            }
            set.add(entry.code);
        }
        return "density= " + this.entries.size() + "/" + max + "; dups= " + dups;
    }

    private String filter(String s) {
        if (s == null) {
            return null;
        }
        return StringUtil2.replace(s, '\u00ad', "-");
    }

    public static void main(String[] arg) throws IOException {
        CommonCodeTable ct = CommonCodeTable.readCommonCodes(Table.C1);
        for (TableEntry entry : ct.entries) {
            System.out.printf("%s%n", entry);
        }
        System.out.printf("%n%s%n", ct.state());
    }

    public class TableEntry
    implements Comparable<TableEntry> {
        public int line;
        public int code;
        public int code2;
        public String value;
        public String status;
        public String comment;

        int parse(String s) {
            if (s == null) {
                return -1;
            }
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e2) {
                return -2;
            }
        }

        TableEntry(String line, String code1, String code2, String value, String status) {
            this.line = Integer.parseInt(line);
            this.code = this.parse(code1);
            if (this.code < 0) {
                this.code = this.parse(code2);
            }
            if (this.code < 1) {
                this.comment = value;
            } else {
                this.value = CommonCodeTable.this.filter(value);
                this.status = status;
            }
        }

        TableEntry(String line, String code1, String value1, String code2, String value2, String status) {
            this.line = Integer.parseInt(line);
            this.code = this.parse(code1);
            this.code2 = this.parse(code2);
            this.value = CommonCodeTable.this.filter(value2);
            this.comment = value1;
            this.status = status;
        }

        @Override
        public int compareTo(TableEntry o) {
            if (CommonCodeTable.this.type == 1) {
                return this.code - o.code;
            }
            int diff = this.code - o.code;
            return diff == 0 ? this.code2 - o.code2 : diff;
        }

        public String toString() {
            if (this.comment != null) {
                return "TableEntry{, line=" + this.line + ", comment=" + this.comment + '}';
            }
            return "TableEntry{, line=" + this.line + ", code=" + this.code + ", value='" + this.value + '\'' + ", status='" + this.status + '\'' + '}';
        }
    }

    public static enum Table {
        C1("Centers-GRIB1,BUFR3", 1, 1, new String[]{"CodeFigureForF1F2", "CodeFigureForF3F3F3", "OriginatingGeneratingCentres_en"}),
        C2("Radiosondes", 2, 1, new String[]{"CodeFigureForBUFR", null, "RadiosondeSoundingSystemUsed_en"}),
        C3("Water temperature profile instrument", 3, 1, new String[]{"CodeFigureForBUFR", null, "InstrumentMakeAndType_en"}),
        C4("Water temperature profile recorder", 4, 1, new String[]{"CodeFigureForBUFR", null, "Meaning_en"}),
        C5("Satellite identifier", 5, 1, new String[]{"CodeFigureForBUFR", null, "SatelliteName_en"}),
        C7("Satellite tracking", 7, 1, new String[]{"CodeFigureForBUFR", null, "TrackingTechniquesStatusOfSystemUsed_en"}),
        C8("Satellite instruments", 8, 1, new String[]{"Code", null, "InstrumentLongName_en", "InstrumentShortName_en"}),
        C11("Centers-GRIB2,BUFR4", 11, 1, new String[]{"GRIB2_BUFR4", null, "OriginatingGeneratingCentre_en"}),
        C12("Subcenters", 12, 2, new String[]{"CodeFigure_OriginatingCentres", "Name_OriginatingCentres_en", "CodeFigure_SubCentres", "Name_SubCentres_en"}),
        C13("Data sub-categories", 13, 2, new String[]{"CodeFigure_DataCategories", "Name_DataCategories_en", "CodeFigure_InternationalDataSubcategories", "Name_InternationalDataSubcategories_en"});

        String name;
        String[] elems;
        int num;
        int type;

        private Table(String name, int num, int type, String[] elems) {
            this.name = name;
            this.num = num;
            this.type = type;
            this.elems = elems;
        }

        public String getResourceName() {
            return "/resources/wmo/CommonCodeTable_" + this.name() + "_02Nov11_en.xml";
        }

        public String getRootElemName() {
            return "CommonCodeTable_" + this.name() + "_Nov11_en";
        }

        public int getTableNo() {
            return this.num;
        }

        public int getTableType() {
            return this.type;
        }

        String[] getElemNames() {
            return this.elems;
        }

        public String getName() {
            return this.name;
        }
    }
}

