/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import thredds.inventory.CollectionManager;
import thredds.inventory.MFile;
import ucar.nc2.grib.GribCollectionProto;
import ucar.unidata.util.StringUtil2;

public class GribCollectionBuilder {
    protected final CollectionManager dcm;
    protected final boolean isSingleFile;
    protected final Logger logger;

    protected GribCollectionBuilder(CollectionManager dcm, boolean isSingleFile, Logger logger) {
        this.dcm = dcm;
        this.isSingleFile = isSingleFile;
        this.logger = logger;
    }

    public static List<GcMFile> makeFiles(File directory, List<MFile> files) {
        ArrayList<GcMFile> result = new ArrayList<GcMFile>(files.size());
        String dirPath = StringUtil2.replace(directory.getPath(), '\\', "/");
        for (MFile file : files) {
            assert (file.getPath().startsWith(dirPath)) : file.getPath() + " != " + dirPath;
            String name = file.getPath().substring(dirPath.length());
            result.add(new GcMFile(directory, name, file.getLastModified()));
        }
        return result;
    }

    public static class GcMFile
    implements MFile {
        public final File directory;
        public final String name;
        public final long lastModified;

        public GcMFile(File directory, String name, long lastModified) {
            this.directory = directory;
            this.name = name;
            this.lastModified = lastModified;
        }

        public GcMFile(File directory, GribCollectionProto.MFile gcmfile) {
            this.directory = directory;
            this.name = gcmfile.getFilename();
            this.lastModified = gcmfile.getLastModified();
        }

        public GribCollectionProto.MFile makeProto() {
            GribCollectionProto.MFile.Builder b = GribCollectionProto.MFile.newBuilder();
            b.setFilename(this.name);
            b.setLastModified(this.lastModified);
            return b.build();
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public long getLength() {
            return 0L;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public String getPath() {
            String path = new File(this.directory, this.name).getPath();
            return StringUtil2.replace(path, '\\', "/");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(MFile o) {
            return this.name.compareTo(o.getName());
        }

        @Override
        public Object getAuxInfo() {
            return null;
        }

        @Override
        public void setAuxInfo(Object info) {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("GcMFile");
            sb.append("{directory=").append(this.directory);
            sb.append(", name='").append(this.name).append('\'');
            sb.append(", lastModified=").append(new Date(this.lastModified));
            sb.append('}');
            return sb.toString();
        }
    }
}

