/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.GribPds;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridTimeCoord;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;

public class GribTimeCoord
extends GridTimeCoord {
    private static Logger log = LoggerFactory.getLogger(GribTimeCoord.class);

    GribTimeCoord(List<GridRecord> records, String where) {
        super(records, where);
        GribGridRecord ggr = (GribGridRecord)records.get(0);
        if (!ggr.isInterval()) {
            return;
        }
        this.timeIntvs = this.refDateDiffers ? this.computeIntervalsWithDiff(records, true) : this.computeIntervals(records, true);
    }

    private List<GridTimeCoord.TimeCoordWithInterval> computeIntervals(List<GridRecord> records, boolean checkConstant) {
        boolean same = true;
        ArrayList<GridTimeCoord.TimeCoordWithInterval> result = new ArrayList<GridTimeCoord.TimeCoordWithInterval>(records.size());
        int intv = -1;
        for (GridRecord gr : records) {
            Date validTime;
            GridTimeCoord.TimeCoordWithInterval timeCoordIntv;
            int start;
            GribGridRecord ggr = (GribGridRecord)gr;
            GribPds pds = ggr.getPds();
            int[] timeInv = pds.getForecastTimeInterval();
            int end = timeInv[1];
            int intv2 = end - (start = timeInv[0]);
            if (intv2 > 0) {
                if (intv < 0) {
                    intv = intv2;
                } else {
                    boolean bl = same = same && intv == intv2;
                }
            }
            if (result.contains(timeCoordIntv = new GridTimeCoord.TimeCoordWithInterval(validTime = gr.getValidTime(), start, intv2))) continue;
            result.add(timeCoordIntv);
        }
        if (same && checkConstant) {
            this.constantInterval = intv;
        }
        Collections.sort(result);
        return result;
    }

    private List<GridTimeCoord.TimeCoordWithInterval> computeIntervalsWithDiff(List<GridRecord> records, boolean checkConstant) {
        boolean same = true;
        ArrayList<GridTimeCoord.TimeCoordWithInterval> result = new ArrayList<GridTimeCoord.TimeCoordWithInterval>(records.size());
        int intv = -1;
        for (GridRecord gr : records) {
            Date validTime;
            GridTimeCoord.TimeCoordWithInterval timeCoordIntv;
            GribGridRecord ggr = (GribGridRecord)gr;
            TimeCoord.Tinv tinv = this.getTinv(ggr);
            int start = tinv.getBounds1();
            int end = tinv.getBounds2();
            int intv2 = end - start;
            if (intv2 > 0) {
                if (intv < 0) {
                    intv = intv2;
                } else {
                    boolean bl = same = same && intv == intv2;
                }
            }
            if (result.contains(timeCoordIntv = new GridTimeCoord.TimeCoordWithInterval(validTime = gr.getValidTime(), start, intv2))) continue;
            result.add(timeCoordIntv);
        }
        if (same && checkConstant) {
            this.constantInterval = intv;
        }
        Collections.sort(result);
        return result;
    }

    private TimeCoord.Tinv getTinv(GribGridRecord ggr) {
        GribPds pds = ggr.getPds();
        int[] timeInv = pds.getForecastTimeInterval();
        TimeCoord.Tinv org = new TimeCoord.Tinv(timeInv[0], timeInv[1]);
        CalendarPeriod fromUnit = GribUtils.getCalendarPeriod(pds.getTimeUnit());
        CalendarPeriod toUnit = GribUtils.getCalendarPeriod(this.timeUnit);
        return org.convertReferenceDate(CalendarDate.of(pds.getReferenceDate()), fromUnit, CalendarDate.of(this.baseDate), toUnit);
    }

    @Override
    protected boolean matchTimes(List<GridRecord> records) {
        if (!(records.get(0) instanceof GribGridRecord)) {
            return false;
        }
        GribGridRecord ggr = (GribGridRecord)records.get(0);
        if (ggr.isInterval() != this.isInterval()) {
            return false;
        }
        for (GridRecord record : records) {
            if (this.timeUdunit.equals(record.getTimeUdunitName())) continue;
            return false;
        }
        if (this.isInterval()) {
            List<GridTimeCoord.TimeCoordWithInterval> timeList = this.refDateDiffers ? this.computeIntervalsWithDiff(records, false) : this.computeIntervals(records, false);
            Collections.sort(timeList);
            return timeList.equals(this.timeIntvs);
        }
        return super.matchTimes(records);
    }

    @Override
    public int findIndex(GridRecord record) {
        Date validTime = record.getValidTime();
        if (!this.isInterval()) {
            return this.times.indexOf(validTime);
        }
        int index = 0;
        for (GridTimeCoord.TimeCoordWithInterval t : this.timeIntvs) {
            GribGridRecord ggr = (GribGridRecord)record;
            TimeCoord.Tinv tinv = this.getTinv(ggr);
            int diff = tinv.getBounds2() - tinv.getBounds1();
            if (t.coord.equals(validTime) && t.interval == diff) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

