/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.mcidas;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import ucar.nc2.iosp.grid.GridDefRecord;
import ucar.nc2.iosp.grid.GridParameter;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridTableLookup;
import ucar.nc2.iosp.mcidas.McIDASGridRecord;
import visad.jmet.MetUnits;

public final class McIDASLookup
implements GridTableLookup {
    private McIDASGridRecord sample;

    public McIDASLookup(McIDASGridRecord sample) {
        this.sample = sample;
    }

    @Override
    public String getShapeName(GridDefRecord gds) {
        return "Spherical";
    }

    @Override
    public final String getGridName(GridDefRecord gds) {
        return gds.toString();
    }

    @Override
    public final GridParameter getParameter(GridRecord gr) {
        McIDASGridRecord mgr = (McIDASGridRecord)gr;
        String name = mgr.getParameterName();
        String desc = mgr.getGridDescription();
        if (desc.trim().equals("")) {
            desc = name;
        }
        String unit = MetUnits.makeSymbol((String)mgr.getParamUnitName());
        return new GridParameter(0, name, desc, unit);
    }

    @Override
    public final String getDisciplineName(GridRecord gr) {
        return "Meteorological Products";
    }

    @Override
    public final String getCategoryName(GridRecord gr) {
        return "Meteorological Parameters";
    }

    @Override
    public final String getLevelName(GridRecord gr) {
        String levelUnit = this.getLevelUnit(gr);
        int level1 = (int)gr.getLevel1();
        int level2 = (int)gr.getLevel2();
        if (((McIDASGridRecord)gr).hasGribInfo()) {
            return this.reflectLevelName(gr);
        }
        if (levelUnit.equalsIgnoreCase("hPa")) {
            return "pressure";
        }
        if (level1 == 1013) {
            return "mean sea level";
        }
        if (level1 == 0) {
            return "tropopause";
        }
        if (level1 == 1001) {
            return "surface";
        }
        if (level2 != 0) {
            return "layer";
        }
        return "";
    }

    @Override
    public final String getLevelDescription(GridRecord gr) {
        return this.getLevelName(gr);
    }

    private String reflectLevelName(GridRecord gr) {
        Class<?> c = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            c = cl.loadClass("ucar.grib.grib1.GribPDSLevel");
            Method m = c.getMethod("getNameShort", Integer.TYPE);
            return (String)m.invoke(null, gr.getLevelType1());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public final String getLevelUnit(GridRecord gr) {
        return MetUnits.makeSymbol((String)((McIDASGridRecord)gr).getLevelUnitName());
    }

    @Override
    public final String getTimeRangeUnitName(int tunit) {
        return "hour";
    }

    @Override
    public final Date getFirstBaseTime() {
        return this.sample.getReferenceTime();
    }

    @Override
    public final boolean isLatLon(GridDefRecord gds) {
        return this.getProjectionName(gds).equals("EQUI");
    }

    @Override
    public final int getProjectionType(GridDefRecord gds) {
        String name = this.getProjectionName(gds).trim();
        if (name.equals("MERC")) {
            return 3;
        }
        if (name.equals("CONF")) {
            return 2;
        }
        if (name.equals("PS")) {
            return 1;
        }
        return -1;
    }

    @Override
    public final boolean isVerticalCoordinate(GridRecord gr) {
        int type = gr.getLevelType1();
        if (((McIDASGridRecord)gr).hasGribInfo()) {
            if (type == 20) {
                return true;
            }
            if (type == 100) {
                return true;
            }
            if (type == 101) {
                return true;
            }
            if (type >= 103 && type <= 128) {
                return true;
            }
            if (type == 141) {
                return true;
            }
            if (type == 160) {
                return true;
            }
        } else if (this.getLevelUnit(gr).equals("hPa")) {
            return true;
        }
        return false;
    }

    @Override
    public final boolean isPositiveUp(GridRecord gr) {
        int type = gr.getLevelType1();
        if (((McIDASGridRecord)gr).hasGribInfo()) {
            if (type == 103) {
                return true;
            }
            if (type == 104) {
                return true;
            }
            if (type == 105) {
                return true;
            }
            if (type == 106) {
                return true;
            }
            if (type == 111) {
                return true;
            }
            if (type == 112) {
                return true;
            }
            if (type == 125) {
                return true;
            }
            if (this.getLevelUnit(gr).equals("hPa")) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final float getFirstMissingValue() {
        return -2.1390621E9f;
    }

    @Override
    public boolean isLayer(GridRecord gr) {
        return gr.getLevel2() != 0.0;
    }

    private String getProjectionName(GridDefRecord gds) {
        return gds.getParam("ProjFlag");
    }

    @Override
    public final String getTitle() {
        return "GRID data";
    }

    @Override
    public String getInstitution() {
        return null;
    }

    @Override
    public final String getSource() {
        return null;
    }

    @Override
    public final String getComment() {
        return null;
    }

    @Override
    public String getGridType() {
        return "McIDAS";
    }
}

