/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewelcli.internal.guava.collect;

import com.lexicalscope.jewelcli.internal.guava.base.$Joiner;
import com.lexicalscope.jewelcli.internal.guava.base.$Preconditions;
import com.lexicalscope.jewelcli.internal.guava.base.$Predicate;
import com.lexicalscope.jewelcli.internal.guava.collect.$Iterables;
import com.lexicalscope.jewelcli.internal.guava.collect.$Iterators;
import com.lexicalscope.jewelcli.internal.guava.collect.$Lists;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class $Collections2 {
    static final $Joiner STANDARD_JOINER = $Joiner.on(", ");

    static <T> Collection<T> cast(Iterable<T> iterable) {
        return (Collection)iterable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FilteredCollection<E>
    implements Collection<E> {
        final Collection<E> unfiltered;
        final $Predicate<? super E> predicate;

        FilteredCollection(Collection<E> unfiltered, $Predicate<? super E> predicate) {
            this.unfiltered = unfiltered;
            this.predicate = predicate;
        }

        @Override
        public boolean add(E element) {
            $Preconditions.checkArgument(this.predicate.apply(element));
            return this.unfiltered.add(element);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            for (E element : collection) {
                $Preconditions.checkArgument(this.predicate.apply(element));
            }
            return this.unfiltered.addAll(collection);
        }

        @Override
        public void clear() {
            $Iterables.removeIf(this.unfiltered, this.predicate);
        }

        @Override
        public boolean contains(Object element) {
            try {
                Object e = element;
                return this.predicate.apply(e) && this.unfiltered.contains(element);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !$Iterators.any(this.unfiltered.iterator(), this.predicate);
        }

        @Override
        public Iterator<E> iterator() {
            return $Iterators.filter(this.unfiltered.iterator(), this.predicate);
        }

        @Override
        public boolean remove(Object element) {
            try {
                Object e = element;
                return this.predicate.apply(e) && this.unfiltered.remove(element);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public boolean removeAll(final Collection<?> collection) {
            $Preconditions.checkNotNull(collection);
            $Predicate combinedPredicate = new $Predicate<E>(){

                @Override
                public boolean apply(E input) {
                    return FilteredCollection.this.predicate.apply(input) && collection.contains(input);
                }
            };
            return $Iterables.removeIf(this.unfiltered, combinedPredicate);
        }

        @Override
        public boolean retainAll(final Collection<?> collection) {
            $Preconditions.checkNotNull(collection);
            $Predicate combinedPredicate = new $Predicate<E>(){

                @Override
                public boolean apply(E input) {
                    return FilteredCollection.this.predicate.apply(input) && !collection.contains(input);
                }
            };
            return $Iterables.removeIf(this.unfiltered, combinedPredicate);
        }

        @Override
        public int size() {
            return $Iterators.size(this.iterator());
        }

        @Override
        public Object[] toArray() {
            return $Lists.newArrayList(this.iterator()).toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return $Lists.newArrayList(this.iterator()).toArray(array);
        }

        public String toString() {
            return $Iterators.toString(this.iterator());
        }
    }
}

