/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1Pds;
import ucar.grib.grib1.GribPDSLevel;
import ucar.grib.grib1.GribPDSParamTable;
import ucar.nc2.iosp.grid.GridParameter;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1ProductDefinitionSection {
    private final int length;
    private final int decscale;
    private final int grid_id;
    private final boolean gds_exists;
    private final boolean bms_exists;
    private final GridParameter parameter;
    private final int parameterNumber;
    private final GribPDSLevel level;
    private final Date baseTime;
    private final long refTime;
    private int forecastTime;
    private int p1;
    private int p2;
    private String timeRange = null;
    private final int timeRangeValue;
    private String tUnit = null;
    private final int table_version;
    private final int center_id;
    private final int subcenter_id;
    private final int typeGenProcess;
    private final boolean lengthErr = false;
    private final Grib1Pds pdsVars;

    public Grib1ProductDefinitionSection(RandomAccessFile raf) throws NotSupportedException, IOException {
        long sectionEnd = raf.getFilePointer();
        this.length = GribNumbers.uint3(raf);
        byte[] pdsData = new byte[this.length];
        raf.skipBytes(-3);
        raf.read(pdsData);
        this.pdsVars = new Grib1Pds(pdsData);
        raf.seek(sectionEnd + 3L);
        sectionEnd += (long)this.length;
        this.table_version = raf.read();
        this.center_id = raf.read();
        this.typeGenProcess = raf.read();
        this.grid_id = raf.read();
        int exists = raf.read();
        this.gds_exists = (exists & 0x80) == 128;
        this.bms_exists = (exists & 0x40) == 64;
        this.parameterNumber = raf.read();
        int levelType = raf.read();
        int levelValue1 = raf.read();
        int levelValue2 = raf.read();
        this.level = new GribPDSLevel(levelType, levelValue1, levelValue2);
        int year = raf.read();
        int month = raf.read();
        int day = raf.read();
        int hour = raf.read();
        int minute = raf.read();
        int fUnit = raf.read();
        switch (fUnit) {
            case 0: {
                this.tUnit = "minute";
                break;
            }
            case 1: {
                this.tUnit = "hour";
                break;
            }
            case 2: {
                this.tUnit = "day";
                break;
            }
            case 3: {
                this.tUnit = "month";
                break;
            }
            case 4: {
                this.tUnit = "1year";
                break;
            }
            case 5: {
                this.tUnit = "decade";
                break;
            }
            case 6: {
                this.tUnit = "day";
                break;
            }
            case 7: {
                this.tUnit = "century";
                break;
            }
            case 10: {
                this.tUnit = "3hours";
                break;
            }
            case 11: {
                this.tUnit = "6hours";
                break;
            }
            case 12: {
                this.tUnit = "12hours";
                break;
            }
            case 254: {
                this.tUnit = "second";
                break;
            }
            default: {
                System.err.println("PDS: Time Unit " + fUnit + " is not yet supported");
            }
        }
        this.p1 = raf.read();
        this.p2 = raf.read();
        this.timeRangeValue = raf.read();
        switch (this.timeRangeValue) {
            case 0: {
                this.timeRange = "product valid at RT + P1";
                this.forecastTime = this.p1;
                break;
            }
            case 1: {
                this.timeRange = "product valid for RT, P1=0";
                this.forecastTime = 0;
                break;
            }
            case 2: {
                this.timeRange = "product valid from (RT + P1) to (RT + P2)";
                this.forecastTime = this.p2;
                break;
            }
            case 3: {
                this.timeRange = "product is an average between (RT + P1) to (RT + P2)";
                this.forecastTime = this.p2;
                break;
            }
            case 4: {
                this.timeRange = "product is an accumulation between (RT + P1) to (RT + P2)";
                this.forecastTime = this.p2;
                break;
            }
            case 5: {
                this.timeRange = "product is the difference (RT + P2) - (RT + P1)";
                this.forecastTime = this.p2;
                break;
            }
            case 6: {
                this.timeRange = "product is an average from (RT - P1) to (RT - P2)";
                this.forecastTime = -this.p2;
                break;
            }
            case 7: {
                this.timeRange = "product is an average from (RT - P1) to (RT + P2)";
                this.forecastTime = this.p2;
                break;
            }
            case 10: {
                this.timeRange = "product valid at RT + P1";
                this.forecastTime = this.p1 = GribNumbers.int2(this.p1, this.p2);
                this.p2 = 0;
                break;
            }
            case 51: {
                this.timeRange = "mean value from RT to (RT + P2)";
                this.forecastTime = this.p2;
                break;
            }
            case 113: {
                this.timeRange = "Average of N forecasts, forecast period of P1, reference intervals of P2";
                this.forecastTime = this.p1;
                break;
            }
            case 123: {
                this.timeRange = "Average of N uninitialized analyses, starting at the reference time, at intervals of P2";
                this.forecastTime = 0;
                break;
            }
            case 124: {
                this.timeRange = "Accumulation of N uninitialized analyses, starting at the reference time, at intervals of P2";
                this.forecastTime = 0;
                break;
            }
            default: {
                System.err.println("PDS: Time Range Indicator " + this.timeRangeValue + " is not yet supported");
            }
        }
        int avgInclude = GribNumbers.int2(raf);
        int avgMissing = raf.read();
        int century = raf.read() - 1;
        if (century == -1) {
            century = 20;
        }
        this.subcenter_id = raf.read();
        this.decscale = GribNumbers.int2(raf);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.set(16, 0);
        calendar.set(century * 100 + year, month - 1, day, hour, minute, 0);
        this.baseTime = calendar.getTime();
        this.refTime = calendar.getTimeInMillis();
        this.parameter = GribPDSParamTable.getParameter(this.center_id, this.subcenter_id, this.table_version, this.parameterNumber);
        Grib1Pds gpv = this.pdsVars;
        raf.seek(sectionEnd);
    }

    public final boolean gdsExists() {
        return this.gds_exists;
    }

    public final boolean bmsExists() {
        return this.bms_exists;
    }

    public final int getCenter() {
        return this.center_id;
    }

    public final int getTypeGenProcess() {
        return this.typeGenProcess;
    }

    public static final String getTypeGenProcessName(int typeGenProcess) {
        switch (typeGenProcess) {
            case 2: {
                return "Ultra Violet Index Model";
            }
            case 3: {
                return "NCEP/ARL Transport and Dispersion Model";
            }
            case 4: {
                return "NCEP/ARL Smoke Model";
            }
            case 5: {
                return "Satellite Derived Precipitation and temperatures, from IR";
            }
            case 10: {
                return "Global Wind-Wave Forecast Model";
            }
            case 19: {
                return "Limited-area Fine Mesh (LFM) analysis";
            }
            case 25: {
                return "Snow Cover Analysis";
            }
            case 30: {
                return "Forecaster generated field";
            }
            case 31: {
                return "Value added post processed field";
            }
            case 39: {
                return "Nested Grid forecast Model (NGM)";
            }
            case 42: {
                return "Global Optimum Interpolation Analysis (GOI) from GFS model";
            }
            case 43: {
                return "Global Optimum Interpolation Analysis (GOI) from  Final run";
            }
            case 44: {
                return "Sea Surface Temperature Analysis";
            }
            case 45: {
                return "Coastal Ocean Circulation Model";
            }
            case 46: {
                return "HYCOM - Global";
            }
            case 47: {
                return "HYCOM - North Pacific basin";
            }
            case 48: {
                return "HYCOM - North Atlantic basin";
            }
            case 49: {
                return "Ozone Analysis from TIROS Observations";
            }
            case 52: {
                return "Ozone Analysis from Nimbus 7 Observations";
            }
            case 53: {
                return "LFM-Fourth Order Forecast Model";
            }
            case 64: {
                return "Regional Optimum Interpolation Analysis (ROI)";
            }
            case 68: {
                return "80 wave triangular, 18-layer Spectral model from GFS model";
            }
            case 69: {
                return "80 wave triangular, 18 layer Spectral model from Medium Range Forecast run";
            }
            case 70: {
                return "Quasi-Lagrangian Hurricane Model (QLM)";
            }
            case 73: {
                return "Fog Forecast model - Ocean Prod. Center";
            }
            case 74: {
                return "Gulf of Mexico Wind/Wave";
            }
            case 75: {
                return "Gulf of Alaska Wind/Wave";
            }
            case 76: {
                return "Bias corrected Medium Range Forecast";
            }
            case 77: {
                return "126 wave triangular, 28 layer Spectral model from GFS model";
            }
            case 78: {
                return "126 wave triangular, 28 layer Spectral model from Medium Range Forecast run";
            }
            case 79: {
                return "Backup from the previous run";
            }
            case 80: {
                return "62 wave triangular, 28 layer Spectral model from Medium Range Forecast run";
            }
            case 81: {
                return "Spectral Statistical Interpolation (SSI) analysis from  GFS model";
            }
            case 82: {
                return "Spectral Statistical Interpolation (SSI) analysis from Final run.";
            }
            case 84: {
                return "MESO ETA Model";
            }
            case 86: {
                return "RUC Model, from Forecast Systems Lab (isentropic; scale: 60km at 40N)";
            }
            case 87: {
                return "CAC Ensemble Forecasts from Spectral (ENSMB)";
            }
            case 88: {
                return "NOAA Wave Watch III (NWW3) Ocean Wave Model";
            }
            case 89: {
                return "Non-hydrostatic Meso Model (NMM)";
            }
            case 90: {
                return "62 wave triangular, 28 layer spectral model extension of the Medium Range Forecast run";
            }
            case 91: {
                return "62 wave triangular, 28 layer spectral model extension of the GFS model";
            }
            case 92: {
                return "62 wave triangular, 28 layer spectral model run from the Medium Range Forecast final analysis";
            }
            case 93: {
                return "62 wave triangular, 28 layer spectral model run from the T62 GDAS analysis of the Medium Range Forecast run";
            }
            case 94: {
                return "T170/L42 Global Spectral Model from MRF run";
            }
            case 95: {
                return "T126/L42 Global Spectral Model from MRF run";
            }
            case 96: {
                return "Global Forecast System Model (formerly known as the Aviation)";
            }
            case 98: {
                return "Climate Forecast System Model -- Atmospheric model (GFS) coupled to a multi level ocean model.";
            }
            case 99: {
                return "Miscellaneous Test ID";
            }
            case 100: {
                return "RUC Surface Analysis (scale: 60km at 40N)";
            }
            case 101: {
                return "RUC Surface Analysis (scale: 40km at 40N)";
            }
            case 105: {
                return "RUC Model from FSL (isentropic; scale: 20km at 40N)";
            }
            case 108: {
                return "LAMP";
            }
            case 109: {
                return "RTMA (Real Time Mesoscale Analysis)";
            }
            case 110: {
                return "ETA Model - 15km version";
            }
            case 111: {
                return "Eta model, generic resolution (Used in SREF processing)";
            }
            case 112: {
                return "WRF-NMM model, generic resolution NMM=Nondydrostatic Mesoscale Model (NCEP)";
            }
            case 113: {
                return "Products from NCEP SREF processing";
            }
            case 115: {
                return "Downscaled GFS from Eta eXtension";
            }
            case 116: {
                return "WRF-EM model, generic resolution EM - Eulerian Mass-core (NCAR - aka Advanced Research WRF)";
            }
            case 120: {
                return "Ice Concentration Analysis";
            }
            case 121: {
                return "Western North Atlantic Regional Wave Model";
            }
            case 122: {
                return "Alaska Waters Regional Wave Model";
            }
            case 123: {
                return "North Atlantic Hurricane Wave Model";
            }
            case 124: {
                return "Eastern North Pacific Regional Wave Model";
            }
            case 125: {
                return "North Pacific Hurricane Wave Model";
            }
            case 126: {
                return "Sea Ice Forecast Model";
            }
            case 127: {
                return "Lake Ice Forecast Model";
            }
            case 128: {
                return "Global Ocean Forecast Model";
            }
            case 129: {
                return "Global Ocean Data Analysis System (GODAS)";
            }
            case 130: {
                return "Merge of fields from the RUC, Eta, and Spectral Model";
            }
            case 131: {
                return "Great Lakes Wave Model";
            }
            case 140: {
                return "North American Regional Reanalysis (NARR)";
            }
            case 141: {
                return "Land Data Assimilation and Forecast System";
            }
            case 150: {
                return "NWS River Forecast System (NWSRFS)";
            }
            case 151: {
                return "NWS Flash Flood Guidance System (NWSFFGS)";
            }
            case 152: {
                return "WSR-88D Stage II Precipitation Analysis";
            }
            case 153: {
                return "WSR-88D Stage III Precipitation Analysis";
            }
            case 180: {
                return "Quantitative Precipitation Forecast generated by NCEP";
            }
            case 181: {
                return "River Forecast Center Quantitative Precipitation Forecast mosaic generated by NCEP";
            }
            case 182: {
                return "River Forecast Center Quantitative Precipitation estimate mosaic generated by NCEP";
            }
            case 183: {
                return "NDFD product generated by NCEP/HPC";
            }
            case 190: {
                return "National Convective Weather Diagnostic generated by NCEP/AWC";
            }
            case 191: {
                return "Current Icing Potential automated product genterated by NCEP/AWC";
            }
            case 192: {
                return "Analysis product from NCEP/AWC";
            }
            case 193: {
                return "Forecast product from NCEP/AWC";
            }
            case 195: {
                return "Climate Data Assimilation System 2 (CDAS2)";
            }
            case 196: {
                return "Climate Data Assimilation System 2 (CDAS2) - used for regeneration runs";
            }
            case 197: {
                return "Climate Data Assimilation System (CDAS)";
            }
            case 198: {
                return "Climate Data Assimilation System (CDAS) - used for regeneration runs";
            }
            case 200: {
                return "CPC Manual Forecast Product";
            }
            case 201: {
                return "CPC Automated Product";
            }
            case 210: {
                return "EPA Air Quality Forecast";
            }
            case 211: {
                return "EPA Air Quality Forecast";
            }
            case 215: {
                return "SPC Manual Forecast Product";
            }
            case 220: {
                return "NCEP/OPC automated product";
            }
            case 255: {
                return "Missing";
            }
        }
        return "Unknown";
    }

    public final int getGrid_Id() {
        return this.grid_id;
    }

    public final String getCenterName() {
        return CommonCodeTable.getCenterName(this.center_id, 1);
    }

    public final int getSubCenter() {
        return this.subcenter_id;
    }

    public final String getSubCenterName() {
        return CommonCodeTable.getSubCenterName(this.center_id, this.subcenter_id);
    }

    public final int getTableVersion() {
        return this.table_version;
    }

    public final int getDecimalScale() {
        return this.decscale;
    }

    public final int getParameterNumber() {
        return this.parameterNumber;
    }

    public final String getType() {
        return this.parameter == null ? "" : this.parameter.getName();
    }

    public final String getDescription() {
        return this.parameter == null ? "" : this.parameter.getDescription();
    }

    public final String getUnit() {
        return this.parameter == null ? "" : this.parameter.getUnit();
    }

    public final String getLevelName() {
        return this.level.getName();
    }

    public final int getLevelType() {
        return this.level.getIndex();
    }

    public final float getLevelValue1() {
        return this.level.getValue1();
    }

    public final float getLevelValue2() {
        return this.level.getValue2();
    }

    public final Date getBaseTime() {
        return this.baseTime;
    }

    public final long getRefTime() {
        return this.refTime;
    }

    public final int getForecastTime() {
        return this.forecastTime;
    }

    public final int getP1() {
        return this.p1;
    }

    public final int getP2() {
        return this.p2;
    }

    public final String getTimeUnit() {
        return this.tUnit;
    }

    public final int getProductDefinition() {
        return this.timeRangeValue;
    }

    public static String getProductDefinitionName(int type) {
        switch (type) {
            case 0: {
                return "Forecast/Uninitialized Analysis/Image Product";
            }
            case 1: {
                return "Initialized analysis product";
            }
            case 2: {
                return "Product with a valid time between P1 and P2";
            }
            case 3: 
            case 6: 
            case 7: {
                return "Average";
            }
            case 4: {
                return "Accumulation";
            }
            case 5: {
                return "Difference";
            }
            case 10: {
                return "product valid at reference time P1";
            }
            case 51: {
                return "Climatological Mean Value";
            }
            case 113: 
            case 115: 
            case 117: {
                return "Average of N forecasts";
            }
            case 114: 
            case 116: {
                return "Accumulation of N forecasts";
            }
            case 118: {
                return "Temporal variance";
            }
            case 119: 
            case 125: {
                return "Standard deviation of N forecasts";
            }
            case 123: {
                return "Average of N uninitialized analyses";
            }
            case 124: {
                return "Accumulation of N uninitialized analyses";
            }
            case 128: {
                return "Average of daily forecast accumulations";
            }
            case 129: {
                return "Average of successive forecast accumulations";
            }
            case 130: {
                return "Average of daily forecast averages";
            }
            case 131: {
                return "Average of successive forecast averages";
            }
            case 132: {
                return "Climatological Average of N analyses";
            }
            case 133: {
                return "Climatological Average of N forecasts";
            }
            case 134: {
                return "Climatological Root Mean Square difference between N forecasts and their verifying analyses";
            }
            case 135: {
                return "Climatological Standard Deviation of N forecasts from the mean of the same N forecasts";
            }
            case 136: {
                return "Climatological Standard Deviation of N analyses from the mean of the same N analyses";
            }
        }
        return "Unknown";
    }

    public final int getGrid_ID() {
        return this.grid_id;
    }

    public final int getTimeRange() {
        return this.timeRangeValue;
    }

    public final String getTimeRangeString() {
        return this.timeRange;
    }

    public final boolean getLengthErr() {
        return false;
    }

    public int getLength() {
        return this.length;
    }

    public Grib1Pds getPdsVars() {
        return this.pdsVars;
    }

    public static void main(String[] args) throws IOException, NoValidGribException {
        RandomAccessFile raf = null;
        PrintStream ps = System.out;
        String infile = args[0];
        raf = new RandomAccessFile(infile, "r");
        raf.order(0);
        raf.skipBytes(Integer.parseInt(args[1]));
        Grib1ProductDefinitionSection pds = new Grib1ProductDefinitionSection(raf);
        Grib1Pds gpv = pds.pdsVars;
        ps.println("Length = " + gpv.getLength());
        ps.println("TimeRangeIndicator = " + gpv.getTimeRangeIndicator());
        assert (pds.length == gpv.getLength());
        assert (pds.table_version == gpv.getParameterTableVersion());
        assert (pds.center_id == gpv.getCenter());
        assert (pds.typeGenProcess == gpv.getGenProcessId());
        assert (pds.typeGenProcess == gpv.getGenProcessId());
        assert (pds.grid_id == gpv.getGridId());
        assert (pds.gds_exists == gpv.gdsExists());
        assert (pds.bms_exists == gpv.bmsExists());
        assert (pds.parameterNumber == gpv.getParameterNumber());
        assert (pds.getLevelType() == gpv.getLevelType1());
        assert ((double)pds.getLevelValue1() == gpv.getLevelValue1());
        assert ((double)pds.getLevelValue2() == gpv.getLevelValue2());
        assert (pds.baseTime.equals(gpv.getReferenceDate()));
        assert (pds.refTime == gpv.getReferenceTime());
        assert (pds.p1 == gpv.getP1());
        assert (pds.p2 == gpv.getP2());
        assert (pds.timeRangeValue == gpv.getTimeRangeIndicator());
        assert (pds.subcenter_id == gpv.getSubCenter());
        assert (pds.decscale == gpv.getDecimalScale());
        assert (pds.forecastTime == gpv.getForecastTime());
    }
}

