/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import java.util.Formatter;
import ucar.nc2.grib.QuasiRegular;
import ucar.nc2.grib.grib2.Grib2DataReader;
import ucar.nc2.grib.grib2.Grib2Drs;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2SectionBitMap;
import ucar.nc2.grib.grib2.Grib2SectionData;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2SectionIndicator;
import ucar.nc2.grib.grib2.Grib2SectionLocalUse;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.io.RandomAccessFile;

public class Grib2Record {
    private final Grib2SectionIndicator is;
    private final Grib2SectionIdentification id;
    private Grib2SectionLocalUse lus;
    private Grib2SectionGridDefinition gdss;
    private Grib2SectionProductDefinition pdss;
    private Grib2SectionDataRepresentation drs;
    private Grib2SectionBitMap bms;
    private Grib2SectionData dataSection;
    private final byte[] header;
    private int file;
    private boolean bmsReplaced;
    public int repeat;
    private Grib2Pds pds2 = null;

    public Grib2Record(byte[] header, Grib2SectionIndicator is, Grib2SectionIdentification id, Grib2SectionLocalUse lus, Grib2SectionGridDefinition gdss, Grib2SectionProductDefinition pdss, Grib2SectionDataRepresentation drs, Grib2SectionBitMap bms, Grib2SectionData dataSection, boolean bmsReplaced) {
        this.header = header;
        this.is = is;
        this.id = id;
        this.lus = lus;
        this.gdss = gdss;
        this.pdss = pdss;
        this.drs = drs;
        this.bms = bms;
        this.dataSection = dataSection;
        this.bmsReplaced = bmsReplaced;
    }

    Grib2Record(Grib2Record from) {
        this.header = from.header;
        this.is = from.is;
        this.id = from.id;
        this.lus = from.lus;
        this.gdss = from.gdss;
        this.pdss = from.pdss;
        this.drs = from.drs;
        this.bms = from.bms;
        this.dataSection = from.dataSection;
        this.repeat = from.repeat;
        this.bmsReplaced = from.bmsReplaced;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public Grib2SectionIndicator getIs() {
        return this.is;
    }

    public Grib2SectionIdentification getId() {
        return this.id;
    }

    public boolean hasLocalUseSection() {
        return this.lus != null && this.lus.getRawBytes() != null;
    }

    public Grib2SectionLocalUse getLocalUseSection() {
        return this.lus;
    }

    public Grib2SectionGridDefinition getGDSsection() {
        return this.gdss;
    }

    public Grib2SectionProductDefinition getPDSsection() {
        return this.pdss;
    }

    public Grib2SectionDataRepresentation getDataRepresentationSection() {
        return this.drs;
    }

    public Grib2SectionBitMap getBitmapSection() {
        return this.bms;
    }

    public Grib2SectionData getDataSection() {
        return this.dataSection;
    }

    public int getDiscipline() {
        return this.is.getDiscipline();
    }

    public CalendarDate getReferenceDate() {
        return this.id.getReferenceDate();
    }

    public Grib2Pds getPDS() {
        if (this.pds2 == null) {
            try {
                this.pds2 = this.pdss.getPDS();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.pds2;
    }

    public void show(Formatter f) {
        f.format("discipline=%d ", this.is.getDiscipline());
        Grib2Pds pds = this.getPDS();
        pds.show(f);
    }

    public void setLus(Grib2SectionLocalUse lus) {
        this.lus = lus;
    }

    public void setGdss(Grib2SectionGridDefinition gdss) {
        this.gdss = gdss;
    }

    public void setPdss(Grib2SectionProductDefinition pdss) {
        this.pdss = pdss;
    }

    public void setDrs(Grib2SectionDataRepresentation drs) {
        this.drs = drs;
    }

    public void setBms(Grib2SectionBitMap bms, boolean replaced) {
        this.bms = bms;
        this.bmsReplaced = replaced;
    }

    public void setDataSection(Grib2SectionData dataSection) {
        this.dataSection = dataSection;
    }

    public int getFile() {
        return this.file;
    }

    public void setFile(int file) {
        this.file = file;
    }

    public boolean isBmsReplaced() {
        return this.bmsReplaced;
    }

    public float[] readData(RandomAccessFile raf) throws IOException {
        Grib2Gds gds = this.gdss.getGDS();
        Grib2DataReader reader = new Grib2DataReader(this.drs.getDataTemplate(), this.gdss.getNumberPoints(), this.drs.getDataPoints(), gds.scanMode, gds.getNxRaw(), this.dataSection.getStartingPosition(), this.dataSection.getMsgLength());
        byte[] bitmap = this.bms.getBitmap(raf);
        Grib2Drs gdrs = this.drs.getDrs(raf);
        float[] data = reader.getData(raf, bitmap, gdrs);
        if (gds.isThin()) {
            data = QuasiRegular.convertQuasiGrid(data, gds.getNptsInLine(), gds.getNxRaw(), gds.getNyRaw());
        }
        return data;
    }

    public Grib2Drs.Type40 readDataTest(RandomAccessFile raf) throws IOException {
        Grib2Gds gds = this.gdss.getGDS();
        Grib2DataReader reader = new Grib2DataReader(this.drs.getDataTemplate(), this.gdss.getNumberPoints(), this.drs.getDataPoints(), gds.scanMode, gds.getNxRaw(), this.dataSection.getStartingPosition(), this.dataSection.getMsgLength());
        byte[] bitmap = this.bms.getBitmap(raf);
        Grib2Drs gdrs = this.drs.getDrs(raf);
        if (gdrs instanceof Grib2Drs.Type40) {
            reader.getData(raf, bitmap, gdrs);
            return (Grib2Drs.Type40)gdrs;
        }
        return null;
    }

    public float[] readData(RandomAccessFile raf, long drsPos) throws IOException {
        raf.seek(drsPos);
        Grib2SectionDataRepresentation drs = new Grib2SectionDataRepresentation(raf);
        Grib2SectionBitMap bms = new Grib2SectionBitMap(raf);
        Grib2SectionData dataSection = new Grib2SectionData(raf);
        Grib2Gds gds = this.gdss.getGDS();
        Grib2DataReader reader = new Grib2DataReader(drs.getDataTemplate(), this.gdss.getNumberPoints(), drs.getDataPoints(), gds.scanMode, gds.getNxRaw(), dataSection.getStartingPosition(), dataSection.getMsgLength());
        byte[] bitmap = bms.getBitmap(raf);
        Grib2Drs gdrs = drs.getDrs(raf);
        float[] data = reader.getData(raf, bitmap, gdrs);
        if (gds.isThin()) {
            data = QuasiRegular.convertQuasiGrid(data, gds.getNptsInLine(), gds.getNxRaw(), gds.getNyRaw());
        }
        return data;
    }

    public static float[] readData(RandomAccessFile raf, long drsPos, long bmsPos, int gdsNumberPoints, int scanMode, int nx, int ny, int[] nptsInLine) throws IOException {
        raf.seek(drsPos);
        Grib2SectionDataRepresentation drs = new Grib2SectionDataRepresentation(raf);
        Grib2SectionBitMap bms = new Grib2SectionBitMap(raf);
        Grib2SectionData dataSection = new Grib2SectionData(raf);
        if (bmsPos > 0L) {
            bms = Grib2SectionBitMap.factory(raf, bmsPos);
        }
        Grib2DataReader reader = new Grib2DataReader(drs.getDataTemplate(), gdsNumberPoints, drs.getDataPoints(), scanMode, nx, dataSection.getStartingPosition(), dataSection.getMsgLength());
        byte[] bitmap = bms.getBitmap(raf);
        Grib2Drs gdrs = drs.getDrs(raf);
        float[] data = reader.getData(raf, bitmap, gdrs);
        if (nptsInLine != null) {
            data = QuasiRegular.convertQuasiGrid(data, nptsInLine, nx, ny);
        }
        return data;
    }
}

