/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGDSVariablesIF;
import ucar.grib.GribGridDefRecord;
import ucar.grib.GribGridRecord;
import ucar.grib.GribIndexName;
import ucar.grib.GribNumbers;
import ucar.grib.GribPds;
import ucar.grib.grib1.Grib1GDSVariables;
import ucar.grib.grib1.Grib1Grid;
import ucar.grib.grib1.Grib1Pds;
import ucar.grib.grib1.Grib1Tables;
import ucar.grib.grib2.Grib2GDSVariables;
import ucar.grib.grib2.Grib2Tables;
import ucar.nc2.iosp.grid.GridIndex;

public class GribIndexReader {
    private static Logger log = LoggerFactory.getLogger(GribIndexReader.class);
    private static boolean debugTiming = false;
    private static boolean debugParse = false;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Calendar calendar;

    public GribIndexReader() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public final GridIndex open(String location) throws IOException {
        InputStream ios;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        if (ios == null) {
            return null;
        }
        return this.open(location, ios);
    }

    public final GridIndex open(String location, InputStream ios) throws IOException {
        int tpasses = 5;
        for (int pass = 0; pass < tpasses; ++pass) {
            if (pass != 0) {
                ios = new FileInputStream(location);
            }
            long start = System.currentTimeMillis();
            GridIndex gridIndex = null;
            FilterInputStream dis = null;
            try {
                String[] split;
                gridIndex = new GridIndex(location);
                dis = new DataInputStream(new BufferedInputStream(ios));
                long lastModified = ((DataInputStream)dis).readLong();
                if (lastModified == 7597120008394602085L) {
                    dis.close();
                    dis = null;
                    throw new UnsupportedOperationException("Dont support text indexes");
                }
                Date baseTime = null;
                boolean grid_edition_1 = false;
                String index_version = "";
                int center = 0;
                int sub_center = 0;
                int table_version = 0;
                String line = ((DataInputStream)dis).readUTF();
                if (debugParse) {
                    System.out.println(line);
                }
                if ((split = line.split("\\s")).length % 2 != 0) {
                    GridIndex gridIndex2 = null;
                    return gridIndex2;
                }
                for (int i = 0; i < split.length; i += 2) {
                    gridIndex.addGlobalAttribute(split[i], split[i + 1]);
                    if (split[i].equals("basetime")) {
                        baseTime = this.dateFormat.parse(split[i + 1]);
                        continue;
                    }
                    if (split[i].equals("grid_edition")) {
                        grid_edition_1 = split[i + 1].equals("1");
                        continue;
                    }
                    if (split[i].equals("index_version")) {
                        index_version = split[i + 1];
                        if (!index_version.equals("7.1")) continue;
                        File f = new File(location);
                        f.delete();
                        GridIndex gridIndex3 = null;
                        return gridIndex3;
                    }
                    if (split[i].equals("center")) {
                        center = Integer.parseInt(split[i + 1]);
                        continue;
                    }
                    if (split[i].equals("sub_center")) {
                        sub_center = Integer.parseInt(split[i + 1]);
                        continue;
                    }
                    if (!split[i].equals("table_version")) continue;
                    table_version = Integer.parseInt(split[i + 1]);
                }
                int number = ((DataInputStream)dis).readInt();
                for (int i = 0; i < number; ++i) {
                    GribGridRecord ggr = new GribGridRecord();
                    ggr.edition = grid_edition_1 ? 1 : 2;
                    ggr.discipline = ((DataInputStream)dis).readInt();
                    long refTime = ((DataInputStream)dis).readLong();
                    this.calendar.setTimeInMillis(refTime);
                    ggr.refTime = refTime;
                    ggr.refTimeAsDate = this.calendar.getTime();
                    ggr.gdsKey = ((DataInputStream)dis).readInt();
                    ggr.gdsOffset = ((DataInputStream)dis).readLong();
                    ggr.pdsOffset = ((DataInputStream)dis).readLong();
                    int pdsSize = ((DataInputStream)dis).readInt();
                    byte[] pdsData = new byte[pdsSize];
                    ((DataInputStream)dis).readFully(pdsData);
                    GribPds pdsv = GribPds.factory(ggr.edition, pdsData, refTime, this.calendar);
                    if (pdsv == null) continue;
                    ggr.setPds(pdsv);
                    if (grid_edition_1) {
                        Grib1Pds pds1 = (Grib1Pds)pdsv;
                        ggr.bmsExists = pds1.bmsExists();
                        ggr.center = pds1.getCenter();
                        ggr.subCenter = pds1.getSubCenter();
                        ggr.tableVersion = pds1.getParameterTableVersion();
                    } else {
                        ggr.center = center;
                        ggr.subCenter = sub_center;
                        ggr.tableVersion = table_version;
                    }
                    gridIndex.addGridRecord(ggr);
                }
                number = ((DataInputStream)dis).readInt();
                for (int j = 0; j < number; ++j) {
                    GribGridDefRecord ggdr;
                    GribGDSVariablesIF gdsv;
                    int gdsSize = ((DataInputStream)dis).readInt();
                    if (gdsSize == 4) {
                        int gdskey = ((DataInputStream)dis).readInt();
                        GribGridDefRecord ggdr2 = new GribGridDefRecord();
                        Grib1Grid.populateGDS(ggdr2, gdskey);
                        gridIndex.addHorizCoordSys(ggdr2);
                        continue;
                    }
                    byte[] gdsData = new byte[gdsSize];
                    ((DataInputStream)dis).readFully(gdsData);
                    if (grid_edition_1) {
                        gdsv = new Grib1GDSVariables(gdsData);
                        ggdr = new GribGridDefRecord(gdsv);
                        int gdskey = index_version.startsWith("8.0") ? ((Grib1GDSVariables)gdsv).get80TypeGdsKey() : ((Grib1GDSVariables)gdsv).getGdsKey();
                        this.populateGDS1(ggdr, (Grib1GDSVariables)gdsv, gdskey);
                        gridIndex.addHorizCoordSys(ggdr);
                        continue;
                    }
                    gdsv = new Grib2GDSVariables(gdsData);
                    ggdr = new GribGridDefRecord(gdsv);
                    int gdskey = index_version.startsWith("8.0") ? ((Grib2GDSVariables)gdsv).get80TypeGdsKey() : ((Grib2GDSVariables)gdsv).getGdsKey();
                    this.populateGDS2(ggdr, (Grib2GDSVariables)gdsv, gdskey);
                    gridIndex.addHorizCoordSys(ggdr);
                }
                if (debugTiming) {
                    long took = System.currentTimeMillis() - start;
                    System.out.println(" Index read " + location + " count=" + gridIndex.getGridCount() + " took=" + took + " msec ");
                }
                log.debug("Binary index read: {}", (Object)location);
                log.debug("Number Records = {} at {}", (Object)gridIndex.getGridCount(), (Object)this.dateFormat.format(Calendar.getInstance().getTime()));
                GridIndex gridIndex4 = gridIndex;
                return gridIndex4;
            }
            catch (IOException e) {
                if (pass == tpasses) {
                    String message = "I/O error at record " + gridIndex.getGridCount() + " in index file";
                    throw new IOException(message);
                }
                log.info("open(): rereading index [{}] due to IOException={}", (Object)location, (Object)e.getMessage());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                continue;
            }
            catch (ParseException e) {
                log.error("open(): ParseException reading index ", e);
                throw new RuntimeException(e);
            }
            finally {
                if (dis != null) {
                    dis.close();
                }
            }
        }
        return null;
    }

    public void populateGDS2(GribGridDefRecord ggdr, Grib2GDSVariables gdsv, int gdskey) {
        int component_flag;
        int gdtn = gdsv.getGdtn();
        ggdr.addParam("GDSkey", Integer.toString(gdskey));
        ggdr.addParam("grid_type", gdtn);
        ggdr.addParam("grid_name", Grib2Tables.codeTable3_1(gdtn));
        String winds = GribNumbers.isBitSet(gdsv.getResolution(), 8) ? "Relative" : "True";
        int n = component_flag = GribNumbers.isBitSet(gdsv.getResolution(), 8) ? 1 : 0;
        if ((gdtn < 50 || gdtn > 53) && gdtn != 100 && gdtn != 120 && gdtn != 1200) {
            int shape = gdsv.getShape();
            ggdr.addParam("grid_shape_code", shape);
            ggdr.addParam("grid_shape", Grib2Tables.codeTable3_2(shape));
            if (shape < 2 || shape == 6 || shape == 8) {
                ggdr.addParam("grid_radius_spherical_earth", gdsv.getEarthRadius());
            } else if (shape > 1 && shape < 6 || shape == 7) {
                ggdr.addParam("grid_major_axis_earth", gdsv.getMajorAxis());
                ggdr.addParam("grid_minor_axis_earth", gdsv.getMinorAxis());
            }
        }
        if (gdsv.getOlon() == 0) {
            ggdr.addParam("Quasi", "false");
        } else {
            ggdr.addParam("Quasi", "true");
        }
        switch (gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 32768: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("La2", gdsv.getLa2());
                ggdr.addParam("Lo2", gdsv.getLo2());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                if (gdtn == 1) {
                    ggdr.addParam("SpLat", gdsv.getSpLat());
                    ggdr.addParam("SpLon", gdsv.getSpLon());
                    ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                    break;
                }
                if (gdtn == 2) {
                    ggdr.addParam("pLat", gdsv.getPoleLat());
                    ggdr.addParam("pLon", gdsv.getPoleLon());
                    ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                    break;
                }
                if (gdtn != 3) break;
                ggdr.addParam("SpLat", gdsv.getSpLat());
                ggdr.addParam("SpLon", gdsv.getSpLon());
                ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                ggdr.addParam("pLat", gdsv.getPoleLat());
                ggdr.addParam("pLon", gdsv.getPoleLon());
                ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                break;
            }
            case 10: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("LaD", gdsv.getLaD());
                ggdr.addParam("La2", gdsv.getLa2());
                ggdr.addParam("Lo2", gdsv.getLo2());
                ggdr.addParam("BasicAngle", gdsv.getAngle());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            case 20: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("LaD", gdsv.getLaD());
                ggdr.addParam("LoV", gdsv.getLoV());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("ProjFlag", gdsv.getProjectionFlag());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                ggdr.addParam("NpProj", npproj);
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            case 30: 
            case 31: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("LaD", gdsv.getLaD());
                ggdr.addParam("LoV", gdsv.getLoV());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("ProjFlag", gdsv.getProjectionFlag());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                ggdr.addParam("NpProj", npproj);
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                ggdr.addParam("Latin1", gdsv.getLatin1());
                ggdr.addParam("Latin2", gdsv.getLatin2());
                ggdr.addParam("SpLat", gdsv.getSpLat());
                ggdr.addParam("SpLon", gdsv.getSpLon());
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("La2", gdsv.getLa2());
                ggdr.addParam("Lo2", gdsv.getLo2());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                ggdr.addParam("NumberParallels", gdsv.getNp());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                if (gdtn == 41) {
                    ggdr.addParam("SpLat", gdsv.getSpLat());
                    ggdr.addParam("SpLon", gdsv.getSpLon());
                    ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                    break;
                }
                if (gdtn == 42) {
                    ggdr.addParam("pLat", gdsv.getPoleLat());
                    ggdr.addParam("pLon", gdsv.getPoleLon());
                    ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                    break;
                }
                if (gdtn != 43) break;
                ggdr.addParam("SpLat", gdsv.getSpLat());
                ggdr.addParam("SpLon", gdsv.getSpLon());
                ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                ggdr.addParam("pLat", gdsv.getPoleLat());
                ggdr.addParam("pLon", gdsv.getPoleLon());
                ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                break;
            }
            case 90: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("Lap", gdsv.getLap());
                ggdr.addParam("Lop", gdsv.getLop());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("Xp", gdsv.getXp());
                ggdr.addParam("Yp", gdsv.getYp());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                ggdr.addParam("Angle", gdsv.getAngle());
                ggdr.addParam("Nr", gdsv.getNr());
                ggdr.addParam("Xo", gdsv.getXo());
                ggdr.addParam("Yo", gdsv.getYo());
                break;
            }
            case 110: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                ggdr.addParam("NpProj", npproj);
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("ProjFlag", gdsv.getProjectionFlag());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            case 204: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("grid_units", "degrees");
                break;
            }
            default: {
                log.warn("Unknown Grid Type " + gdtn);
            }
        }
    }

    public void populateGDS1(GribGridDefRecord ggdr, Grib1GDSVariables gdsv, int gdskey) {
        int component_flag;
        int gdtn = gdsv.getGdtn();
        ggdr.addParam("GDSkey", Integer.toString(gdskey));
        ggdr.addParam("grid_type", gdtn);
        ggdr.addParam("grid_name", Grib1Tables.getGridName(gdtn));
        String winds = GribNumbers.isBitSet(gdsv.getResolution(), 8) ? "Relative" : "True";
        int n = component_flag = GribNumbers.isBitSet(gdsv.getResolution(), 8) ? 1 : 0;
        if ((gdtn < 50 || gdtn > 53) && gdtn != 100 && gdtn != 120 && gdtn != 1200) {
            int shape = gdsv.getShape();
            ggdr.addParam("grid_shape_code", shape);
            ggdr.addParam("grid_shape", Grib1Tables.getShapeName(shape));
            if (shape == 0) {
                ggdr.addParam("grid_radius_spherical_earth", gdsv.getEarthRadius());
            } else if (shape == 1) {
                ggdr.addParam("grid_major_axis_earth", gdsv.getMajorAxis());
                ggdr.addParam("grid_minor_axis_earth", gdsv.getMinorAxis());
            }
        }
        switch (gdtn) {
            case 0: 
            case 10: 
            case 20: 
            case 30: 
            case 201: 
            case 202: 
            case 203: 
            case 205: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("La2", gdsv.getLa2());
                ggdr.addParam("Lo2", gdsv.getLo2());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                if (gdtn == 10) {
                    ggdr.addParam("SpLat", gdsv.getSpLat());
                    ggdr.addParam("SpLon", gdsv.getSpLon());
                    ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                    break;
                }
                if (gdtn == 20) {
                    ggdr.addParam("pLat", gdsv.getPoleLat());
                    ggdr.addParam("pLon", gdsv.getPoleLon());
                    ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                    break;
                }
                if (gdtn != 30) break;
                ggdr.addParam("SpLat", gdsv.getSpLat());
                ggdr.addParam("SpLon", gdsv.getSpLon());
                ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                ggdr.addParam("pLat", gdsv.getPoleLat());
                ggdr.addParam("pLon", gdsv.getPoleLon());
                ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                break;
            }
            case 1: 
            case 6: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("La2", gdsv.getLa2());
                ggdr.addParam("Lo2", gdsv.getLo2());
                ggdr.addParam("Latin", gdsv.getLatin1());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            case 5: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("LoV", gdsv.getLoV());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("ProjFlag", gdsv.getProjectionFlag());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                ggdr.addParam("NpProj", npproj);
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            case 3: 
            case 13: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("LoV", gdsv.getLoV());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("ProjFlag", gdsv.getProjectionFlag());
                String npproj = "false";
                if ((gdsv.getProjectionFlag() & 0x80) == 0) {
                    npproj = "true";
                }
                ggdr.addParam("NpProj", npproj);
                ggdr.addParam("Latin1", gdsv.getLatin1());
                ggdr.addParam("Latin2", gdsv.getLatin2());
                ggdr.addParam("SpLat", gdsv.getSpLat());
                ggdr.addParam("SpLon", gdsv.getSpLon());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            case 4: 
            case 14: 
            case 24: 
            case 34: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("La1", gdsv.getLa1());
                ggdr.addParam("Lo1", gdsv.getLo1());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("La2", gdsv.getLa2());
                ggdr.addParam("Lo2", gdsv.getLo2());
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("NumberParallels", gdsv.getNp());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                if (gdtn == 14) {
                    ggdr.addParam("SpLat", gdsv.getSpLat());
                    ggdr.addParam("SpLon", gdsv.getSpLon());
                    ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                    break;
                }
                if (gdtn == 24) {
                    ggdr.addParam("pLat", gdsv.getPoleLat());
                    ggdr.addParam("pLon", gdsv.getPoleLon());
                    ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                    break;
                }
                if (gdtn != 34) break;
                ggdr.addParam("SpLat", gdsv.getSpLat());
                ggdr.addParam("SpLon", gdsv.getSpLon());
                ggdr.addParam("RotationAngle", gdsv.getRotationAngle());
                ggdr.addParam("pLat", gdsv.getPoleLat());
                ggdr.addParam("pLon", gdsv.getPoleLon());
                ggdr.addParam("StretchingFactor", gdsv.getStretchingFactor());
                break;
            }
            case 90: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("Lap", gdsv.getLap());
                ggdr.addParam("Lop", gdsv.getLop());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("Dx", gdsv.getDx());
                ggdr.addParam("Dy", gdsv.getDy());
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("Xp", gdsv.getXp());
                ggdr.addParam("Yp", gdsv.getYp());
                ggdr.addParam("Angle", gdsv.getAngle());
                ggdr.addParam("Nr", gdsv.getNr());
                ggdr.addParam("Xo", gdsv.getXo());
                ggdr.addParam("Yo", gdsv.getYo());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            case 204: {
                ggdr.addParam("Nx", gdsv.getNx());
                ggdr.addParam("Ny", gdsv.getNy());
                ggdr.addParam("ResCompFlag", gdsv.getResolution());
                ggdr.addParam("Winds", winds);
                ggdr.addParam("VectorComponentFlag", component_flag);
                ggdr.addParam("grid_units", gdsv.getGridUnits());
                ggdr.addParam("scanning_mode", gdsv.getScanMode());
                break;
            }
            default: {
                log.error("Unknown Grid Type " + gdtn);
            }
        }
    }

    public void setDebug(boolean flag) {
        debugTiming = flag;
    }

    public void setVerbose(boolean flag) {
        debugParse = flag;
    }

    public static void main(String[] args) throws IOException {
        File gbx = new File(GribIndexName.get("C:/data/NDFD.grib2"));
        if (!gbx.exists()) {
            gbx = new File(GribIndexName.get("/local/robb/data/grib/idd/text/NDFD_CONUS_5km_20090221_1200.grib2"));
        }
        debugParse = false;
        if (args.length < 1) {
            GridIndex index = new GribIndexReader().open(gbx.getPath());
        } else {
            GridIndex index = new GribIndexReader().open(args[0]);
        }
        if (debugTiming) {
            return;
        }
    }
}

