/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import java.io.IOException;
import java.io.InputStream;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.TimeUnitConverter;
import ucar.grib.GribResourceReader;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.GribLevelType;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib1.Grib1ParamLevel;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.AfwaTables;
import ucar.nc2.grib.grib1.tables.FnmocTables;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.grib.grib1.tables.Grib1WmoTimeType;
import ucar.nc2.grib.grib1.tables.NcepRfcTables;
import ucar.nc2.grib.grib1.tables.NcepTables;
import ucar.nc2.wmo.CommonCodeTable;

public class Grib1Customizer
implements GribTables {
    private static final Logger logger = LoggerFactory.getLogger(Grib1Customizer.class);
    private int center;
    private Grib1ParamTables tables;
    private TimeUnitConverter timeUnitConverter;
    private HashMap<Integer, GribLevelType> wmoTable3;

    public static Grib1Customizer factory(Grib1Record proto, Grib1ParamTables tables) {
        int center = proto.getPDSsection().getCenter();
        int subcenter = proto.getPDSsection().getSubCenter();
        int version = proto.getPDSsection().getTableVersion();
        return Grib1Customizer.factory(center, subcenter, version, tables);
    }

    public static Grib1Customizer factory(int center, int subcenter, int version, Grib1ParamTables tables) {
        if (center == 7) {
            return new NcepTables(tables);
        }
        if (center == 9) {
            return new NcepRfcTables(tables);
        }
        if (center == 57) {
            return new AfwaTables(tables);
        }
        if (center == 58) {
            return new FnmocTables(tables);
        }
        return new Grib1Customizer(center, tables);
    }

    public static String getSubCenterName(int center, int subcenter) {
        Grib1Customizer cust = Grib1Customizer.factory(center, subcenter, 0, null);
        return cust.getSubCenterName(subcenter);
    }

    protected Grib1Customizer(int center, Grib1ParamTables tables) {
        this.center = center;
        this.tables = tables == null ? new Grib1ParamTables() : tables;
    }

    public int getCenter() {
        return this.center;
    }

    public Grib1Parameter getParameter(int center, int subcenter, int tableVersion, int param_number) {
        return this.tables.getParameter(center, subcenter, tableVersion, param_number);
    }

    public String getGeneratingProcessName(int genProcess) {
        return null;
    }

    public String getSubCenterName(int subcenter) {
        return CommonCodeTable.getSubCenterName(this.center, subcenter);
    }

    public String makeVariableName(GribCollection gribCollection, GribCollection.VariableIndex vindex) {
        return this.makeVariableNameFromTables(gribCollection.getCenter(), gribCollection.getSubcenter(), vindex.tableVersion, vindex.parameter, vindex.levelType, vindex.isLayer, vindex.intvType, vindex.intvName);
    }

    public String makeVariableName(Grib1SectionProductDefinition pds) {
        return this.makeVariableNameFromTables(pds.getCenter(), pds.getSubCenter(), pds.getTableVersion(), pds.getParameterNumber(), pds.getLevelType(), this.isLayer(pds.getLevelType()), pds.getTimeRangeIndicator(), null);
    }

    public String makeVariableNameFromRecord(GribCollection gribCollection, GribCollection.VariableIndex vindex) {
        return this.makeVariableNameFromRecord(gribCollection.getCenter(), gribCollection.getSubcenter(), vindex.tableVersion, vindex.parameter, vindex.levelType, vindex.isLayer, vindex.intvType, vindex.intvName);
    }

    private String makeVariableNameFromRecord(int center, int subcenter, int tableVersion, int paramNo, int levelType, boolean isLayer, int intvType, String intvName) {
        Formatter f = new Formatter();
        f.format("VAR_%d-%d-%d-%d", center, subcenter, tableVersion, paramNo);
        if (levelType != -9999) {
            f.format("_L%d", levelType);
            if (isLayer) {
                f.format("_layer", new Object[0]);
            }
        }
        if (intvType >= 0) {
            if (intvName != null) {
                if (intvName.equals("Mixed_intervals")) {
                    f.format("_Imixed", new Object[0]);
                } else {
                    f.format("_I%s", intvName);
                }
            }
            f.format("_S%s", intvType);
        }
        return f.toString();
    }

    private String makeVariableNameFromTables(int center, int subcenter, int version, int paramNo, int levelType, boolean isLayer, int intvType, String intvName) {
        Formatter f = new Formatter();
        Grib1Parameter param = this.getParameter(center, subcenter, version, paramNo);
        if (param == null) {
            f.format("VAR%d-%d-%d-%d", center, subcenter, version, paramNo);
        } else if (param.useName()) {
            f.format("%s", param.getName());
        } else {
            f.format("%s", GribUtils.makeNameFromDescription(param.getDescription()));
        }
        if (levelType != -9999) {
            f.format("_%s", this.getLevelNameShort(levelType));
            if (isLayer) {
                f.format("_layer", new Object[0]);
            }
        }
        if (intvType >= 0) {
            GribStatType stat = Grib1WmoTimeType.getStatType(intvType);
            if (stat != null) {
                if (intvName != null) {
                    f.format("_%s", intvName);
                }
                f.format("_%s", stat.name());
            } else {
                if (intvName != null) {
                    f.format("_%s", intvName);
                }
                f.format("_%d", intvType);
            }
        }
        return f.toString();
    }

    public String makeVariableLongName(int center, int subcenter, int version, int paramNo, int levelType, int intvType, String intvName, boolean isLayer, String probabilityName) {
        Grib1Parameter param;
        boolean isProb;
        Formatter f = new Formatter();
        boolean bl = isProb = probabilityName != null && probabilityName.length() > 0;
        if (isProb) {
            f.format("Probability ", new Object[0]);
        }
        if ((param = this.getParameter(center, subcenter, version, paramNo)) == null) {
            f.format("Unknown Parameter %d-%d-%d-%d", center, subcenter, version, paramNo);
        } else {
            f.format("%s", param.getDescription());
        }
        if (intvType >= 0) {
            GribStatType stat = Grib1WmoTimeType.getStatType(intvType);
            if (stat != null) {
                f.format(" (%s %s)", intvName, stat.name());
            } else if (intvName != null && intvName.length() > 0) {
                f.format(" (%s)", intvName);
            }
        }
        if (levelType != -9999) {
            f.format(" @ %s", this.getLevelDescription(levelType));
            if (isLayer) {
                f.format(" layer", new Object[0]);
            }
        }
        return f.toString();
    }

    public String makeVariableUnits(int center, int subcenter, int version, int paramNo) {
        Grib1Parameter param = this.getParameter(center, subcenter, version, paramNo);
        String val = param == null ? "" : param.getUnit();
        return val == null ? "" : val;
    }

    public Grib1ParamTime getParamTime(Grib1SectionProductDefinition pds) {
        return new Grib1ParamTime(this, pds);
    }

    public String getTimeTypeName(int timeRangeIndicator) {
        return Grib1WmoTimeType.getTimeTypeName(timeRangeIndicator);
    }

    public GribStatType getStatType(int timeRangeIndicator) {
        return Grib1WmoTimeType.getStatType(timeRangeIndicator);
    }

    public Grib1ParamLevel getParamLevel(Grib1SectionProductDefinition pds) {
        return new Grib1ParamLevel(this, pds);
    }

    public VertCoord.VertUnit getVertUnit(int code) {
        return this.makeVertUnit(code);
    }

    public boolean is3D(int levelType) {
        return this.getLevelUnits(levelType) != null;
    }

    protected VertCoord.VertUnit makeVertUnit(int code) {
        return this.getLevelType(code);
    }

    @Override
    public String getLevelNameShort(int levelType) {
        String result;
        GribLevelType lt = this.getLevelType(levelType);
        String string = result = lt == null ? null : lt.getAbbrev();
        if (result == null) {
            result = "unknownLevel" + levelType;
        }
        return result;
    }

    public String getLevelDescription(int levelType) {
        GribLevelType lt = this.getLevelType(levelType);
        return lt == null ? null : lt.getDesc();
    }

    public boolean isLayer(int levelType) {
        GribLevelType lt = this.getLevelType(levelType);
        return lt == null ? false : lt.isLayer();
    }

    public boolean isPositiveUp(int levelType) {
        GribLevelType lt = this.getLevelType(levelType);
        return lt == null ? false : lt.isPositiveUp();
    }

    public String getLevelUnits(int levelType) {
        GribLevelType lt = this.getLevelType(levelType);
        return lt == null ? null : lt.getUnits();
    }

    public String getLevelDatum(int levelType) {
        GribLevelType lt = this.getLevelType(levelType);
        return lt == null ? null : lt.getDatum();
    }

    public void setTimeUnitConverter(TimeUnitConverter timeUnitConverter) {
        this.timeUnitConverter = timeUnitConverter;
    }

    public int convertTimeUnit(int timeUnit) {
        if (this.timeUnitConverter == null) {
            return timeUnit;
        }
        return this.timeUnitConverter.convertTimeUnit(timeUnit);
    }

    private GribLevelType getLevelType(int code) {
        if (this.wmoTable3 == null) {
            this.wmoTable3 = this.readTable3("resources/grib1/wmoTable3.xml");
        }
        if (this.wmoTable3 == null) {
            return null;
        }
        GribLevelType result = this.wmoTable3.get(code);
        if (result == null) {
            result = new GribLevelType(code, "unknown code " + code, null, false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap<Integer, GribLevelType> readTable3(String path) {
        HashMap<Integer, GribLevelType> hashMap;
        InputStream is = null;
        try {
            is = GribResourceReader.getInputStream(path);
            if (is == null) {
                logger.error("Cant find Table 3 = " + path);
                HashMap<Integer, GribLevelType> hashMap2 = null;
                return hashMap2;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            HashMap<Integer, GribLevelType> result = new HashMap<Integer, GribLevelType>(200);
            List<Element> params = root.getChildren("parameter");
            for (Element elem1 : params) {
                int code = Integer.parseInt(elem1.getAttributeValue("code"));
                String desc = elem1.getChildText("description");
                String abbrev = elem1.getChildText("abbrev");
                String units = elem1.getChildText("units");
                String datum = elem1.getChildText("datum");
                boolean isLayer = elem1.getChild("isLayer") != null;
                boolean isPositiveUp = elem1.getChild("isPositiveUp") != null;
                GribLevelType lt = new GribLevelType(code, desc, abbrev, units, datum, isPositiveUp, isLayer);
                result.put(code, lt);
            }
            hashMap = result;
        }
        catch (IOException ioe) {
            logger.error("Cant read NcepLevelTypes = " + path, ioe);
            HashMap<Integer, GribLevelType> hashMap3 = null;
            return hashMap3;
        }
        catch (JDOMException e) {
            logger.error("Cant parse NcepLevelTypes = " + path, e);
            HashMap<Integer, GribLevelType> hashMap4 = null;
            return hashMap4;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return hashMap;
    }

    public static void main(String[] args) {
        Grib1Customizer cust = new Grib1Customizer(0, null);
        String units = cust.getLevelUnits(110);
        assert (units != null);
    }
}

