/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.io.IOException;
import ucar.grib.QuasiRegular;
import ucar.grib.grib2.Grib2BitMapSection;
import ucar.grib.grib2.Grib2DataRepresentationSection;
import ucar.grib.grib2.Grib2DataSection;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2LocalUseSection;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public final class GempakGrib2Data {
    private RandomAccessFile raf = null;
    private boolean expandQuasi = true;

    public GempakGrib2Data(RandomAccessFile raf) {
        this.raf = raf;
    }

    public GempakGrib2Data(RandomAccessFile raf, boolean expandQuasi) {
        this.raf = raf;
        this.expandQuasi = expandQuasi;
    }

    public final float[] getData(long start, long refTime) throws IOException {
        long time = System.currentTimeMillis();
        Grib2IdentificationSection id = null;
        Grib2LocalUseSection lus = null;
        Grib2GridDefinitionSection gds = null;
        Grib2ProductDefinitionSection pds = null;
        Grib2DataRepresentationSection drs = null;
        Grib2BitMapSection bms = null;
        Grib2DataSection ds = null;
        this.raf.order(0);
        this.raf.seek(start);
        int secLength = this.raf.readInt();
        if (secLength > 0) {
            id = new Grib2IdentificationSection(this.raf);
        }
        if ((secLength = this.raf.readInt()) > 0) {
            lus = new Grib2LocalUseSection(this.raf);
        }
        if ((secLength = this.raf.readInt()) > 0) {
            gds = new Grib2GridDefinitionSection(this.raf, false);
        }
        if ((secLength = this.raf.readInt()) > 0) {
            pds = new Grib2ProductDefinitionSection(this.raf, refTime);
        }
        if ((secLength = this.raf.readInt()) > 0) {
            drs = new Grib2DataRepresentationSection(this.raf);
        }
        if ((secLength = this.raf.readInt()) > 0) {
            bms = new Grib2BitMapSection(true, this.raf, gds);
        }
        if (bms.getBitmapIndicator() == 254) {
            long offset = this.raf.getFilePointer();
            gds = new Grib2GridDefinitionSection(this.raf, false);
            Grib2ProductDefinitionSection savepds = pds;
            pds = new Grib2ProductDefinitionSection(this.raf, refTime);
            Grib2DataRepresentationSection savedrs = drs;
            drs = new Grib2DataRepresentationSection(this.raf);
            bms = new Grib2BitMapSection(true, this.raf, gds);
            pds = savepds;
            drs = savedrs;
            this.raf.seek(offset);
        }
        if ((secLength = this.raf.readInt()) > 0) {
            ds = new Grib2DataSection(true, this.raf, gds, drs, bms);
        }
        if (gds.getOlon() == 0 || !this.expandQuasi) {
            return ds.getData();
        }
        QuasiRegular qr = new QuasiRegular(ds.getData(), gds);
        return qr.getData();
    }
}

