/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import ucar.util.prefs.Bean;
import ucar.util.prefs.PersistenceManager;

public class PreferencesExt
extends AbstractPreferences
implements PersistenceManager {
    static Preferences userRoot = new PreferencesExt(null, "");
    static Preferences systemRoot = new PreferencesExt(null, "");
    private boolean isBackingStoreAvailable = true;
    private PreferencesExt parent;
    private HashMap keyValues;
    private HashMap children;
    private PreferencesExt storedDefaults = null;

    public static void setUserRoot(PreferencesExt prefs) {
        userRoot = prefs;
    }

    public static void setSystemRoot(PreferencesExt prefs) {
        systemRoot = prefs;
    }

    public PreferencesExt(PreferencesExt parent, String name) {
        super(parent, name);
        this.parent = parent;
        this.keyValues = new HashMap(20);
        this.children = new HashMap(10);
    }

    void setStoredDefaults(PreferencesExt storedDefaults) {
        this.storedDefaults = storedDefaults;
    }

    private PreferencesExt getStoredDefaults() {
        return this.parent == null ? this.storedDefaults : this.parent.getStoredDefaults();
    }

    @Override
    public boolean isUserNode() {
        return this != systemRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBean(String key, Object def) {
        if (key == null) {
            throw new NullPointerException("Null key");
        }
        if (this.isRemoved()) {
            throw new IllegalStateException("Node has been removed.");
        }
        Object object = this.lock;
        synchronized (object) {
            Object result = null;
            try {
                result = this._getObject(key);
                if (result != null) {
                    if (result instanceof Bean.Collection) {
                        result = ((Bean.Collection)result).getCollection();
                    } else if (result instanceof Bean) {
                        result = ((Bean)result).getObject();
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return result == null ? def : result;
        }
    }

    public void putBean(String key, Object newValue) {
        Object oldValue = this.getBean(key, null);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.keyValues.put(key, new Bean(newValue));
        }
    }

    public void putBeanCollection(String key, Collection newValue) {
        Object oldValue = this.getBean(key, null);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.keyValues.put(key, new Bean.Collection(newValue));
        }
    }

    public void putBeanObject(String key, Object newValue) {
        Object oldValue = this.getBean(key, null);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.keyValues.put(key, newValue);
        }
    }

    @Override
    public List getList(String key, List def) {
        try {
            Object bean = this.getBean(key, def);
            return (List)bean;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void putList(String key, List newValue) {
        this.putBeanObject(key, newValue);
    }

    @Override
    protected String[] childrenNamesSpi() {
        HashSet allKids = new HashSet(this.children.keySet());
        PreferencesExt sd = this.getStoredDefaults();
        if (sd != null) {
            allKids.addAll(sd.childrenNamesSpi(this.absolutePath()));
        }
        ArrayList list = new ArrayList(allKids);
        Collections.sort(list);
        String[] result = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i).toString();
        }
        return result;
    }

    protected Collection childrenNamesSpi(String nodePath) {
        HashSet allKids = new HashSet();
        try {
            if (this.nodeExists(nodePath)) {
                PreferencesExt node = (PreferencesExt)this.node(nodePath);
                allKids.addAll(node.children.keySet());
            }
        }
        catch (BackingStoreException e) {
            // empty catch block
        }
        PreferencesExt sd = this.getStoredDefaults();
        if (sd != null) {
            allKids.addAll(sd.childrenNamesSpi(nodePath));
        }
        return allKids;
    }

    String[] keysNoDefaults() throws BackingStoreException {
        HashSet allKeys = new HashSet(this.keyValues.keySet());
        ArrayList list = new ArrayList(allKeys);
        Collections.sort(list);
        String[] result = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i).toString();
        }
        return result;
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        HashSet allKeys = new HashSet(this.keyValues.keySet());
        PreferencesExt sd = this.getStoredDefaults();
        if (sd != null) {
            allKeys.addAll(sd.keysSpi(this.absolutePath()));
        }
        ArrayList list = new ArrayList(allKeys);
        Collections.sort(list);
        String[] result = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i).toString();
        }
        return result;
    }

    protected Collection keysSpi(String nodePath) {
        HashSet allKeys = new HashSet();
        try {
            if (this.nodeExists(nodePath)) {
                PreferencesExt node = (PreferencesExt)this.node(nodePath);
                allKeys.addAll(node.keyValues.keySet());
            }
        }
        catch (BackingStoreException e) {
            // empty catch block
        }
        PreferencesExt sd = this.getStoredDefaults();
        if (sd != null) {
            allKeys.addAll(sd.keysSpi(nodePath));
        }
        return allKeys;
    }

    void dump() throws BackingStoreException {
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            System.out.println("key = " + keys[i] + " value= " + this.get(keys[i], null));
        }
        String[] kidNames = this.childrenNames();
        for (int i = 0; i < kidNames.length; ++i) {
            ((PreferencesExt)this.node(kidNames[i])).dump();
        }
    }

    void show(String what, Collection c) {
        try {
            System.out.println("---" + what + ":");
            for (Object o : c) {
                System.out.println("  " + o.toString() + " " + o.getClass().getName());
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        System.out.println("***");
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        PreferencesExt child = (PreferencesExt)this.children.get(name);
        if (null != child) {
            return child;
        }
        child = new PreferencesExt(this, name);
        this.children.put(name, child);
        child.newNode = true;
        return child;
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    @Override
    protected String getSpi(String keyName) {
        Object o = this._getObject(keyName);
        return o == null ? null : o.toString();
    }

    @Override
    protected void putSpi(String key, String newValue) {
        String oldValue = this.getSpi(key);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.keyValues.put(key, newValue);
        }
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        if (this.parent != null && null == this.parent.children.remove(this.name())) {
            System.out.println("ERROR PreferencesExt.removeNodeSpi :" + this.name());
        }
    }

    @Override
    protected void removeSpi(String key) {
        this.keyValues.remove(key);
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
    }

    Object getObjectNoDefaults(String keyName) {
        return this.keyValues.get(keyName);
    }

    @Override
    public void putObject(String keyName, Object value) {
        if (keyName == null) {
            throw new IllegalArgumentException("PreferencesExt try to store null keyname");
        }
        this.keyValues.put(keyName, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(String key) {
        Object object = this.lock;
        synchronized (object) {
            Object result = null;
            try {
                result = this._getObject(key);
            }
            catch (Exception e) {
                // empty catch block
            }
            return result;
        }
    }

    private Object _getObject(String keyName) {
        Object result = null;
        try {
            PreferencesExt sd;
            result = this.keyValues.get(keyName);
            if (result == null && (sd = this.getStoredDefaults()) != null) {
                result = sd.getObjectFromNode(this.absolutePath(), keyName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectFromNode(String nodePath, String keyName) {
        PreferencesExt preferencesExt;
        Object result;
        block9: {
            result = null;
            try {
                PreferencesExt node;
                if (!this.nodeExists(nodePath)) break block9;
                preferencesExt = node = (PreferencesExt)this.node(nodePath);
                synchronized (preferencesExt) {
                    result = node._getObject(keyName);
                }
            }
            catch (BackingStoreException e) {
                // empty catch block
            }
        }
        PreferencesExt sd = this.getStoredDefaults();
        if (result == null && sd != null) {
            preferencesExt = sd;
            synchronized (preferencesExt) {
                result = sd.getObjectFromNode(nodePath, keyName);
            }
        }
        return result;
    }
}

