/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ThreddsMetadata;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CollectionManager;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.fmrc.Fmrc;
import ucar.nc2.thredds.MetadataExtractor;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.util.StringUtil2;

@ThreadSafe
public class InvDatasetFcFmrc
extends InvDatasetFeatureCollection {
    private static final Logger logger = LoggerFactory.getLogger(InvDatasetFcFmrc.class);
    private static final String FMRC = "fmrc.ncd";
    private static final String BEST = "best.ncd";
    private static final String RUNS = "runs";
    private static final String RUN_NAME = "RUN_";
    private static final String RUN_TITLE = "Forecast Model Run";
    private static final String FORECAST = "forecast";
    private static final String FORECAST_NAME = "ConstantForecast_";
    private static final String FORECAST_TITLE = "Constant Forecast Date";
    private static final String OFFSET = "offset";
    private static final String OFFSET_NAME = "Offset_";
    private static final String OFFSET_TITLE = "Constant Forecast Offset";
    private final Fmrc fmrc;
    private final Set<FeatureCollectionConfig.FmrcDatasetType> wantDatasets;

    InvDatasetFcFmrc(InvDatasetImpl parent, String name, String path, FeatureCollectionType fcType, FeatureCollectionConfig config) {
        super(parent, name, path, fcType, config);
        this.tmi.setDataType(FeatureType.GRID);
        this.finish();
        Formatter errlog = new Formatter();
        try {
            this.fmrc = new Fmrc(this.dcm, config);
        }
        catch (Exception e) {
            throw new RuntimeException(errlog.toString());
        }
        this.wantDatasets = config.fmrcConfig.datasets;
    }

    @Override
    public void update(CollectionManager.Force force) {
        this.fmrc.update();
    }

    @Override
    public void updateProto() {
        this.fmrc.updateProto();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InvDatasetFeatureCollection.State checkState() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean checkInv = true;
            boolean checkProto = true;
            if (this.state == null) {
                this.orgService = this.getServiceDefault();
                if (this.orgService == null) {
                    throw new IllegalStateException("no default service in FMRC dataset " + this.getName());
                }
                this.virtualService = this.makeVirtualService(this.orgService);
            } else {
                this.fmrc.checkNeeded(false);
                checkInv = this.fmrc.checkInvState(this.state.lastInvChange);
                checkProto = this.fmrc.checkProtoState(this.state.lastProtoChange);
                if (!checkInv && !checkProto) {
                    return this.state;
                }
            }
            InvDatasetFeatureCollection.State localState = new InvDatasetFeatureCollection.State(this.state);
            if (checkProto) {
                GridDataset gds = this.fmrc.getDataset2D(null);
                if (null != gds) {
                    localState.vars = MetadataExtractor.extractVariables(this, (ucar.nc2.dt.GridDataset)gds);
                    localState.coverage = MetadataExtractor.extractGeospatial(gds);
                    localState.dateRange = MetadataExtractor.extractCalendarDateRange(gds);
                }
                localState.lastProtoChange = System.currentTimeMillis();
            }
            if (checkInv) {
                this.makeDatasetTop(localState);
                localState.lastInvChange = System.currentTimeMillis();
            }
            this.state = localState;
            return this.state;
        }
    }

    @Override
    public InvCatalogImpl makeCatalog(String match, String orgPath, URI catURI) {
        logger.debug("FMRC make catalog for " + match + " " + catURI);
        InvDatasetFeatureCollection.State localState = null;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", e);
            return null;
        }
        try {
            if (match == null || match.length() == 0) {
                InvCatalogImpl main = this.makeCatalogTop(catURI, localState);
                main.addService(this.virtualService);
                main.getDataset().getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
                main.finish();
                return main;
            }
            if (match.equals(RUNS) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Runs)) {
                return this.makeCatalogRuns(catURI, localState);
            }
            if (match.equals(OFFSET) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantOffsets)) {
                return this.makeCatalogOffsets(catURI, localState);
            }
            if (match.equals(FORECAST) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantForecasts)) {
                return this.makeCatalogForecasts(catURI, localState);
            }
            if (match.startsWith("files") && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Files)) {
                return this.makeCatalogFiles(catURI, localState, this.dcm.getFilenames(), true);
            }
        }
        catch (Exception e) {
            logger.error("Error making catalog for " + this.path, e);
        }
        return null;
    }

    private InvCatalogImpl makeCatalogRuns(URI catURI, InvDatasetFeatureCollection.State localState) throws IOException {
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl runCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), catURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(RUN_TITLE);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.coverage != null) {
            tmi.setGeospatialCoverage(localState.coverage);
        }
        runCatalog.addDataset(top);
        runCatalog.addService(this.virtualService);
        top.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
        for (InvDatasetImpl ds : this.makeRunDatasets()) {
            top.addDataset(ds);
        }
        runCatalog.finish();
        return runCatalog;
    }

    private InvCatalogImpl makeCatalogOffsets(URI catURI, InvDatasetFeatureCollection.State localState) throws IOException {
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl offCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), catURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.coverage != null) {
            tmi.setGeospatialCoverage(localState.coverage);
        }
        if (localState.dateRange != null) {
            tmi.setTimeCoverage(localState.dateRange);
        }
        top.setName(OFFSET_TITLE);
        offCatalog.addDataset(top);
        offCatalog.addService(this.virtualService);
        top.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
        for (InvDatasetImpl ds : this.makeOffsetDatasets()) {
            top.addDataset(ds);
        }
        offCatalog.finish();
        return offCatalog;
    }

    private InvCatalogImpl makeCatalogForecasts(URI catURI, InvDatasetFeatureCollection.State localState) throws IOException {
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl foreCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), catURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(FORECAST_TITLE);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.coverage != null) {
            tmi.setGeospatialCoverage(localState.coverage);
        }
        if (localState.dateRange != null) {
            tmi.setTimeCoverage(localState.dateRange);
        }
        foreCatalog.addDataset(top);
        foreCatalog.addService(this.virtualService);
        foreCatalog.addService(this.cdmrService);
        top.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
        for (InvDatasetImpl ds : this.makeForecastDatasets()) {
            top.addDataset(ds);
        }
        foreCatalog.finish();
        return foreCatalog;
    }

    private List<InvDatasetImpl> makeRunDatasets() throws IOException {
        ArrayList<InvDatasetImpl> datasets = new ArrayList<InvDatasetImpl>();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (CalendarDate runDate : this.fmrc.getRunDates()) {
            String name = this.getName() + "_" + RUN_NAME + runDate;
            name = StringUtil2.replace(name, ' ', "_");
            InvDatasetImpl nested = new InvDatasetImpl(this, name);
            nested.setUrlPath(this.path + "/" + RUNS + "/" + name);
            nested.setID(id + "/" + RUNS + "/" + name);
            ThreddsMetadata tm = nested.getLocalMetadata();
            tm.addDocumentation("summary", "Data from Run " + name);
            CalendarDateRange dr = this.fmrc.getDateRangeForRun(runDate);
            if (dr != null) {
                tm.setTimeCoverage(dr);
            }
            datasets.add(nested);
        }
        Collections.reverse(datasets);
        return datasets;
    }

    private List<InvDatasetImpl> makeOffsetDatasets() throws IOException {
        ArrayList<InvDatasetImpl> datasets = new ArrayList<InvDatasetImpl>();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (double offset : this.fmrc.getForecastOffsets()) {
            String name = this.getName() + "_" + OFFSET_NAME + offset + "hr";
            name = StringUtil2.replace(name, ' ', "_");
            InvDatasetImpl nested = new InvDatasetImpl(this, name);
            nested.setUrlPath(this.path + "/" + OFFSET + "/" + name);
            nested.setID(id + "/" + OFFSET + "/" + name);
            ThreddsMetadata tm = nested.getLocalMetadata();
            tm.addDocumentation("summary", "Data from the " + offset + " hour forecasts, across different model runs.");
            CalendarDateRange dr = this.fmrc.getDateRangeForOffset(offset);
            if (dr != null) {
                tm.setTimeCoverage(dr);
            }
            datasets.add(nested);
        }
        return datasets;
    }

    private List<InvDatasetImpl> makeForecastDatasets() throws IOException {
        ArrayList<InvDatasetImpl> datasets = new ArrayList<InvDatasetImpl>();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (CalendarDate forecastDate : this.fmrc.getForecastDates()) {
            String name = this.getName() + "_" + FORECAST_NAME + forecastDate;
            name = StringUtil2.replace(name, ' ', "_");
            InvDatasetImpl nested = new InvDatasetImpl(this, name);
            nested.setUrlPath(this.path + "/" + FORECAST + "/" + name);
            nested.setID(id + "/" + FORECAST + "/" + name);
            ThreddsMetadata tm = nested.getLocalMetadata();
            tm.addDocumentation("summary", "Data with the same forecast date, " + name + ", across different model runs.");
            tm.setTimeCoverage(CalendarDateRange.of(forecastDate, forecastDate));
            datasets.add(nested);
        }
        return datasets;
    }

    private void makeDatasetTop(InvDatasetFeatureCollection.State localState) {
        ThreddsMetadata tm;
        String name;
        InvDatasetImpl ds;
        String id;
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        InvDatasetImpl parent = (InvDatasetImpl)this.getParent();
        if (parent != null) {
            top.transferMetadata(parent, true);
        }
        if ((id = this.getID()) == null) {
            id = this.getPath();
        }
        top.setID(id);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.coverage != null) {
            tmi.setGeospatialCoverage(localState.coverage);
        }
        if (localState.dateRange != null) {
            tmi.setTimeCoverage(localState.dateRange);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.TwoD)) {
            ds = new InvDatasetImpl(this, "Forecast Model Run Collection (2D time coordinates)");
            name = this.getName() + "_" + FMRC;
            name = StringUtil2.replace(name, ' ', "_");
            ds.setUrlPath(this.path + "/" + name);
            ds.setID(id + "/" + name);
            tm = ds.getLocalMetadata();
            tm.addDocumentation("summary", "Forecast Model Run Collection (2D time coordinates).");
            ds.finish();
            top.addDataset(ds);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Best)) {
            ds = new InvDatasetImpl(this, "Best Time Series");
            name = this.getName() + "_" + BEST;
            name = StringUtil2.replace(name, ' ', "_");
            ds.setUrlPath(this.path + "/" + name);
            ds.setID(id + "/" + name);
            tm = ds.getLocalMetadata();
            tm.addDocumentation("summary", "Best time series, taking the data from the most recent run available.");
            ds.finish();
            top.addDataset(ds);
        }
        if (this.config.fmrcConfig.getBestDatasets() != null) {
            for (FeatureCollectionConfig.BestDataset bd : this.config.fmrcConfig.getBestDatasets()) {
                InvDatasetImpl ds2 = new InvDatasetImpl(this, bd.name);
                String name2 = this.getName() + "_" + bd.name;
                name2 = StringUtil2.replace(name2, ' ', "_");
                ds2.setUrlPath(this.path + "/" + name2);
                ds2.setID(id + "/" + name2);
                ThreddsMetadata tm2 = ds2.getLocalMetadata();
                tm2.addDocumentation("summary", "Best time series, excluding offset hours less than " + bd.greaterThan);
                ds2.finish();
                top.addDataset(ds2);
            }
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Runs)) {
            ds = new InvCatalogRef(this, RUN_TITLE, this.getCatalogHref(RUNS));
            ds.finish();
            top.addDataset(ds);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantForecasts)) {
            ds = new InvCatalogRef(this, FORECAST_TITLE, this.getCatalogHref(FORECAST));
            ds.finish();
            top.addDataset(ds);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantOffsets)) {
            ds = new InvCatalogRef(this, OFFSET_TITLE, this.getCatalogHref(OFFSET));
            ds.finish();
            top.addDataset(ds);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Files) && this.topDirectory != null) {
            InvCatalogRef filesCat = new InvCatalogRef(this, "files", this.getCatalogHref("files"));
            filesCat.finish();
            top.addDataset(filesCat);
        }
        localState.top = top;
        this.finish();
    }

    @Override
    public GridDataset getGridDataset(String matchPath) throws IOException {
        int pos = matchPath.indexOf(47);
        String wantType = pos > -1 ? matchPath.substring(0, pos) : matchPath;
        String wantName = pos > -1 ? matchPath.substring(pos + 1) : matchPath;
        String hasName = StringUtil2.replace(this.name, ' ', "_") + "_";
        try {
            if (wantType.equals("files")) {
                NetcdfDataset ncd = this.getNetcdfDataset(matchPath);
                return ncd == null ? null : new GridDataset(ncd);
            }
            if (wantName.equals(hasName + FMRC) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.TwoD)) {
                return this.fmrc.getDataset2D(null);
            }
            if (wantName.equals(hasName + BEST) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Best)) {
                return this.fmrc.getDatasetBest();
            }
            if (wantType.equals(OFFSET) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantOffsets)) {
                int pos1 = wantName.lastIndexOf(OFFSET_NAME);
                int pos2 = wantName.lastIndexOf("hr");
                if (pos1 < 0 || pos2 < 0) {
                    return null;
                }
                String id = wantName.substring(pos1 + OFFSET_NAME.length(), pos2);
                try {
                    double hour = Double.parseDouble(id);
                    return this.fmrc.getConstantOffsetDataset(hour);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (wantType.equals(RUNS) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.Runs)) {
                int pos1 = wantName.indexOf(RUN_NAME);
                if (pos1 < 0) {
                    return null;
                }
                String id = wantName.substring(pos1 + RUN_NAME.length());
                CalendarDate date = CalendarDate.parseISOformat(null, id);
                if (date == null) {
                    return null;
                }
                return this.fmrc.getRunTimeDataset(date);
            }
            if (wantType.equals(FORECAST) && this.wantDatasets.contains((Object)FeatureCollectionConfig.FmrcDatasetType.ConstantForecasts)) {
                int pos1 = wantName.indexOf(FORECAST_NAME);
                if (pos1 < 0) {
                    return null;
                }
                String id = wantName.substring(pos1 + FORECAST_NAME.length());
                CalendarDate date = CalendarDate.parseISOformat(null, id);
                if (date == null) {
                    return null;
                }
                return this.fmrc.getConstantForecastDataset(date);
            }
            if (this.config.fmrcConfig.getBestDatasets() != null) {
                for (FeatureCollectionConfig.BestDataset bd : this.config.fmrcConfig.getBestDatasets()) {
                    if (!wantName.endsWith(bd.name)) continue;
                    return this.fmrc.getDatasetBest(bd);
                }
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return null;
    }

    @Override
    public FeatureDataset getFeatureDataset() {
        return null;
    }
}

