/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.TimePartitionCollection;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.grib1.Grib1TimePartitionBuilder;
import ucar.nc2.grib.grib2.Grib2TimePartitionBuilder;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.io.RandomAccessFile;

public abstract class TimePartition
extends GribCollection {
    public static final byte VERT_COORDS_DIFFER = 1;
    public static final byte ENS_COORDS_DIFFER = 2;
    private static FileCache partitionCache;
    private static final FileFactory collectionFactory;
    protected Map<String, Partition> partitionMap = new TreeMap<String, Partition>();
    protected List<Partition> partitions = new ArrayList<Partition>();
    protected final Logger logger;

    public static void initPartitionCache(int minElementsInMemory, int maxElementsInMemory, int period) {
        partitionCache = new FileCache("TimePartitionCache", minElementsInMemory, maxElementsInMemory, -1, period);
    }

    public static FileCache getPartitionCache() {
        return partitionCache;
    }

    public static void disableNetcdfFileCache() {
        if (null != partitionCache) {
            partitionCache.disable();
        }
        partitionCache = null;
    }

    public static boolean update(boolean isGrib1, TimePartitionCollection tpc, Logger logger) throws IOException {
        if (isGrib1) {
            return Grib1TimePartitionBuilder.update(tpc, logger);
        }
        return Grib2TimePartitionBuilder.update(tpc, logger);
    }

    public static TimePartition factory(boolean isGrib1, TimePartitionCollection tpc, CollectionManager.Force force, Logger logger) throws IOException {
        if (isGrib1) {
            return Grib1TimePartitionBuilder.factory(tpc, force, logger);
        }
        return Grib2TimePartitionBuilder.factory(tpc, force, logger);
    }

    protected TimePartition(String name, File directory, FeatureCollectionConfig.GribConfig dcm, boolean isGrib1, Logger logger) {
        super(name, directory, dcm, isGrib1);
        this.logger = logger;
    }

    @Override
    public List<String> getFilenames() {
        List<Partition> parts = this.getPartitions();
        ArrayList<String> result = new ArrayList<String>(parts.size());
        for (Partition p : parts) {
            result.add(p.indexFilename);
        }
        return result;
    }

    public void addPartition(String name, String filename, long lastModified, String directory) {
        Partition partition = new Partition(name, filename, lastModified, directory);
        this.partitionMap.put(name, partition);
        this.partitions.add(partition);
    }

    public void addPartition(CollectionManager dcm) {
        Partition partition = new Partition(dcm);
        this.partitionMap.put(dcm.getCollectionName(), new Partition(dcm));
        this.partitions.add(partition);
    }

    public Partition getPartitionByName(String name) {
        return this.partitionMap.get(name);
    }

    public Partition getPartitionLast() {
        return this.partitions.get(this.partitions.size() - 1);
    }

    @Override
    public GribCollection.VariableIndex makeVariableIndex(GribCollection.GroupHcs group, int tableVersion, int discipline, int category, int parameter, int levelType, boolean isLayer, int intvType, String intvName, int ensDerivedType, int probType, String probabilityName, int genProcessType, int cdmHash, int timeIdx, int vertIdx, int ensIdx, long recordsPos, int recordsLen) {
        throw new UnsupportedOperationException();
    }

    public GribCollection.VariableIndex makeVariableIndex(GribCollection.GroupHcs group, int tableVersion, int discipline, int category, int parameter, int levelType, boolean isLayer, int intvType, String intvName, int ensDerivedType, int probType, String probabilityName, int genProcessType, int cdmHash, int timeIdx, int vertIdx, int ensIdx, long recordsPos, int recordsLen, List<Integer> groupnoList, List<Integer> varnoList, List<Integer> flagList) {
        VariableIndexPartitioned vip = new VariableIndexPartitioned(group, discipline, category, parameter, levelType, isLayer, intvType, intvName, ensDerivedType, probType, probabilityName, genProcessType, cdmHash, timeIdx, vertIdx, ensIdx, recordsPos, recordsLen);
        int nparts = varnoList.size();
        vip.groupno = new int[nparts];
        vip.varno = new int[nparts];
        vip.flag = new int[nparts];
        for (int i = 0; i < nparts; ++i) {
            vip.groupno[i] = groupnoList.get(i);
            vip.varno[i] = varnoList.get(i);
            vip.flag[i] = flagList.get(i);
        }
        return vip;
    }

    public VariableIndexPartitioned makeVariableIndexPartitioned(GribCollection.VariableIndex vi, int nparts) {
        VariableIndexPartitioned vip = new VariableIndexPartitioned(vi.group, vi.discipline, vi.category, vi.parameter, vi.levelType, vi.isLayer, vi.intvType, vi.intvName, vi.ensDerivedType, vi.probType, vi.probabilityName, vi.genProcessType, vi.cdmHash, vi.timeIdx, vi.vertIdx, vi.ensIdx, vi.recordsPos, vi.recordsLen);
        vip.groupno = new int[nparts];
        vip.varno = new int[nparts];
        vip.flag = new int[nparts];
        for (int i = 0; i < nparts; ++i) {
            vip.groupno[i] = -1;
            vip.varno[i] = -1;
        }
        return vip;
    }

    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public List<Partition> getPartitionsSorted() {
        ArrayList<Partition> c = new ArrayList<Partition>(this.partitions);
        Collections.sort(c);
        if (this.gribConfig != null && !this.gribConfig.filesSortIncreasing.booleanValue()) {
            Collections.reverse(c);
        }
        return c;
    }

    public void removePartition(Partition p) {
        this.partitions.remove(p);
        if (null != p.getDcm()) {
            this.partitionMap.remove(p.getDcm().getCollectionName());
        }
    }

    @Override
    public void showIndex(Formatter f) {
        List<Partition> plist = this.getPartitions();
        f.format("Partitions (%d)%n", plist.size());
        for (Partition p : plist) {
            f.format("  %s%n", p);
        }
        f.format("%n", new Object[0]);
        for (GribCollection.GroupHcs g : this.groups) {
            for (GribCollection.VariableIndex v : g.varIndex) {
                VariableIndexPartitioned vp = (VariableIndexPartitioned)v;
                for (int i = 0; i < vp.flag.length; ++i) {
                    if (vp.flag[i] == 0) continue;
                    f.format("  %s has missing (%d) on partition %d%n", v.id(), vp.flag[i], i);
                }
            }
        }
        super.showIndex(f);
    }

    public RandomAccessFile getRaf(int partno, int fileno) throws IOException {
        Partition part = this.getPartitions().get(partno);
        GribCollection gc = part.getGribCollection();
        RandomAccessFile raf = gc.getDataRaf(fileno);
        gc.close();
        return raf;
    }

    @Override
    public void close() throws IOException {
        assert (this.objCache == null);
        super.close();
    }

    public void delete() throws IOException {
        if (partitionCache != null) {
            for (Partition tp : this.partitions) {
                partitionCache.remove(tp.indexFilename);
            }
        }
        this.close();
    }

    public void setPartitionIndexReletive() {
        File dir = new File(this.getLocation());
        for (Partition p : this.getPartitions()) {
            File old = new File(p.indexFilename);
            File n = new File(dir.getParent(), old.getName());
            p.indexFilename = n.getPath();
        }
    }

    static {
        collectionFactory = new FileFactory(){

            @Override
            public FileCacheable open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
                RandomAccessFile raf = new RandomAccessFile(location, "r");
                Partition p = (Partition)iospMessage;
                return GribCollection.createFromIndex(p.isGrib1(), p.getName(), new File(p.getDirectory()), raf, p.getConfig(), p.getLogger());
            }
        };
    }

    public class VariableIndexPartitioned
    extends GribCollection.VariableIndex {
        public int[] groupno;
        public int[] varno;
        public int[] flag;

        public VariableIndexPartitioned(GribCollection.GroupHcs g, int discipline, int category, int parameter, int levelType, boolean isLayer, int intvType, String intvName, int ensDerivedType, int probType, String probabilityName, int genProcessType, int cdmHash, int timeIdx, int vertIdx, int ensIdx, long recordsPos, int recordsLen) {
            super(g, 0, discipline, category, parameter, levelType, isLayer, intvType, intvName, ensDerivedType, probType, probabilityName, genProcessType, cdmHash, timeIdx, vertIdx, ensIdx, recordsPos, recordsLen);
        }

        public void setPartitionIndex(int partno, int groupIdx, int varIdx, int flag) {
            this.groupno[partno] = groupIdx;
            this.varno[partno] = varIdx;
            this.flag[partno] = flag;
        }

        public GribCollection.VariableIndex getVindex(int partno) throws IOException {
            Partition p = TimePartition.this.getPartitions().get(partno);
            GribCollection gc = p.getGribCollection();
            GribCollection.GroupHcs g = gc.groups.get(this.groupno[partno]);
            GribCollection.VariableIndex vindex = g.varIndex.get(this.varno[partno]);
            vindex.readRecords();
            gc.close();
            return vindex;
        }

        @Override
        public String toStringComplete() {
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append("VariableIndexPartitioned");
            sb.append("{\ngroupno=").append(this.groupno == null ? "null" : "");
            for (i = 0; this.groupno != null && i < this.groupno.length; ++i) {
                sb.append(i == 0 ? "" : ", ").append(this.groupno[i]);
            }
            sb.append("\n varno=").append(this.varno == null ? "null" : "");
            for (i = 0; this.varno != null && i < this.varno.length; ++i) {
                sb.append(i == 0 ? "" : ", ").append(this.varno[i]);
            }
            sb.append("\n flags=").append(this.flag == null ? "null" : "");
            for (i = 0; this.flag != null && i < this.flag.length; ++i) {
                sb.append(i == 0 ? "" : ", ").append(this.flag[i]);
            }
            sb.append("}\n");
            sb.append(super.toStringComplete());
            return sb.toString();
        }

        public void cleanup() throws IOException {
        }
    }

    public class Partition
    implements Comparable<Partition> {
        private final String name;
        private final String directory;
        private String indexFilename;
        private long lastModified;
        public GribCollection gc;
        private CollectionManager dcm;

        public Partition(String name, String indexFilename, long lastModified, String directory) {
            this.name = name;
            this.indexFilename = indexFilename;
            this.directory = directory;
            this.lastModified = lastModified;
        }

        public String getName() {
            return this.name;
        }

        public String getIndexFilename() {
            return this.indexFilename;
        }

        public String getDirectory() {
            return this.directory;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public boolean isGrib1() {
            return TimePartition.this.isGrib1;
        }

        public FeatureCollectionConfig.GribConfig getConfig() {
            return TimePartition.this.gribConfig;
        }

        public Logger getLogger() {
            return TimePartition.this.logger;
        }

        public CollectionManager getDcm() {
            return this.dcm;
        }

        public GribCollection getGribCollection() throws IOException {
            GribCollection result = partitionCache != null ? (GribCollection)partitionCache.acquire(collectionFactory, this.indexFilename, this.indexFilename, -1, null, this) : (GribCollection)collectionFactory.open(this.indexFilename, -1, null, this);
            return result;
        }

        @Override
        public int compareTo(Partition o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return "Partition{dcm=" + this.dcm + ", name='" + this.name + '\'' + ", filename='" + this.indexFilename + '\'' + '}';
        }

        public Partition(CollectionManager dcm) {
            this.dcm = dcm;
            this.name = dcm.getCollectionName();
            this.directory = dcm.getRoot();
        }

        public GribCollection makeGribCollection(CollectionManager.Force force) throws IOException {
            GribCollection result = GribCollection.factory(TimePartition.this.isGrib1, this.dcm, force, TimePartition.this.logger);
            this.indexFilename = result.getIndexFile().getPath();
            return result;
        }
    }
}

