/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli;

import com.lexicalscope.jewel.cli.CommandLineInterface;
import com.lexicalscope.jewel.cli.HelpMessage;
import com.lexicalscope.jewel.cli.HelpMessageBuilderImpl;
import com.lexicalscope.jewel.cli.OptionOrder;
import com.lexicalscope.jewel.cli.ParsedOptionSummary;
import com.lexicalscope.jewel.cli.specification.CliSpecification;
import com.lexicalscope.jewel.cli.specification.OptionsSpecification;
import com.lexicalscope.jewel.cli.specification.ParsedOptionSpecification;
import com.lexicalscope.jewel.cli.specification.UnparsedOptionSpecification;
import com.lexicalscope.jewelcli.internal.fluentcollections.$FluentDollar;
import com.lexicalscope.jewelcli.internal.fluentcollectionslist.$FluentList;
import com.lexicalscope.jewelcli.internal.fluentreflection.$FluentClass;
import com.lexicalscope.jewelcli.internal.fluentreflection.$FluentMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class OptionsSpecificationImpl<O>
implements CliSpecification,
OptionsSpecification<O> {
    private final $FluentClass<O> klass;
    private final Set<ParsedOptionSpecification> options;
    private final Map<String, ParsedOptionSpecification> optionsByName = new TreeMap<String, ParsedOptionSpecification>();
    private final Map<$FluentMethod, ParsedOptionSpecification> optionsMethod = new HashMap<$FluentMethod, ParsedOptionSpecification>();
    private final Map<$FluentMethod, ParsedOptionSpecification> optionalOptionsMethod = new HashMap<$FluentMethod, ParsedOptionSpecification>();
    private final Map<$FluentMethod, UnparsedOptionSpecification> unparsedOptionsMethod = new HashMap<$FluentMethod, UnparsedOptionSpecification>();
    private final Map<$FluentMethod, UnparsedOptionSpecification> unparsedOptionalOptionsMethod = new HashMap<$FluentMethod, UnparsedOptionSpecification>();

    OptionsSpecificationImpl($FluentClass<O> klass, List<ParsedOptionSpecification> optionSpecifications, List<UnparsedOptionSpecification> unparsedSpecifications) {
        this.klass = klass;
        this.options = klass.annotatedWith(CommandLineInterface.class) && klass.annotation(CommandLineInterface.class).order().equals((Object)OptionOrder.DEFINITION) ? new LinkedHashSet<ParsedOptionSpecification>() : new TreeSet<ParsedOptionSpecification>();
        for (ParsedOptionSpecification parsedOptionSpecification : optionSpecifications) {
            this.addOption(parsedOptionSpecification);
        }
        for (UnparsedOptionSpecification unparsedOptionSpecification : unparsedSpecifications) {
            this.addUnparsedOption(unparsedOptionSpecification);
        }
    }

    @Override
    public boolean isSpecified(String key) {
        return this.optionsByName.containsKey(key);
    }

    @Override
    public ParsedOptionSpecification getSpecification(String key) {
        return this.optionsByName.get(key);
    }

    @Override
    public ParsedOptionSpecification getSpecification($FluentMethod method) {
        if (this.optionsMethod.containsKey(method)) {
            return this.optionsMethod.get(method);
        }
        return this.optionalOptionsMethod.get(method);
    }

    @Override
    public $FluentList<ParsedOptionSpecification> getMandatoryOptions() {
        $FluentList<ParsedOptionSpecification> result = $FluentDollar.$.list(ParsedOptionSpecification.class);
        for (ParsedOptionSpecification specification : this.options) {
            if (specification.isOptional() || specification.hasDefaultValue()) continue;
            result.add(specification);
        }
        return result;
    }

    @Override
    public Iterator<ParsedOptionSpecification> iterator() {
        return new ArrayList<ParsedOptionSpecification>(this.optionsByName.values()).iterator();
    }

    @Override
    public UnparsedOptionSpecification getUnparsedSpecification() {
        return this.unparsedOptionsMethod.values().iterator().next();
    }

    @Override
    public boolean hasUnparsedSpecification() {
        return !this.unparsedOptionsMethod.values().isEmpty();
    }

    private String applicationName() {
        String applicationName;
        if (this.klass.annotatedWith(CommandLineInterface.class) && (applicationName = this.klass.annotation(CommandLineInterface.class).application()) != null && !applicationName.trim().equals("")) {
            return applicationName.trim();
        }
        return null;
    }

    private void addOption(ParsedOptionSpecification optionSpecification) {
        for (String name : optionSpecification.getNames()) {
            this.optionsByName.put(name, optionSpecification);
        }
        this.options.add(optionSpecification);
        this.optionsMethod.put(optionSpecification.getMethod(), optionSpecification);
        if (optionSpecification.isOptional()) {
            this.optionalOptionsMethod.put(optionSpecification.getOptionalityMethod(), optionSpecification);
        }
    }

    private void addUnparsedOption(UnparsedOptionSpecification optionSpecification) {
        this.unparsedOptionsMethod.put(optionSpecification.getMethod(), optionSpecification);
        if (optionSpecification.isOptional()) {
            this.unparsedOptionalOptionsMethod.put(optionSpecification.getOptionalityMethod(), optionSpecification);
        }
    }

    @Override
    public void describeTo(HelpMessage helpMessage) {
        if (!(this.hasCustomApplicationName() || this.hasUnparsedSpecification() && !this.getUnparsedSpecification().isHidden())) {
            helpMessage.noUsageInformation();
        } else {
            if (this.hasCustomApplicationName()) {
                helpMessage.hasUsageInformation(this.applicationName());
            } else {
                helpMessage.hasUsageInformation();
            }
            if (this.getMandatoryOptions().isEmpty()) {
                helpMessage.hasOnlyOptionalOptions();
            } else {
                helpMessage.hasSomeMandatoryOptions();
            }
            if (this.hasUnparsedSpecification() && !this.getUnparsedSpecification().isHidden()) {
                if (this.getUnparsedSpecification().isMultiValued()) {
                    helpMessage.hasUnparsedMultiValuedOption(this.getUnparsedSpecification().getValueName());
                } else {
                    helpMessage.hasUnparsedOption(this.getUnparsedSpecification().getValueName());
                }
            }
        }
        helpMessage.startOfOptions();
        for (ParsedOptionSpecification specification : this.options) {
            if (specification.isHidden()) continue;
            new ParsedOptionSummary(specification).describeOptionTo(helpMessage.option());
        }
        helpMessage.endOfOptions();
    }

    private boolean hasCustomApplicationName() {
        return !OptionsSpecificationImpl.nullOrBlank(this.applicationName());
    }

    static boolean nullOrBlank(String string) {
        return string == null || string.trim().equals("");
    }

    public String toString() {
        HelpMessageBuilderImpl helpMessage = new HelpMessageBuilderImpl();
        this.describeTo(helpMessage);
        return helpMessage.toString();
    }
}

