/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli;

import com.lexicalscope.jewel.cli.HelpMessage;
import com.lexicalscope.jewel.cli.HelpMessageOptionSummaryBuilderImpl;
import com.lexicalscope.jewel.cli.OptionHelpMessage;

class HelpMessageBuilderImpl
implements HelpMessage {
    private final StringBuilder message = new StringBuilder();
    private final String lineSeparator = System.getProperty("line.separator");
    private String separator = "";

    HelpMessageBuilderImpl() {
    }

    @Override
    public void noUsageInformation() {
        this.message.append("The options available are:");
    }

    @Override
    public void hasUsageInformation(String applicationName) {
        this.hasUsageInformation();
        this.message.append(String.format("%s ", applicationName));
    }

    @Override
    public void hasUsageInformation() {
        this.message.append("Usage: ");
    }

    @Override
    public void hasOnlyOptionalOptions() {
        this.message.append("[");
        this.message.append("options");
        this.message.append("]");
    }

    @Override
    public void hasSomeMandatoryOptions() {
        this.message.append("options");
    }

    @Override
    public void hasUnparsedMultiValuedOption(String valueName) {
        this.message.append(" ");
        this.message.append(valueName);
        this.message.append("...");
    }

    @Override
    public void hasUnparsedOption(String valueName) {
        this.message.append(" ");
        this.message.append(valueName);
    }

    @Override
    public void startOfOptions() {
        this.message.append(this.lineSeparator);
    }

    @Override
    public OptionHelpMessage option() {
        this.message.append(this.separator).append("\t");
        this.separator = this.lineSeparator;
        return new HelpMessageOptionSummaryBuilderImpl(this.message);
    }

    @Override
    public void endOfOptions() {
    }

    public String toString() {
        return this.message.toString();
    }
}

