/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.collection.Grib2Iosp;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.grib2.table.Grib2Customizer;

public class Grib2Collection
extends GribCollection {
    public Grib2Collection(String name, File directory, FeatureCollectionConfig config) {
        super(name, directory, config, false);
    }

    @Override
    public NetcdfDataset getNetcdfDataset(GribCollection.Dataset ds, GribCollection.GroupGC group, String filename, FeatureCollectionConfig gribConfig, Formatter errlog, Logger logger) throws IOException {
        if (filename == null) {
            Grib2Iosp iosp = new Grib2Iosp(group, ds.getType());
            GribCollection.NetcdfFileGC ncfile = new GribCollection.NetcdfFileGC(iosp, null, this.getIndexFilepathInCache(), null);
            return new NetcdfDataset(ncfile);
        }
        MFile wantFile = this.findMFileByName(filename);
        if (wantFile != null) {
            GribCollection gc = GribCdmIndex.openGribCollectionFromDataFile(false, wantFile, CollectionUpdateType.nocheck, gribConfig, errlog, logger);
            if (gc == null) {
                return null;
            }
            Grib2Iosp iosp = new Grib2Iosp(gc);
            GribCollection.NetcdfFileGC ncfile = new GribCollection.NetcdfFileGC(iosp, null, this.getIndexFilepathInCache(), null);
            return new NetcdfDataset(ncfile);
        }
        return null;
    }

    @Override
    public GridDataset getGridDataset(GribCollection.Dataset ds, GribCollection.GroupGC group, String filename, FeatureCollectionConfig gribConfig, Formatter errlog, Logger logger) throws IOException {
        if (filename == null) {
            Grib2Iosp iosp = new Grib2Iosp(group, ds.getType());
            GribCollection.NetcdfFileGC ncfile = new GribCollection.NetcdfFileGC(iosp, null, this.getIndexFilepathInCache() + "#" + group.getId(), null);
            NetcdfDataset ncd = new NetcdfDataset(ncfile);
            return new GridDataset(ncd);
        }
        MFile wantFile = this.findMFileByName(filename);
        if (wantFile != null) {
            GribCollection gc = GribCdmIndex.openGribCollectionFromDataFile(false, wantFile, CollectionUpdateType.nocheck, gribConfig, errlog, logger);
            if (gc == null) {
                return null;
            }
            Grib2Iosp iosp = new Grib2Iosp(gc);
            GribCollection.NetcdfFileGC ncfile = new GribCollection.NetcdfFileGC(iosp, null, this.getIndexFilepathInCache(), null);
            NetcdfDataset ncd = new NetcdfDataset(ncfile);
            return new GridDataset(ncd);
        }
        return null;
    }

    @Override
    public String makeVariableName(GribCollection.VariableIndex vindex) {
        return Grib2Iosp.makeVariableNameFromTable((Grib2Customizer)this.cust, this, vindex);
    }
}

