/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetFcFmrc;
import thredds.catalog.InvDatasetFcPoint;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.CollectionManagerCatalog;
import thredds.inventory.CollectionUpdateListener;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.CollectionUpdater;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.util.log.LoggerFactoryImpl;

@ThreadSafe
public abstract class InvDatasetFeatureCollection
extends InvCatalogRef
implements CollectionUpdateListener {
    protected static final String LATEST_DATASET_CATALOG = "latest.xml";
    protected static final String LATEST_SERVICE = "latest";
    protected static final String VARIABLES = "?metadata=variableMap";
    protected static final String FILES = "files";
    protected static final String Virtual_Services = "VirtualServices";
    private static String catalogServletName = "/catalog";
    protected static String context = "/thredds";
    private static String cdmrFeatureServiceUrlPath = "/cdmrFeature";
    private static ucar.nc2.util.log.LoggerFactory loggerFactory = new LoggerFactoryImpl();
    private static Logger classLogger = LoggerFactory.getLogger(InvDatasetFeatureCollection.class);
    protected InvService orgService;
    protected InvService virtualService;
    protected InvService cdmrService;
    protected Logger logger;
    protected final String path;
    protected final FeatureCollectionType fcType;
    protected final FeatureCollectionConfig config;
    protected String topDirectory;
    protected MCollection datasetCollection;
    protected String collectionName;
    @GuardedBy(value="lock")
    protected State state;
    @GuardedBy(value="lock")
    protected boolean first = true;
    protected final Object lock = new Object();

    public static void setContext(String c) {
        context = c;
    }

    public static void setCatalogServletName(String catServletName) {
        catalogServletName = catServletName;
    }

    protected static String buildCatalogServiceHref(String path) {
        return context + (catalogServletName == null ? "" : catalogServletName) + "/" + path + "/catalog.xml";
    }

    public static void setCdmrFeatureServiceUrlPath(String urlPath) {
        cdmrFeatureServiceUrlPath = urlPath;
    }

    public static void setLoggerFactory(ucar.nc2.util.log.LoggerFactory fac) {
        loggerFactory = fac;
    }

    private static InvService makeCdmrFeatureService() {
        return new InvService("cdmrFeature", "cdmrFeature", context + cdmrFeatureServiceUrlPath, null, null);
    }

    public static InvDatasetFeatureCollection factory(InvDatasetImpl parent, String name, String path, FeatureCollectionType fcType, FeatureCollectionConfig config) {
        InvDatasetFeatureCollection result;
        if (fcType == FeatureCollectionType.FMRC) {
            result = new InvDatasetFcFmrc(parent, name, path, fcType, config);
        } else if (fcType == FeatureCollectionType.GRIB1 || fcType == FeatureCollectionType.GRIB2) {
            try {
                Class<?> c = InvDatasetFeatureCollection.class.getClassLoader().loadClass("thredds.catalog.InvDatasetFcGrib");
                Constructor<?> ctor = c.getConstructor(InvDatasetImpl.class, String.class, String.class, FeatureCollectionType.class, FeatureCollectionConfig.class);
                result = (InvDatasetFeatureCollection)ctor.newInstance(new Object[]{parent, name, path, fcType, config});
            }
            catch (Throwable e) {
                classLogger.error("Failed to open " + name + " path=" + path, e);
                return null;
            }
        } else {
            result = new InvDatasetFcPoint(parent, name, path, fcType, config);
        }
        if (result != null) {
            result.finishConstruction();
        }
        return result;
    }

    protected InvDatasetFeatureCollection(InvDatasetImpl parent, String name, String path, FeatureCollectionType fcType, FeatureCollectionConfig config) {
        super(parent, name, InvDatasetFeatureCollection.buildCatalogServiceHref(path));
        this.path = path;
        this.fcType = fcType;
        this.config = config;
        this.getLocalMetadataInheritable().setDataType(fcType.getFeatureType());
        config.name = this.collectionName = CollectionAbstract.cleanName(config.name != null ? config.name : name);
        this.logger = loggerFactory.getLogger("fc." + this.collectionName);
        this.logger.info("FeatureCollection added = {}", (Object)this.getConfig());
    }

    protected void makeCollection() {
        Formatter errlog = new Formatter();
        this.datasetCollection = this.config.spec.startsWith("catalog:") ? new CollectionManagerCatalog(this.config.name, this.config.spec, null, errlog) : new MFileCollectionManager(this.config, errlog, this.logger);
        this.topDirectory = this.datasetCollection.getRoot();
        String errs = errlog.toString();
        if (errs.length() > 0) {
            this.logger.warn("MFileCollectionManager parse error = {} ", (Object)errs);
        }
    }

    protected void finishConstruction() {
        CollectionUpdater.INSTANCE.scheduleTasks(this.config, this, this.logger);
    }

    @Override
    public String getCollectionName() {
        return this.collectionName;
    }

    @Override
    public void sendEvent(CollectionUpdateType type) {
        this.update(type);
    }

    protected abstract void updateProto();

    protected abstract void updateCollection(State var1, CollectionUpdateType var2);

    protected abstract void makeDatasetTop(State var1);

    @Override
    boolean check(StringBuilder out, boolean show) {
        boolean isValid = true;
        return isValid && super.check(out, show);
    }

    protected String getCatalogHref(String what) {
        return InvDatasetFeatureCollection.buildCatalogServiceHref(this.path + "/" + what);
    }

    protected void firstInit() {
        this.orgService = this.getServiceDefault();
        if (this.orgService == null) {
            this.orgService = this.makeServiceDefault();
        }
        this.virtualService = this.makeServiceVirtual(this.orgService);
        this.cdmrService = InvDatasetFeatureCollection.makeCdmrFeatureService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State checkState() {
        Object object = this.lock;
        synchronized (object) {
            if (this.first) {
                this.firstInit();
                this.updateCollection(this.state, this.config.updateConfig.updateType);
                this.makeDatasetTop(this.state);
                this.first = false;
            }
        }
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(CollectionUpdateType force) {
        Object object = this.lock;
        synchronized (object) {
            if (this.first) {
                this.state = this.checkState();
                this.state.lastInvChange = System.currentTimeMillis();
                return;
            }
        }
        State localState = this.state.copy();
        this.updateCollection(localState, force);
        this.makeDatasetTop(localState);
        localState.lastInvChange = System.currentTimeMillis();
        Object object2 = this.lock;
        synchronized (object2) {
            this.state = localState;
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getLatestFileName() {
        if (this.config.gribConfig.latestNamer != null) {
            return this.config.gribConfig.latestNamer;
        }
        return "Latest " + this.name + " File";
    }

    public String getTopDirectoryLocation() {
        return this.topDirectory;
    }

    public FeatureCollectionConfig getConfig() {
        return this.config;
    }

    public MCollection getDatasetCollectionManager() {
        return this.datasetCollection;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public List<InvDataset> getDatasets() {
        try {
            this.checkState();
        }
        catch (Exception e) {
            this.logger.error("Error in checkState", e);
        }
        ArrayList<InvDataset> tops = new ArrayList<InvDataset>(1);
        tops.add(this.state.top);
        return tops;
    }

    protected InvService makeServiceDefault() {
        InvService result = new InvService("Default", ServiceType.COMPOUND.toString(), null, null, null);
        result.addService(InvService.opendap);
        result.addService(InvService.fileServer);
        result.addService(InvService.wms);
        result.addService(InvService.wcs);
        result.addService(InvService.ncss);
        result.addService(InvService.cdmremote);
        result.addService(InvService.ncml);
        result.addService(InvService.uddc);
        result.addService(InvService.iso);
        return result;
    }

    protected InvService makeServiceVirtual(InvService org) {
        if (org.getServiceType() != ServiceType.COMPOUND) {
            return org;
        }
        InvService result = new InvService(Virtual_Services, ServiceType.COMPOUND.toString(), null, null, null);
        for (InvService service : org.getServices()) {
            if (service.getServiceType() == ServiceType.HTTPServer) continue;
            result.addService(service);
        }
        return result;
    }

    public abstract InvCatalogImpl makeCatalog(String var1, String var2, URI var3);

    protected InvCatalogImpl makeCatalogTop(URI catURI, State localState) throws IOException, URISyntaxException {
        InvCatalogImpl parentCatalog = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl mainCatalog = new InvCatalogImpl(this.getName(), parentCatalog.getVersion(), catURI);
        mainCatalog.addDataset(localState.top);
        mainCatalog.addService(InvService.latest);
        mainCatalog.addService(this.virtualService);
        mainCatalog.finish();
        return mainCatalog;
    }

    protected InvCatalogImpl makeCatalogFiles(URI catURI, State localState, List<String> filenames, boolean addLatest) throws IOException {
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl result = new InvCatalogImpl(this.getFullName(), parent.getVersion(), catURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(FILES);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.coverage != null) {
            tmi.setGeospatialCoverage(localState.coverage);
        }
        tmi.setTimeCoverage((DateRange)null);
        result.addDataset(top);
        result.addService(this.orgService);
        top.getLocalMetadataInheritable().setServiceName(this.orgService.getName());
        if (addLatest) {
            InvDatasetImpl ds = new InvDatasetImpl(this, this.getLatestFileName());
            ds.setUrlPath(LATEST_DATASET_CATALOG);
            ds.setServiceName(LATEST_SERVICE);
            ds.finish();
            top.addDataset(ds);
            result.addService(InvService.latest);
        }
        ArrayList<String> sortedFilenames = new ArrayList<String>(filenames);
        Collections.sort(sortedFilenames, String.CASE_INSENSITIVE_ORDER);
        if (this.config.gribConfig != null && !this.config.gribConfig.filesSortIncreasing.booleanValue()) {
            Collections.reverse(sortedFilenames);
        }
        for (String f : sortedFilenames) {
            if (!f.startsWith(this.topDirectory)) {
                this.logger.warn("File {} doesnt start with topDir {}", (Object)f, (Object)this.topDirectory);
            }
            String fname = f.substring(this.topDirectory.length() + 1);
            InvDatasetImpl ds = new InvDatasetImpl(this, fname);
            String lpath = this.getPath() + "/" + FILES + "/" + fname;
            ds.setUrlPath(lpath);
            ds.setID(lpath);
            ds.tmi.addVariableMapLink(this.makeMetadataLink(lpath, VARIABLES));
            File file = new File(f);
            ds.tm.setDataSize(file.length());
            ds.finish();
            top.addDataset(ds);
        }
        result.finish();
        return result;
    }

    protected String makeMetadataLink(String datasetName, String metadata) {
        return context + "/metadata/" + datasetName + metadata;
    }

    public InvCatalogImpl makeLatest(String matchPath, String reqPath, URI catURI) throws IOException {
        MFile mfile;
        String mpath;
        this.checkState();
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl result = new InvCatalogImpl(this.getFullName(), parent.getVersion(), catURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(this.getLatestFileName());
        result.addDataset(top);
        if (this.orgService != null) {
            result.addService(this.orgService);
            top.getLocalMetadataInheritable().setServiceName(this.orgService.getName());
        }
        if (!(mpath = (mfile = this.datasetCollection.getLatestFile()).getPath()).startsWith(this.topDirectory)) {
            this.logger.warn("File {} doesnt start with topDir {}", (Object)mpath, (Object)this.topDirectory);
        }
        String fname = mpath.substring(this.topDirectory.length() + 1);
        String path = "files/" + fname;
        top.setUrlPath(this.path + "/" + path);
        top.setID(this.path + "/" + path);
        top.tmi.addVariableMapLink(this.makeMetadataLink(this.path + "/" + path, VARIABLES));
        top.tm.setDataSize(mfile.getLength());
        result.finish();
        return result;
    }

    public GridDataset getGridDataset(String matchPath) throws IOException {
        String name;
        int pos = matchPath.indexOf(47);
        String type = pos > -1 ? matchPath.substring(0, pos) : matchPath;
        String string = name = pos > -1 ? matchPath.substring(pos + 1) : "";
        if (type.equals(FILES)) {
            if (this.topDirectory == null) {
                return null;
            }
            String filename = this.topDirectory + (this.topDirectory.endsWith("/") ? "" : "/") + name;
            NetcdfDataset ncd = NetcdfDataset.acquireDataset(null, filename, null, -1, null, null);
            return new GridDataset(ncd);
        }
        return null;
    }

    public abstract FeatureDataset getFeatureDataset();

    public NetcdfDataset getNetcdfDataset(String matchPath) throws IOException {
        String name;
        int pos = matchPath.indexOf(47);
        String type = pos > -1 ? matchPath.substring(0, pos) : matchPath;
        String string = name = pos > -1 ? matchPath.substring(pos + 1) : "";
        if (type.equals(FILES)) {
            if (this.topDirectory == null) {
                return null;
            }
            String filename = this.topDirectory + (this.topDirectory.endsWith("/") ? "" : "/") + name;
            return NetcdfDataset.acquireDataset(null, filename, null, -1, null, null);
        }
        GridDataset gds = this.getGridDataset(matchPath);
        return gds == null ? null : (NetcdfDataset)gds.getNetcdfFile();
    }

    public File getFile(String remaining) {
        if (null == this.topDirectory) {
            return null;
        }
        int pos = remaining.indexOf(FILES);
        StringBuilder fname = new StringBuilder(this.topDirectory);
        if (!this.topDirectory.endsWith("/")) {
            fname.append("/");
        }
        fname.append(pos > -1 ? remaining.substring(pos + FILES.length() + 1) : remaining);
        return new File(fname.toString());
    }

    static class ScanFilter
    implements CrawlableDatasetFilter {
        private final Pattern p;
        private final long olderThan;

        public ScanFilter(Pattern p, long olderThan) {
            this.p = p;
            this.olderThan = olderThan;
        }

        @Override
        public boolean accept(CrawlableDataset dataset) {
            long now;
            Date lastModDate;
            Matcher matcher;
            if (dataset.isCollection()) {
                return true;
            }
            if (this.p != null && !(matcher = this.p.matcher(dataset.getName())).matches()) {
                return false;
            }
            return this.olderThan <= 0L || (lastModDate = dataset.lastModified()) == null || (now = System.currentTimeMillis()) - lastModDate.getTime() > this.olderThan;
        }

        @Override
        public Object getConfigObject() {
            return null;
        }
    }

    protected class State {
        protected ThreddsMetadata.Variables vars;
        protected ThreddsMetadata.GeospatialCoverage coverage;
        protected CalendarDateRange dateRange;
        protected InvDatasetImpl top;
        protected long lastInvChange;
        protected long lastProtoChange;

        protected State(State from) {
            if (from != null) {
                this.vars = from.vars;
                this.coverage = from.coverage;
                this.dateRange = from.dateRange;
                this.lastProtoChange = from.lastProtoChange;
                this.top = from.top;
                this.lastInvChange = from.lastInvChange;
            }
        }

        protected State copy() {
            return new State(this);
        }
    }
}

