/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.CDMNode;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.util.Indent;

public class Group
extends CDMNode
implements AttributeContainer {
    protected NetcdfFile ncfile;
    protected List<Variable> variables = new ArrayList<Variable>();
    protected List<Dimension> dimensions = new ArrayList<Dimension>();
    protected List<Group> groups = new ArrayList<Group>();
    protected List<Attribute> attributes = new ArrayList<Attribute>();
    protected List<EnumTypedef> enumTypedefs = new ArrayList<EnumTypedef>();
    private int hashCode = 0;

    static List<Group> collectPath(Group g) {
        ArrayList<Group> list = new ArrayList<Group>();
        while (g != null) {
            list.add(0, g);
            g = g.getParentGroup();
        }
        return list;
    }

    public boolean isRoot() {
        return this.getParentGroup() == null;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public Variable findVariable(String varShortName) {
        if (varShortName == null) {
            return null;
        }
        for (Variable v : this.variables) {
            if (!varShortName.equals(v.getShortName())) continue;
            return v;
        }
        return null;
    }

    public Variable findVariableOrInParent(String varShortName) {
        if (varShortName == null) {
            return null;
        }
        Variable v = this.findVariable(varShortName);
        Group parent = this.getParentGroup();
        if (v == null && parent != null) {
            v = parent.findVariableOrInParent(varShortName);
        }
        return v;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public NetcdfFile getNetcdfFile() {
        return this.ncfile;
    }

    public Group findGroup(String groupShortName) {
        if (groupShortName == null) {
            return null;
        }
        for (Group group : this.groups) {
            if (!groupShortName.equals(group.getShortName())) continue;
            return group;
        }
        return null;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public List<EnumTypedef> getEnumTypedefs() {
        return this.enumTypedefs;
    }

    public Dimension findDimension(String name) {
        if (name == null) {
            return null;
        }
        Dimension d = this.findDimensionLocal(name);
        if (d != null) {
            return d;
        }
        Group parent = this.getParentGroup();
        if (parent != null) {
            return parent.findDimension(name);
        }
        return null;
    }

    public Dimension findDimensionLocal(String name) {
        if (name == null) {
            return null;
        }
        for (Dimension d : this.dimensions) {
            if (!name.equals(d.getShortName())) continue;
            return d;
        }
        return null;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.immutable ? this.attributes : Collections.unmodifiableList(this.attributes);
    }

    @Override
    public void addAll(Iterable<Attribute> atts) {
        for (Attribute att : atts) {
            this.addAttribute(att);
        }
    }

    public Attribute findAttribute(String name) {
        if (name == null) {
            return null;
        }
        for (Attribute a : this.attributes) {
            if (!name.equals(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    public Attribute findAttributeIgnoreCase(String name) {
        if (name == null) {
            return null;
        }
        for (Attribute a : this.attributes) {
            if (!name.equalsIgnoreCase(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    public EnumTypedef findEnumeration(String name) {
        if (name == null) {
            return null;
        }
        for (EnumTypedef d : this.enumTypedefs) {
            if (!name.equals(d.getShortName())) continue;
            return d;
        }
        Group parent = this.getParentGroup();
        if (parent != null) {
            return parent.findEnumeration(name);
        }
        return null;
    }

    public Group commonParent(Group other) {
        if (this.isParent(other)) {
            return this;
        }
        if (other.isParent(this)) {
            return other;
        }
        while (!other.isParent(this)) {
            other = other.getParentGroup();
        }
        return other;
    }

    public boolean isParent(Group other) {
        while (other != this && other.getParentGroup() != null) {
            other = other.getParentGroup();
        }
        return other == this;
    }

    public String getNameAndAttributes() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Group ");
        sbuff.append(this.getShortName());
        sbuff.append("\n");
        for (Attribute att : this.attributes) {
            sbuff.append("  ").append(this.getShortName()).append(":");
            sbuff.append(att.toString());
            sbuff.append(";");
            sbuff.append("\n");
        }
        return sbuff.toString();
    }

    protected void writeCDL(Formatter out, Indent indent, boolean strict) {
        boolean hasA;
        boolean hasE = this.enumTypedefs.size() > 0;
        boolean hasD = this.dimensions.size() > 0;
        boolean hasV = this.variables.size() > 0;
        boolean hasG = this.groups.size() > 0;
        boolean bl = hasA = this.attributes.size() > 0;
        if (hasE) {
            out.format("%stypes:%n", indent);
            indent.incr();
            for (EnumTypedef e : this.enumTypedefs) {
                e.writeCDL(out, indent, strict);
                out.format("%n", new Object[0]);
            }
            indent.decr();
            out.format("%n", new Object[0]);
        }
        if (hasD) {
            out.format("%sdimensions:%n", indent);
            indent.incr();
            for (Dimension myd : this.dimensions) {
                myd.writeCDL(out, indent, strict);
                out.format("%n", new Object[0]);
            }
            indent.decr();
        }
        if (hasV) {
            out.format("%svariables:%n", indent);
            indent.incr();
            for (Variable v : this.variables) {
                v.writeCDL(out, indent, false, strict);
                out.format("%n", new Object[0]);
            }
            indent.decr();
        }
        for (Group g : this.groups) {
            String gname = strict ? NetcdfFile.makeValidCDLName(g.getShortName()) : g.getShortName();
            out.format("%n%sgroup: %s {%n", indent, gname);
            indent.incr();
            g.writeCDL(out, indent, strict);
            indent.decr();
            out.format("%s}%n", indent);
        }
        if (hasA) {
            if (this.isRoot()) {
                out.format("%s// global attributes:%n", indent);
            } else {
                out.format("%s// group attributes:%n", indent);
            }
            for (Attribute att : this.attributes) {
                out.format("%s:", indent);
                att.writeCDL(out, strict);
                out.format(";", new Object[0]);
                if (!strict && att.getDataType() != DataType.STRING) {
                    out.format(" // %s", new Object[]{att.getDataType()});
                }
                out.format("%n", new Object[0]);
            }
        }
    }

    public Group(NetcdfFile ncfile, Group parent, String shortName) {
        super(shortName);
        this.ncfile = ncfile;
        this.setParentGroup(parent == null ? ncfile.getRootGroup() : parent);
    }

    @Override
    public void setParentGroup(Group parent) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        super.setParentGroup(parent == null ? this.ncfile.getRootGroup() : parent);
    }

    public String setName(String shortName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.setShortName(shortName);
        return this.getShortName();
    }

    @Override
    public Attribute addAttribute(Attribute att) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute a = this.attributes.get(i);
            if (!att.getShortName().equals(a.getShortName())) continue;
            this.attributes.set(i, att);
            return att;
        }
        this.attributes.add(att);
        return att;
    }

    public void addDimension(Dimension d) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (this.findDimensionLocal(d.getShortName()) != null) {
            throw new IllegalArgumentException("Dimension name (" + d.getShortName() + ") must be unique within Group " + this.getShortName());
        }
        this.dimensions.add(d);
        d.setGroup(this);
    }

    public boolean addDimensionIfNotExists(Dimension d) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (this.findDimensionLocal(d.getShortName()) != null) {
            return false;
        }
        this.dimensions.add(d);
        d.setGroup(this);
        return true;
    }

    public void addGroup(Group g) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (this.findGroup(g.getShortName()) != null) {
            throw new IllegalArgumentException("Group name (" + g.getShortName() + ") must be unique within Group " + this.getShortName());
        }
        this.groups.add(g);
        g.setParentGroup(this);
    }

    public void addEnumeration(EnumTypedef e) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (e == null) {
            return;
        }
        e.setParentGroup(this);
        this.enumTypedefs.add(e);
    }

    public void addVariable(Variable v) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (v == null) {
            return;
        }
        if (this.findVariable(v.getShortName()) != null) {
            Variable other = this.findVariable(v.getShortName());
            throw new IllegalArgumentException("Variable name (" + v.getShortName() + ") must be unique within Group " + this.getShortName());
        }
        this.variables.add(v);
        v.setParentGroup(this);
    }

    public boolean remove(Attribute a) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return a != null && this.attributes.remove(a);
    }

    public boolean remove(Dimension d) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return d != null && this.dimensions.remove(d);
    }

    public boolean remove(Group g) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return g != null && this.groups.remove(g);
    }

    public boolean remove(Variable v) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return v != null && this.variables.remove(v);
    }

    public boolean removeDimension(String dimName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension d = this.dimensions.get(i);
            if (!dimName.equals(d.getShortName())) continue;
            this.dimensions.remove(d);
            return true;
        }
        return false;
    }

    public boolean removeVariable(String shortName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable v = this.variables.get(i);
            if (!shortName.equals(v.getShortName())) continue;
            this.variables.remove(v);
            return true;
        }
        return false;
    }

    public Group setImmutable() {
        super.setImmutable(true);
        this.variables = Collections.unmodifiableList(this.variables);
        this.dimensions = Collections.unmodifiableList(this.dimensions);
        this.groups = Collections.unmodifiableList(this.groups);
        this.attributes = Collections.unmodifiableList(this.attributes);
        return this;
    }

    public String toString() {
        return this.getShortName();
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Group)) {
            return false;
        }
        Group og = (Group)oo;
        if (!this.getShortName().equals(og.getShortName())) {
            return false;
        }
        return this.getParentGroup() == null || this.getParentGroup().equals(og.getParentGroup());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getShortName().hashCode();
            if (this.getParentGroup() != null) {
                result = 37 * result + this.getParentGroup().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    @Override
    public void hashCodeShow(Indent indent) {
        System.out.printf("%sGroup hash = %d%n", indent, this.hashCode());
        System.out.printf("%s shortName %s = %d%n", indent, this.getShortName(), this.getShortName().hashCode());
        System.out.printf("%s parentGroup %s = %d%n", indent, this.getParentGroup(), this.getParentGroup().hashCode());
    }

    public Group makeRelativeGroup(NetcdfFile ncf, String path, boolean ignorelast) {
        boolean isabsolute;
        path = path.trim();
        boolean bl = isabsolute = (path = path.replace("//", "/")).charAt(0) == '/';
        if (isabsolute) {
            path = path.substring(1);
        }
        String[] pieces = path.split("/");
        if (ignorelast) {
            pieces[pieces.length - 1] = null;
        }
        Group current = isabsolute ? this.ncfile.getRootGroup() : this;
        for (String name : pieces) {
            if (name == null) continue;
            String clearname = NetcdfFile.makeNameUnescaped(name);
            Group next = current.findGroup(clearname);
            if (next == null) {
                next = new Group(ncf, current, clearname);
                current.addGroup(next);
            }
            current = next;
        }
        return current;
    }
}

