/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ft.point.writer.VariableSimpleImpl;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocation;

public class WriterCFPointCollection
extends CFPointWriter {
    private Variable time;
    private Variable lat;
    private Variable lon;
    private Variable alt;
    private int recno = 0;
    private ArrayDouble.D1 timeArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 latArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 lonArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 altArray = new ArrayDouble.D1(1);

    public WriterCFPointCollection(String fileOut, String title) throws IOException {
        this(null, fileOut, Arrays.asList(new Attribute("title", title)));
    }

    public WriterCFPointCollection(NetcdfFileWriter.Version version, String fileOut, List<Attribute> atts) throws IOException {
        super(fileOut, atts, version);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.point.name()));
    }

    public void writeHeader(List<VariableSimpleIF> vars, DateUnit timeUnit, String altUnits) throws IOException {
        this.altUnits = altUnits;
        this.writer.addUnlimitedDimension("obs");
        ArrayList<VariableSimpleIF> coords = new ArrayList<VariableSimpleIF>();
        coords.add(VariableSimpleImpl.make("time", "time of measurement", timeUnit.getUnitsString(), DataType.DOUBLE));
        coords.add(VariableSimpleImpl.make("latitude", "station latitude", "degrees_north", DataType.DOUBLE));
        coords.add(VariableSimpleImpl.make("longitude", "station longitude", "degrees_east", DataType.DOUBLE));
        if (altUnits != null) {
            coords.add(VariableSimpleImpl.make("altitude", "altitude", altUnits, DataType.DOUBLE).add(new Attribute("positive", CF1Convention.getZisPositive("altitude", altUnits))));
        }
        if (this.writer.getVersion().isExtendedModel()) {
            this.record = (Structure)this.writer.addVariable(null, "record", DataType.STRUCTURE, "obs");
            this.addCoordinatesExtended(coords);
            this.addVariablesExtended(vars);
            this.record.calcElementSize();
            this.writer.create();
        } else {
            this.addCoordinatesClassic(coords);
            this.addDataVariablesClassic(vars);
            this.writer.create();
            this.record = this.writer.addRecordStructure();
            this.time = this.writer.findVariable("time");
            this.lat = this.writer.findVariable("latitude");
            this.lon = this.writer.findVariable("longitude");
            this.alt = this.writer.findVariable("altitude");
        }
    }

    protected void addCoordinatesClassic(List<VariableSimpleIF> coords) throws IOException {
        for (VariableSimpleIF vs : coords) {
            Variable member = this.writer.addVariable(null, vs.getShortName(), vs.getDataType(), "obs");
            for (Attribute att : vs.getAttributes()) {
                member.addAttribute(att);
            }
        }
    }

    protected void addCoordinatesExtended(List<VariableSimpleIF> coords) throws IOException {
        for (VariableSimpleIF vs : coords) {
            Variable member = this.writer.addStructureMember(this.record, vs.getShortName(), vs.getDataType(), null);
            for (Attribute att : vs.getAttributes()) {
                member.addAttribute(att);
            }
        }
    }

    public void writeRecord(PointFeature sobs, StructureData sdata) throws IOException {
        this.writeRecord(sobs.getObservationTime(), sobs.getObservationTimeAsCalendarDate(), sobs.getLocation(), sdata);
    }

    public void writeRecord(double timeCoordValue, CalendarDate obsDate, EarthLocation loc, StructureData sdata) throws IOException {
        this.trackBB(loc, obsDate);
        this.timeArray.set(0, timeCoordValue);
        this.latArray.set(0, loc.getLatitude());
        this.lonArray.set(0, loc.getLongitude());
        if (this.altUnits != null) {
            this.altArray.set(0, loc.getAltitude());
        }
        int[] origin = new int[]{this.recno};
        try {
            super.writeStructureData(origin, sdata);
            if (this.isExtendedModel) {
                throw new RuntimeException("extended model not working yet");
            }
            this.writer.write(this.time, origin, this.timeArray);
            this.writer.write(this.lat, origin, this.latArray);
            this.writer.write(this.lon, origin, this.lonArray);
            if (this.altUnits != null) {
                this.writer.write(this.alt, origin, this.altArray);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        ++this.recno;
    }
}

