/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateND;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateSharer;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateVert;
import ucar.coord.Counter;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.collection.Grib1CollectionWriter;
import ucar.nc2.grib.collection.Grib1Iosp;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.GribCollectionBuilder;
import ucar.nc2.grib.grib1.Grib1Index;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.Grib1Utils;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.CloseableIterator;

public class Grib1CollectionBuilder
extends GribCollectionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(Grib1CollectionBuilder.class);
    private final boolean intvMerge;
    private final boolean useGenType;
    private final boolean useTableVersion;
    private final boolean useCenter;
    private FeatureCollectionConfig.GribConfig gribConfig;
    private Grib1Customizer cust;

    public Grib1CollectionBuilder(String name, MCollection dcm, Logger logger) {
        super(true, name, dcm, logger);
        FeatureCollectionConfig config = (FeatureCollectionConfig)dcm.getAuxInfo("fcConfig");
        this.gribConfig = config.gribConfig;
        Map<String, Boolean> pdsConfig = config.gribConfig.pdsHash;
        this.useTableVersion = this.assignValue(pdsConfig, "useTableVersion", true);
        this.intvMerge = this.assignValue(pdsConfig, "intvMerge", true);
        this.useCenter = this.assignValue(pdsConfig, "useCenter", true);
        this.useGenType = this.assignValue(pdsConfig, "useGenType", false);
    }

    private boolean assignValue(Map<String, Boolean> pdsHash, String key, boolean value) {
        Boolean b;
        if (pdsHash != null && (b = pdsHash.get(key)) != null) {
            value = b;
        }
        return value;
    }

    public List<Grib1CollectionWriter.Group> makeGroups(List<MFile> allFiles, Formatter errlog) throws IOException {
        HashMap<GribCollectionBuilder.GroupAndRuntime, Grib1CollectionWriter.Group> gdsMap = new HashMap<GribCollectionBuilder.GroupAndRuntime, Grib1CollectionWriter.Group>();
        logger.debug("Grib2CollectionBuilder {}: makeGroups", (Object)this.name);
        int fileno = 0;
        Counter statsAll = new Counter();
        logger.debug(" dcm={}", (Object)this.dcm);
        FeatureCollectionConfig config = (FeatureCollectionConfig)this.dcm.getAuxInfo("fcConfig");
        Map<String, Boolean> pdsConvert = config.gribConfig.pdsHash;
        FeatureCollectionConfig.GribIntvFilter intvMap = config != null ? config.gribConfig.intvFilter : null;
        int totalRecords = 0;
        try (CloseableIterator<MFile> iter = this.dcm.getFileIterator();){
            while (iter.hasNext()) {
                Grib1Index index;
                MFile mfile = (MFile)iter.next();
                try {
                    index = (Grib1Index)GribIndex.readOrCreateIndexFromSingleFile(true, false, mfile, config.gribConfig, CollectionUpdateType.test, logger);
                    allFiles.add(mfile);
                }
                catch (IOException ioe) {
                    logger.error("Grib2CollectionBuilder " + this.name + " : reading/Creating gbx9 index for file " + mfile.getPath() + " failed", ioe);
                    continue;
                }
                int n = index.getNRecords();
                totalRecords += n;
                for (Grib1Record gr : index.getRecords()) {
                    if (this.cust == null) {
                        this.cust = Grib1Customizer.factory(gr, null);
                        this.cust.setTimeUnitConverter(config.gribConfig.getTimeUnitConverter());
                    }
                    if (intvMap != null && this.filterOut(gr, intvMap)) {
                        ++statsAll.filter;
                        continue;
                    }
                    gr.setFile(fileno);
                    int gdsHash = gr.getGDSsection().getGDS().hashCode();
                    if (0 == (gdsHash = this.gribConfig.convertGdsHash(gdsHash))) continue;
                    CalendarDate runtime = gr.getReferenceDate();
                    GribCollectionBuilder.GroupAndRuntime gar = new GribCollectionBuilder.GroupAndRuntime(gdsHash, runtime.getMillis());
                    Grib1CollectionWriter.Group g = (Grib1CollectionWriter.Group)gdsMap.get(gar);
                    if (g == null) {
                        g = new Grib1CollectionWriter.Group(gr.getGDSsection(), gdsHash, runtime);
                        gdsMap.put(gar, g);
                    }
                    g.records.add(gr);
                }
                ++fileno;
                statsAll.recordsTotal += index.getRecords().size();
            }
        }
        ArrayList<Grib1CollectionWriter.Group> groups = new ArrayList<Grib1CollectionWriter.Group>(gdsMap.values());
        for (Grib1CollectionWriter.Group g : groups) {
            Counter stats = new Counter();
            Grib1Rectilyser rect = new Grib1Rectilyser(g.records, g.gdsHash, pdsConvert);
            rect.make(config.gribConfig, stats, errlog);
            g.gribVars = rect.gribvars;
            g.coords = rect.coords;
            statsAll.add(stats);
            if (config.gribConfig.gdsNamer == null) continue;
            g.nameOverride = config.gribConfig.gdsNamer.get(g.gdsHash);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(statsAll.show());
        }
        return groups;
    }

    private boolean filterOut(Grib1Record gr, FeatureCollectionConfig.GribIntvFilter intvFilter) {
        Grib1SectionProductDefinition pdss = gr.getPDSsection();
        Grib1ParamTime ptime = pdss.getParamTime(this.cust);
        if (!ptime.isInterval()) {
            return false;
        }
        int[] intv = ptime.getInterval();
        if (intv == null) {
            return false;
        }
        int haveLength = intv[1] - intv[0];
        if (haveLength == 0 && intvFilter.isZeroExcluded()) {
            return intv[0] == 0 && intv[1] == 0;
        }
        if (intvFilter.hasFilter()) {
            int param;
            int version;
            int subcenter;
            int center = pdss.getCenter();
            int id = (center << 8) + ((subcenter = pdss.getSubCenter()) << 16) + ((version = pdss.getTableVersion()) << 24) + (param = pdss.getParameterNumber());
            return !intvFilter.filterOk(id, haveLength, Integer.MIN_VALUE);
        }
        return false;
    }

    @Override
    protected boolean writeIndex(String name, String indexFilepath, CoordinateRuntime masterRuntime, List<? extends GribCollectionBuilder.Group> groups, List<MFile> files) throws IOException {
        Grib1CollectionWriter writer = new Grib1CollectionWriter(this.dcm, logger);
        ArrayList<Grib1CollectionWriter.Group> groups2 = new ArrayList<Grib1CollectionWriter.Group>();
        for (GribCollectionBuilder.Group group : groups) {
            groups2.add((Grib1CollectionWriter.Group)group);
        }
        File indexFileInCache = GribCollection.getFileInCache(indexFilepath);
        return writer.writeIndex(name, indexFileInCache, masterRuntime, groups2, files);
    }

    private int cdmVariableHash(Grib1Record gr, int gdsHash) {
        return Grib1CollectionBuilder.cdmVariableHash(this.cust, gr, gdsHash, this.useTableVersion, this.intvMerge, this.useCenter);
    }

    public static int cdmVariableHash(Grib1Customizer cust, Grib1Record gr) {
        return Grib1CollectionBuilder.cdmVariableHash(cust, gr, 0, true, true, true);
    }

    public static int cdmVariableHash(Grib1Customizer cust, Grib1Record gr, int gdsHash, boolean useTableVersion, boolean intvMerge, boolean useCenter) {
        Grib1ParamTime ptime;
        int result = 17;
        Grib1SectionGridDefinition gdss = gr.getGDSsection();
        result = gdsHash == 0 ? (result += result * 37 + gdss.getGDS().hashCode()) : (result += result * 37 + gdsHash);
        Grib1SectionProductDefinition pdss = gr.getPDSsection();
        result += result * 37 + pdss.getLevelType();
        if (cust.isLayer(pdss.getLevelType())) {
            result += result * 37 + 1;
        }
        result += result * 37 + pdss.getParameterNumber();
        if (useTableVersion) {
            result += result * 37 + pdss.getTableVersion();
        }
        if ((ptime = pdss.getParamTime(cust)).isInterval()) {
            if (!intvMerge) {
                result += result * 37 + ptime.getIntervalSize();
            }
            if (ptime.getStatType() != null) {
                result += result * 37 + ptime.getStatType().ordinal();
            }
        }
        if (useCenter && pdss.getParameterNumber() > 127) {
            result += result * 37 + pdss.getCenter();
            if (pdss.getSubCenter() > 0) {
                result += result * 37 + pdss.getSubCenter();
            }
        }
        return result;
    }

    private class Grib1Rectilyser {
        private final int gdsHash;
        private final List<Grib1Record> records;
        private List<VariableBag> gribvars;
        private List<Coordinate> coords;

        Grib1Rectilyser(List<Grib1Record> records, int gdsHash, Map<String, Boolean> pdsConfig) {
            this.records = records;
            this.gdsHash = gdsHash;
        }

        public void make(FeatureCollectionConfig.GribConfig config, Counter counter, Formatter info) throws IOException {
            boolean isDense = config != null && "dense".equals(config.getParameter("CoordSys"));
            CalendarPeriod userTimeUnit = config.getUserTimeUnit();
            HashMap<Integer, VariableBag> vbHash = new HashMap<Integer, VariableBag>(100);
            for (Grib1Record gr : this.records) {
                int cdmHash = Grib1CollectionBuilder.this.cdmVariableHash(gr, this.gdsHash);
                VariableBag bag = (VariableBag)vbHash.get(cdmHash);
                if (bag == null) {
                    bag = new VariableBag(gr, cdmHash);
                    vbHash.put(cdmHash, bag);
                }
                bag.atomList.add(gr);
            }
            this.gribvars = new ArrayList(vbHash.values());
            Collections.sort(this.gribvars);
            for (VariableBag vb : this.gribvars) {
                Grib1SectionProductDefinition pdss = vb.first.getPDSsection();
                Grib1ParamTime ptime = pdss.getParamTime(Grib1CollectionBuilder.this.cust);
                int unit = Grib1CollectionBuilder.this.cust.convertTimeUnit(pdss.getTimeUnit());
                vb.timeUnit = userTimeUnit == null ? Grib2Utils.getCalendarPeriod(unit) : userTimeUnit;
                vb.coordND = new CoordinateND();
                boolean isTimeInterval = ptime.isInterval();
                if (isDense) {
                    vb.coordND.addBuilder(new CoordinateRuntime.Builder1(vb.timeUnit));
                    if (isTimeInterval) {
                        vb.coordND.addBuilder(new CoordinateTimeIntv.Builder1(Grib1CollectionBuilder.this.cust, unit, vb.timeUnit, null));
                    } else {
                        vb.coordND.addBuilder(new CoordinateTime.Builder1(Grib1CollectionBuilder.this.cust, pdss.getTimeUnit(), vb.timeUnit, null));
                    }
                } else {
                    vb.coordND.addBuilder(new CoordinateRuntime.Builder1(vb.timeUnit));
                    vb.coordND.addBuilder(new CoordinateTime2D.Builder1(isTimeInterval, Grib1CollectionBuilder.this.cust, vb.timeUnit, unit));
                }
                if (vb.first.getPDSsection().isEnsemble()) {
                    vb.coordND.addBuilder(new CoordinateEns.Builder1(Grib1CollectionBuilder.this.cust, 0));
                }
                if (Grib1CollectionBuilder.this.cust.isVerticalCoordinate(pdss.getLevelType())) {
                    vb.coordND.addBuilder(new CoordinateVert.Builder1(Grib1CollectionBuilder.this.cust, pdss.getLevelType()));
                }
                for (Grib1Record gr : vb.atomList) {
                    vb.coordND.addRecord(gr);
                }
                vb.coordND.finish(vb.atomList, info);
            }
            CoordinateSharer<Grib1Record> sharify = new CoordinateSharer<Grib1Record>(isDense);
            for (VariableBag vb : this.gribvars) {
                sharify.addCoords(vb.coordND.getCoordinates());
            }
            sharify.finish();
            this.coords = sharify.getUnionCoords();
            int tot_used = 0;
            int tot_dups = 0;
            int total = 0;
            for (VariableBag vb : this.gribvars) {
                vb.coordND = sharify.reindex(vb.coordND);
                vb.coordIndex = sharify.reindex2shared(vb.coordND.getCoordinates());
                tot_used += vb.coordND.getSparseArray().countNotMissing();
                tot_dups += vb.coordND.getSparseArray().getNduplicates();
                total += vb.coordND.getSparseArray().getTotalSize();
            }
            counter.recordsUnique += tot_used;
            counter.dups += tot_dups;
            counter.vars += this.gribvars.size();
            counter.recordsTotal += total;
        }

        public void showInfo(Formatter f, Grib1Customizer tables) {
            Counter all = new Counter();
            for (VariableBag vb : this.gribvars) {
                f.format("Variable %s (%d)%n", Grib1Iosp.makeVariableName(Grib1CollectionBuilder.this.cust, vb.first.getPDSsection()), vb.cdmHash);
                vb.coordND.showInfo(f, all);
                f.format("%n", new Object[0]);
            }
            f.format("%n all= %s", all.show());
        }
    }

    public class VariableBag
    implements Comparable<VariableBag> {
        Grib1Record first;
        int cdmHash;
        public List<Grib1Record> atomList = new ArrayList<Grib1Record>(100);
        public CoordinateND<Grib1Record> coordND;
        CalendarPeriod timeUnit;
        public List<Integer> coordIndex;
        long pos;
        int length;

        private VariableBag(Grib1Record first, int cdmHash) {
            this.first = first;
            this.cdmHash = cdmHash;
        }

        @Override
        public int compareTo(VariableBag o) {
            return Grib1Utils.extractParameterCode(this.first).compareTo(Grib1Utils.extractParameterCode(o.first));
        }
    }
}

