/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.MFile;
import thredds.inventory.partition.DirectoryCollection;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.SparseArray;
import ucar.coord.TwoDTimeInventory;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.GcMFile;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarTimeZone;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;
import ucar.unidata.util.StringUtil2;

public abstract class GribCollection
implements FileCacheable,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GribCollection.class);
    public static final long MISSING_RECORD = -1L;
    private static FileCache dataRafCache;
    private static DiskCache2 diskCache;
    private static final FileFactory dataRafFactory;
    private static CalendarDateFormatter cf;
    protected final String name;
    protected File directory;
    protected final FeatureCollectionConfig config;
    protected final boolean isGrib1;
    public int version;
    public int center;
    public int subcenter;
    public int master;
    public int local;
    public int genProcessType;
    public int genProcessId;
    public int backProcessId;
    public List<Parameter> params;
    protected Map<Integer, MFile> fileMap;
    protected List<Dataset> datasets;
    protected List<HorizCoordSys> horizCS;
    protected CoordinateRuntime masterRuntime;
    protected GribTables cust;
    private Map<String, MFile> filenameMap;
    protected RandomAccessFile indexRaf;
    protected FileCache objCache = null;
    protected String indexFilename;
    private Set<String> groupNames = new HashSet<String>(5);

    public static void initDataRafCache(int minElementsInMemory, int maxElementsInMemory, int period) {
        dataRafCache = new FileCache("GribCollectionDataRafCache ", minElementsInMemory, maxElementsInMemory, -1, period);
    }

    public static FileCache getDataRafCache() {
        return dataRafCache;
    }

    public static void disableDataRafCache() {
        if (null != dataRafCache) {
            dataRafCache.disable();
        }
        dataRafCache = null;
    }

    public static void setDiskCache2(DiskCache2 dc) {
        diskCache = dc;
    }

    public static DiskCache2 getDiskCache2() {
        if (diskCache == null) {
            diskCache = DiskCache2.getDefault();
        }
        return diskCache;
    }

    public static File makeTopIndexFileFromConfig(FeatureCollectionConfig config) {
        Formatter errlog = new Formatter();
        CollectionSpecParser specp = new CollectionSpecParser(config.spec, errlog);
        String name = StringUtil2.replace(config.name, '\\', "/");
        String cname = null;
        switch (config.ptype) {
            case file: 
            case directory: {
                cname = DirectoryCollection.makeCollectionName(name, Paths.get(specp.getRootDir(), new String[0]));
                break;
            }
            case none: {
                cname = !specp.wantSubdirs() ? name : DirectoryCollection.makeCollectionName(name, Paths.get(specp.getRootDir(), new String[0]));
            }
        }
        return GribCollection.makeIndexFile(cname, new File(specp.getRootDir()));
    }

    static File makeIndexFile(String collectionName, File directory) {
        String nameNoBlanks = StringUtil2.replace(collectionName, ' ', "_");
        return new File(directory, nameNoBlanks + ".ncx2");
    }

    static MFile makeIndexMFile(String collectionName, File directory) {
        String nameNoBlanks = StringUtil2.replace(collectionName, ' ', "_");
        return new GcMFile(directory, nameNoBlanks + ".ncx2", -1L, -1);
    }

    public static String makeName(String collectionName, CalendarDate runtime) {
        String nameNoBlanks = StringUtil2.replace(collectionName, ' ', "_");
        return nameNoBlanks + "-" + cf.toString(runtime);
    }

    public static String makeNameFromIndexFilename(String idxPathname) {
        String idxFilename;
        int pos = (idxPathname = StringUtil2.replace(idxPathname, '\\', "/")).lastIndexOf(47);
        String string = idxFilename = pos < 0 ? idxPathname : idxPathname.substring(pos + 1);
        assert (idxFilename.endsWith(".ncx2"));
        return idxFilename.substring(0, idxFilename.length() - ".ncx2".length());
    }

    public static File getFileInCache(String path) {
        return GribCollection.getDiskCache2().getFile(path);
    }

    public static File getFileInCache(File f) {
        return GribCollection.getDiskCache2().getFile(f.getPath());
    }

    public static File getExistingFileOrCache(String path) {
        return GribCollection.getDiskCache2().getExistingFileOrCache(path);
    }

    protected GribCollection(String name, File directory, FeatureCollectionConfig config, boolean isGrib1) {
        this.name = name;
        this.directory = directory;
        this.config = config;
        this.isGrib1 = isGrib1;
        if (config == null) {
            logger.error("HEY GribCollection {} has empty config%n", (Object)name);
        }
        if (name == null) {
            logger.error("HEY GribCollection has null name dir={}%n", (Object)directory);
        }
    }

    protected void copyInfo(GribCollection from) {
        this.center = from.center;
        this.subcenter = from.subcenter;
        this.master = from.master;
        this.local = from.local;
        this.genProcessType = from.genProcessType;
        this.genProcessId = from.genProcessId;
        this.backProcessId = from.backProcessId;
    }

    public String getName() {
        return this.name;
    }

    public Collection<MFile> getFiles() {
        return this.fileMap.values();
    }

    public FeatureCollectionConfig getConfig() {
        return this.config;
    }

    public List<String> getFilenames() {
        ArrayList<String> result = new ArrayList<String>();
        for (MFile file : this.fileMap.values()) {
            result.add(file.getPath());
        }
        Collections.sort(result);
        return result;
    }

    public String getFilename(int fileno) {
        return this.fileMap.get(fileno).getPath();
    }

    public List<Dataset> getDatasets() {
        return this.datasets;
    }

    public Dataset findDataset(String name) {
        for (Dataset ds : this.datasets) {
            if (!ds.type.toString().equalsIgnoreCase(name)) continue;
            return ds;
        }
        return null;
    }

    public Dataset makeDataset(Type type) {
        Dataset result = new Dataset(type);
        this.datasets.add(result);
        return result;
    }

    public Dataset getDatasetCanonical() {
        for (Dataset ds : this.datasets) {
            if (ds.getType() == Type.GC) {
                return ds;
            }
            if (ds.getType() != Type.TwoD) continue;
            return ds;
        }
        return null;
    }

    public HorizCoordSys getHorizCS(int index) {
        return this.horizCS.get(index);
    }

    public CoordinateRuntime getMasterRuntime() {
        return this.masterRuntime;
    }

    protected void makeHorizCS() {
        HashMap<Integer, HorizCoordSys> gdsMap = new HashMap<Integer, HorizCoordSys>();
        for (Dataset ds : this.datasets) {
            for (GroupGC hcs : ds.getGroups()) {
                gdsMap.put(hcs.getGdsHash(), hcs.horizCoordSys);
            }
        }
        this.horizCS = new ArrayList<HorizCoordSys>();
        for (HorizCoordSys hcs : gdsMap.values()) {
            this.horizCS.add(hcs);
        }
    }

    public int findHorizCS(HorizCoordSys hcs) {
        return this.horizCS.indexOf(hcs);
    }

    public void addHorizCoordSystem(GdsHorizCoordSys hcs, byte[] rawGds, int gdsHash, String nameOverride, int predefinedGridDefinition) {
        this.horizCS.add(new HorizCoordSys(hcs, rawGds, gdsHash, nameOverride, predefinedGridDefinition));
    }

    public MFile findMFileByName(String filename) {
        if (this.filenameMap == null) {
            this.filenameMap = new HashMap<String, MFile>(this.fileMap.size() * 2);
            for (MFile file : this.fileMap.values()) {
                this.filenameMap.put(file.getName(), file);
            }
        }
        return this.filenameMap.get(filename);
    }

    public void setFileMap(Map<Integer, MFile> fileMap) {
        this.fileMap = fileMap;
    }

    void setIndexRaf(RandomAccessFile indexRaf) {
        this.indexRaf = indexRaf;
        if (indexRaf != null) {
            this.indexFilename = indexRaf.getLocation();
        }
    }

    public String getIndexFilepathInCache() {
        File indexFile = GribCollection.makeIndexFile(this.name, this.directory);
        return GribCollection.getFileInCache(indexFile.getPath()).getPath();
    }

    public List<Parameter> getParams() {
        return this.params;
    }

    public int getCenter() {
        return this.center;
    }

    public int getSubcenter() {
        return this.subcenter;
    }

    public int getMaster() {
        return this.master;
    }

    public int getLocal() {
        return this.local;
    }

    public int getGenProcessType() {
        return this.genProcessType;
    }

    public int getGenProcessId() {
        return this.genProcessId;
    }

    public int getBackProcessId() {
        return this.backProcessId;
    }

    public boolean isGrib1() {
        return this.isGrib1;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public abstract String makeVariableName(VariableIndex var1);

    public abstract NetcdfDataset getNetcdfDataset(Dataset var1, GroupGC var2, String var3, FeatureCollectionConfig var4, Formatter var5, Logger var6) throws IOException;

    public abstract GridDataset getGridDataset(Dataset var1, GroupGC var2, String var3, FeatureCollectionConfig var4, Formatter var5, Logger var6) throws IOException;

    public RandomAccessFile getDataRaf(int fileno) throws IOException {
        MFile mfile = this.fileMap.get(fileno);
        String filename = mfile.getPath();
        File dataFile = new File(filename);
        if (!dataFile.exists() && this.indexRaf != null) {
            File index = new File(this.indexRaf.getLocation());
            File parent = index.getParentFile();
            dataFile = this.fileMap.size() == 1 ? new File(parent, this.name) : new File(parent, dataFile.getName());
        }
        if (!dataFile.exists()) {
            throw new FileNotFoundException("data file not found = " + dataFile.getPath());
        }
        RandomAccessFile want = this.getDataRaf(dataFile.getPath());
        want.order(0);
        return want;
    }

    private RandomAccessFile getDataRaf(String location) throws IOException {
        if (dataRafCache != null) {
            return (RandomAccessFile)dataRafCache.acquire(dataRafFactory, location, null);
        }
        return new RandomAccessFile(location, "r");
    }

    @Override
    public void close() throws IOException {
        if (this.objCache != null) {
            this.objCache.release(this);
        } else if (this.indexRaf != null) {
            this.indexRaf.close();
            this.indexRaf = null;
        }
    }

    @Override
    public String getLocation() {
        if (this.indexRaf != null) {
            return this.indexRaf.getLocation();
        }
        return this.getIndexFilepathInCache();
    }

    @Override
    public long getLastModified() {
        File indexFile = GribCollection.makeIndexFile(this.name, this.directory);
        File indexFileInPath = GribCollection.getFileInCache(indexFile.getPath());
        if (indexFileInPath.exists()) {
            return indexFileInPath.lastModified();
        }
        return 0L;
    }

    @Override
    public void setFileCache(FileCache fileCache) {
        this.objCache = fileCache;
    }

    public VariableIndex makeVariableIndex(GroupGC g, int cdmHash, int discipline, GribTables customizer, byte[] rawPds, List<Integer> index, long recordsPos, int recordsLen) {
        return new VariableIndex(g, discipline, customizer, rawPds, cdmHash, index, recordsPos, recordsLen);
    }

    public VariableIndex makeVariableIndex(GroupGC g, VariableIndex other) {
        return new VariableIndex(g, other);
    }

    public void showIndex(Formatter f) {
        f.format("Class (%s)%n", this.getClass().getName());
        f.format("%s%n%n", this.toString());
        for (Dataset ds : this.datasets) {
            f.format("Dataset %s%n", new Object[]{ds.getType()});
            for (GroupGC g : ds.groups) {
                f.format(" Group %s%n", g.horizCoordSys.getId());
                for (VariableIndex v : g.variList) {
                    f.format("  %s%n", v.toStringShort());
                }
            }
        }
        if (this.fileMap == null) {
            f.format("Files empty%n", new Object[0]);
        } else {
            f.format("Files (%d)%n", this.fileMap.size());
            Iterator<Object> i$ = this.fileMap.keySet().iterator();
            while (i$.hasNext()) {
                int index = (Integer)i$.next();
                f.format("  %d: %s%n", index, this.fileMap.get(index));
            }
            f.format("%n", new Object[0]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GribCollection{");
        sb.append("\nname='").append(this.name).append('\'');
        sb.append("\n directory=").append(this.directory);
        sb.append("\n config=").append(this.config);
        sb.append("\n isGrib1=").append(this.isGrib1);
        sb.append("\n version=").append(this.version);
        sb.append("\n center=").append(this.center);
        sb.append("\n subcenter=").append(this.subcenter);
        sb.append("\n master=").append(this.master);
        sb.append("\n local=").append(this.local);
        sb.append("\n genProcessType=").append(this.genProcessType);
        sb.append("\n genProcessId=").append(this.genProcessId);
        sb.append("\n backProcessId=").append(this.backProcessId);
        sb.append("\n}");
        return sb.toString();
    }

    public GroupGC makeGroup() {
        return new GroupGC();
    }

    static {
        dataRafFactory = new FileFactory(){

            @Override
            public FileCacheable open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
                return new RandomAccessFile(location, "r");
            }
        };
        cf = new CalendarDateFormatter("yyyyMMdd-HHmmss", new CalendarTimeZone("UTC"));
    }

    protected static class NetcdfFileGC
    extends NetcdfFile {
        public NetcdfFileGC(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
            super(spi, raf, location, cancelTask);
        }
    }

    public static class Record {
        public final int fileno;
        public final long pos;
        public final long bmsPos;
        public final int scanMode;

        public Record(int fileno, long pos, long bmsPos, int scanMode) {
            this.fileno = fileno;
            this.pos = pos;
            this.bmsPos = bmsPos;
            this.scanMode = scanMode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("GribCollection.Record{");
            sb.append("fileno=").append(this.fileno);
            sb.append(", pos=").append(this.pos);
            sb.append(", bmsPos=").append(this.bmsPos);
            sb.append('}');
            return sb.toString();
        }
    }

    public class VariableIndex
    implements Comparable<VariableIndex> {
        public final GroupGC group;
        public final int tableVersion;
        public final int discipline;
        public final byte[] rawPds;
        public final int cdmHash;
        public final long recordsPos;
        public final int recordsLen;
        List<Integer> coordIndex;
        private SparseArray<Record> sa;
        TwoDTimeInventory twot;
        int[] time2runtime;
        public final int category;
        public final int parameter;
        public final int levelType;
        public final int intvType;
        public final int ensDerivedType;
        public final int probType;
        private String intvName;
        public final String probabilityName;
        public final boolean isLayer;
        public final boolean isEnsemble;
        public final int genProcessType;
        public int ndups;
        public int nrecords;
        public int missing;
        public int totalSize;
        public float density;
        List<Coordinate> coords;

        private VariableIndex(GroupGC g, int discipline, GribTables customizer, byte[] rawPds, int cdmHash, List<Integer> index, long recordsPos, int recordsLen) {
            this.group = g;
            this.discipline = discipline;
            this.rawPds = rawPds;
            this.cdmHash = cdmHash;
            this.coordIndex = index;
            this.recordsPos = recordsPos;
            this.recordsLen = recordsLen;
            if (GribCollection.this.isGrib1) {
                Grib1Customizer cust = (Grib1Customizer)customizer;
                Grib1SectionProductDefinition pds = new Grib1SectionProductDefinition(rawPds);
                this.category = 0;
                this.tableVersion = pds.getTableVersion();
                this.parameter = pds.getParameterNumber();
                this.levelType = pds.getLevelType();
                Grib1ParamTime ptime = pds.getParamTime(cust);
                this.intvType = ptime.isInterval() ? pds.getTimeRangeIndicator() : -1;
                this.isLayer = cust.isLayer(pds.getLevelType());
                this.ensDerivedType = -1;
                this.probType = -1;
                this.probabilityName = null;
                this.genProcessType = pds.getGenProcess();
                this.isEnsemble = pds.isEnsemble();
            } else {
                Grib2SectionProductDefinition pdss = new Grib2SectionProductDefinition(rawPds);
                Grib2Pds pds = null;
                try {
                    pds = pdss.getPDS();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.tableVersion = -1;
                this.category = pds.getParameterCategory();
                this.parameter = pds.getParameterNumber();
                this.levelType = pds.getLevelType1();
                this.intvType = pds.getStatisticalProcessType();
                this.isLayer = Grib2Utils.isLayer(pds);
                if (pds.isEnsembleDerived()) {
                    Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)pds);
                    this.ensDerivedType = pdsDerived.getDerivedForecastType();
                } else {
                    this.ensDerivedType = -1;
                }
                if (pds.isProbability()) {
                    Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds);
                    this.probabilityName = pdsProb.getProbabilityName();
                    this.probType = pdsProb.getProbabilityType();
                } else {
                    this.probType = -1;
                    this.probabilityName = null;
                }
                this.genProcessType = pds.getGenProcessType();
                this.isEnsemble = pds.isEnsemble();
            }
        }

        protected VariableIndex(GroupGC g, VariableIndex other) {
            this.group = g;
            this.tableVersion = other.tableVersion;
            this.discipline = other.discipline;
            this.rawPds = other.rawPds;
            this.cdmHash = other.cdmHash;
            this.coordIndex = new ArrayList<Integer>(other.coordIndex);
            this.recordsPos = 0L;
            this.recordsLen = 0;
            this.category = other.category;
            this.parameter = other.parameter;
            this.levelType = other.levelType;
            this.intvType = other.intvType;
            this.isLayer = other.isLayer;
            this.ensDerivedType = other.ensDerivedType;
            this.probabilityName = other.probabilityName;
            this.probType = other.probType;
            this.genProcessType = other.genProcessType;
            this.isEnsemble = other.isEnsemble;
            this.time2runtime = other.time2runtime;
            this.twot = other.twot;
        }

        public List<Coordinate> getCoordinates() {
            ArrayList<Coordinate> result = new ArrayList<Coordinate>(this.coordIndex.size());
            for (int idx : this.coordIndex) {
                result.add(this.group.coords.get(idx));
            }
            return result;
        }

        public CoordinateTimeAbstract getCoordinateTime() {
            Coordinate ctP = this.getCoordinate(Coordinate.Type.time);
            if (ctP == null) {
                ctP = this.getCoordinate(Coordinate.Type.timeIntv);
            }
            if (ctP == null) {
                ctP = this.getCoordinate(Coordinate.Type.time2D);
            }
            return (CoordinateTimeAbstract)ctP;
        }

        public Coordinate getCoordinate(Coordinate.Type want) {
            for (int idx : this.coordIndex) {
                if (this.group.coords.get(idx).getType() != want) continue;
                return this.group.coords.get(idx);
            }
            return null;
        }

        public int getCoordinateIdx(Coordinate.Type want) {
            for (int idx : this.coordIndex) {
                if (this.group.coords.get(idx).getType() != want) continue;
                return idx;
            }
            return -1;
        }

        public Coordinate getCoordinate(int index) {
            int grpIndex = this.coordIndex.get(index);
            return this.group.coords.get(grpIndex);
        }

        public int getCoordinateIndex(Coordinate.Type want) {
            for (int idx : this.coordIndex) {
                if (this.group.coords.get(idx).getType() != want) continue;
                return idx;
            }
            return -1;
        }

        public Iterable<Integer> getCoordinateIndex() {
            return this.coordIndex;
        }

        public String getTimeIntvName() {
            if (this.intvName != null) {
                return this.intvName;
            }
            CoordinateTimeIntv timeiCoord = (CoordinateTimeIntv)this.getCoordinate(Coordinate.Type.timeIntv);
            if (timeiCoord != null) {
                this.intvName = timeiCoord.getTimeIntervalName();
                return this.intvName;
            }
            CoordinateTime2D time2DCoord = (CoordinateTime2D)this.getCoordinate(Coordinate.Type.time2D);
            if (time2DCoord == null || !time2DCoord.isTimeInterval()) {
                return null;
            }
            this.intvName = time2DCoord.getTimeIntervalName();
            return this.intvName;
        }

        public SparseArray<Record> getSparseArray() {
            return this.sa;
        }

        public String id() {
            return this.discipline + "-" + this.category + "-" + this.parameter;
        }

        public int getVarid() {
            return (this.discipline << 16) + (this.category << 8) + this.parameter;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("VariableIndex");
            sb.append("{tableVersion=").append(this.tableVersion);
            sb.append(", discipline=").append(this.discipline);
            sb.append(", category=").append(this.category);
            sb.append(", parameter=").append(this.parameter);
            sb.append(", levelType=").append(this.levelType);
            sb.append(", intvType=").append(this.intvType);
            sb.append(", ensDerivedType=").append(this.ensDerivedType);
            sb.append(", probType=").append(this.probType);
            sb.append(", intvName='").append(this.intvName).append('\'');
            sb.append(", probabilityName='").append(this.probabilityName).append('\'');
            sb.append(", isLayer=").append(this.isLayer);
            sb.append(", genProcessType=").append(this.genProcessType);
            sb.append(", cdmHash=").append(this.cdmHash);
            sb.append('}');
            return sb.toString();
        }

        public String toStringComplete() {
            StringBuilder sb = new StringBuilder();
            sb.append("VariableIndex");
            sb.append("{tableVersion=").append(this.tableVersion);
            sb.append(", discipline=").append(this.discipline);
            sb.append(", category=").append(this.category);
            sb.append(", parameter=").append(this.parameter);
            sb.append(", levelType=").append(this.levelType);
            sb.append(", intvType=").append(this.intvType);
            sb.append(", ensDerivedType=").append(this.ensDerivedType);
            sb.append(", probType=").append(this.probType);
            sb.append(", intvName='").append(this.intvName).append('\'');
            sb.append(", probabilityName='").append(this.probabilityName).append('\'');
            sb.append(", isLayer=").append(this.isLayer);
            sb.append(", cdmHash=").append(this.cdmHash);
            sb.append(", recordsPos=").append(this.recordsPos);
            sb.append(", recordsLen=").append(this.recordsLen);
            sb.append(", group=").append(this.group.getId());
            sb.append("}\n");
            if (this.time2runtime == null) {
                sb.append("time2runtime is null");
            } else {
                sb.append("time2runtime=");
                for (int idx : this.time2runtime) {
                    sb.append(idx).append(",");
                }
            }
            return sb.toString();
        }

        public String toStringShort() {
            Formatter sb = new Formatter();
            sb.format("Variable {%d-%d-%d", this.discipline, this.category, this.parameter);
            sb.format(", levelType=%d", this.levelType);
            sb.format(", intvType=%d", this.intvType);
            if (this.intvName != null && this.intvName.length() > 0) {
                sb.format(" intv=%s", this.intvName);
            }
            if (this.probabilityName != null && this.probabilityName.length() > 0) {
                sb.format(" prob=%s", this.probabilityName);
            }
            sb.format(" cdmHash=%d}", this.cdmHash);
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readRecords() throws IOException {
            Object object;
            if (this.sa != null) {
                return;
            }
            if (this.recordsLen == 0) {
                return;
            }
            byte[] b = new byte[this.recordsLen];
            if (GribCollection.this.indexRaf != null) {
                object = GribCollection.this.indexRaf;
                synchronized (object) {
                    GribCollection.this.indexRaf.seek(this.recordsPos);
                    GribCollection.this.indexRaf.readFully(b);
                }
            }
            String idxPath = GribCollection.this.getIndexFilepathInCache();
            try (RandomAccessFile raf = new RandomAccessFile(idxPath, "r");){
                raf.seek(this.recordsPos);
                raf.readFully(b);
            }
            object = this;
            synchronized (object) {
                GribCollectionProto.SparseArray proto = GribCollectionProto.SparseArray.parseFrom(b);
                int cdmHash = proto.getCdmHash();
                if (cdmHash != this.cdmHash) {
                    throw new IllegalStateException("Corrupted index");
                }
                int nsizes = proto.getSizeCount();
                int[] size = new int[nsizes];
                for (int i = 0; i < nsizes; ++i) {
                    size[i] = proto.getSize(i);
                }
                int ntrack = proto.getTrackCount();
                int[] track = new int[ntrack];
                for (int i = 0; i < ntrack; ++i) {
                    track[i] = proto.getTrack(i);
                }
                int n = proto.getRecordsCount();
                ArrayList<Record> records = new ArrayList<Record>(n);
                for (int i = 0; i < n; ++i) {
                    GribCollectionProto.Record pr = proto.getRecords(i);
                    records.add(new Record(pr.getFileno(), pr.getPos(), pr.getBmsPos(), pr.getScanMode()));
                }
                this.sa = new SparseArray(size, track, records);
            }
        }

        @Override
        public int compareTo(VariableIndex o) {
            int r = this.discipline - o.discipline;
            if (r != 0) {
                return r;
            }
            r = this.category - o.category;
            if (r != 0) {
                return r;
            }
            r = this.parameter - o.parameter;
            if (r != 0) {
                return r;
            }
            r = this.levelType - o.levelType;
            if (r != 0) {
                return r;
            }
            r = this.intvType - o.intvType;
            return r;
        }

        public void calcTotalSize() {
            this.totalSize = 1;
            for (int idx : this.coordIndex) {
                Coordinate coord = this.group.coords.get(idx);
                if (coord instanceof CoordinateTime2D) {
                    this.totalSize *= ((CoordinateTime2D)coord).getNtimes();
                    continue;
                }
                this.totalSize *= coord.getSize();
            }
            this.density = (float)this.nrecords / (float)this.totalSize;
        }
    }

    public class GroupGC
    implements Comparable<GroupGC> {
        HorizCoordSys horizCoordSys;
        List<VariableIndex> variList;
        List<Coordinate> coords;
        int[] filenose;
        Map<Integer, VariableIndex> varMap;
        boolean isTwod = true;
        private CalendarDateRange dateRange = null;

        GroupGC() {
            this.variList = new ArrayList<VariableIndex>();
            this.coords = new ArrayList<Coordinate>();
        }

        GroupGC(GroupGC from) {
            this.horizCoordSys = from.horizCoordSys;
            this.variList = new ArrayList<VariableIndex>(from.variList.size());
            this.coords = new ArrayList<Coordinate>(from.coords.size());
            this.isTwod = from.isTwod;
        }

        public void setHorizCoordSystem(GdsHorizCoordSys hcs, byte[] rawGds, int gdsHash, String nameOverride, int predefinedGridDefinition) {
            this.horizCoordSys = new HorizCoordSys(hcs, rawGds, gdsHash, nameOverride, predefinedGridDefinition);
        }

        public VariableIndex addVariable(VariableIndex vi) {
            this.variList.add(vi);
            return vi;
        }

        public GribCollection getGribCollection() {
            return GribCollection.this;
        }

        public Iterable<VariableIndex> getVariables() {
            return this.variList;
        }

        public Iterable<Coordinate> getCoordinates() {
            return this.coords;
        }

        public String getId() {
            return this.horizCoordSys.getId();
        }

        public String getDescription() {
            return this.horizCoordSys.getDescription();
        }

        public GdsHorizCoordSys getGdsHorizCoordSys() {
            return this.horizCoordSys.getHcs();
        }

        public int getGdsHash() {
            return this.horizCoordSys.getGdsHash();
        }

        @Override
        public int compareTo(GroupGC o) {
            return this.getDescription().compareTo(o.getDescription());
        }

        public List<MFile> getFiles() {
            ArrayList<MFile> result = new ArrayList<MFile>();
            if (this.filenose == null) {
                return result;
            }
            for (int fileno : this.filenose) {
                result.add(GribCollection.this.fileMap.get(fileno));
            }
            Collections.sort(result);
            return result;
        }

        public List<String> getFilenames() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.filenose == null) {
                return result;
            }
            for (int fileno : this.filenose) {
                result.add(GribCollection.this.fileMap.get(fileno).getPath());
            }
            Collections.sort(result);
            return result;
        }

        public VariableIndex findVariableByHash(int cdmHash) {
            if (this.varMap == null) {
                this.varMap = new HashMap<Integer, VariableIndex>(this.variList.size() * 2);
                for (VariableIndex vi : this.variList) {
                    this.varMap.put(vi.cdmHash, vi);
                }
            }
            return this.varMap.get(cdmHash);
        }

        public CalendarDateRange getCalendarDateRange() {
            if (this.dateRange == null) {
                CalendarDateRange result = null;
                for (Coordinate coord : this.coords) {
                    switch (coord.getType()) {
                        case time: 
                        case timeIntv: 
                        case time2D: {
                            CoordinateTimeAbstract time = (CoordinateTimeAbstract)coord;
                            CalendarDateRange range = time.makeCalendarDateRange(null);
                            result = result == null ? range : result.extend(range);
                        }
                    }
                }
                this.dateRange = result;
            }
            return this.dateRange;
        }

        public int getNFiles() {
            if (this.filenose == null) {
                return 0;
            }
            return this.filenose.length;
        }

        public int getNCoords() {
            return this.coords.size();
        }

        public int getNVariables() {
            return this.variList.size();
        }

        public void show(Formatter f) {
            f.format("Group %s (%d) isTwoD=%s%n", this.horizCoordSys.getId(), this.getGdsHash(), this.isTwod);
            f.format(" nfiles %d%n", this.filenose == null ? 0 : this.filenose.length);
        }
    }

    @Immutable
    public class HorizCoordSys {
        private final GdsHorizCoordSys hcs;
        private final byte[] rawGds;
        private final int gdsHash;
        private final String id;
        private final String description;
        private final String nameOverride;
        private final int predefinedGridDefinition;

        public HorizCoordSys(GdsHorizCoordSys hcs, byte[] rawGds, int gdsHash, String nameOverride, int predefinedGridDefinition) {
            this.hcs = hcs;
            this.rawGds = rawGds;
            this.gdsHash = gdsHash;
            this.nameOverride = nameOverride;
            this.predefinedGridDefinition = predefinedGridDefinition;
            this.id = this.makeId();
            this.description = this.makeDescription();
        }

        public GdsHorizCoordSys getHcs() {
            return this.hcs;
        }

        public byte[] getRawGds() {
            return this.rawGds;
        }

        public int getGdsHash() {
            return this.gdsHash;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public String getNameOverride() {
            return this.nameOverride;
        }

        public int getPredefinedGridDefinition() {
            return this.predefinedGridDefinition;
        }

        private String makeId() {
            String base;
            if (this.nameOverride != null) {
                return this.nameOverride;
            }
            String tryit = base = this.hcs.makeId();
            int count = 1;
            while (GribCollection.this.groupNames.contains(tryit)) {
                tryit = base + "-" + ++count;
            }
            GribCollection.this.groupNames.add(tryit);
            return tryit;
        }

        private String makeDescription() {
            String result = null;
            if (GribCollection.this.config.gribConfig.gdsNamer != null) {
                result = GribCollection.this.config.gribConfig.gdsNamer.get(this.gdsHash);
            }
            if (result != null) {
                return result;
            }
            return this.hcs.makeDescription();
        }
    }

    public class Dataset {
        final Type type;
        List<GroupGC> groups;

        public Dataset(Type type) {
            this.type = type;
            this.groups = new ArrayList<GroupGC>();
        }

        Dataset(Dataset from) {
            this.type = from.type;
            this.groups = new ArrayList<GroupGC>(from.groups.size());
        }

        public GroupGC addGroupCopy(GroupGC from) {
            GroupGC g = new GroupGC(from);
            this.groups.add(g);
            return g;
        }

        public Iterable<GroupGC> getGroups() {
            return this.groups;
        }

        public int getGroupsSize() {
            return this.groups.size();
        }

        public Type getType() {
            return this.type;
        }

        public boolean isTwoD() {
            return this.type == Type.TwoD;
        }

        public GroupGC getGroup(int index) {
            return this.groups.get(index);
        }

        public GroupGC findGroupById(String id) {
            for (GroupGC g : this.getGroups()) {
                if (!g.getId().equals(id)) continue;
                return g;
            }
            return null;
        }
    }

    public static enum Type {
        GC,
        TwoD,
        Best,
        Analysis;

    }
}

