/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.util.List;
import thredds.catalog.ServiceType;
import thredds.catalog2.Catalog;
import thredds.catalog2.DatasetNode;
import thredds.catalog2.Property;
import thredds.catalog2.Service;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.CatalogRefBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.simpleImpl.CatalogRefImpl;
import thredds.catalog2.simpleImpl.DatasetImpl;
import thredds.catalog2.simpleImpl.DatasetNodeContainer;
import thredds.catalog2.simpleImpl.DatasetNodeImpl;
import thredds.catalog2.simpleImpl.GlobalServiceContainer;
import thredds.catalog2.simpleImpl.PropertyContainer;
import thredds.catalog2.simpleImpl.ServiceContainer;
import thredds.catalog2.simpleImpl.ServiceImpl;
import ucar.nc2.units.DateType;

class CatalogImpl
implements Catalog,
CatalogBuilder {
    private String name;
    private URI docBaseUri;
    private String version;
    private DateType expires;
    private DateType lastModified;
    private final ServiceContainer serviceContainer;
    private final GlobalServiceContainer globalServiceContainer;
    private final DatasetNodeContainer datasetContainer;
    private final PropertyContainer propertyContainer;
    private boolean isBuilt = false;

    CatalogImpl(String name, URI docBaseUri, String version, DateType expires, DateType lastModified) {
        if (docBaseUri == null) {
            throw new IllegalArgumentException("Catalog base URI must not be null.");
        }
        this.name = name;
        this.docBaseUri = docBaseUri;
        this.version = version;
        this.expires = expires;
        this.lastModified = lastModified;
        this.globalServiceContainer = new GlobalServiceContainer();
        this.serviceContainer = new ServiceContainer(this.globalServiceContainer);
        this.datasetContainer = new DatasetNodeContainer(null);
        this.propertyContainer = new PropertyContainer();
    }

    DatasetNodeContainer getDatasetNodeContainer() {
        return this.datasetContainer;
    }

    @Override
    public void setName(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDocBaseUri(URI docBaseUri) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        if (docBaseUri == null) {
            throw new IllegalArgumentException("Catalog base URI must not be null.");
        }
        this.docBaseUri = docBaseUri;
    }

    @Override
    public URI getDocBaseUri() {
        return this.docBaseUri;
    }

    @Override
    public void setVersion(String version) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        this.version = version;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setExpires(DateType expires) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        this.expires = expires;
    }

    @Override
    public DateType getExpires() {
        return this.expires;
    }

    @Override
    public void setLastModified(DateType lastModified) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        this.lastModified = lastModified;
    }

    @Override
    public DateType getLastModified() {
        return this.lastModified;
    }

    @Override
    public ServiceBuilder addService(String name, ServiceType type, URI baseUri) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        return this.serviceContainer.addService(name, type, baseUri);
    }

    @Override
    public boolean removeService(ServiceBuilder serviceBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        if (serviceBuilder == null) {
            return false;
        }
        return this.serviceContainer.removeService((ServiceImpl)serviceBuilder);
    }

    @Override
    public List<Service> getServices() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Catalog has escaped its CatalogBuilder without build() being called.");
        }
        return this.serviceContainer.getServices();
    }

    @Override
    public Service getServiceByName(String name) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Catalog has escaped its CatalogBuilder without being build()-ed.");
        }
        return this.serviceContainer.getServiceByName(name);
    }

    @Override
    public Service findServiceByNameGlobally(String name) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Catalog has escaped its CatalogBuilder without being build()-ed.");
        }
        return this.globalServiceContainer.getServiceByGloballyUniqueName(name);
    }

    @Override
    public List<ServiceBuilder> getServiceBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        return this.serviceContainer.getServiceBuilders();
    }

    @Override
    public ServiceBuilder getServiceBuilderByName(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        return this.serviceContainer.getServiceBuilderByName(name);
    }

    @Override
    public ServiceBuilder findServiceBuilderByNameGlobally(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        return this.globalServiceContainer.getServiceByGloballyUniqueName(name);
    }

    @Override
    public void addProperty(String name, String value) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        this.propertyContainer.addProperty(name, value);
    }

    @Override
    public boolean removeProperty(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        return this.propertyContainer.removeProperty(name);
    }

    @Override
    public List<String> getPropertyNames() {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        return this.propertyContainer.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        return this.propertyContainer.getPropertyValue(name);
    }

    @Override
    public List<Property> getProperties() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Catalog has escaped from its CatalogBuilder before build() was called.");
        }
        return this.propertyContainer.getProperties();
    }

    @Override
    public Property getPropertyByName(String name) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Catalog has escaped from its CatalogBuilder before build() was called.");
        }
        return this.propertyContainer.getPropertyByName(name);
    }

    @Override
    public DatasetBuilder addDataset(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        DatasetImpl di = new DatasetImpl(name, this, null);
        this.datasetContainer.addDatasetNode(di);
        return di;
    }

    @Override
    public CatalogRefBuilder addCatalogRef(String name, URI reference) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        CatalogRefImpl crb = new CatalogRefImpl(name, reference, this, null);
        this.datasetContainer.addDatasetNode(crb);
        return crb;
    }

    @Override
    public boolean removeDataset(DatasetNodeBuilder builder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        if (builder == null) {
            throw new IllegalArgumentException("DatasetNodeBuilder may not be null.");
        }
        return this.datasetContainer.removeDatasetNode((DatasetNodeImpl)builder);
    }

    @Override
    public List<DatasetNode> getDatasets() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Catalog has escaped its CatalogBuilder without being build()-ed.");
        }
        return this.datasetContainer.getDatasets();
    }

    @Override
    public DatasetNode getDatasetById(String id) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Catalog has escaped its CatalogBuilder without being build()-ed.");
        }
        return this.datasetContainer.getDatasetById(id);
    }

    @Override
    public DatasetNode findDatasetByIdGlobally(String id) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Catalog has escaped its CatalogBuilder without being build()-ed.");
        }
        return this.datasetContainer.getDatasetNodeByGloballyUniqueId(id);
    }

    @Override
    public List<DatasetNodeBuilder> getDatasetNodeBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        return this.datasetContainer.getDatasetNodeBuilders();
    }

    @Override
    public DatasetNodeBuilder getDatasetNodeBuilderById(String id) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        return this.datasetContainer.getDatasetNodeBuilderById(id);
    }

    @Override
    public DatasetNodeBuilder findDatasetNodeBuilderByIdGlobally(String id) {
        if (this.isBuilt) {
            throw new IllegalStateException("This CatalogBuilder has been built.");
        }
        return this.datasetContainer.getDatasetNodeByGloballyUniqueId(id);
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public BuilderIssues getIssues() {
        BuilderIssues issues = new BuilderIssues();
        issues.addAllIssues(this.globalServiceContainer.getIssues(this));
        issues.addAllIssues(this.serviceContainer.getIssues());
        issues.addAllIssues(this.datasetContainer.getIssues());
        issues.addAllIssues(this.propertyContainer.getIssues());
        return issues;
    }

    @Override
    public Catalog build() throws BuilderException {
        if (this.isBuilt) {
            return this;
        }
        this.serviceContainer.build();
        this.datasetContainer.build();
        this.propertyContainer.build();
        this.isBuilt = true;
        return this;
    }
}

