/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointIteratorFiltered;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;

public abstract class PointCollectionImpl
implements PointFeatureCollection {
    protected String name;
    protected LatLonRect boundingBox;
    protected CalendarDateRange dateRange;
    protected int npts;
    protected PointFeatureIterator localIterator;
    protected DateUnit timeUnit;
    protected String altUnits;
    protected List<Variable> extras;

    protected PointCollectionImpl(String name, DateUnit timeUnit, String altUnits) {
        this.name = name;
        this.timeUnit = timeUnit;
        this.altUnits = altUnits;
        this.npts = -1;
    }

    @Override
    public DateUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public String getAltUnits() {
        return this.altUnits;
    }

    @Override
    public List<Variable> getExtraVariables() {
        return this.extras == null ? new ArrayList() : this.extras;
    }

    @Override
    public void setDateRange(DateRange range) {
        this.dateRange = CalendarDateRange.of(range);
    }

    @Override
    public void setCalendarDateRange(CalendarDateRange range) {
        this.dateRange = range;
    }

    @Override
    public void setBoundingBox(LatLonRect bb) {
        this.boundingBox = bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calcBounds() throws IOException {
        if (this.dateRange != null && this.boundingBox != null && this.size() > 0) {
            return;
        }
        PointFeatureIterator iter = this.getPointFeatureIterator(-1);
        iter.setCalculateBounds(this);
        try {
            while (iter.hasNext()) {
                iter.next();
            }
        }
        finally {
            iter.finish();
        }
    }

    @Override
    public void setSize(int npts) {
        this.npts = npts;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public void finish() {
        if (this.localIterator != null) {
            this.localIterator.finish();
        }
    }

    @Override
    public PointFeature next() throws IOException {
        return this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getPointFeatureIterator(-1);
    }

    @Override
    public int size() {
        return this.npts;
    }

    public int getNobs() {
        return this.npts;
    }

    @Override
    public DateRange getDateRange() {
        return this.dateRange == null ? null : this.dateRange.toDateRange();
    }

    @Override
    public CalendarDateRange getCalendarDateRange() {
        return this.dateRange;
    }

    @Override
    public LatLonRect getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public FeatureType getCollectionFeatureType() {
        return FeatureType.POINT;
    }

    @Override
    public PointFeatureCollection subset(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
        return new PointCollectionSubset(this, boundingBox, dateRange);
    }

    @Override
    public PointFeatureCollection subset(LatLonRect boundingBox, DateRange dateRange) throws IOException {
        return new PointCollectionSubset(this, boundingBox, CalendarDateRange.of(dateRange));
    }

    protected class PointCollectionSubset
    extends PointCollectionImpl {
        protected PointCollectionImpl from;

        public PointCollectionSubset(PointCollectionImpl from, LatLonRect filter_bb, CalendarDateRange filter_date) {
            super(from.name, from.getTimeUnit(), from.getAltUnits());
            this.from = from;
            if (filter_bb == null) {
                this.boundingBox = from.boundingBox;
            } else {
                LatLonRect latLonRect = this.boundingBox = from.boundingBox == null ? filter_bb : from.boundingBox.intersect(filter_bb);
            }
            this.dateRange = filter_date == null ? from.dateRange : (from.dateRange == null ? filter_date : from.dateRange.intersect(filter_date));
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            return new PointIteratorFiltered(this.from.getPointFeatureIterator(bufferSize), this.boundingBox, this.dateRange);
        }
    }
}

