/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.TrajectoryFeatureCollection;
import ucar.nc2.ft.point.OneNestedPointCollectionImpl;
import ucar.nc2.ft.point.PointCollectionIteratorFiltered;
import ucar.nc2.ft.point.TrajectoryFeatureImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class StandardTrajectoryCollectionImpl
extends OneNestedPointCollectionImpl
implements TrajectoryFeatureCollection {
    private NestedTable ft;
    private TrajCollectionIterator localIterator = null;

    protected StandardTrajectoryCollectionImpl(String name, DateUnit timeUnit, String altUnits) {
        super(name, timeUnit, altUnits, FeatureType.TRAJECTORY);
    }

    StandardTrajectoryCollectionImpl(NestedTable ft, DateUnit timeUnit, String altUnits) {
        super(ft.getName(), timeUnit, altUnits, FeatureType.TRAJECTORY);
        this.ft = ft;
        this.extras = ft.getExtras();
    }

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        return new TrajCollectionIterator(this.ft.getRootFeatureDataIterator(bufferSize));
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public TrajectoryFeatureCollection subset(LatLonRect boundingBox) throws IOException {
        return new StandardTrajectoryCollectionSubset(this, boundingBox);
    }

    @Override
    public TrajectoryFeature next() throws IOException {
        return this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = (TrajCollectionIterator)this.getPointFeatureCollectionIterator(-1);
    }

    private class StandardTrajectoryCollectionSubset
    extends StandardTrajectoryCollectionImpl {
        TrajectoryFeatureCollection from;
        LatLonRect boundingBox;

        StandardTrajectoryCollectionSubset(TrajectoryFeatureCollection from, LatLonRect boundingBox) {
            super(from.getName() + "-subset", from.getTimeUnit(), from.getAltUnits());
            this.from = from;
            this.boundingBox = boundingBox;
        }

        @Override
        public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
            return new PointCollectionIteratorFiltered(this.from.getPointFeatureCollectionIterator(bufferSize), new Filter());
        }

        private class Filter
        implements PointFeatureCollectionIterator.Filter {
            private Filter() {
            }

            @Override
            public boolean filter(PointFeatureCollection pointFeatureCollection) {
                ProfileFeature profileFeature = (ProfileFeature)pointFeatureCollection;
                return StandardTrajectoryCollectionSubset.this.boundingBox.contains(profileFeature.getLatLon());
            }
        }
    }

    private class StandardTrajectoryFeature
    extends TrajectoryFeatureImpl {
        Cursor cursor;
        StructureData trajData;

        StandardTrajectoryFeature(Cursor cursor, StructureData trajData) {
            super(StandardTrajectoryCollectionImpl.this.ft.getFeatureName(cursor), StandardTrajectoryCollectionImpl.this.getTimeUnit(), StandardTrajectoryCollectionImpl.this.getAltUnits(), -1);
            this.cursor = cursor;
            this.trajData = trajData;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            Cursor cursorIter = this.cursor.copy();
            StructureDataIterator siter = StandardTrajectoryCollectionImpl.this.ft.getLeafFeatureDataIterator(cursorIter, bufferSize);
            StandardPointFeatureIterator iter = new StandardPointFeatureIterator(StandardTrajectoryCollectionImpl.this.ft, this.timeUnit, siter, cursorIter);
            if (this.boundingBox == null || this.dateRange == null || this.npts < 0) {
                iter.setCalculateBounds(this);
            }
            return iter;
        }

        @Override
        public StructureData getFeatureData() {
            return this.trajData;
        }
    }

    private class TrajCollectionIterator
    implements PointFeatureCollectionIterator {
        StructureDataIterator structIter;
        StructureData nextTraj;

        TrajCollectionIterator(StructureDataIterator structIter) throws IOException {
            this.structIter = structIter;
        }

        @Override
        public boolean hasNext() throws IOException {
            do {
                if (!this.structIter.hasNext()) {
                    return false;
                }
                this.nextTraj = this.structIter.next();
            } while (StandardTrajectoryCollectionImpl.this.ft.isFeatureMissing(this.nextTraj));
            return true;
        }

        @Override
        public TrajectoryFeature next() throws IOException {
            Cursor cursor = new Cursor(StandardTrajectoryCollectionImpl.this.ft.getNumberOfLevels());
            cursor.recnum[1] = this.structIter.getCurrentRecno();
            cursor.tableData[1] = this.nextTraj;
            cursor.currentIndex = 1;
            StandardTrajectoryCollectionImpl.this.ft.addParentJoin(cursor);
            return new StandardTrajectoryFeature(cursor, this.nextTraj);
        }

        @Override
        public void setBufferSize(int bytes) {
        }

        @Override
        public void finish() {
            this.structIter.finish();
        }
    }
}

