/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.collection.Grib2Iosp;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.grib.grib1.tables.Grib1WmoTimeType;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Iosp
extends GribIosp {
    private static final Logger logger = LoggerFactory.getLogger(Grib2Iosp.class);
    private Grib1Customizer cust;

    @Override
    public String makeVariableName(GribCollection.VariableIndex vindex) {
        return this.makeVariableNameFromTables(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), vindex.tableVersion, vindex.parameter, vindex.levelType, vindex.isLayer, vindex.intvType, vindex.getTimeIntvName());
    }

    @Override
    public String makeVariableNameFromRecord(GribCollection.VariableIndex vindex) {
        return this.makeVariableNameFromRecord(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), vindex.tableVersion, vindex.parameter, vindex.levelType, vindex.isLayer, vindex.intvType, vindex.getTimeIntvName());
    }

    private String makeVariableNameFromRecord(int center, int subcenter, int tableVersion, int paramNo, int levelType, boolean isLayer, int intvType, String intvName) {
        Formatter f = new Formatter();
        f.format("VAR_%d-%d-%d-%d", center, subcenter, tableVersion, paramNo);
        if (levelType != -9999) {
            f.format("_L%d", levelType);
            if (isLayer) {
                f.format("_layer", new Object[0]);
            }
        }
        if (intvType >= 0) {
            if (intvName != null) {
                if (intvName.equals("Mixed_intervals")) {
                    f.format("_Imixed", new Object[0]);
                } else {
                    f.format("_I%s", intvName);
                }
            }
            f.format("_S%s", intvType);
        }
        return f.toString();
    }

    public static String makeVariableName(Grib1Customizer cust, Grib1SectionProductDefinition pds) {
        return Grib1Iosp.makeVariableNameFromTables(cust, pds.getCenter(), pds.getSubCenter(), pds.getTableVersion(), pds.getParameterNumber(), pds.getLevelType(), cust.isLayer(pds.getLevelType()), pds.getTimeRangeIndicator(), null);
    }

    private static String makeVariableNameFromTables(Grib1Customizer cust, int center, int subcenter, int version, int paramNo, int levelType, boolean isLayer, int intvType, String intvName) {
        Formatter f = new Formatter();
        Grib1Parameter param = cust.getParameter(center, subcenter, version, paramNo);
        if (param == null) {
            f.format("VAR%d-%d-%d-%d", center, subcenter, version, paramNo);
        } else if (param.useName()) {
            f.format("%s", param.getName());
        } else {
            f.format("%s", GribUtils.makeNameFromDescription(param.getDescription()));
        }
        if (levelType != -9999) {
            f.format("_%s", cust.getLevelNameShort(levelType));
            if (isLayer) {
                f.format("_layer", new Object[0]);
            }
        }
        if (intvType >= 0) {
            GribStatType stat = Grib1WmoTimeType.getStatType(intvType);
            if (stat != null) {
                if (intvName != null) {
                    f.format("_%s", intvName);
                }
                f.format("_%s", stat.name());
            } else {
                if (intvName != null) {
                    f.format("_%s", intvName);
                }
                f.format("_%d", intvType);
            }
        }
        return f.toString();
    }

    private String makeVariableNameFromTables(int center, int subcenter, int version, int paramNo, int levelType, boolean isLayer, int intvType, String intvName) {
        return Grib1Iosp.makeVariableNameFromTables(this.cust, center, subcenter, version, paramNo, levelType, isLayer, intvType, intvName);
    }

    @Override
    protected String makeVariableLongName(GribCollection.VariableIndex vindex) {
        return this.makeVariableLongName(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), vindex.tableVersion, vindex.parameter, vindex.levelType, vindex.intvType, vindex.getTimeIntvName(), vindex.isLayer, vindex.probabilityName);
    }

    public String makeVariableLongName(int center, int subcenter, int version, int paramNo, int levelType, int intvType, String intvName, boolean isLayer, String probabilityName) {
        Grib1Parameter param;
        boolean isProb;
        Formatter f = new Formatter();
        boolean bl = isProb = probabilityName != null && probabilityName.length() > 0;
        if (isProb) {
            f.format("Probability ", new Object[0]);
        }
        if ((param = this.cust.getParameter(center, subcenter, version, paramNo)) == null) {
            f.format("Unknown Parameter %d-%d-%d-%d", center, subcenter, version, paramNo);
        } else {
            f.format("%s", param.getDescription());
        }
        if (intvType >= 0) {
            GribStatType stat = Grib1WmoTimeType.getStatType(intvType);
            if (stat != null) {
                f.format(" (%s %s)", intvName, stat.name());
            } else if (intvName != null && intvName.length() > 0) {
                f.format(" (%s)", intvName);
            }
        }
        if (levelType != -9999) {
            f.format(" @ %s", this.cust.getLevelDescription(levelType));
            if (isLayer) {
                f.format(" layer", new Object[0]);
            }
        }
        return f.toString();
    }

    @Override
    protected String makeVariableUnits(GribCollection.VariableIndex vindex) {
        return this.makeVariableUnits(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), vindex.tableVersion, vindex.parameter);
    }

    public String makeVariableUnits(int center, int subcenter, int version, int paramNo) {
        Grib1Parameter param = this.cust.getParameter(center, subcenter, version, paramNo);
        String val = param == null ? "" : param.getUnit();
        return val == null ? "" : val;
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        GribCdmIndex.GribCollectionType type = GribCdmIndex.getType(raf);
        if (type == GribCdmIndex.GribCollectionType.GRIB1) {
            return true;
        }
        if (type == GribCdmIndex.GribCollectionType.Partition1) {
            return true;
        }
        return Grib1RecordScanner.isValidFile(raf);
    }

    @Override
    public String getFileTypeId() {
        return DataFormatType.GRIB1.toString();
    }

    @Override
    public String getFileTypeDescription() {
        return "GRIB1 Collection";
    }

    public Grib1Iosp() {
        super(true, logger);
    }

    public Grib1Iosp(GribCollection.GroupGC gHcs, GribCollection.Type gtype) {
        super(true, logger);
        this.gHcs = gHcs;
        this.owned = true;
        this.gtype = gtype;
    }

    public Grib1Iosp(GribCollection gc) {
        super(true, logger);
        this.gribCollection = gc;
        this.owned = true;
    }

    protected String getIntervalName(int code) {
        return this.cust.getTimeTypeName(code);
    }

    @Override
    protected GribTables createCustomizer() throws IOException {
        Grib1ParamTables tables = this.config.gribConfig.paramTable != null ? Grib1ParamTables.factory(this.config.gribConfig.paramTable) : Grib1ParamTables.factory(this.config.gribConfig.paramTablePath, this.config.gribConfig.lookupTablePath);
        this.cust = Grib1Customizer.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getMaster(), tables);
        return this.cust;
    }

    @Override
    protected void addGlobalAttributes(NetcdfFile ncfile) {
        String val = this.cust.getGeneratingProcessName(this.gribCollection.getGenProcessId());
        if (val != null) {
            ncfile.addAttribute(null, new Attribute("Generating_process_or_model", val));
        }
    }

    @Override
    protected String getVerticalCoordDesc(int vc_code) {
        return this.cust.getLevelDescription(vc_code);
    }

    @Override
    protected GribTables.Parameter getParameter(GribCollection.VariableIndex vindex) {
        return this.cust.getParameter(this.gribCollection.center, this.gribCollection.subcenter, this.gribCollection.version, vindex.parameter);
    }

    @Override
    protected void addVariableAttributes(Variable v, GribCollection.VariableIndex vindex) {
        String timeTypeName;
        String ldesc;
        v.addAttribute(new Attribute("Grib_Variable_Id", this.makeVariableNameFromRecord(vindex)));
        v.addAttribute(new Attribute("Grib1_Center", this.gribCollection.center));
        v.addAttribute(new Attribute("Grib1_Subcenter", this.gribCollection.subcenter));
        v.addAttribute(new Attribute("Grib1_TableVersion", vindex.tableVersion));
        v.addAttribute(new Attribute("Grib1_Parameter", vindex.parameter));
        Grib1Parameter param = this.cust.getParameter(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), vindex.tableVersion, vindex.parameter);
        if (param != null && param.getName() != null) {
            v.addAttribute(new Attribute("Grib1_Parameter_Name", param.getName()));
        }
        if (vindex.levelType != 255) {
            v.addAttribute(new Attribute("Grib1_Level_Type", vindex.levelType));
        }
        if ((ldesc = this.cust.getLevelDescription(vindex.levelType)) != null) {
            v.addAttribute(new Attribute("Grib1_Level_Desc", ldesc));
        }
        if ((timeTypeName = this.cust.getTimeTypeName(vindex.intvType)) != null && timeTypeName.length() != 0) {
            v.addAttribute(new Attribute("time_interval", timeTypeName));
        }
        if (vindex.ensDerivedType >= 0) {
            v.addAttribute(new Attribute("Grib1_Ensemble_Derived_Type", vindex.ensDerivedType));
        } else if (vindex.probabilityName != null && vindex.probabilityName.length() > 0) {
            v.addAttribute(new Attribute("Grib1_Probability_Type", vindex.probabilityName));
        }
    }

    @Override
    protected void show(RandomAccessFile rafData, long dataPos) throws IOException {
        rafData.seek(dataPos);
        Grib1Record gr = new Grib1Record(rafData);
        Formatter f = new Formatter();
        f.format("File=%s%n", rafData.getLocation());
        Grib1SectionProductDefinition pds = gr.getPDSsection();
        Grib1Parameter param = this.cust.getParameter(pds.getCenter(), pds.getSubCenter(), pds.getTableVersion(), pds.getParameterNumber());
        f.format("  Parameter=%s%n", param);
        f.format("  ReferenceDate=%s%n", gr.getReferenceDate());
        Grib1ParamTime ptime = pds.getParamTime(this.cust);
        f.format("  ForecastTime=%d%n", ptime.getForecastTime());
        if (ptime.isInterval()) {
            int[] tinv = ptime.getInterval();
            f.format("  TimeInterval=(%d,%d)%n", tinv[0], tinv[1]);
        }
        f.format("%n", new Object[0]);
        gr.getPDSsection().showPds(this.cust, f);
        System.out.printf("%nGrib1Record.readData at drsPos %d = %s%n", dataPos, f.toString());
    }

    @Override
    protected float[] readData(RandomAccessFile rafData, GribIosp.DataRecord dr) throws IOException {
        return Grib1Record.readData(rafData, dr.dataPos);
    }
}

