/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.iosp.BitReader;
import ucar.unidata.io.RandomAccessFile;

public class Grib2Drs {
    public static Grib2Drs factory(int template, RandomAccessFile raf) throws IOException {
        switch (template) {
            case 0: {
                return new Type0(raf);
            }
            case 2: {
                return new Type2(raf);
            }
            case 3: {
                return new Type3(raf);
            }
            case 40: {
                return new Type40(raf);
            }
            case 50002: {
                return new Type50002(raf);
            }
        }
        throw new UnsupportedOperationException("Unsupported DRS type = " + template);
    }

    public int getNBits() {
        return -1;
    }

    public int getNGroups() {
        return 1;
    }

    public static class Type50002
    extends Grib2Drs {
        public float referenceValue;
        public int binaryScaleFactor;
        public int decimalScaleFactor;
        public int numberOfBits;
        public int p1;
        public int p2;
        public int widthOfFirstOrderValues;
        public int widthOfWidth;
        public int widthOfLength;
        public int boustrophonic;
        public int orderOfSPD;
        public int widthOfSPD;
        public int[] spd;
        public int lengthOfSection6;
        public int section6;
        public int bitMapIndicator;
        public int lengthOfSection7;
        public int section7;

        Type50002(RandomAccessFile raf) throws IOException {
            this.referenceValue = raf.readFloat();
            this.binaryScaleFactor = GribNumbers.int2(raf);
            this.decimalScaleFactor = GribNumbers.int2(raf);
            this.numberOfBits = raf.read();
            this.widthOfFirstOrderValues = raf.read();
            this.p1 = GribNumbers.int4(raf);
            this.p2 = GribNumbers.int4(raf);
            this.widthOfWidth = raf.read();
            this.widthOfLength = raf.read();
            this.boustrophonic = raf.read();
            this.orderOfSPD = raf.read();
            this.widthOfSPD = raf.read();
            this.spd = new int[this.orderOfSPD + 1];
            BitReader bitReader = new BitReader(raf, raf.getFilePointer());
            for (int i = 0; i < this.orderOfSPD; ++i) {
                this.spd[i] = (int)bitReader.bits2UInt(this.widthOfSPD);
            }
            this.spd[this.orderOfSPD] = (int)bitReader.bits2SInt(this.widthOfSPD);
            this.lengthOfSection6 = GribNumbers.int4(raf);
            this.section6 = raf.read();
            this.bitMapIndicator = raf.read();
            this.lengthOfSection7 = GribNumbers.int4(raf);
            this.section7 = raf.read();
        }

        @Override
        public int getNBits() {
            return this.numberOfBits;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Type50002");
            sb.append("{\n\treferenceValue=").append(this.referenceValue);
            sb.append(",\n\tbinaryScaleFactor=").append(this.binaryScaleFactor);
            sb.append(",\n\tdecimalScaleFactor=").append(this.decimalScaleFactor);
            sb.append(",\n\tnumberOfBits=").append(this.numberOfBits);
            sb.append(",\n\twidthOfFirstOrderValues=").append(this.widthOfFirstOrderValues);
            sb.append(",\n\tp1=").append(this.p1);
            sb.append(",\n\tp2=").append(this.p2);
            sb.append(",\n\twidthOfWidth=").append(this.widthOfWidth);
            sb.append(",\n\twidthOfLength=").append(this.widthOfLength);
            sb.append(",\n\tboustrophonic=").append(this.boustrophonic);
            sb.append(",\n\torderOfSPD=").append(this.orderOfSPD);
            sb.append(",\n\twidthOfSPD=").append(this.widthOfSPD);
            sb.append(",\n\tspd=");
            int[] arr$ = this.spd;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                float i = arr$[i$];
                sb.append(i).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(",\n\tlengthOfSection6=").append(this.lengthOfSection6);
            sb.append(",\n\tsection6=").append(this.section6);
            sb.append(",\n\tbitMapIndicator=").append(this.bitMapIndicator);
            sb.append(",\n\tlengthOfSection7=").append(this.lengthOfSection7);
            sb.append(",\n\tsection7=").append(this.section7);
            sb.append("\n}");
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Type50002 type50002 = (Type50002)o;
            if (Float.compare(type50002.referenceValue, this.referenceValue) != 0) {
                return false;
            }
            if (this.binaryScaleFactor != type50002.binaryScaleFactor) {
                return false;
            }
            if (this.decimalScaleFactor != type50002.decimalScaleFactor) {
                return false;
            }
            if (this.numberOfBits != type50002.numberOfBits) {
                return false;
            }
            if (this.widthOfFirstOrderValues != type50002.widthOfFirstOrderValues) {
                return false;
            }
            if (this.p1 != type50002.p1) {
                return false;
            }
            if (this.p2 != type50002.p2) {
                return false;
            }
            if (this.widthOfWidth != type50002.widthOfWidth) {
                return false;
            }
            if (this.widthOfLength != type50002.widthOfLength) {
                return false;
            }
            if (this.boustrophonic != type50002.boustrophonic) {
                return false;
            }
            if (this.orderOfSPD != type50002.orderOfSPD) {
                return false;
            }
            if (this.widthOfSPD != type50002.widthOfSPD) {
                return false;
            }
            for (int i = 0; i < this.spd.length; ++i) {
                if (this.spd[i] == type50002.spd[i]) continue;
                return false;
            }
            if (this.lengthOfSection6 != type50002.lengthOfSection6) {
                return false;
            }
            if (this.section6 != type50002.section6) {
                return false;
            }
            if (this.bitMapIndicator != type50002.bitMapIndicator) {
                return false;
            }
            if (this.lengthOfSection7 != type50002.lengthOfSection7) {
                return false;
            }
            return this.section7 == type50002.section7;
        }

        public int hashCode() {
            int result = this.referenceValue != 0.0f ? Float.floatToIntBits(this.referenceValue) : 0;
            result = 31 * result + this.binaryScaleFactor;
            result = 31 * result + this.decimalScaleFactor;
            result = 31 * result + this.numberOfBits;
            result = 31 * result + this.widthOfFirstOrderValues;
            result = 31 * result + this.p1;
            result = 31 * result + this.p2;
            result = 31 * result + this.widthOfWidth;
            result = 31 * result + this.widthOfLength;
            result = 31 * result + this.boustrophonic;
            result = 31 * result + this.orderOfSPD;
            result = 31 * result + this.widthOfSPD;
            for (int i = 0; i < this.spd.length; ++i) {
                result = 31 * result + this.spd[i];
            }
            result = 31 * result + this.lengthOfSection6;
            result = 31 * result + this.section6;
            result = 31 * result + this.section6;
            result = 31 * result + this.lengthOfSection7;
            result = 31 * result + this.section7;
            return result;
        }
    }

    public static class Type40
    extends Type0 {
        public int compressionMethod;
        public int compressionRatio;
        boolean hasSignedProblem = false;

        Type40(RandomAccessFile raf) throws IOException {
            super(raf);
            this.compressionMethod = raf.read();
            this.compressionRatio = raf.read();
        }

        public boolean hasSignedProblem() {
            return this.hasSignedProblem;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("\nType40");
            sb.append("{compressionMethod=").append(this.compressionMethod);
            sb.append(", compressionRatio=").append(this.compressionRatio);
            sb.append(", hasSignedProblem=").append(this.hasSignedProblem);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Type40 type40 = (Type40)o;
            if (this.compressionMethod != type40.compressionMethod) {
                return false;
            }
            return this.compressionRatio == type40.compressionRatio;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.compressionMethod;
            result = 31 * result + this.compressionRatio;
            return result;
        }
    }

    public static class Type3
    extends Type2 {
        public int orderSpatial;
        public int descriptorSpatial;

        Type3(RandomAccessFile raf) throws IOException {
            super(raf);
            this.orderSpatial = raf.read();
            this.descriptorSpatial = raf.read();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("\nType3");
            sb.append("{orderSpatial=").append(this.orderSpatial);
            sb.append(", descriptorSpatial=").append(this.descriptorSpatial);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Type3 type3 = (Type3)o;
            if (this.descriptorSpatial != type3.descriptorSpatial) {
                return false;
            }
            return this.orderSpatial == type3.orderSpatial;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.orderSpatial;
            result = 31 * result + this.descriptorSpatial;
            return result;
        }
    }

    public static class Type2
    extends Type0 {
        public float secondaryMissingValue;
        public float primaryMissingValue;
        public int missingValueManagement;
        public int splittingMethod;
        public int numberOfGroups;
        public int referenceGroupWidths;
        public int bitsGroupWidths;
        public int referenceGroupLength;
        public int lengthIncrement;
        public int lengthLastGroup;
        public int bitsScaledGroupLength;

        Type2(RandomAccessFile raf) throws IOException {
            super(raf);
            this.splittingMethod = raf.read();
            this.missingValueManagement = raf.read();
            this.primaryMissingValue = raf.readFloat();
            this.secondaryMissingValue = raf.readFloat();
            this.numberOfGroups = GribNumbers.int4(raf);
            this.referenceGroupWidths = raf.read();
            this.bitsGroupWidths = raf.read();
            this.referenceGroupLength = GribNumbers.int4(raf);
            this.lengthIncrement = raf.read();
            this.lengthLastGroup = GribNumbers.int4(raf);
            this.bitsScaledGroupLength = raf.read();
        }

        @Override
        public int getNGroups() {
            return this.numberOfGroups;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("\nType2");
            sb.append("{secondaryMissingValue=").append(this.secondaryMissingValue);
            sb.append(", primaryMissingValue=").append(this.primaryMissingValue);
            sb.append(", missingValueManagement=").append(this.missingValueManagement);
            sb.append(", splittingMethod=").append(this.splittingMethod);
            sb.append(", numberOfGroups=").append(this.numberOfGroups);
            sb.append(", referenceGroupWidths=").append(this.referenceGroupWidths);
            sb.append(", bitsGroupWidths=").append(this.bitsGroupWidths);
            sb.append(", referenceGroupLength=").append(this.referenceGroupLength);
            sb.append(", lengthIncrement=").append(this.lengthIncrement);
            sb.append(", lengthLastGroup=").append(this.lengthLastGroup);
            sb.append(", bitsScaledGroupLength=").append(this.bitsScaledGroupLength);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Type2 type2 = (Type2)o;
            if (this.bitsGroupWidths != type2.bitsGroupWidths) {
                return false;
            }
            if (this.bitsScaledGroupLength != type2.bitsScaledGroupLength) {
                return false;
            }
            if (this.lengthIncrement != type2.lengthIncrement) {
                return false;
            }
            if (this.lengthLastGroup != type2.lengthLastGroup) {
                return false;
            }
            if (this.missingValueManagement != type2.missingValueManagement) {
                return false;
            }
            if (this.numberOfGroups != type2.numberOfGroups) {
                return false;
            }
            if (Float.compare(type2.primaryMissingValue, this.primaryMissingValue) != 0) {
                return false;
            }
            if (this.referenceGroupLength != type2.referenceGroupLength) {
                return false;
            }
            if (this.referenceGroupWidths != type2.referenceGroupWidths) {
                return false;
            }
            if (Float.compare(type2.secondaryMissingValue, this.secondaryMissingValue) != 0) {
                return false;
            }
            return this.splittingMethod == type2.splittingMethod;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.secondaryMissingValue != 0.0f ? Float.floatToIntBits(this.secondaryMissingValue) : 0);
            result = 31 * result + (this.primaryMissingValue != 0.0f ? Float.floatToIntBits(this.primaryMissingValue) : 0);
            result = 31 * result + this.missingValueManagement;
            result = 31 * result + this.splittingMethod;
            result = 31 * result + this.numberOfGroups;
            result = 31 * result + this.referenceGroupWidths;
            result = 31 * result + this.bitsGroupWidths;
            result = 31 * result + this.referenceGroupLength;
            result = 31 * result + this.lengthIncrement;
            result = 31 * result + this.lengthLastGroup;
            result = 31 * result + this.bitsScaledGroupLength;
            return result;
        }
    }

    public static class Type0
    extends Grib2Drs {
        public float referenceValue;
        public int binaryScaleFactor;
        public int decimalScaleFactor;
        public int numberOfBits;
        public int originalType;

        Type0(RandomAccessFile raf) throws IOException {
            this.referenceValue = raf.readFloat();
            this.binaryScaleFactor = GribNumbers.int2(raf);
            this.decimalScaleFactor = GribNumbers.int2(raf);
            this.numberOfBits = raf.read();
            this.originalType = raf.read();
        }

        @Override
        public int getNBits() {
            return this.numberOfBits;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Type0");
            sb.append("{referenceValue=").append(this.referenceValue);
            sb.append(", binaryScaleFactor=").append(this.binaryScaleFactor);
            sb.append(", decimalScaleFactor=").append(this.decimalScaleFactor);
            sb.append(", numberOfBits=").append(this.numberOfBits);
            sb.append(", originalType=").append(this.originalType);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Type0 type0 = (Type0)o;
            if (this.binaryScaleFactor != type0.binaryScaleFactor) {
                return false;
            }
            if (this.decimalScaleFactor != type0.decimalScaleFactor) {
                return false;
            }
            if (this.numberOfBits != type0.numberOfBits) {
                return false;
            }
            if (this.originalType != type0.originalType) {
                return false;
            }
            return Float.compare(type0.referenceValue, this.referenceValue) == 0;
        }

        public int hashCode() {
            int result = this.referenceValue != 0.0f ? Float.floatToIntBits(this.referenceValue) : 0;
            result = 31 * result + this.binaryScaleFactor;
            result = 31 * result + this.decimalScaleFactor;
            result = 31 * result + this.numberOfBits;
            result = 31 * result + this.originalType;
            return result;
        }
    }
}

