/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.Grib2Table;
import ucar.nc2.grib.grib2.table.NcepLocalTables;
import ucar.nc2.util.TableParser;

public class FslLocalTables
extends NcepLocalTables {
    public static final int center_id = 59;
    private static final String hrrrTable = "resources/grib2/noaa_gsd/Fsl-hrrr.csv";
    private static final String fimTable = "resources/grib2/noaa_gsd/fim.gribtable";
    private static final boolean debug = true;
    private Grib2Table tableDef;

    static FslLocalTables localFactory(int subCenter, int masterVersion, int localVersion, int genProcessId) {
        return new FslLocalTables(subCenter, masterVersion, localVersion, genProcessId);
    }

    private FslLocalTables(int subCenter, int masterVersion, int localVersion, int genProcessId) {
        super(59, subCenter, masterVersion, localVersion, genProcessId);
        this.tableDef = genProcessId == 125 ? new Grib2Table(hrrrTable, Grib2Table.Type.test) : new Grib2Table(fimTable, Grib2Table.Type.test);
        this.initLocalTable(null);
    }

    @Override
    public String getTablePath(int discipline, int category, int number) {
        if (category <= 191 && number <= 191) {
            return super.getTablePath(discipline, category, number);
        }
        return this.tableDef.path;
    }

    @Override
    public String getSubCenterName(int center, int subcenter) {
        switch (subcenter) {
            case 0: {
                return null;
            }
            case 1: {
                return "FSL/FRD Regional Analysis and Prediction Branch";
            }
            case 2: {
                return "FSL/FRD Local Analysis and Prediction Branch";
            }
        }
        return super.getSubCenterName(center, subcenter);
    }

    @Override
    public String getGeneratingProcessName(int genProcess) {
        switch (genProcess) {
            case 103: {
                return "ExREF";
            }
            case 105: {
                return "RAP/ RUC";
            }
            case 106: {
                return "Developmental Testbed Center Winter Field Experiment, WRF-ARW";
            }
            case 112: {
                return "Developmental Testbed Center Winter Field Experiment, WRF-NMM";
            }
            case 116: {
                return "Flow-following Finite-volume Icosahedral Model (FIM)";
            }
            case 125: {
                return "High-Resolution Rapid Refresh";
            }
        }
        return null;
    }

    @Override
    public String getLevelNameShort(int id) {
        if (id < 192) {
            return super.getLevelNameShort(id);
        }
        switch (id) {
            case 200: {
                return "Entire_atmosphere";
            }
        }
        return null;
    }

    @Override
    public String getLevelName(int id) {
        if (id < 192) {
            return super.getLevelName(id);
        }
        switch (id) {
            case 200: {
                return "Entire atmosphere layer";
            }
        }
        return null;
    }

    @Override
    public String getStatisticNameShort(int id) {
        switch (id) {
            case 255: {
                return "Interval";
            }
        }
        return super.getStatisticNameShort(id);
    }

    protected void initLocalTable(Formatter f) {
        this.local = this.tableDef.path.equals(hrrrTable) ? this.readCsv(hrrrTable, f) : this.readFim(fimTable, f);
    }

    @Override
    public void lookForProblems(Formatter f) {
        this.initLocalTable(f);
    }

    private Map<Integer, Grib2Parameter> readCsv(String resourcePath, Formatter f) {
        boolean header = true;
        HashMap<Integer, Grib2Parameter> result = new HashMap<Integer, Grib2Parameter>(100);
        ClassLoader cl = this.getClass().getClassLoader();
        try (InputStream is = cl.getResourceAsStream(resourcePath);){
            String line;
            if (is == null) {
                throw new IllegalStateException("Cant find " + resourcePath);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            HashMap<String, Grib2Parameter> names = new HashMap<String, Grib2Parameter>(200);
            while (!(line = br.readLine()).startsWith("Record")) {
            }
            while ((line = br.readLine()) != null) {
                Grib2Parameter dup;
                if (line.length() == 0 || line.startsWith("#")) continue;
                String[] flds = line.split(",");
                String recordNumber = flds[0].trim();
                int tableNumber = Integer.parseInt(flds[1].trim());
                int disciplineNumber = Integer.parseInt(flds[2].trim());
                int categoryNumber = Integer.parseInt(flds[3].trim());
                int parameterNumber = Integer.parseInt(flds[4].trim());
                String WGrib2Name = flds[5].trim();
                String NCLName = flds[6].trim();
                String FieldType2 = flds[7].trim();
                String Description2 = flds[8].trim();
                String Units = flds[9].trim();
                System.out.printf("%3s %3d %3d %3d %3d %-10s %-25s %-30s %-100s %-20s%n", recordNumber, tableNumber, disciplineNumber, categoryNumber, parameterNumber, WGrib2Name, NCLName, FieldType2, Description2, Units);
                String name = !WGrib2Name.equals("var") ? WGrib2Name : FieldType2;
                Grib2Parameter s = new Grib2Parameter(disciplineNumber, categoryNumber, parameterNumber, name, Units, null, Description2);
                s.desc = Description2;
                result.put(FslLocalTables.makeHash(disciplineNumber, categoryNumber, parameterNumber), s);
                System.out.printf(" %s%n", s);
                if ((categoryNumber > 191 || parameterNumber > 191) && (dup = (Grib2Parameter)names.get(s.getName())) != null && f != null) {
                    if (header) {
                        f.format("Problems in table %s %n", resourcePath);
                    }
                    header = false;
                    f.format(" DUPLICATE NAME %s and %s (%s)%n", s.getId(), dup.getId(), s.getName());
                }
                names.put(s.getName(), s);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return result;
    }

    private Map<Integer, Grib2Parameter> readFim(String resourcePath, Formatter f) {
        boolean header = true;
        HashMap<Integer, Grib2Parameter> result = new HashMap<Integer, Grib2Parameter>(100);
        ClassLoader cl = this.getClass().getClassLoader();
        try (InputStream is = cl.getResourceAsStream(resourcePath);){
            if (is == null) {
                throw new IllegalStateException("Cant find " + resourcePath);
            }
            List<TableParser.Record> recs = TableParser.readTable(is, "56,63i,68i,93,102,112", 50000);
            for (TableParser.Record record : recs) {
                String desc = (String)record.get(0);
                int param = (Integer)record.get(1);
                int ztype = (Integer)record.get(2);
                String abbrev = (String)record.get(4);
                String units = (String)record.get(5);
                System.out.printf("%s == %3d %3d %-20s %-20s%n", desc, param, ztype, abbrev, units);
                Grib2Parameter gp = new Grib2Parameter(0, 0, param, abbrev, units, null, desc);
                result.put(FslLocalTables.makeHash(0, 0, param), gp);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return result;
    }

    public static void main(String[] args) {
        FslLocalTables hrrr = new FslLocalTables(0, 0, 1, 125);
        Formatter f = new Formatter();
        Grib2Parameter.compareTables("FSL-HRRR", "Standard WMO version", hrrr.getParameters(), Grib2Customizer.factory(0, 0, 0, 0, 0), f);
        System.out.printf("%s%n", f);
        Formatter f2 = new Formatter();
        Grib2Parameter.compareTables("FSL-HRRR", "NCEP Table", hrrr.getParameters(), Grib2Customizer.factory(7, 0, 0, 0, 0), f2);
        System.out.printf("%s%n", f2);
    }
}

