/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.writer;

import java.io.IOException;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingStrategy;
import ucar.unidata.io.RandomAccessFile;

public class Grib2NetcdfWriter
implements AutoCloseable {
    String fileIn;
    String fileOut;
    NetcdfFileWriter writer;
    private int mask23 = -1;
    private int mask19 = -16;
    private int mask15 = -256;
    private int mask11 = -4096;
    private int mask07 = -65536;
    private int mask03 = -1048576;
    private int mask00 = -8388608;

    public Grib2NetcdfWriter(String fileIn, String fileOut) throws IOException {
        this.fileIn = fileIn;
        this.fileOut = fileOut;
        Nc4Chunking chunker = Nc4ChunkingStrategy.factory(Nc4Chunking.Strategy.grib, 9, true);
        this.writer = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf4, fileOut, chunker);
    }

    public void write() throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(this.fileIn, "r");){
            Grib2RecordScanner scanner = new Grib2RecordScanner(raf);
            while (scanner.hasNext()) {
                Grib2Record gr = scanner.next();
                float[] data = gr.readData(raf);
                for (int i = 0; i < data.length; ++i) {
                    data[i] = this.bitShave(data[i]);
                    if (i % 10 != 0) continue;
                    System.out.println();
                }
            }
        }
    }

    private float bitShave(float value) {
        if (Float.isNaN(value)) {
            return value;
        }
        int bits = Float.floatToRawIntBits(value);
        int shave = bits & this.mask11;
        float result = Float.intBitsToFloat(shave);
        return result;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public static void main(String[] args) {
        String fileIn = "Q:/cdmUnitTest/formats/grib2/ds.mint.bin";
        String fileOut = "C:/tmp/ds.mint.bin";
        try (Grib2NetcdfWriter writer = new Grib2NetcdfWriter(fileIn, fileOut);){
            writer.write();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

