/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import ucar.units.BadUnitException;
import ucar.units.BaseQuantity;
import ucar.units.BaseUnit;
import ucar.units.ConversionException;
import ucar.units.Converter;
import ucar.units.ConverterImpl;
import ucar.units.DerivedUnit;
import ucar.units.DivideException;
import ucar.units.MultiplyException;
import ucar.units.RaiseException;
import ucar.units.SI;
import ucar.units.ShiftException;
import ucar.units.Unit;
import ucar.units.UnitException;
import ucar.units.UnitImpl;
import ucar.units.UnitName;
import ucar.units.UnitSystemException;
import ucar.units.UnitSystemManager;

public final class TimeScaleUnit
extends UnitImpl {
    private static final long serialVersionUID = 1L;
    private final Unit _unit;
    private final Date _origin;
    private static final SimpleDateFormat dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, Locale.US);
    static final BaseUnit SECOND;

    public TimeScaleUnit(Unit unit, Date origin) throws BadUnitException, UnitSystemException {
        this(unit, origin, null);
    }

    public TimeScaleUnit(Unit unit, Date origin, UnitName id) throws BadUnitException, UnitSystemException {
        super(id);
        if (!unit.isCompatible(UnitSystemManager.instance().getBaseUnit(BaseQuantity.TIME))) {
            throw new BadUnitException("\"" + unit + "\" is not a unit of time");
        }
        this._unit = unit;
        this._origin = origin;
    }

    static Unit getInstance(Unit unit, Date origin) throws ShiftException {
        try {
            return unit instanceof TimeScaleUnit ? new TimeScaleUnit(((TimeScaleUnit)unit)._unit, origin) : new TimeScaleUnit(unit, origin);
        }
        catch (Exception e) {
            throw (ShiftException)new ShiftException(unit, origin).initCause(e);
        }
    }

    public Unit getUnit() {
        return this._unit;
    }

    public Date getOrigin() {
        return this._origin;
    }

    @Override
    public Unit clone(UnitName id) {
        TimeScaleUnit clone;
        try {
            clone = new TimeScaleUnit(this.getUnit(), this.getOrigin(), id);
        }
        catch (UnitException e) {
            clone = null;
        }
        return clone;
    }

    @Override
    public Unit shiftTo(double origin) throws ShiftException {
        Date newOrigin;
        try {
            newOrigin = new Date(this._origin.getTime() + (long)(this._unit.convertTo(origin, (Unit)SECOND) * 1000.0));
        }
        catch (ConversionException e) {
            throw (ShiftException)new ShiftException((Unit)this, origin).initCause(e);
        }
        try {
            return new TimeScaleUnit(this._unit, newOrigin);
        }
        catch (BadUnitException e) {
            throw new AssertionError();
        }
        catch (UnitSystemException e) {
            throw (ShiftException)new ShiftException((Unit)this, origin).initCause(e);
        }
    }

    @Override
    public Unit shiftTo(Date origin) throws ShiftException {
        return TimeScaleUnit.getInstance(this._unit, origin);
    }

    @Override
    protected Unit myMultiplyBy(Unit that) throws MultiplyException {
        throw new MultiplyException(this);
    }

    @Override
    protected Unit myDivideBy(Unit that) throws DivideException {
        throw new DivideException(this);
    }

    @Override
    protected Unit myDivideInto(Unit that) throws DivideException {
        throw new DivideException(that, this);
    }

    @Override
    protected Unit myRaiseTo(int power) throws RaiseException {
        throw new RaiseException(this);
    }

    @Override
    public DerivedUnit getDerivedUnit() {
        return this.getUnit().getDerivedUnit();
    }

    @Override
    public Converter getConverterTo(Unit outputUnit) throws ConversionException {
        return new MyConverter(this, outputUnit);
    }

    @Override
    public final boolean isCompatible(Unit that) {
        return that instanceof TimeScaleUnit;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TimeScaleUnit)) {
            return false;
        }
        TimeScaleUnit that = (TimeScaleUnit)object;
        return this._origin.equals(that._origin) && this._unit.equals(that._unit);
    }

    @Override
    public int hashCode() {
        return this.getUnit().hashCode() ^ this.getOrigin().hashCode();
    }

    @Override
    public boolean isDimensionless() {
        return false;
    }

    @Override
    public String toString() {
        String string = super.toString();
        return string != null ? string : this.getCanonicalString();
    }

    @Override
    public String getCanonicalString() {
        return this.getUnit().toString() + dateFormat.format(this.getOrigin());
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormat.applyPattern(" 'since' yyyy-MM-dd HH:mm:ss.SSS 'UTC'");
        try {
            SECOND = BaseUnit.getOrCreate(UnitName.newUnitName("second", null, "s"), BaseQuantity.TIME);
        }
        catch (Exception e) {
            throw (ExceptionInInitializerError)new ExceptionInInitializerError().initCause(e);
        }
    }

    protected static final class MyConverter
    extends ConverterImpl {
        private final double offset;
        private final Converter converter;

        protected MyConverter(TimeScaleUnit fromUnit, Unit toUnit) throws ConversionException {
            super(fromUnit, toUnit);
            this.converter = fromUnit.getUnit().getConverterTo(((TimeScaleUnit)toUnit).getUnit());
            this.offset = SI.SECOND.convertTo((double)(fromUnit.getOrigin().getTime() - ((TimeScaleUnit)toUnit).getOrigin().getTime()) / 1000.0, ((TimeScaleUnit)toUnit).getUnit());
        }

        @Override
        public double convert(double amount) {
            return this.converter.convert(amount) + this.offset;
        }

        @Override
        public float[] convert(float[] input, float[] output) {
            output = this.converter.convert(input, output);
            int i = input.length;
            while (--i >= 0) {
                int n = i;
                output[n] = (float)((double)output[n] + this.offset);
            }
            return output;
        }

        @Override
        public double[] convert(double[] input, double[] output) {
            output = this.converter.convert(input, output);
            int i = input.length;
            while (--i >= 0) {
                int n = i;
                output[n] = output[n] + this.offset;
            }
            return output;
        }
    }
}

