/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.itadaki.bzip2.BZip2InputStream;
import org.itadaki.bzip2.BZip2OutputStream;

public class RoundTrip {
    private static final FileFilter fileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.canRead();
        }
    };
    private static final FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && file.canRead();
        }
    };

    private static List<File> getFiles(File base) {
        ArrayList<File> files = new ArrayList<File>();
        if (base.isFile()) {
            if (base.canRead()) {
                files.add(base);
            }
        } else {
            File[] subDirectories;
            File[] fileArray = subDirectories = base.listFiles(directoryFilter);
            int n = subDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File subDirectory = fileArray[n2];
                files.addAll(RoundTrip.getFiles(subDirectory));
                ++n2;
            }
            fileArray = base.listFiles(fileFilter);
            n = fileArray.length;
            n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                files.add(file);
                ++n2;
            }
        }
        return files;
    }

    private static void roundTrip(List<File> files) throws IOException {
        File tempFile = File.createTempFile("rtr", ".tmp");
        for (File inputFile : files) {
            int bytesRead;
            long inputLength = inputFile.length();
            System.out.print(String.valueOf(inputLength) + " " + inputFile);
            BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(inputFile));
            BufferedOutputStream compressedOutputStream = new BufferedOutputStream(new FileOutputStream(tempFile));
            BZip2OutputStream bzip2OutputStream = new BZip2OutputStream(compressedOutputStream);
            byte[] buffer = new byte[524288];
            while ((bytesRead = ((InputStream)fileInputStream).read(buffer, 0, buffer.length)) != -1) {
                bzip2OutputStream.write(buffer, 0, bytesRead);
            }
            bzip2OutputStream.close();
            ((OutputStream)compressedOutputStream).close();
            ((InputStream)fileInputStream).close();
            long compressedLength = tempFile.length();
            System.out.printf(" (%.1f%%)\n", Float.valueOf((float)(inputLength - compressedLength) / (float)inputLength * 100.0f));
            BufferedInputStream compressedInputStream = new BufferedInputStream(new FileInputStream(tempFile));
            BZip2InputStream bzip2InputStream = new BZip2InputStream(compressedInputStream, false);
            byte[] decoded = new byte[524288];
            while ((bytesRead = bzip2InputStream.read(decoded)) != -1) {
            }
            ((InputStream)compressedInputStream).close();
            bzip2InputStream.close();
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Tests the compression/decompression cycle on a file or directory. Compression isperformed using a temporary file, and the target file or directory is not altered.\n\nUsage:\n  java demo.RoundTrip <file or directory name>\n");
            System.exit(1);
        }
        System.out.println("Finding files...");
        List<File> files = RoundTrip.getFiles(new File(args[0]));
        System.out.println("Testing compression/decompression cycle...");
        RoundTrip.roundTrip(files);
    }
}

