/*
 * Decompiled with CFR 0.152.
 */
package org.itadaki.bzip2;

public class BZip2DivSufSort {
    private static final int STACK_SIZE = 64;
    private static final int BUCKET_A_SIZE = 256;
    private static final int BUCKET_B_SIZE = 65536;
    private static final int SS_BLOCKSIZE = 1024;
    private static final int INSERTIONSORT_THRESHOLD = 8;
    private static final int[] log2table;
    private final int[] SA;
    private final byte[] T;
    private final int n;

    static {
        int[] nArray = new int[256];
        nArray[0] = -1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 3;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 3;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 3;
        nArray[16] = 4;
        nArray[17] = 4;
        nArray[18] = 4;
        nArray[19] = 4;
        nArray[20] = 4;
        nArray[21] = 4;
        nArray[22] = 4;
        nArray[23] = 4;
        nArray[24] = 4;
        nArray[25] = 4;
        nArray[26] = 4;
        nArray[27] = 4;
        nArray[28] = 4;
        nArray[29] = 4;
        nArray[30] = 4;
        nArray[31] = 4;
        nArray[32] = 5;
        nArray[33] = 5;
        nArray[34] = 5;
        nArray[35] = 5;
        nArray[36] = 5;
        nArray[37] = 5;
        nArray[38] = 5;
        nArray[39] = 5;
        nArray[40] = 5;
        nArray[41] = 5;
        nArray[42] = 5;
        nArray[43] = 5;
        nArray[44] = 5;
        nArray[45] = 5;
        nArray[46] = 5;
        nArray[47] = 5;
        nArray[48] = 5;
        nArray[49] = 5;
        nArray[50] = 5;
        nArray[51] = 5;
        nArray[52] = 5;
        nArray[53] = 5;
        nArray[54] = 5;
        nArray[55] = 5;
        nArray[56] = 5;
        nArray[57] = 5;
        nArray[58] = 5;
        nArray[59] = 5;
        nArray[60] = 5;
        nArray[61] = 5;
        nArray[62] = 5;
        nArray[63] = 5;
        nArray[64] = 6;
        nArray[65] = 6;
        nArray[66] = 6;
        nArray[67] = 6;
        nArray[68] = 6;
        nArray[69] = 6;
        nArray[70] = 6;
        nArray[71] = 6;
        nArray[72] = 6;
        nArray[73] = 6;
        nArray[74] = 6;
        nArray[75] = 6;
        nArray[76] = 6;
        nArray[77] = 6;
        nArray[78] = 6;
        nArray[79] = 6;
        nArray[80] = 6;
        nArray[81] = 6;
        nArray[82] = 6;
        nArray[83] = 6;
        nArray[84] = 6;
        nArray[85] = 6;
        nArray[86] = 6;
        nArray[87] = 6;
        nArray[88] = 6;
        nArray[89] = 6;
        nArray[90] = 6;
        nArray[91] = 6;
        nArray[92] = 6;
        nArray[93] = 6;
        nArray[94] = 6;
        nArray[95] = 6;
        nArray[96] = 6;
        nArray[97] = 6;
        nArray[98] = 6;
        nArray[99] = 6;
        nArray[100] = 6;
        nArray[101] = 6;
        nArray[102] = 6;
        nArray[103] = 6;
        nArray[104] = 6;
        nArray[105] = 6;
        nArray[106] = 6;
        nArray[107] = 6;
        nArray[108] = 6;
        nArray[109] = 6;
        nArray[110] = 6;
        nArray[111] = 6;
        nArray[112] = 6;
        nArray[113] = 6;
        nArray[114] = 6;
        nArray[115] = 6;
        nArray[116] = 6;
        nArray[117] = 6;
        nArray[118] = 6;
        nArray[119] = 6;
        nArray[120] = 6;
        nArray[121] = 6;
        nArray[122] = 6;
        nArray[123] = 6;
        nArray[124] = 6;
        nArray[125] = 6;
        nArray[126] = 6;
        nArray[127] = 6;
        nArray[128] = 7;
        nArray[129] = 7;
        nArray[130] = 7;
        nArray[131] = 7;
        nArray[132] = 7;
        nArray[133] = 7;
        nArray[134] = 7;
        nArray[135] = 7;
        nArray[136] = 7;
        nArray[137] = 7;
        nArray[138] = 7;
        nArray[139] = 7;
        nArray[140] = 7;
        nArray[141] = 7;
        nArray[142] = 7;
        nArray[143] = 7;
        nArray[144] = 7;
        nArray[145] = 7;
        nArray[146] = 7;
        nArray[147] = 7;
        nArray[148] = 7;
        nArray[149] = 7;
        nArray[150] = 7;
        nArray[151] = 7;
        nArray[152] = 7;
        nArray[153] = 7;
        nArray[154] = 7;
        nArray[155] = 7;
        nArray[156] = 7;
        nArray[157] = 7;
        nArray[158] = 7;
        nArray[159] = 7;
        nArray[160] = 7;
        nArray[161] = 7;
        nArray[162] = 7;
        nArray[163] = 7;
        nArray[164] = 7;
        nArray[165] = 7;
        nArray[166] = 7;
        nArray[167] = 7;
        nArray[168] = 7;
        nArray[169] = 7;
        nArray[170] = 7;
        nArray[171] = 7;
        nArray[172] = 7;
        nArray[173] = 7;
        nArray[174] = 7;
        nArray[175] = 7;
        nArray[176] = 7;
        nArray[177] = 7;
        nArray[178] = 7;
        nArray[179] = 7;
        nArray[180] = 7;
        nArray[181] = 7;
        nArray[182] = 7;
        nArray[183] = 7;
        nArray[184] = 7;
        nArray[185] = 7;
        nArray[186] = 7;
        nArray[187] = 7;
        nArray[188] = 7;
        nArray[189] = 7;
        nArray[190] = 7;
        nArray[191] = 7;
        nArray[192] = 7;
        nArray[193] = 7;
        nArray[194] = 7;
        nArray[195] = 7;
        nArray[196] = 7;
        nArray[197] = 7;
        nArray[198] = 7;
        nArray[199] = 7;
        nArray[200] = 7;
        nArray[201] = 7;
        nArray[202] = 7;
        nArray[203] = 7;
        nArray[204] = 7;
        nArray[205] = 7;
        nArray[206] = 7;
        nArray[207] = 7;
        nArray[208] = 7;
        nArray[209] = 7;
        nArray[210] = 7;
        nArray[211] = 7;
        nArray[212] = 7;
        nArray[213] = 7;
        nArray[214] = 7;
        nArray[215] = 7;
        nArray[216] = 7;
        nArray[217] = 7;
        nArray[218] = 7;
        nArray[219] = 7;
        nArray[220] = 7;
        nArray[221] = 7;
        nArray[222] = 7;
        nArray[223] = 7;
        nArray[224] = 7;
        nArray[225] = 7;
        nArray[226] = 7;
        nArray[227] = 7;
        nArray[228] = 7;
        nArray[229] = 7;
        nArray[230] = 7;
        nArray[231] = 7;
        nArray[232] = 7;
        nArray[233] = 7;
        nArray[234] = 7;
        nArray[235] = 7;
        nArray[236] = 7;
        nArray[237] = 7;
        nArray[238] = 7;
        nArray[239] = 7;
        nArray[240] = 7;
        nArray[241] = 7;
        nArray[242] = 7;
        nArray[243] = 7;
        nArray[244] = 7;
        nArray[245] = 7;
        nArray[246] = 7;
        nArray[247] = 7;
        nArray[248] = 7;
        nArray[249] = 7;
        nArray[250] = 7;
        nArray[251] = 7;
        nArray[252] = 7;
        nArray[253] = 7;
        nArray[254] = 7;
        nArray[255] = 7;
        log2table = nArray;
    }

    private static final void swapElements(int[] array1, int index1, int[] array2, int index2) {
        int temp = array1[index1];
        array1[index1] = array2[index2];
        array2[index2] = temp;
    }

    private int ssCompare(int p1, int p2, int depth) {
        int[] SA = this.SA;
        byte[] T = this.T;
        int U1 = depth + SA[p1];
        int U2 = depth + SA[p2];
        int U1n = SA[p1 + 1] + 2;
        int U2n = SA[p2 + 1] + 2;
        while (U1 < U1n && U2 < U2n && T[U1] == T[U2]) {
            ++U1;
            ++U2;
        }
        return U1 < U1n ? (U2 < U2n ? (T[U1] & 0xFF) - (T[U2] & 0xFF) : 1) : (U2 < U2n ? -1 : 0);
    }

    private int ssCompareLast(int PA, int p1, int p2, int depth, int size) {
        int[] SA = this.SA;
        byte[] T = this.T;
        int U1 = depth + SA[p1];
        int U2 = depth + SA[p2];
        int U1n = size;
        int U2n = SA[p2 + 1] + 2;
        while (U1 < U1n && U2 < U2n && T[U1] == T[U2]) {
            ++U1;
            ++U2;
        }
        if (U1 < U1n) {
            return U2 < U2n ? (T[U1] & 0xFF) - (T[U2] & 0xFF) : 1;
        }
        if (U2 == U2n) {
            return 1;
        }
        U1 %= size;
        U1n = SA[PA] + 2;
        while (U1 < U1n && U2 < U2n && T[U1] == T[U2]) {
            ++U1;
            ++U2;
        }
        return U1 < U1n ? (U2 < U2n ? (T[U1] & 0xFF) - (T[U2] & 0xFF) : 1) : (U2 < U2n ? -1 : 0);
    }

    private void ssInsertionSort(int PA, int first, int last, int depth) {
        int[] SA = this.SA;
        int i = last - 2;
        while (first <= i) {
            int r;
            int t = SA[i];
            int j = i + 1;
            while ((r = this.ssCompare(PA + t, PA + SA[j], depth)) > 0) {
                do {
                    SA[j - 1] = SA[j];
                } while (++j < last && SA[j] < 0);
                if (last <= j) break;
            }
            if (r == 0) {
                SA[j] = ~SA[j];
            }
            SA[j - 1] = t;
            --i;
        }
    }

    private void ssFixdown(int Td, int PA, int sa, int i, int size) {
        int j;
        int[] SA = this.SA;
        byte[] T = this.T;
        int v = SA[sa + i];
        int c = T[Td + SA[PA + v]] & 0xFF;
        while ((j = 2 * i + 1) < size) {
            int e;
            int k;
            int d;
            if ((d = T[Td + SA[PA + SA[sa + (k = j++)]]] & 0xFF) < (e = T[Td + SA[PA + SA[sa + j]]] & 0xFF)) {
                k = j;
                d = e;
            }
            if (d <= c) break;
            SA[sa + i] = SA[sa + k];
            i = k;
        }
        SA[sa + i] = v;
    }

    private void ssHeapSort(int Td, int PA, int sa, int size) {
        int[] SA = this.SA;
        byte[] T = this.T;
        int m = size;
        if (size % 2 == 0 && (T[Td + SA[PA + SA[sa + --m / 2]]] & 0xFF) < (T[Td + SA[PA + SA[sa + m]]] & 0xFF)) {
            BZip2DivSufSort.swapElements(SA, sa + m, SA, sa + m / 2);
        }
        int i = m / 2 - 1;
        while (i >= 0) {
            this.ssFixdown(Td, PA, sa, i, m);
            --i;
        }
        if (size % 2 == 0) {
            BZip2DivSufSort.swapElements(SA, sa, SA, sa + m);
            this.ssFixdown(Td, PA, sa, 0, m);
        }
        i = m - 1;
        while (i > 0) {
            int t = SA[sa];
            SA[sa] = SA[sa + i];
            this.ssFixdown(Td, PA, sa, 0, i);
            SA[sa + i] = t;
            --i;
        }
    }

    private int ssMedian3(int Td, int PA, int v1, int v2, int v3) {
        int[] SA = this.SA;
        byte[] T = this.T;
        int T_v1 = T[Td + SA[PA + SA[v1]]] & 0xFF;
        int T_v2 = T[Td + SA[PA + SA[v2]]] & 0xFF;
        int T_v3 = T[Td + SA[PA + SA[v3]]] & 0xFF;
        if (T_v1 > T_v2) {
            int temp = v1;
            v1 = v2;
            v2 = temp;
            int T_vtemp = T_v1;
            T_v1 = T_v2;
            T_v2 = T_vtemp;
        }
        if (T_v2 > T_v3) {
            if (T_v1 > T_v3) {
                return v1;
            }
            return v3;
        }
        return v2;
    }

    private int ssMedian5(int Td, int PA, int v1, int v2, int v3, int v4, int v5) {
        int T_vtemp;
        int temp;
        int[] SA = this.SA;
        byte[] T = this.T;
        int T_v1 = T[Td + SA[PA + SA[v1]]] & 0xFF;
        int T_v2 = T[Td + SA[PA + SA[v2]]] & 0xFF;
        int T_v3 = T[Td + SA[PA + SA[v3]]] & 0xFF;
        int T_v4 = T[Td + SA[PA + SA[v4]]] & 0xFF;
        int T_v5 = T[Td + SA[PA + SA[v5]]] & 0xFF;
        if (T_v2 > T_v3) {
            temp = v2;
            v2 = v3;
            v3 = temp;
            T_vtemp = T_v2;
            T_v2 = T_v3;
            T_v3 = T_vtemp;
        }
        if (T_v4 > T_v5) {
            temp = v4;
            v4 = v5;
            v5 = temp;
            T_vtemp = T_v4;
            T_v4 = T_v5;
            T_v5 = T_vtemp;
        }
        if (T_v2 > T_v4) {
            temp = v2;
            v2 = v4;
            v4 = temp;
            T_vtemp = T_v2;
            T_v2 = T_v4;
            T_v4 = T_vtemp;
            temp = v3;
            v3 = v5;
            v5 = temp;
            T_vtemp = T_v3;
            T_v3 = T_v5;
            T_v5 = T_vtemp;
        }
        if (T_v1 > T_v3) {
            temp = v1;
            v1 = v3;
            v3 = temp;
            T_vtemp = T_v1;
            T_v1 = T_v3;
            T_v3 = T_vtemp;
        }
        if (T_v1 > T_v4) {
            temp = v1;
            v1 = v4;
            v4 = temp;
            T_vtemp = T_v1;
            T_v1 = T_v4;
            T_v4 = T_vtemp;
            temp = v3;
            v3 = v5;
            v5 = temp;
            T_vtemp = T_v3;
            T_v3 = T_v5;
            T_v5 = T_vtemp;
        }
        if (T_v3 > T_v4) {
            return v4;
        }
        return v3;
    }

    private int ssPivot(int Td, int PA, int first, int last) {
        int t = last - first;
        int middle = first + t / 2;
        if (t <= 512) {
            if (t <= 32) {
                return this.ssMedian3(Td, PA, first, middle, last - 1);
            }
            return this.ssMedian5(Td, PA, first, first + (t >>= 2), middle, last - 1 - t, last - 1);
        }
        return this.ssMedian3(Td, PA, this.ssMedian3(Td, PA, first, first + (t >>= 3), first + (t << 1)), this.ssMedian3(Td, PA, middle - t, middle, middle + t), this.ssMedian3(Td, PA, last - 1 - (t << 1), last - 1 - t, last - 1));
    }

    private int ssLog(int n) {
        return (n & 0xFF00) != 0 ? 8 + log2table[n >> 8 & 0xFF] : log2table[n & 0xFF];
    }

    private int ssSubstringPartition(int PA, int first, int last, int depth) {
        int[] SA = this.SA;
        int a = first - 1;
        int b = last;
        while (true) {
            if (++a < b && SA[PA + SA[a]] + depth >= SA[PA + SA[a] + 1] + 1) {
                SA[a] = ~SA[a];
                continue;
            }
            while (a < --b && SA[PA + SA[b]] + depth < SA[PA + SA[b] + 1] + 1) {
            }
            if (b <= a) break;
            int t = ~SA[b];
            SA[b] = SA[a];
            SA[a] = t;
        }
        if (first < a) {
            SA[first] = ~SA[first];
        }
        return a;
    }

    private void ssMultiKeyIntroSort(int PA, int first, int last, int depth) {
        int[] SA = this.SA;
        byte[] T = this.T;
        StackEntry[] stack = new StackEntry[64];
        int Td = 0;
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        int e = 0;
        int f = 0;
        int s = 0;
        int t = 0;
        int v = 0;
        int x = 0;
        int ssize = 0;
        int limit = this.ssLog(last - first);
        while (true) {
            if (last - first <= 8) {
                if (1 < last - first) {
                    this.ssInsertionSort(PA, first, last, depth);
                }
                if (ssize == 0) {
                    return;
                }
                StackEntry entry = stack[--ssize];
                first = entry.a;
                last = entry.b;
                depth = entry.c;
                limit = entry.d;
                continue;
            }
            Td = depth;
            if (limit-- == 0) {
                this.ssHeapSort(Td, PA, first, last - first);
            }
            if (limit < 0) {
                a = first + 1;
                v = T[Td + SA[PA + SA[first]]] & 0xFF;
                while (a < last) {
                    x = T[Td + SA[PA + SA[a]]] & 0xFF;
                    if (x != v) {
                        if (1 < a - first) break;
                        v = x;
                        first = a;
                    }
                    ++a;
                }
                if ((T[Td + SA[PA + SA[first]] - 1] & 0xFF) < v) {
                    first = this.ssSubstringPartition(PA, first, a, depth);
                }
                if (a - first <= last - a) {
                    if (1 < a - first) {
                        stack[ssize++] = new StackEntry(a, last, depth, -1);
                        last = a;
                        ++depth;
                        limit = this.ssLog(a - first);
                        continue;
                    }
                    first = a;
                    limit = -1;
                    continue;
                }
                if (1 < last - a) {
                    stack[ssize++] = new StackEntry(first, a, depth + 1, this.ssLog(a - first));
                    first = a;
                    limit = -1;
                    continue;
                }
                last = a;
                ++depth;
                limit = this.ssLog(a - first);
                continue;
            }
            a = this.ssPivot(Td, PA, first, last);
            v = T[Td + SA[PA + SA[a]]] & 0xFF;
            BZip2DivSufSort.swapElements(SA, first, SA, a);
            b = first;
            while (++b < last && (x = T[Td + SA[PA + SA[b]]] & 0xFF) == v) {
            }
            a = b;
            if (a < last && x < v) {
                while (++b < last && (x = T[Td + SA[PA + SA[b]]] & 0xFF) <= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
            }
            c = last;
            while (b < --c && (x = T[Td + SA[PA + SA[c]]] & 0xFF) == v) {
            }
            d = c;
            if (b < d && x > v) {
                while (b < --c && (x = T[Td + SA[PA + SA[c]]] & 0xFF) >= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            while (b < c) {
                BZip2DivSufSort.swapElements(SA, b, SA, c);
                while (++b < c && (x = T[Td + SA[PA + SA[b]]] & 0xFF) <= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
                while (b < --c && (x = T[Td + SA[PA + SA[c]]] & 0xFF) >= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            if (a <= d) {
                c = b - 1;
                s = a - first;
                t = b - a;
                if (s > t) {
                    s = t;
                }
                e = first;
                f = b - s;
                while (s > 0) {
                    BZip2DivSufSort.swapElements(SA, e, SA, f);
                    --s;
                    ++e;
                    ++f;
                }
                s = d - c;
                t = last - d - 1;
                if (s > t) {
                    s = t;
                }
                e = b;
                f = last - s;
                while (s > 0) {
                    BZip2DivSufSort.swapElements(SA, e, SA, f);
                    --s;
                    ++e;
                    ++f;
                }
                a = first + (b - a);
                c = last - (d - c);
                int n = b = v <= (T[Td + SA[PA + SA[a]] - 1] & 0xFF) ? a : this.ssSubstringPartition(PA, a, c, depth);
                if (a - first <= last - c) {
                    if (last - c <= c - b) {
                        stack[ssize++] = new StackEntry(b, c, depth + 1, this.ssLog(c - b));
                        stack[ssize++] = new StackEntry(c, last, depth, limit);
                        last = a;
                        continue;
                    }
                    if (a - first <= c - b) {
                        stack[ssize++] = new StackEntry(c, last, depth, limit);
                        stack[ssize++] = new StackEntry(b, c, depth + 1, this.ssLog(c - b));
                        last = a;
                        continue;
                    }
                    stack[ssize++] = new StackEntry(c, last, depth, limit);
                    stack[ssize++] = new StackEntry(first, a, depth, limit);
                    first = b;
                    last = c;
                    ++depth;
                    limit = this.ssLog(c - b);
                    continue;
                }
                if (a - first <= c - b) {
                    stack[ssize++] = new StackEntry(b, c, depth + 1, this.ssLog(c - b));
                    stack[ssize++] = new StackEntry(first, a, depth, limit);
                    first = c;
                    continue;
                }
                if (last - c <= c - b) {
                    stack[ssize++] = new StackEntry(first, a, depth, limit);
                    stack[ssize++] = new StackEntry(b, c, depth + 1, this.ssLog(c - b));
                    first = c;
                    continue;
                }
                stack[ssize++] = new StackEntry(first, a, depth, limit);
                stack[ssize++] = new StackEntry(c, last, depth, limit);
                first = b;
                last = c;
                ++depth;
                limit = this.ssLog(c - b);
                continue;
            }
            ++limit;
            if ((T[Td + SA[PA + SA[first]] - 1] & 0xFF) < v) {
                first = this.ssSubstringPartition(PA, first, last, depth);
                limit = this.ssLog(last - first);
            }
            ++depth;
        }
    }

    private void ssBlockSwap(int[] array1, int first1, int[] array2, int first2, int size) {
        int i = size;
        int a = first1;
        int b = first2;
        while (i > 0) {
            BZip2DivSufSort.swapElements(array1, a, array2, b);
            --i;
            ++a;
            ++b;
        }
    }

    private void ssMergeForward(int PA, int[] buf, int bufoffset, int first, int middle, int last, int depth) {
        int[] SA = this.SA;
        int bufend = bufoffset + (middle - first) - 1;
        this.ssBlockSwap(buf, bufoffset, SA, first, middle - first);
        int t = SA[first];
        int i = first;
        int j = bufoffset;
        int k = middle;
        while (true) {
            int r;
            if ((r = this.ssCompare(PA + buf[j], PA + SA[k], depth)) < 0) {
                do {
                    SA[i++] = buf[j];
                    if (bufend <= j) {
                        buf[j] = t;
                        return;
                    }
                    buf[j++] = SA[i];
                } while (buf[j] < 0);
                continue;
            }
            if (r > 0) {
                do {
                    SA[i++] = SA[k];
                    SA[k++] = SA[i];
                    if (last > k) continue;
                    while (j < bufend) {
                        SA[i++] = buf[j];
                        buf[j++] = SA[i];
                    }
                    SA[i] = buf[j];
                    buf[j] = t;
                    return;
                } while (SA[k] < 0);
                continue;
            }
            SA[k] = ~SA[k];
            do {
                SA[i++] = buf[j];
                if (bufend <= j) {
                    buf[j] = t;
                    return;
                }
                buf[j++] = SA[i];
            } while (buf[j] < 0);
            do {
                SA[i++] = SA[k];
                SA[k++] = SA[i];
                if (last > k) continue;
                while (j < bufend) {
                    SA[i++] = buf[j];
                    buf[j++] = SA[i];
                }
                SA[i] = buf[j];
                buf[j] = t;
                return;
            } while (SA[k] < 0);
        }
    }

    private void ssMergeBackward(int PA, int[] buf, int bufoffset, int first, int middle, int last, int depth) {
        int p2;
        int p1;
        int[] SA = this.SA;
        int bufend = bufoffset + (last - middle);
        this.ssBlockSwap(buf, bufoffset, SA, middle, last - middle);
        int x = 0;
        if (buf[bufend - 1] < 0) {
            x |= 1;
            p1 = PA + ~buf[bufend - 1];
        } else {
            p1 = PA + buf[bufend - 1];
        }
        if (SA[middle - 1] < 0) {
            x |= 2;
            p2 = PA + ~SA[middle - 1];
        } else {
            p2 = PA + SA[middle - 1];
        }
        int t = SA[last - 1];
        int i = last - 1;
        int j = bufend - 1;
        int k = middle - 1;
        while (true) {
            int r;
            if ((r = this.ssCompare(p1, p2, depth)) > 0) {
                if ((x & 1) != 0) {
                    do {
                        SA[i--] = buf[j];
                        buf[j--] = SA[i];
                    } while (buf[j] < 0);
                    x ^= 1;
                }
                SA[i--] = buf[j];
                if (j <= bufoffset) {
                    buf[j] = t;
                    return;
                }
                buf[j--] = SA[i];
                if (buf[j] < 0) {
                    x |= 1;
                    p1 = PA + ~buf[j];
                    continue;
                }
                p1 = PA + buf[j];
                continue;
            }
            if (r < 0) {
                if ((x & 2) != 0) {
                    do {
                        SA[i--] = SA[k];
                        SA[k--] = SA[i];
                    } while (SA[k] < 0);
                    x ^= 2;
                }
                SA[i--] = SA[k];
                SA[k--] = SA[i];
                if (k < first) {
                    while (bufoffset < j) {
                        SA[i--] = buf[j];
                        buf[j--] = SA[i];
                    }
                    SA[i] = buf[j];
                    buf[j] = t;
                    return;
                }
                if (SA[k] < 0) {
                    x |= 2;
                    p2 = PA + ~SA[k];
                    continue;
                }
                p2 = PA + SA[k];
                continue;
            }
            if ((x & 1) != 0) {
                do {
                    SA[i--] = buf[j];
                    buf[j--] = SA[i];
                } while (buf[j] < 0);
                x ^= 1;
            }
            SA[i--] = ~buf[j];
            if (j <= bufoffset) {
                buf[j] = t;
                return;
            }
            buf[j--] = SA[i];
            if ((x & 2) != 0) {
                do {
                    SA[i--] = SA[k];
                    SA[k--] = SA[i];
                } while (SA[k] < 0);
                x ^= 2;
            }
            SA[i--] = SA[k];
            SA[k--] = SA[i];
            if (k < first) {
                while (bufoffset < j) {
                    SA[i--] = buf[j];
                    buf[j--] = SA[i];
                }
                SA[i] = buf[j];
                buf[j] = t;
                return;
            }
            if (buf[j] < 0) {
                x |= 1;
                p1 = PA + ~buf[j];
            } else {
                p1 = PA + buf[j];
            }
            if (SA[k] < 0) {
                x |= 2;
                p2 = PA + ~SA[k];
                continue;
            }
            p2 = PA + SA[k];
        }
    }

    private static final int getIDX(int a) {
        return a >= 0 ? a : ~a;
    }

    private void ssMergeCheckEqual(int PA, int depth, int a) {
        int[] SA = this.SA;
        if (SA[a] >= 0 && this.ssCompare(PA + BZip2DivSufSort.getIDX(SA[a - 1]), PA + SA[a], depth) == 0) {
            SA[a] = ~SA[a];
        }
    }

    private void ssMerge(int PA, int first, int middle, int last, int[] buf, int bufoffset, int bufsize, int depth) {
        int[] SA = this.SA;
        StackEntry[] stack = new StackEntry[64];
        int check = 0;
        int ssize = 0;
        while (true) {
            StackEntry entry;
            if (last - middle <= bufsize) {
                if (first < middle && middle < last) {
                    this.ssMergeBackward(PA, buf, bufoffset, first, middle, last, depth);
                }
                if (check & true) {
                    this.ssMergeCheckEqual(PA, depth, first);
                }
                if ((check & 2) != 0) {
                    this.ssMergeCheckEqual(PA, depth, last);
                }
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                first = entry.a;
                middle = entry.b;
                last = entry.c;
                check = entry.d;
                continue;
            }
            if (middle - first <= bufsize) {
                if (first < middle) {
                    this.ssMergeForward(PA, buf, bufoffset, first, middle, last, depth);
                }
                if ((check & 1) != 0) {
                    this.ssMergeCheckEqual(PA, depth, first);
                }
                if ((check & 2) != 0) {
                    this.ssMergeCheckEqual(PA, depth, last);
                }
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                first = entry.a;
                middle = entry.b;
                last = entry.c;
                check = entry.d;
                continue;
            }
            int m = 0;
            int len = Math.min(middle - first, last - middle);
            int half = len >> 1;
            while (len > 0) {
                if (this.ssCompare(PA + BZip2DivSufSort.getIDX(SA[middle + m + half]), PA + BZip2DivSufSort.getIDX(SA[middle - m - half - 1]), depth) < 0) {
                    m += half + 1;
                    half -= len & 1 ^ 1;
                }
                len = half;
                half >>= 1;
            }
            if (m > 0) {
                int j;
                this.ssBlockSwap(SA, middle - m, SA, middle, m);
                int i = j = middle;
                int next = 0;
                if (middle + m < last) {
                    if (SA[middle + m] < 0) {
                        while (SA[i - 1] < 0) {
                            --i;
                        }
                        SA[middle + m] = ~SA[middle + m];
                    }
                    j = middle;
                    while (SA[j] < 0) {
                        ++j;
                    }
                    next = 1;
                }
                if (i - first <= last - j) {
                    stack[ssize++] = new StackEntry(j, middle + m, last, check & 2 | next & 1);
                    middle -= m;
                    last = i;
                    check &= 1;
                    continue;
                }
                if (i == middle && middle == j) {
                    next <<= 1;
                }
                stack[ssize++] = new StackEntry(first, middle - m, i, check & 1 | next & 2);
                first = j;
                middle += m;
                check = check & 2 | next & 1;
                continue;
            }
            if ((check & 1) != 0) {
                this.ssMergeCheckEqual(PA, depth, first);
            }
            this.ssMergeCheckEqual(PA, depth, middle);
            if ((check & 2) != 0) {
                this.ssMergeCheckEqual(PA, depth, last);
            }
            if (ssize == 0) {
                return;
            }
            entry = stack[--ssize];
            first = entry.a;
            middle = entry.b;
            last = entry.c;
            check = entry.d;
        }
    }

    private void subStringSort(int PA, int first, int last, int[] buf, int bufoffset, int bufsize, int depth, boolean lastsuffix, int size) {
        int k;
        int[] SA = this.SA;
        if (lastsuffix) {
            ++first;
        }
        int a = first;
        int i = 0;
        while (a + 1024 < last) {
            this.ssMultiKeyIntroSort(PA, a, a + 1024, depth);
            int[] curbuf = SA;
            int curbufoffset = a + 1024;
            int curbufsize = last - (a + 1024);
            if (curbufsize <= bufsize) {
                curbufsize = bufsize;
                curbuf = buf;
                curbufoffset = bufoffset;
            }
            int b = a;
            k = 1024;
            int j = i;
            while ((j & 1) != 0) {
                this.ssMerge(PA, b - k, b, b + k, curbuf, curbufoffset, curbufsize, depth);
                b -= k;
                k <<= 1;
                j >>>= 1;
            }
            a += 1024;
            ++i;
        }
        this.ssMultiKeyIntroSort(PA, a, last, depth);
        k = 1024;
        while (i != 0) {
            if (i & true) {
                this.ssMerge(PA, a - k, a, last, buf, bufoffset, bufsize, depth);
                a -= k;
            }
            k <<= 1;
            i >>= 1;
        }
        if (lastsuffix) {
            a = first;
            i = SA[first - 1];
            int r = 1;
            while (a < last && (SA[a] < 0 || (r = this.ssCompareLast(PA, PA + i, PA + SA[a], depth, size)) > 0)) {
                SA[a - 1] = SA[a];
                ++a;
            }
            if (r == 0) {
                SA[a] = ~SA[a];
            }
            SA[a - 1] = i;
        }
    }

    private int trGetC(int ISA, int ISAd, int ISAn, int p) {
        return ISAd + p < ISAn ? this.SA[ISAd + p] : this.SA[ISA + (ISAd - ISA + p) % (ISAn - ISA)];
    }

    private void trFixdown(int ISA, int ISAd, int ISAn, int sa, int i, int size) {
        int j;
        int[] SA = this.SA;
        int v = SA[sa + i];
        int c = this.trGetC(ISA, ISAd, ISAn, v);
        while ((j = 2 * i + 1) < size) {
            int e;
            int k;
            int d;
            if ((d = this.trGetC(ISA, ISAd, ISAn, SA[sa + (k = j++)])) < (e = this.trGetC(ISA, ISAd, ISAn, SA[sa + j]))) {
                k = j;
                d = e;
            }
            if (d <= c) break;
            SA[sa + i] = SA[sa + k];
            i = k;
        }
        SA[sa + i] = v;
    }

    private void trHeapSort(int ISA, int ISAd, int ISAn, int sa, int size) {
        int[] SA = this.SA;
        int m = size;
        if (size % 2 == 0 && this.trGetC(ISA, ISAd, ISAn, SA[sa + --m / 2]) < this.trGetC(ISA, ISAd, ISAn, SA[sa + m])) {
            BZip2DivSufSort.swapElements(SA, sa + m, SA, sa + m / 2);
        }
        int i = m / 2 - 1;
        while (i >= 0) {
            this.trFixdown(ISA, ISAd, ISAn, sa, i, m);
            --i;
        }
        if (size % 2 == 0) {
            BZip2DivSufSort.swapElements(SA, sa + 0, SA, sa + m);
            this.trFixdown(ISA, ISAd, ISAn, sa, 0, m);
        }
        i = m - 1;
        while (i > 0) {
            int t = SA[sa + 0];
            SA[sa + 0] = SA[sa + i];
            this.trFixdown(ISA, ISAd, ISAn, sa, 0, i);
            SA[sa + i] = t;
            --i;
        }
    }

    private void trInsertionSort(int ISA, int ISAd, int ISAn, int first, int last) {
        int[] SA = this.SA;
        int a = first + 1;
        while (a < last) {
            int r;
            int t = SA[a];
            int b = a - 1;
            while ((r = this.trGetC(ISA, ISAd, ISAn, t) - this.trGetC(ISA, ISAd, ISAn, SA[b])) < 0) {
                do {
                    SA[b + 1] = SA[b];
                } while (first <= --b && SA[b] < 0);
                if (b < first) break;
            }
            if (r == 0) {
                SA[b] = ~SA[b];
            }
            SA[b + 1] = t;
            ++a;
        }
    }

    private int trLog(int n) {
        return (n & 0xFFFF0000) != 0 ? ((n & 0xFF000000) != 0 ? 24 + log2table[n >> 24 & 0xFF] : 16 + log2table[n >> 16 & 0xFF]) : ((n & 0xFF00) != 0 ? 8 + log2table[n >> 8 & 0xFF] : 0 + log2table[n >> 0 & 0xFF]);
    }

    private int trMedian3(int ISA, int ISAd, int ISAn, int v1, int v2, int v3) {
        int[] SA = this.SA;
        int SA_v1 = this.trGetC(ISA, ISAd, ISAn, SA[v1]);
        int SA_v2 = this.trGetC(ISA, ISAd, ISAn, SA[v2]);
        int SA_v3 = this.trGetC(ISA, ISAd, ISAn, SA[v3]);
        if (SA_v1 > SA_v2) {
            int temp = v1;
            v1 = v2;
            v2 = temp;
            int SA_vtemp = SA_v1;
            SA_v1 = SA_v2;
            SA_v2 = SA_vtemp;
        }
        if (SA_v2 > SA_v3) {
            if (SA_v1 > SA_v3) {
                return v1;
            }
            return v3;
        }
        return v2;
    }

    private int trMedian5(int ISA, int ISAd, int ISAn, int v1, int v2, int v3, int v4, int v5) {
        int SA_vtemp;
        int temp;
        int[] SA = this.SA;
        int SA_v1 = this.trGetC(ISA, ISAd, ISAn, SA[v1]);
        int SA_v2 = this.trGetC(ISA, ISAd, ISAn, SA[v2]);
        int SA_v3 = this.trGetC(ISA, ISAd, ISAn, SA[v3]);
        int SA_v4 = this.trGetC(ISA, ISAd, ISAn, SA[v4]);
        int SA_v5 = this.trGetC(ISA, ISAd, ISAn, SA[v5]);
        if (SA_v2 > SA_v3) {
            temp = v2;
            v2 = v3;
            v3 = temp;
            SA_vtemp = SA_v2;
            SA_v2 = SA_v3;
            SA_v3 = SA_vtemp;
        }
        if (SA_v4 > SA_v5) {
            temp = v4;
            v4 = v5;
            v5 = temp;
            SA_vtemp = SA_v4;
            SA_v4 = SA_v5;
            SA_v5 = SA_vtemp;
        }
        if (SA_v2 > SA_v4) {
            temp = v2;
            v2 = v4;
            v4 = temp;
            SA_vtemp = SA_v2;
            SA_v2 = SA_v4;
            SA_v4 = SA_vtemp;
            temp = v3;
            v3 = v5;
            v5 = temp;
            SA_vtemp = SA_v3;
            SA_v3 = SA_v5;
            SA_v5 = SA_vtemp;
        }
        if (SA_v1 > SA_v3) {
            temp = v1;
            v1 = v3;
            v3 = temp;
            SA_vtemp = SA_v1;
            SA_v1 = SA_v3;
            SA_v3 = SA_vtemp;
        }
        if (SA_v1 > SA_v4) {
            temp = v1;
            v1 = v4;
            v4 = temp;
            SA_vtemp = SA_v1;
            SA_v1 = SA_v4;
            SA_v4 = SA_vtemp;
            temp = v3;
            v3 = v5;
            v5 = temp;
            SA_vtemp = SA_v3;
            SA_v3 = SA_v5;
            SA_v5 = SA_vtemp;
        }
        if (SA_v3 > SA_v4) {
            return v4;
        }
        return v3;
    }

    private int trPivot(int ISA, int ISAd, int ISAn, int first, int last) {
        int t = last - first;
        int middle = first + t / 2;
        if (t <= 512) {
            if (t <= 32) {
                return this.trMedian3(ISA, ISAd, ISAn, first, middle, last - 1);
            }
            return this.trMedian5(ISA, ISAd, ISAn, first, first + (t >>= 2), middle, last - 1 - t, last - 1);
        }
        return this.trMedian3(ISA, ISAd, ISAn, this.trMedian3(ISA, ISAd, ISAn, first, first + (t >>= 3), first + (t << 1)), this.trMedian3(ISA, ISAd, ISAn, middle - t, middle, middle + t), this.trMedian3(ISA, ISAd, ISAn, last - 1 - (t << 1), last - 1 - t, last - 1));
    }

    private void lsUpdateGroup(int ISA, int first, int last) {
        int[] SA = this.SA;
        int a = first;
        while (a < last) {
            int b;
            if (SA[a] >= 0) {
                b = a;
                do {
                    SA[ISA + SA[a]] = a;
                } while (++a < last && SA[a] >= 0);
                SA[b] = b - a;
                if (last <= a) break;
            }
            b = a;
            do {
                SA[a] = ~SA[a];
            } while (SA[++a] < 0);
            int t = a;
            do {
                SA[ISA + SA[b]] = t;
            } while (++b <= a);
            ++a;
        }
    }

    private void lsIntroSort(int ISA, int ISAd, int ISAn, int first, int last) {
        int[] SA = this.SA;
        StackEntry[] stack = new StackEntry[64];
        int x = 0;
        int ssize = 0;
        int limit = this.trLog(last - first);
        while (true) {
            int b;
            int a;
            StackEntry entry;
            if (last - first <= 8) {
                if (1 < last - first) {
                    this.trInsertionSort(ISA, ISAd, ISAn, first, last);
                    this.lsUpdateGroup(ISA, first, last);
                } else if (last - first == 1) {
                    SA[first] = -1;
                }
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                first = entry.a;
                last = entry.b;
                limit = entry.c;
                continue;
            }
            if (limit-- == 0) {
                this.trHeapSort(ISA, ISAd, ISAn, first, last - first);
                a = last - 1;
                while (first < a) {
                    x = this.trGetC(ISA, ISAd, ISAn, SA[a]);
                    b = a - 1;
                    while (first <= b && this.trGetC(ISA, ISAd, ISAn, SA[b]) == x) {
                        SA[b] = ~SA[b];
                        --b;
                    }
                    a = b;
                }
                this.lsUpdateGroup(ISA, first, last);
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                first = entry.a;
                last = entry.b;
                limit = entry.c;
                continue;
            }
            a = this.trPivot(ISA, ISAd, ISAn, first, last);
            BZip2DivSufSort.swapElements(SA, first, SA, a);
            int v = this.trGetC(ISA, ISAd, ISAn, SA[first]);
            b = first;
            while (++b < last && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) == v) {
            }
            a = b;
            if (a < last && x < v) {
                while (++b < last && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) <= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
            }
            int c = last;
            while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) == v) {
            }
            int d = c;
            if (b < d && x > v) {
                while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) >= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            while (b < c) {
                BZip2DivSufSort.swapElements(SA, b, SA, c);
                while (++b < c && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) <= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
                while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) >= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            if (a <= d) {
                c = b - 1;
                int s = a - first;
                int t = b - a;
                if (s > t) {
                    s = t;
                }
                int e = first;
                int f = b - s;
                while (s > 0) {
                    BZip2DivSufSort.swapElements(SA, e, SA, f);
                    --s;
                    ++e;
                    ++f;
                }
                s = d - c;
                t = last - d - 1;
                if (s > t) {
                    s = t;
                }
                e = b;
                f = last - s;
                while (s > 0) {
                    BZip2DivSufSort.swapElements(SA, e, SA, f);
                    --s;
                    ++e;
                    ++f;
                }
                a = first + (b - a);
                b = last - (d - c);
                c = first;
                v = a - 1;
                while (c < a) {
                    SA[ISA + SA[c]] = v;
                    ++c;
                }
                if (b < last) {
                    c = a;
                    v = b - 1;
                    while (c < b) {
                        SA[ISA + SA[c]] = v;
                        ++c;
                    }
                }
                if (b - a == 1) {
                    SA[a] = -1;
                }
                if (a - first <= last - b) {
                    if (first < a) {
                        stack[ssize++] = new StackEntry(b, last, limit, 0);
                        last = a;
                        continue;
                    }
                    first = b;
                    continue;
                }
                if (b < last) {
                    stack[ssize++] = new StackEntry(first, a, limit, 0);
                    first = b;
                    continue;
                }
                last = a;
                continue;
            }
            if (ssize == 0) {
                return;
            }
            entry = stack[--ssize];
            first = entry.a;
            last = entry.b;
            limit = entry.c;
        }
    }

    private void lsSort(int ISA, int n, int depth) {
        int[] SA = this.SA;
        int ISAd = ISA + depth;
        while (-n < SA[0]) {
            int last;
            int t;
            int first = 0;
            int skip = 0;
            do {
                if ((t = SA[first]) < 0) {
                    first -= t;
                    skip += t;
                    continue;
                }
                if (skip != 0) {
                    SA[first + skip] = skip;
                    skip = 0;
                }
                last = SA[ISA + t] + 1;
                this.lsIntroSort(ISA, ISAd, ISA + n, first, last);
                first = last;
            } while (first < n);
            if (skip != 0) {
                SA[first + skip] = skip;
            }
            if (n < ISAd - ISA) {
                first = 0;
                do {
                    if ((t = SA[first]) < 0) {
                        first -= t;
                        continue;
                    }
                    last = SA[ISA + t] + 1;
                    int i = first;
                    while (i < last) {
                        SA[ISA + SA[i]] = i;
                        ++i;
                    }
                    first = last;
                } while (first < n);
                break;
            }
            ISAd += ISAd - ISA;
        }
    }

    private PartitionResult trPartition(int ISA, int ISAd, int ISAn, int first, int last, int v) {
        int[] SA = this.SA;
        int x = 0;
        int b = first - 1;
        while (++b < last && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) == v) {
        }
        int a = b;
        if (a < last && x < v) {
            while (++b < last && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) <= v) {
                if (x != v) continue;
                BZip2DivSufSort.swapElements(SA, b, SA, a);
                ++a;
            }
        }
        int c = last;
        while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) == v) {
        }
        int d = c;
        if (b < d && x > v) {
            while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) >= v) {
                if (x != v) continue;
                BZip2DivSufSort.swapElements(SA, c, SA, d);
                --d;
            }
        }
        while (b < c) {
            BZip2DivSufSort.swapElements(SA, b, SA, c);
            while (++b < c && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) <= v) {
                if (x != v) continue;
                BZip2DivSufSort.swapElements(SA, b, SA, a);
                ++a;
            }
            while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) >= v) {
                if (x != v) continue;
                BZip2DivSufSort.swapElements(SA, c, SA, d);
                --d;
            }
        }
        if (a <= d) {
            c = b - 1;
            int s = a - first;
            int t = b - a;
            if (s > t) {
                s = t;
            }
            int e = first;
            int f = b - s;
            while (s > 0) {
                BZip2DivSufSort.swapElements(SA, e, SA, f);
                --s;
                ++e;
                ++f;
            }
            s = d - c;
            t = last - d - 1;
            if (s > t) {
                s = t;
            }
            e = b;
            f = last - s;
            while (s > 0) {
                BZip2DivSufSort.swapElements(SA, e, SA, f);
                --s;
                ++e;
                ++f;
            }
            first += b - a;
            last -= d - c;
        }
        return new PartitionResult(first, last);
    }

    private void trCopy(int ISA, int ISAn, int first, int a, int b, int last, int depth) {
        int s;
        int[] SA = this.SA;
        int v = b - 1;
        int c = first;
        int d = a - 1;
        while (c <= d) {
            s = SA[c] - depth;
            if (s < 0) {
                s += ISAn - ISA;
            }
            if (SA[ISA + s] == v) {
                SA[++d] = s;
                SA[ISA + s] = d;
            }
            ++c;
        }
        c = last - 1;
        int e = d + 1;
        d = b;
        while (e < d) {
            s = SA[c] - depth;
            if (s < 0) {
                s += ISAn - ISA;
            }
            if (SA[ISA + s] == v) {
                SA[--d] = s;
                SA[ISA + s] = d;
            }
            --c;
        }
    }

    private void trIntroSort(int ISA, int ISAd, int ISAn, int first, int last, TRBudget budget, int size) {
        int s;
        int[] SA = this.SA;
        StackEntry[] stack = new StackEntry[64];
        int x = 0;
        int ssize = 0;
        int limit = this.trLog(last - first);
        while (true) {
            int next;
            StackEntry entry;
            int v;
            int c;
            int b;
            int a;
            if (limit < 0) {
                if (limit == -1) {
                    StackEntry entry2;
                    if (!budget.update(size, last - first)) break;
                    PartitionResult result = this.trPartition(ISA, ISAd - 1, ISAn, first, last, last - 1);
                    a = result.first;
                    b = result.last;
                    if (first < a || b < last) {
                        if (a < last) {
                            c = first;
                            v = a - 1;
                            while (c < a) {
                                SA[ISA + SA[c]] = v;
                                ++c;
                            }
                        }
                        if (b < last) {
                            c = a;
                            v = b - 1;
                            while (c < b) {
                                SA[ISA + SA[c]] = v;
                                ++c;
                            }
                        }
                        stack[ssize++] = new StackEntry(0, a, b, 0);
                        stack[ssize++] = new StackEntry(ISAd - 1, first, last, -2);
                        if (a - first <= last - b) {
                            if (1 < a - first) {
                                stack[ssize++] = new StackEntry(ISAd, b, last, this.trLog(last - b));
                                last = a;
                                limit = this.trLog(a - first);
                                continue;
                            }
                            if (1 < last - b) {
                                first = b;
                                limit = this.trLog(last - b);
                                continue;
                            }
                            if (ssize == 0) {
                                return;
                            }
                            entry2 = stack[--ssize];
                            ISAd = entry2.a;
                            first = entry2.b;
                            last = entry2.c;
                            limit = entry2.d;
                            continue;
                        }
                        if (1 < last - b) {
                            stack[ssize++] = new StackEntry(ISAd, first, a, this.trLog(a - first));
                            first = b;
                            limit = this.trLog(last - b);
                            continue;
                        }
                        if (1 < a - first) {
                            last = a;
                            limit = this.trLog(a - first);
                            continue;
                        }
                        if (ssize == 0) {
                            return;
                        }
                        entry2 = stack[--ssize];
                        ISAd = entry2.a;
                        first = entry2.b;
                        last = entry2.c;
                        limit = entry2.d;
                        continue;
                    }
                    c = first;
                    while (c < last) {
                        SA[ISA + SA[c]] = c;
                        ++c;
                    }
                    if (ssize == 0) {
                        return;
                    }
                    entry2 = stack[--ssize];
                    ISAd = entry2.a;
                    first = entry2.b;
                    last = entry2.c;
                    limit = entry2.d;
                    continue;
                }
                if (limit == -2) {
                    a = stack[--ssize].b;
                    b = stack[ssize].c;
                    this.trCopy(ISA, ISAn, first, a, b, last, ISAd - ISA);
                    if (ssize == 0) {
                        return;
                    }
                    entry = stack[--ssize];
                    ISAd = entry.a;
                    first = entry.b;
                    last = entry.c;
                    limit = entry.d;
                    continue;
                }
                if (SA[first] >= 0) {
                    a = first;
                    do {
                        SA[ISA + SA[a]] = a;
                    } while (++a < last && SA[a] >= 0);
                    first = a;
                }
                if (first < last) {
                    a = first;
                    do {
                        SA[a] = ~SA[a];
                    } while (SA[++a] < 0);
                    int n = next = SA[ISA + SA[a]] != SA[ISAd + SA[a]] ? this.trLog(a - first + 1) : -1;
                    if (++a < last) {
                        b = first;
                        v = a - 1;
                        while (b < a) {
                            SA[ISA + SA[b]] = v;
                            ++b;
                        }
                    }
                    if (a - first <= last - a) {
                        stack[ssize++] = new StackEntry(ISAd, a, last, -3);
                        ++ISAd;
                        last = a;
                        limit = next;
                        continue;
                    }
                    if (1 < last - a) {
                        stack[ssize++] = new StackEntry(ISAd + 1, first, a, next);
                        first = a;
                        limit = -3;
                        continue;
                    }
                    ++ISAd;
                    last = a;
                    limit = next;
                    continue;
                }
                if (ssize == 0) {
                    return;
                }
                entry = stack[--ssize];
                ISAd = entry.a;
                first = entry.b;
                last = entry.c;
                limit = entry.d;
                continue;
            }
            if (last - first <= 8) {
                if (!budget.update(size, last - first)) break;
                this.trInsertionSort(ISA, ISAd, ISAn, first, last);
                limit = -3;
                continue;
            }
            if (limit-- == 0) {
                if (!budget.update(size, last - first)) break;
                this.trHeapSort(ISA, ISAd, ISAn, first, last - first);
                a = last - 1;
                while (first < a) {
                    x = this.trGetC(ISA, ISAd, ISAn, SA[a]);
                    b = a - 1;
                    while (first <= b && this.trGetC(ISA, ISAd, ISAn, SA[b]) == x) {
                        SA[b] = ~SA[b];
                        --b;
                    }
                    a = b;
                }
                limit = -3;
                continue;
            }
            a = this.trPivot(ISA, ISAd, ISAn, first, last);
            BZip2DivSufSort.swapElements(SA, first, SA, a);
            v = this.trGetC(ISA, ISAd, ISAn, SA[first]);
            b = first;
            while (++b < last && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) == v) {
            }
            a = b;
            if (a < last && x < v) {
                while (++b < last && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) <= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
            }
            c = last;
            while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) == v) {
            }
            int d = c;
            if (b < d && x > v) {
                while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) >= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            while (b < c) {
                BZip2DivSufSort.swapElements(SA, b, SA, c);
                while (++b < c && (x = this.trGetC(ISA, ISAd, ISAn, SA[b])) <= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, b, SA, a);
                    ++a;
                }
                while (b < --c && (x = this.trGetC(ISA, ISAd, ISAn, SA[c])) >= v) {
                    if (x != v) continue;
                    BZip2DivSufSort.swapElements(SA, c, SA, d);
                    --d;
                }
            }
            if (a <= d) {
                c = b - 1;
                s = a - first;
                int t = b - a;
                if (s > t) {
                    s = t;
                }
                int e = first;
                int f = b - s;
                while (s > 0) {
                    BZip2DivSufSort.swapElements(SA, e, SA, f);
                    --s;
                    ++e;
                    ++f;
                }
                s = d - c;
                t = last - d - 1;
                if (s > t) {
                    s = t;
                }
                e = b;
                f = last - s;
                while (s > 0) {
                    BZip2DivSufSort.swapElements(SA, e, SA, f);
                    --s;
                    ++e;
                    ++f;
                }
                a = first + (b - a);
                b = last - (d - c);
                next = SA[ISA + SA[a]] != v ? this.trLog(b - a) : -1;
                c = first;
                v = a - 1;
                while (c < a) {
                    SA[ISA + SA[c]] = v;
                    ++c;
                }
                if (b < last) {
                    c = a;
                    v = b - 1;
                    while (c < b) {
                        SA[ISA + SA[c]] = v;
                        ++c;
                    }
                }
                if (a - first <= last - b) {
                    if (last - b <= b - a) {
                        if (1 < a - first) {
                            stack[ssize++] = new StackEntry(ISAd + 1, a, b, next);
                            stack[ssize++] = new StackEntry(ISAd, b, last, limit);
                            last = a;
                            continue;
                        }
                        if (1 < last - b) {
                            stack[ssize++] = new StackEntry(ISAd + 1, a, b, next);
                            first = b;
                            continue;
                        }
                        if (1 < b - a) {
                            ++ISAd;
                            first = a;
                            last = b;
                            limit = next;
                            continue;
                        }
                        if (ssize == 0) {
                            return;
                        }
                        entry = stack[--ssize];
                        ISAd = entry.a;
                        first = entry.b;
                        last = entry.c;
                        limit = entry.d;
                        continue;
                    }
                    if (a - first <= b - a) {
                        if (1 < a - first) {
                            stack[ssize++] = new StackEntry(ISAd, b, last, limit);
                            stack[ssize++] = new StackEntry(ISAd + 1, a, b, next);
                            last = a;
                            continue;
                        }
                        if (1 < b - a) {
                            stack[ssize++] = new StackEntry(ISAd, b, last, limit);
                            ++ISAd;
                            first = a;
                            last = b;
                            limit = next;
                            continue;
                        }
                        first = b;
                        continue;
                    }
                    if (1 < b - a) {
                        stack[ssize++] = new StackEntry(ISAd, b, last, limit);
                        stack[ssize++] = new StackEntry(ISAd, first, a, limit);
                        ++ISAd;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    stack[ssize++] = new StackEntry(ISAd, b, last, limit);
                    last = a;
                    continue;
                }
                if (a - first <= b - a) {
                    if (1 < last - b) {
                        stack[ssize++] = new StackEntry(ISAd + 1, a, b, next);
                        stack[ssize++] = new StackEntry(ISAd, first, a, limit);
                        first = b;
                        continue;
                    }
                    if (1 < a - first) {
                        stack[ssize++] = new StackEntry(ISAd + 1, a, b, next);
                        last = a;
                        continue;
                    }
                    if (1 < b - a) {
                        ++ISAd;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    stack[ssize++] = new StackEntry(ISAd, first, last, limit);
                    continue;
                }
                if (last - b <= b - a) {
                    if (1 < last - b) {
                        stack[ssize++] = new StackEntry(ISAd, first, a, limit);
                        stack[ssize++] = new StackEntry(ISAd + 1, a, b, next);
                        first = b;
                        continue;
                    }
                    if (1 < b - a) {
                        stack[ssize++] = new StackEntry(ISAd, first, a, limit);
                        ++ISAd;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    last = a;
                    continue;
                }
                if (1 < b - a) {
                    stack[ssize++] = new StackEntry(ISAd, first, a, limit);
                    stack[ssize++] = new StackEntry(ISAd, b, last, limit);
                    ++ISAd;
                    first = a;
                    last = b;
                    limit = next;
                    continue;
                }
                stack[ssize++] = new StackEntry(ISAd, first, a, limit);
                first = b;
                continue;
            }
            if (!budget.update(size, last - first)) break;
            ++limit;
            ++ISAd;
        }
        s = 0;
        while (s < ssize) {
            if (stack[s].d == -3) {
                this.lsUpdateGroup(ISA, stack[s].b, stack[s].c);
            }
            ++s;
        }
    }

    private void trSort(int ISA, int n, int depth) {
        int[] SA = this.SA;
        int first = 0;
        if (-n < SA[0]) {
            TRBudget budget = new TRBudget(n, this.trLog(n) * 2 / 3 + 1);
            do {
                int t;
                if ((t = SA[first]) < 0) {
                    first -= t;
                    continue;
                }
                int last = SA[ISA + t] + 1;
                if (1 < last - first) {
                    this.trIntroSort(ISA, ISA + depth, ISA + n, first, last, budget, n);
                    if (budget.chance == 0) {
                        if (first > 0) {
                            SA[0] = -first;
                        }
                        this.lsSort(ISA, n, depth);
                        break;
                    }
                }
                first = last;
            } while (first < n);
        }
    }

    private static final int BUCKET_B(int c0, int c1) {
        return c1 << 8 | c0;
    }

    private static final int BUCKET_BSTAR(int c0, int c1) {
        return c0 << 8 | c1;
    }

    private int sortTypeBstar(int[] bucketA, int[] bucketB) {
        int c1;
        int t;
        int ti1;
        byte[] T = this.T;
        int[] SA = this.SA;
        int n = this.n;
        int[] tempbuf = new int[256];
        int i = 1;
        boolean flag = true;
        while (i < n) {
            if (T[i - 1] != T[i]) {
                if ((T[i - 1] & 0xFF) <= (T[i] & 0xFF)) break;
                flag = false;
                break;
            }
            ++i;
        }
        i = n - 1;
        int m = n;
        int ti = T[i] & 0xFF;
        int t0 = T[0] & 0xFF;
        if (ti < t0 || T[i] == T[0] && flag) {
            if (!flag) {
                int n2 = BZip2DivSufSort.BUCKET_BSTAR(ti, t0);
                bucketB[n2] = bucketB[n2] + 1;
                SA[--m] = i;
            } else {
                int n3 = BZip2DivSufSort.BUCKET_B(ti, t0);
                bucketB[n3] = bucketB[n3] + 1;
            }
            --i;
            while (i >= 0 && (ti = T[i] & 0xFF) <= (ti1 = T[i + 1] & 0xFF)) {
                int n4 = BZip2DivSufSort.BUCKET_B(ti, ti1);
                bucketB[n4] = bucketB[n4] + 1;
                --i;
            }
        }
        while (i >= 0) {
            do {
                int n5 = T[i] & 0xFF;
                bucketA[n5] = bucketA[n5] + 1;
            } while (--i >= 0 && (T[i] & 0xFF) >= (T[i + 1] & 0xFF));
            if (i < 0) continue;
            int n6 = BZip2DivSufSort.BUCKET_BSTAR(T[i] & 0xFF, T[i + 1] & 0xFF);
            bucketB[n6] = bucketB[n6] + 1;
            SA[--m] = i--;
            while (i >= 0 && (ti = T[i] & 0xFF) <= (ti1 = T[i + 1] & 0xFF)) {
                int n7 = BZip2DivSufSort.BUCKET_B(ti, ti1);
                bucketB[n7] = bucketB[n7] + 1;
                --i;
            }
        }
        if ((m = n - m) == 0) {
            i = 0;
            while (i < n) {
                SA[i] = i;
                ++i;
            }
            return 0;
        }
        int c0 = 0;
        i = -1;
        int j = 0;
        while (c0 < 256) {
            t = i + bucketA[c0];
            bucketA[c0] = i + j;
            i = t + bucketB[BZip2DivSufSort.BUCKET_B(c0, c0)];
            c1 = c0 + 1;
            while (c1 < 256) {
                bucketB[c0 << 8 | c1] = j += bucketB[BZip2DivSufSort.BUCKET_BSTAR(c0, c1)];
                i += bucketB[BZip2DivSufSort.BUCKET_B(c0, c1)];
                ++c1;
            }
            ++c0;
        }
        int PAb = n - m;
        int ISAb = m;
        i = m - 2;
        while (i >= 0) {
            t = SA[PAb + i];
            c0 = T[t] & 0xFF;
            c1 = T[t + 1] & 0xFF;
            int n8 = BZip2DivSufSort.BUCKET_BSTAR(c0, c1);
            int n9 = bucketB[n8] - 1;
            bucketB[n8] = n9;
            SA[n9] = i--;
        }
        t = SA[PAb + m - 1];
        c0 = T[t] & 0xFF;
        c1 = T[t + 1] & 0xFF;
        int n10 = BZip2DivSufSort.BUCKET_BSTAR(c0, c1);
        int n11 = bucketB[n10] - 1;
        bucketB[n10] = n11;
        SA[n11] = m - 1;
        int[] buf = SA;
        int bufoffset = m;
        int bufsize = n - 2 * m;
        if (bufsize <= 256) {
            buf = tempbuf;
            bufoffset = 0;
            bufsize = 256;
        }
        c0 = 255;
        j = m;
        while (j > 0) {
            c1 = 255;
            while (c0 < c1) {
                i = bucketB[BZip2DivSufSort.BUCKET_BSTAR(c0, c1)];
                if (1 < j - i) {
                    this.subStringSort(PAb, i, j, buf, bufoffset, bufsize, 2, SA[i] == m - 1, n);
                }
                j = i;
                --c1;
            }
            --c0;
        }
        i = m - 1;
        while (i >= 0) {
            if (SA[i] >= 0) {
                j = i;
                do {
                    SA[ISAb + SA[i]] = i;
                } while (--i >= 0 && SA[i] >= 0);
                SA[i + 1] = i - j;
                if (i <= 0) break;
            }
            j = i;
            do {
                SA[i] = ~SA[i];
                SA[ISAb + SA[i]] = j;
            } while (SA[--i] < 0);
            SA[ISAb + SA[i]] = j;
            --i;
        }
        this.trSort(ISAb, m, 1);
        i = n - 1;
        j = m;
        if ((T[i] & 0xFF) < (T[0] & 0xFF) || T[i] == T[0] && flag) {
            if (!flag) {
                SA[SA[ISAb + --j]] = i;
            }
            --i;
            while (i >= 0 && (T[i] & 0xFF) <= (T[i + 1] & 0xFF)) {
                --i;
            }
        }
        while (i >= 0) {
            --i;
            while (i >= 0 && (T[i] & 0xFF) >= (T[i + 1] & 0xFF)) {
                --i;
            }
            if (i < 0) continue;
            SA[SA[ISAb + --j]] = i--;
            while (i >= 0 && (T[i] & 0xFF) <= (T[i + 1] & 0xFF)) {
                --i;
            }
        }
        c0 = 255;
        i = n - 1;
        int k = m - 1;
        while (c0 >= 0) {
            c1 = 255;
            while (c0 < c1) {
                t = i - bucketB[BZip2DivSufSort.BUCKET_B(c0, c1)];
                bucketB[BZip2DivSufSort.BUCKET_B((int)c0, (int)c1)] = i + 1;
                i = t;
                j = bucketB[BZip2DivSufSort.BUCKET_BSTAR(c0, c1)];
                while (j <= k) {
                    SA[i] = SA[k];
                    --i;
                    --k;
                }
                --c1;
            }
            t = i - bucketB[BZip2DivSufSort.BUCKET_B(c0, c0)];
            bucketB[BZip2DivSufSort.BUCKET_B((int)c0, (int)c0)] = i + 1;
            if (c0 < 255) {
                bucketB[BZip2DivSufSort.BUCKET_BSTAR((int)c0, (int)(c0 + 1))] = t + 1;
            }
            i = bucketA[c0];
            --c0;
        }
        return m;
    }

    private int constructBWT(int[] bucketA, int[] bucketB) {
        int s1;
        int s;
        int i;
        byte[] T = this.T;
        int[] SA = this.SA;
        int n = this.n;
        int t = 0;
        int c0 = 0;
        int c2 = 0;
        int orig = -1;
        int c1 = 254;
        while (c1 >= 0) {
            i = bucketB[BZip2DivSufSort.BUCKET_BSTAR(c1, c1 + 1)];
            int j = bucketA[c1 + 1];
            t = 0;
            c2 = -1;
            while (i <= j) {
                s1 = s = SA[j];
                if (s >= 0) {
                    if (--s < 0) {
                        s = n - 1;
                    }
                    if ((c0 = T[s] & 0xFF) <= c1) {
                        SA[j] = ~s1;
                        if (s > 0 && (T[s - 1] & 0xFF) > c0) {
                            s ^= 0xFFFFFFFF;
                        }
                        if (c2 == c0) {
                            SA[--t] = s;
                        } else {
                            if (c2 >= 0) {
                                bucketB[BZip2DivSufSort.BUCKET_B((int)c2, (int)c1)] = t;
                            }
                            c2 = c0;
                            t = bucketB[BZip2DivSufSort.BUCKET_B(c2, c1)] - 1;
                            SA[t] = s;
                        }
                    }
                } else {
                    SA[j] = ~s;
                }
                --j;
            }
            --c1;
        }
        i = 0;
        while (i < n) {
            s1 = s = SA[i];
            if (s >= 0) {
                if (--s < 0) {
                    s = n - 1;
                }
                if ((c0 = T[s] & 0xFF) >= (T[s + 1] & 0xFF)) {
                    if (s > 0 && (T[s - 1] & 0xFF) < c0) {
                        s ^= 0xFFFFFFFF;
                    }
                    if (c0 == c2) {
                        SA[++t] = s;
                    } else {
                        if (c2 != -1) {
                            bucketA[c2] = t;
                        }
                        c2 = c0;
                        t = bucketA[c2] + 1;
                        SA[t] = s;
                    }
                }
            } else {
                s1 ^= 0xFFFFFFFF;
            }
            if (s1 == 0) {
                SA[i] = T[n - 1];
                orig = i;
            } else {
                SA[i] = T[s1 - 1];
            }
            ++i;
        }
        return orig;
    }

    public int bwt() {
        int[] SA = this.SA;
        byte[] T = this.T;
        int n = this.n;
        int[] bucketA = new int[256];
        int[] bucketB = new int[65536];
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            SA[0] = T[0];
            return 0;
        }
        int m = this.sortTypeBstar(bucketA, bucketB);
        if (m > 0) {
            return this.constructBWT(bucketA, bucketB);
        }
        return 0;
    }

    public BZip2DivSufSort(byte[] T, int[] SA, int n) {
        this.T = T;
        this.SA = SA;
        this.n = n;
    }

    private final class PartitionResult {
        final int first;
        final int last;

        public PartitionResult(int first, int last) {
            this.first = first;
            this.last = last;
        }
    }

    private static class StackEntry {
        final int a;
        final int b;
        final int c;
        final int d;

        public StackEntry(int a, int b, int c, int d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }
    }

    private static class TRBudget {
        int budget;
        int chance;

        public boolean update(int size, int n) {
            this.budget -= n;
            if (this.budget <= 0) {
                if (--this.chance == 0) {
                    return false;
                }
                this.budget += size;
            }
            return true;
        }

        public TRBudget(int budget, int chance) {
            this.budget = budget;
            this.chance = chance;
        }
    }
}

