/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateND;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateSharer;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateVert;
import ucar.coord.Counter;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.collection.Grib2CollectionWriter;
import ucar.nc2.grib.collection.GribCollectionBuilder;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.Grib2Variable;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.CloseableIterator;

class Grib2CollectionBuilder
extends GribCollectionBuilder {
    private FeatureCollectionConfig.GribConfig gribConfig;
    private Grib2Customizer cust;

    public Grib2CollectionBuilder(String name, MCollection dcm, Logger logger) {
        super(false, name, dcm, logger);
        FeatureCollectionConfig config = (FeatureCollectionConfig)dcm.getAuxInfo("fcConfig");
        this.gribConfig = config.gribConfig;
    }

    public List<Grib2CollectionWriter.Group> makeGroups(List<MFile> allFiles, boolean singleRuntime, Formatter errlog) throws IOException {
        HashMap<GribCollectionBuilder.GroupAndRuntime, Grib2CollectionWriter.Group> gdsMap = new HashMap<GribCollectionBuilder.GroupAndRuntime, Grib2CollectionWriter.Group>();
        this.logger.debug("Grib2CollectionBuilder {}: makeGroups", (Object)this.name);
        int fileno = 0;
        Counter statsAll = new Counter();
        this.logger.debug(" dcm={}", (Object)this.dcm);
        int totalRecords = 0;
        try (CloseableIterator<MFile> iter = this.dcm.getFileIterator();){
            while (iter.hasNext()) {
                Grib2Index index;
                MFile mfile = (MFile)iter.next();
                try {
                    index = GribIosp.debugGbxIndexOnly ? (Grib2Index)GribIndex.open(false, mfile) : (Grib2Index)GribIndex.readOrCreateIndexFromSingleFile(false, mfile, CollectionUpdateType.test, this.logger);
                    allFiles.add(mfile);
                }
                catch (IOException ioe) {
                    this.logger.error("Grib2CollectionBuilder " + this.name + " : reading/Creating gbx9 index for file " + mfile.getPath() + " failed", ioe);
                    continue;
                }
                if (index == null) {
                    this.logger.error("Grib2CollectionBuilder " + this.name + " : reading/Creating gbx9 index for file " + mfile.getPath() + " failed");
                    continue;
                }
                int n = index.getNRecords();
                totalRecords += n;
                for (Grib2Record gr : index.getRecords()) {
                    if (this.cust == null) {
                        this.cust = Grib2Customizer.factory(gr);
                        this.cust.setTimeUnitConverter(this.gribConfig.getTimeUnitConverter());
                    }
                    if (this.filterIntervals(gr, this.gribConfig.intvFilter)) {
                        ++statsAll.filter;
                        continue;
                    }
                    gr.setFile(fileno);
                    Grib2Gds gdsHashObject = gr.getGDS();
                    int gdsHash = this.gribConfig.convertGdsHash(gdsHashObject.hashCode());
                    if (0 == gdsHash) continue;
                    CalendarDate runtimeDate = gr.getReferenceDate();
                    long runtime = singleRuntime ? runtimeDate.getMillis() : 0L;
                    GribCollectionBuilder.GroupAndRuntime gar = new GribCollectionBuilder.GroupAndRuntime(gdsHashObject, runtime);
                    Grib2CollectionWriter.Group g = (Grib2CollectionWriter.Group)gdsMap.get(gar);
                    if (g == null) {
                        g = new Grib2CollectionWriter.Group(gr.getGDSsection(), gdsHashObject, runtimeDate);
                        gdsMap.put(gar, g);
                    }
                    g.records.add(gr);
                    g.runtimes.add(runtimeDate.getMillis());
                }
                ++fileno;
                statsAll.recordsTotal += index.getRecords().size();
            }
        }
        if (totalRecords == 0) {
            this.logger.warn("No records found in files. Check Grib1/Grib2 for collection {}. If wrong, delete gbx9.", (Object)this.name);
            throw new IllegalStateException("No records found in dataset " + this.name);
        }
        ArrayList<Grib2CollectionWriter.Group> groups = new ArrayList<Grib2CollectionWriter.Group>(gdsMap.values());
        for (Grib2CollectionWriter.Group g : groups) {
            Counter stats = new Counter();
            Grib2Rectilyser rect = new Grib2Rectilyser(g.records, g.gdsHashObject);
            rect.make(this.gribConfig, stats, errlog);
            g.gribVars = rect.gribvars;
            g.coords = rect.coords;
            statsAll.add(stats);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(statsAll.show());
        }
        return groups;
    }

    private boolean filterIntervals(Grib2Record gr, FeatureCollectionConfig.GribIntvFilter intvFilter) {
        int timeUnit = gr.getPDS().getTimeUnit();
        if (Grib2Utils.getCalendarPeriod(timeUnit) == null) {
            this.logger.info("Skip record with unknown time Unit= {}", (Object)timeUnit);
            return true;
        }
        int[] intv = this.cust.getForecastTimeIntervalOffset(gr);
        if (intv == null) {
            return false;
        }
        int haveLength = intv[1] - intv[0];
        if (haveLength == 0 && (intvFilter == null || intvFilter.isZeroExcluded())) {
            return true;
        }
        if (intvFilter != null && intvFilter.hasFilter()) {
            int discipline = gr.getIs().getDiscipline();
            Grib2Pds pds = gr.getPDS();
            int category = pds.getParameterCategory();
            int number = pds.getParameterNumber();
            int id = (discipline << 16) + (category << 8) + number;
            int prob = Integer.MIN_VALUE;
            if (pds.isProbability()) {
                Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds);
                prob = (int)(1000.0 * pdsProb.getProbabilityUpperLimit());
            }
            return !intvFilter.filterOk(id, haveLength, prob);
        }
        return false;
    }

    @Override
    protected boolean writeIndex(String name, String indexFilepath, CoordinateRuntime masterRuntime, List<? extends GribCollectionBuilder.Group> groups, List<MFile> files) throws IOException {
        Grib2CollectionWriter writer = new Grib2CollectionWriter(this.dcm, this.logger);
        ArrayList<Grib2CollectionWriter.Group> groups2 = new ArrayList<Grib2CollectionWriter.Group>();
        for (GribCollectionBuilder.Group group : groups) {
            groups2.add((Grib2CollectionWriter.Group)group);
        }
        File indexFileInCache = GribIndexCache.getFileOrCache(indexFilepath);
        return writer.writeIndex(name, indexFileInCache, masterRuntime, groups2, files, this.type);
    }

    private class Grib2Rectilyser {
        private final int gdsHashOverride;
        private final List<Grib2Record> records;
        private List<VariableBag> gribvars;
        private List<Coordinate> coords;

        Grib2Rectilyser(List<Grib2Record> records, Object gdsHashObject) {
            this.records = records;
            int gdsHash = Grib2CollectionBuilder.this.gribConfig.convertGdsHash(gdsHashObject.hashCode());
            this.gdsHashOverride = gdsHash == gdsHashObject.hashCode() ? 0 : gdsHash;
        }

        public void make(FeatureCollectionConfig.GribConfig config, Counter counter, Formatter info) throws IOException {
            CalendarPeriod userTimeUnit = config.userTimeUnit;
            HashMap<Grib2Variable, VariableBag> vbHash = new HashMap<Grib2Variable, VariableBag>(100);
            for (Grib2Record gr : this.records) {
                Grib2Variable gv;
                try {
                    gv = new Grib2Variable(Grib2CollectionBuilder.this.cust, gr, this.gdsHashOverride, ((Grib2CollectionBuilder)Grib2CollectionBuilder.this).gribConfig.intvMerge, ((Grib2CollectionBuilder)Grib2CollectionBuilder.this).gribConfig.useGenType);
                }
                catch (Throwable t) {
                    Grib2CollectionBuilder.this.logger.warn("Exception on record ", t);
                    continue;
                }
                VariableBag bag = (VariableBag)vbHash.get(gv);
                if (bag == null) {
                    bag = new VariableBag(gr, gv);
                    vbHash.put(gv, bag);
                }
                bag.atomList.add(gr);
            }
            this.gribvars = new ArrayList(vbHash.values());
            Collections.sort(this.gribvars);
            for (VariableBag vb : this.gribvars) {
                VertCoord.VertUnit vertUnit;
                Grib2Pds pdsFirst = vb.first.getPDS();
                int code = Grib2CollectionBuilder.this.cust.convertTimeUnit(pdsFirst.getTimeUnit());
                vb.timeUnit = userTimeUnit == null ? Grib2Utils.getCalendarPeriod(code) : userTimeUnit;
                CoordinateND.Builder<Grib2Record> coordNBuilder = new CoordinateND.Builder<Grib2Record>();
                boolean isTimeInterval = vb.first.getPDS().isTimeInterval();
                CoordinateTime2D.Builder2 builder2D = new CoordinateTime2D.Builder2(isTimeInterval, Grib2CollectionBuilder.this.cust, vb.timeUnit, code);
                coordNBuilder.addBuilder(builder2D);
                if (vb.first.getPDS().isEnsemble()) {
                    coordNBuilder.addBuilder(new CoordinateEns.Builder2(0));
                }
                if ((vertUnit = Grib2CollectionBuilder.this.cust.getVertUnit(pdsFirst.getLevelType1())).isVerticalCoordinate()) {
                    coordNBuilder.addBuilder(new CoordinateVert.Builder2(pdsFirst.getLevelType1(), Grib2CollectionBuilder.this.cust.getVertUnit(pdsFirst.getLevelType1())));
                }
                for (Grib2Record gr : vb.atomList) {
                    coordNBuilder.addRecord(gr);
                }
                vb.coordND = coordNBuilder.finish(vb.atomList, info);
            }
            CoordinateSharer<Grib2Record> sharify = new CoordinateSharer<Grib2Record>(config.unionRuntimeCoord);
            for (VariableBag vb : this.gribvars) {
                sharify.addCoords(vb.coordND.getCoordinates());
            }
            sharify.finish();
            this.coords = sharify.getUnionCoords();
            int tot_used = 0;
            int tot_dups = 0;
            int total = 0;
            for (VariableBag vb : this.gribvars) {
                vb.coordND = sharify.reindexCoordND(vb.coordND);
                vb.coordIndex = sharify.reindex2shared(vb.coordND.getCoordinates());
                tot_used += vb.coordND.getSparseArray().countNotMissing();
                tot_dups += vb.coordND.getSparseArray().getNdups();
                total += vb.coordND.getSparseArray().getTotalSize();
            }
            counter.recordsUnique += tot_used;
            counter.dups += tot_dups;
            counter.vars += this.gribvars.size();
            counter.recordsTotal += total;
        }

        public void showInfo(Formatter f, Grib2Customizer tables) {
            Counter all = new Counter();
            for (VariableBag vb : this.gribvars) {
                f.format("Variable %s (%d)%n", tables.getVariableName(vb.first), vb.gv.hashCode());
                vb.coordND.showInfo(f, all);
                f.format("%n", new Object[0]);
            }
            f.format("%n all= %s", all.show());
        }
    }

    static class VariableBag
    implements Comparable<VariableBag> {
        public Grib2Record first;
        public Grib2Variable gv;
        public List<Grib2Record> atomList = new ArrayList<Grib2Record>(100);
        public CoordinateND<Grib2Record> coordND;
        CalendarPeriod timeUnit;
        public List<Integer> coordIndex;
        long pos;
        int length;

        private VariableBag(Grib2Record first, Grib2Variable gv) {
            this.first = first;
            this.gv = gv;
        }

        @Override
        public int compareTo(VariableBag o) {
            return Grib2Utils.getVariableName(this.first).compareTo(Grib2Utils.getVariableName(o.first));
        }
    }
}

