/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.MFile;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.CoordinateTimeIntv;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.GcMFile;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribHorizCoordSystem;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.Grib1Variable;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.Grib2Variable;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarTimeZone;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;
import ucar.unidata.util.StringUtil2;

public class GribCollectionMutable
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GribCollectionMutable.class);
    public static final long MISSING_RECORD = -1L;
    private static CalendarDateFormatter cf = new CalendarDateFormatter("yyyyMMdd-HHmmss", new CalendarTimeZone("UTC"));
    protected String name;
    protected FeatureCollectionConfig config;
    protected boolean isGrib1;
    protected File directory;
    protected String orgDirectory;
    public int version;
    public int center;
    public int subcenter;
    public int master;
    public int local;
    public int genProcessType;
    public int genProcessId;
    public int backProcessId;
    public List<Parameter> params;
    protected Map<Integer, MFile> fileMap;
    protected List<Dataset> datasets;
    protected List<GribHorizCoordSystem> horizCS;
    protected CoordinateRuntime masterRuntime;
    protected GribTables cust;
    protected int indexVersion;
    protected RandomAccessFile indexRaf;
    protected String indexFilename;
    protected long lastModified;
    protected long fileSize;
    public static int countGC;
    private Set<String> hcsNames = new HashSet<String>(5);

    static MFile makeIndexMFile(String collectionName, File directory) {
        String nameNoBlanks = StringUtil2.replace(collectionName, ' ', "_");
        return new GcMFile(directory, nameNoBlanks + ".ncx3", -1L, -1L, -1);
    }

    public static String makeName(String collectionName, CalendarDate runtime) {
        String nameNoBlanks = StringUtil2.replace(collectionName, ' ', "_");
        return nameNoBlanks + "-" + cf.toString(runtime);
    }

    protected GribCollectionMutable(String name, File directory, FeatureCollectionConfig config, boolean isGrib1) {
        ++countGC;
        this.name = name;
        this.directory = directory;
        this.config = config;
        this.isGrib1 = isGrib1;
        if (config == null) {
            logger.error("HEY GribCollection {} has empty config%n", (Object)name);
        }
        if (name == null) {
            logger.error("HEY GribCollection has null name dir={}%n", (Object)directory);
        }
    }

    protected void copyInfo(GribCollectionMutable from) {
        this.center = from.center;
        this.subcenter = from.subcenter;
        this.master = from.master;
        this.local = from.local;
        this.genProcessType = from.genProcessType;
        this.genProcessId = from.genProcessId;
        this.backProcessId = from.backProcessId;
    }

    public String getName() {
        return this.name;
    }

    public File getDirectory() {
        return this.directory;
    }

    public String getLocation() {
        if (this.indexRaf != null) {
            return this.indexRaf.getLocation();
        }
        return this.getIndexFilepathInCache();
    }

    public Collection<MFile> getFiles() {
        return this.fileMap.values();
    }

    public FeatureCollectionConfig getConfig() {
        return this.config;
    }

    public List<String> getFilenames() {
        ArrayList<String> result = new ArrayList<String>();
        for (MFile file : this.fileMap.values()) {
            result.add(file.getPath());
        }
        Collections.sort(result);
        return result;
    }

    public File getIndexParentFile() {
        if (this.indexRaf == null) {
            return null;
        }
        Path index = Paths.get(this.indexRaf.getLocation(), new String[0]);
        Path parent = index.getParent();
        return parent.toFile();
    }

    public String getFilename(int fileno) {
        return this.fileMap.get(fileno).getPath();
    }

    public List<Dataset> getDatasets() {
        return this.datasets;
    }

    public Dataset makeDataset(GribCollectionImmutable.Type type) {
        Dataset result = new Dataset(type);
        this.datasets.add(result);
        return result;
    }

    public Dataset getDatasetCanonical() {
        for (Dataset ds : this.datasets) {
            if (ds.gctype == GribCollectionImmutable.Type.Best) continue;
            return ds;
        }
        throw new IllegalStateException("GC.getDatasetCanonical failed on=" + this.name);
    }

    public GribHorizCoordSystem getHorizCS(int index) {
        return this.horizCS.get(index);
    }

    protected void makeHorizCS() {
        HashMap<Object, GribHorizCoordSystem> gdsMap = new HashMap<Object, GribHorizCoordSystem>();
        for (Dataset ds : this.datasets) {
            for (GroupGC hcs : ds.groups) {
                gdsMap.put(hcs.getGdsHash(), hcs.horizCoordSys);
            }
        }
        this.horizCS = new ArrayList<GribHorizCoordSystem>();
        for (GribHorizCoordSystem hcs : gdsMap.values()) {
            this.horizCS.add(hcs);
        }
    }

    public int findHorizCS(GribHorizCoordSystem hcs) {
        return this.horizCS.indexOf(hcs);
    }

    public void addHorizCoordSystem(GdsHorizCoordSys hcs, byte[] rawGds, Object gdsHashObject, int predefinedGridDefinition) {
        String hcsName = this.makeHorizCoordSysName(hcs);
        String desc = null;
        if (this.config.gribConfig.gdsNamer != null) {
            desc = this.config.gribConfig.gdsNamer.get(gdsHashObject.hashCode());
        }
        if (desc == null) {
            desc = hcs.makeDescription();
        }
        this.horizCS.add(new GribHorizCoordSystem(hcs, rawGds, gdsHashObject, hcsName, desc, predefinedGridDefinition));
    }

    public void setFileMap(Map<Integer, MFile> fileMap) {
        this.fileMap = fileMap;
    }

    void setIndexRaf(RandomAccessFile indexRaf) {
        this.indexRaf = indexRaf;
        if (indexRaf != null) {
            this.indexFilename = indexRaf.getLocation();
        }
    }

    private String getIndexFilepathInCache() {
        File indexFile = GribCdmIndex.makeIndexFile(this.name, this.directory);
        return GribIndexCache.getFileOrCache(indexFile.getPath()).getPath();
    }

    public File setOrgDirectory(String orgDirectory) {
        File indexFile;
        File parent;
        this.orgDirectory = orgDirectory;
        this.directory = new File(orgDirectory);
        if (!this.directory.exists() && (parent = (indexFile = new File(this.indexFilename)).getParentFile()).exists()) {
            this.directory = parent;
        }
        return this.directory;
    }

    @Override
    public void close() throws IOException {
        if (this.indexRaf != null) {
            this.indexRaf.close();
            this.indexRaf = null;
        }
    }

    private String makeHorizCoordSysName(GdsHorizCoordSys hcs) {
        String base;
        String tryit = base = hcs.makeId();
        int count = 1;
        while (this.hcsNames.contains(tryit)) {
            tryit = base + "-" + ++count;
        }
        this.hcsNames.add(tryit);
        return tryit;
    }

    public VariableIndex makeVariableIndex(GroupGC g, GribTables customizer, int discipline, int center, int subcenter, byte[] rawPds, List<Integer> index, long recordsPos, int recordsLen) {
        return new VariableIndex(g, customizer, discipline, center, subcenter, rawPds, index, recordsPos, recordsLen);
    }

    public void showIndex(Formatter f) {
        f.format("Class (%s)%n", this.getClass().getName());
        f.format("%s%n%n", this.toString());
        for (Dataset ds : this.datasets) {
            f.format("Dataset %s%n", new Object[]{ds.gctype});
            for (GroupGC g : ds.groups) {
                f.format(" Group %s%n", g.horizCoordSys.getId());
                for (VariableIndex v : g.variList) {
                    f.format("  %s%n", v.toStringShort());
                }
            }
        }
        if (this.fileMap == null) {
            f.format("Files empty%n", new Object[0]);
        } else {
            f.format("Files (%d)%n", this.fileMap.size());
            Iterator<Object> i$ = this.fileMap.keySet().iterator();
            while (i$.hasNext()) {
                int index = (Integer)i$.next();
                f.format("  %d: %s%n", index, this.fileMap.get(index));
            }
            f.format("%n", new Object[0]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GribCollectionMutable{");
        sb.append("\nname='").append(this.name).append('\'');
        sb.append("\n directory=").append(this.directory);
        sb.append("\n config=").append(this.config);
        sb.append("\n isGrib1=").append(this.isGrib1);
        sb.append("\n version=").append(this.version);
        sb.append("\n center=").append(this.center);
        sb.append("\n subcenter=").append(this.subcenter);
        sb.append("\n master=").append(this.master);
        sb.append("\n local=").append(this.local);
        sb.append("\n genProcessType=").append(this.genProcessType);
        sb.append("\n genProcessId=").append(this.genProcessId);
        sb.append("\n backProcessId=").append(this.backProcessId);
        sb.append("\n}");
        return sb.toString();
    }

    public GroupGC makeGroup() {
        return new GroupGC();
    }

    @Immutable
    public static class Record {
        public final int fileno;
        public final long pos;
        public final long bmsPos;
        public final int scanMode;

        public Record(int fileno, long pos, long bmsPos, int scanMode) {
            this.fileno = fileno;
            this.pos = pos;
            this.bmsPos = bmsPos;
            this.scanMode = scanMode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("GribCollection.Record{");
            sb.append("fileno=").append(this.fileno);
            sb.append(", pos=").append(this.pos);
            sb.append(", bmsPos=").append(this.bmsPos);
            sb.append(", scanMode=").append(this.scanMode);
            sb.append('}');
            return sb.toString();
        }
    }

    public class VariableIndex
    implements Comparable<VariableIndex> {
        public final GroupGC group;
        public final int tableVersion;
        public final int discipline;
        public final int center;
        public final int subcenter;
        public final byte[] rawPds;
        public final long recordsPos;
        public final int recordsLen;
        public Object gribVariable;
        List<Integer> coordIndex;
        public final int category;
        public final int parameter;
        public final int levelType;
        public final int intvType;
        public final int ensDerivedType;
        public final int probType;
        private String intvName;
        public final String probabilityName;
        public final boolean isLayer;
        public final boolean isEnsemble;
        public final int genProcessType;
        public int ndups;
        public int nrecords;
        public int nmissing;
        List<Coordinate> coords;

        private VariableIndex(GroupGC g, GribTables customizer, int discipline, int center, int subcenter, byte[] rawPds, List<Integer> index, long recordsPos, int recordsLen) {
            this.group = g;
            this.discipline = discipline;
            this.rawPds = rawPds;
            this.center = center;
            this.subcenter = subcenter;
            this.coordIndex = index;
            this.recordsPos = recordsPos;
            this.recordsLen = recordsLen;
            if (GribCollectionMutable.this.isGrib1) {
                Grib1Customizer cust = (Grib1Customizer)customizer;
                Grib1SectionProductDefinition pds = new Grib1SectionProductDefinition(rawPds);
                this.category = 0;
                this.tableVersion = pds.getTableVersion();
                this.parameter = pds.getParameterNumber();
                this.levelType = pds.getLevelType();
                Grib1ParamTime ptime = cust.getParamTime(pds);
                this.intvType = ptime.isInterval() ? pds.getTimeRangeIndicator() : -1;
                this.isLayer = cust.isLayer(pds.getLevelType());
                this.ensDerivedType = -1;
                this.probType = -1;
                this.probabilityName = null;
                this.genProcessType = pds.getGenProcess();
                this.isEnsemble = pds.isEnsemble();
                this.gribVariable = new Grib1Variable(cust, pds, (Grib1Gds)g.getGdsHash(), GribCollectionMutable.this.config.gribConfig.useTableVersion, GribCollectionMutable.this.config.gribConfig.intvMerge, GribCollectionMutable.this.config.gribConfig.useCenter);
            } else {
                Grib2Customizer cust2 = (Grib2Customizer)customizer;
                Grib2SectionProductDefinition pdss = new Grib2SectionProductDefinition(rawPds);
                Grib2Pds pds = pdss.getPDS();
                assert (pds != null);
                this.tableVersion = -1;
                this.category = pds.getParameterCategory();
                this.parameter = pds.getParameterNumber();
                this.levelType = pds.getLevelType1();
                this.intvType = pds.getStatisticalProcessType();
                this.isLayer = Grib2Utils.isLayer(pds);
                if (pds.isEnsembleDerived()) {
                    Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)pds);
                    this.ensDerivedType = pdsDerived.getDerivedForecastType();
                } else {
                    this.ensDerivedType = -1;
                }
                if (pds.isProbability()) {
                    Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds);
                    this.probabilityName = pdsProb.getProbabilityName();
                    this.probType = pdsProb.getProbabilityType();
                } else {
                    this.probType = -1;
                    this.probabilityName = null;
                }
                this.genProcessType = pds.getGenProcessType();
                this.isEnsemble = pds.isEnsemble();
                this.gribVariable = new Grib2Variable(cust2, discipline, center, subcenter, (Grib2Gds)g.getGdsHash(), pds, GribCollectionMutable.this.config.gribConfig.intvMerge, GribCollectionMutable.this.config.gribConfig.useGenType);
            }
        }

        protected VariableIndex(GroupGC g, VariableIndex other) {
            this.group = g;
            this.tableVersion = other.tableVersion;
            this.discipline = other.discipline;
            this.center = other.center;
            this.subcenter = other.subcenter;
            this.rawPds = other.rawPds;
            this.gribVariable = other.gribVariable;
            this.coordIndex = new ArrayList<Integer>(other.coordIndex);
            this.recordsPos = 0L;
            this.recordsLen = 0;
            this.category = other.category;
            this.parameter = other.parameter;
            this.levelType = other.levelType;
            this.intvType = other.intvType;
            this.isLayer = other.isLayer;
            this.ensDerivedType = other.ensDerivedType;
            this.probabilityName = other.probabilityName;
            this.probType = other.probType;
            this.genProcessType = other.genProcessType;
            this.isEnsemble = other.isEnsemble;
        }

        public List<Coordinate> getCoordinates() {
            ArrayList<Coordinate> result = new ArrayList<Coordinate>(this.coordIndex.size());
            for (int idx : this.coordIndex) {
                result.add(this.group.coords.get(idx));
            }
            return result;
        }

        public Coordinate getCoordinate(Coordinate.Type want) {
            for (int idx : this.coordIndex) {
                if (this.group.coords.get(idx).getType() != want) continue;
                return this.group.coords.get(idx);
            }
            return null;
        }

        public int getCoordinateIdx(Coordinate.Type want) {
            for (int idx : this.coordIndex) {
                if (this.group.coords.get(idx).getType() != want) continue;
                return idx;
            }
            return -1;
        }

        public String getTimeIntvName() {
            if (this.intvName != null) {
                return this.intvName;
            }
            CoordinateTimeIntv timeiCoord = (CoordinateTimeIntv)this.getCoordinate(Coordinate.Type.timeIntv);
            if (timeiCoord != null) {
                this.intvName = timeiCoord.getTimeIntervalName();
                return this.intvName;
            }
            CoordinateTime2D time2DCoord = (CoordinateTime2D)this.getCoordinate(Coordinate.Type.time2D);
            if (time2DCoord == null || !time2DCoord.isTimeInterval()) {
                return null;
            }
            this.intvName = time2DCoord.getTimeIntervalName();
            return this.intvName;
        }

        public String id() {
            return this.discipline + "-" + this.category + "-" + this.parameter;
        }

        public int getVarid() {
            return (this.discipline << 16) + (this.category << 8) + this.parameter;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("VariableIndex");
            sb.append("{tableVersion=").append(this.tableVersion);
            sb.append(", discipline=").append(this.discipline);
            sb.append(", category=").append(this.category);
            sb.append(", parameter=").append(this.parameter);
            sb.append(", levelType=").append(this.levelType);
            sb.append(", intvType=").append(this.intvType);
            sb.append(", ensDerivedType=").append(this.ensDerivedType);
            sb.append(", probType=").append(this.probType);
            sb.append(", intvName='").append(this.intvName).append('\'');
            sb.append(", probabilityName='").append(this.probabilityName).append('\'');
            sb.append(", isLayer=").append(this.isLayer);
            sb.append(", genProcessType=").append(this.genProcessType);
            sb.append(", cdmHash=").append(this.gribVariable.hashCode());
            sb.append('}');
            return sb.toString();
        }

        public String toStringComplete() {
            StringBuilder sb = new StringBuilder();
            sb.append("VariableIndex");
            sb.append("{tableVersion=").append(this.tableVersion);
            sb.append(", discipline=").append(this.discipline);
            sb.append(", category=").append(this.category);
            sb.append(", parameter=").append(this.parameter);
            sb.append(", levelType=").append(this.levelType);
            sb.append(", intvType=").append(this.intvType);
            sb.append(", ensDerivedType=").append(this.ensDerivedType);
            sb.append(", probType=").append(this.probType);
            sb.append(", intvName='").append(this.intvName).append('\'');
            sb.append(", probabilityName='").append(this.probabilityName).append('\'');
            sb.append(", isLayer=").append(this.isLayer);
            sb.append(", cdmHash=").append(this.gribVariable.hashCode());
            sb.append(", recordsPos=").append(this.recordsPos);
            sb.append(", recordsLen=").append(this.recordsLen);
            sb.append(", group=").append(this.group.getId());
            sb.append("}\n");
            return sb.toString();
        }

        public String toStringShort() {
            Formatter sb = new Formatter();
            sb.format("Variable {%d-%d-%d", this.discipline, this.category, this.parameter);
            sb.format(", levelType=%d", this.levelType);
            sb.format(", intvType=%d", this.intvType);
            if (this.intvName != null && this.intvName.length() > 0) {
                sb.format(" intv=%s", this.intvName);
            }
            if (this.probabilityName != null && this.probabilityName.length() > 0) {
                sb.format(" prob=%s", this.probabilityName);
            }
            sb.format(" cdmHash=%d}", this.gribVariable.hashCode());
            return sb.toString();
        }

        @Override
        public int compareTo(VariableIndex o) {
            int r = this.discipline - o.discipline;
            if (r != 0) {
                return r;
            }
            r = this.category - o.category;
            if (r != 0) {
                return r;
            }
            r = this.parameter - o.parameter;
            if (r != 0) {
                return r;
            }
            r = this.levelType - o.levelType;
            if (r != 0) {
                return r;
            }
            r = this.intvType - o.intvType;
            return r;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof VariableIndex)) {
                return false;
            }
            VariableIndex that = (VariableIndex)o;
            return this.gribVariable.equals(that.gribVariable);
        }

        public int hashCode() {
            return this.gribVariable.hashCode();
        }
    }

    public class GroupGC
    implements Comparable<GroupGC> {
        GribHorizCoordSystem horizCoordSys;
        List<VariableIndex> variList;
        List<Coordinate> coords;
        int[] filenose;
        HashMap<VariableIndex, VariableIndex> varMap;
        boolean isTwoD = true;
        private CalendarDateRange dateRange = null;

        GroupGC() {
            this.variList = new ArrayList<VariableIndex>();
            this.coords = new ArrayList<Coordinate>();
        }

        GroupGC(GroupGC from) {
            this.horizCoordSys = from.horizCoordSys;
            this.variList = new ArrayList<VariableIndex>(from.variList.size());
            this.coords = new ArrayList<Coordinate>(from.coords.size());
            this.isTwoD = from.isTwoD;
        }

        public VariableIndex addVariable(VariableIndex vi) {
            this.variList.add(vi);
            return vi;
        }

        public GribCollectionMutable getGribCollection() {
            return GribCollectionMutable.this;
        }

        public Iterable<VariableIndex> getVariables() {
            return this.variList;
        }

        public Iterable<Coordinate> getCoordinates() {
            return this.coords;
        }

        public String getId() {
            return this.horizCoordSys.getId();
        }

        public String getDescription() {
            return this.horizCoordSys.getDescription();
        }

        public byte[] getGdsBytes() {
            return this.horizCoordSys.getRawGds();
        }

        public Object getGdsHash() {
            return this.horizCoordSys.getGdsHash();
        }

        @Override
        public int compareTo(GroupGC o) {
            return this.getDescription().compareTo(o.getDescription());
        }

        public List<MFile> getFiles() {
            ArrayList<MFile> result = new ArrayList<MFile>();
            if (this.filenose == null) {
                return result;
            }
            for (int fileno : this.filenose) {
                result.add(GribCollectionMutable.this.fileMap.get(fileno));
            }
            Collections.sort(result);
            return result;
        }

        public List<String> getFilenames() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.filenose == null) {
                return result;
            }
            for (int fileno : this.filenose) {
                result.add(GribCollectionMutable.this.fileMap.get(fileno).getPath());
            }
            Collections.sort(result);
            return result;
        }

        public VariableIndex findVariableByHash(VariableIndex want) {
            if (this.varMap == null) {
                this.varMap = new HashMap(this.variList.size() * 2);
                for (VariableIndex vi : this.variList) {
                    this.varMap.put(vi, vi);
                }
            }
            VariableIndex result = this.varMap.get(want);
            return result;
        }

        public CalendarDateRange getCalendarDateRange() {
            if (this.dateRange == null) {
                CalendarDateRange result = null;
                for (Coordinate coord : this.coords) {
                    switch (coord.getType()) {
                        case time: 
                        case timeIntv: 
                        case time2D: {
                            CoordinateTimeAbstract time = (CoordinateTimeAbstract)coord;
                            CalendarDateRange range = time.makeCalendarDateRange(null);
                            result = result == null ? range : result.extend(range);
                        }
                    }
                }
                this.dateRange = result;
            }
            return this.dateRange;
        }

        public int getNFiles() {
            if (this.filenose == null) {
                return 0;
            }
            return this.filenose.length;
        }

        public void show(Formatter f) {
            f.format("Group %s (%d) isTwoD=%s%n", this.horizCoordSys.getId(), this.horizCoordSys.getGdsHash().hashCode(), this.isTwoD);
            f.format(" nfiles %d%n", this.filenose == null ? 0 : this.filenose.length);
            f.format(" hcs = %s%n", this.horizCoordSys.getHcs());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("GroupGC{");
            sb.append(GribCollectionMutable.this.getName());
            sb.append(" isTwoD=").append(this.isTwoD);
            sb.append('}');
            return sb.toString();
        }
    }

    public class Dataset {
        public GribCollectionImmutable.Type gctype;
        List<GroupGC> groups;

        public Dataset(GribCollectionImmutable.Type type) {
            this.gctype = type;
            this.groups = new ArrayList<GroupGC>();
        }

        Dataset(Dataset from) {
            this.gctype = from.gctype;
            this.groups = new ArrayList<GroupGC>(from.groups.size());
        }

        public GroupGC addGroupCopy(GroupGC from) {
            GroupGC g = new GroupGC(from);
            this.groups.add(g);
            return g;
        }

        public List<GroupGC> getGroups() {
            return this.groups;
        }
    }
}

