/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import thredds.inventory.MFile;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.units.DateFromString;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileFactory;

public abstract class AggregationOuterDimension
extends Aggregation
implements ProxyReader {
    protected static boolean debugCache = false;
    protected static boolean debugInvocation = false;
    protected static boolean debugStride = false;
    public static int invocation = 0;
    protected List<String> aggVarNames = new ArrayList<String>();
    protected List<VariableDS> aggVars = new ArrayList<VariableDS>();
    private int totalCoords = 0;
    protected List<CacheVar> cacheList = new ArrayList<CacheVar>();
    protected boolean timeUnitsChange = false;

    protected AggregationOuterDimension(NetcdfDataset ncd, String dimName, Aggregation.Type type, String recheckS) {
        super(ncd, dimName, type, recheckS);
    }

    void setTimeUnitsChange(boolean timeUnitsChange) {
        this.timeUnitsChange = timeUnitsChange;
        if (timeUnitsChange) {
            this.isDate = true;
        }
    }

    public void addVariable(String varName) {
        this.aggVarNames.add(varName);
    }

    void addVariableFromGlobalAttribute(String varName, String orgName) {
        this.cacheList.add(new PromoteVar(varName, orgName));
    }

    void addVariableFromGlobalAttributeCompose(String varName, String format, String gattNames) {
        this.cacheList.add(new PromoteVarCompose(varName, format, gattNames));
    }

    void addCacheVariable(String varName, DataType dtype) {
        if (this.findCacheVariable(varName) != null) {
            return;
        }
        this.cacheList.add(new CacheVar(varName, dtype));
    }

    CacheVar findCacheVariable(String varName) {
        for (CacheVar cv : this.cacheList) {
            if (!cv.varName.equals(varName)) continue;
            return cv;
        }
        return null;
    }

    List<String> getAggVariableNames() {
        return this.aggVarNames;
    }

    protected void buildCoords(CancelTask cancelTask) throws IOException {
        DatasetOuterDimension dod;
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        if (this.type == Aggregation.Type.forecastModelRunCollection) {
            for (Aggregation.Dataset nested : nestedDatasets) {
                dod = (DatasetOuterDimension)nested;
                dod.ncoord = 1;
            }
        }
        this.totalCoords = 0;
        for (Aggregation.Dataset nested : nestedDatasets) {
            dod = (DatasetOuterDimension)nested;
            this.totalCoords += dod.setStartEnd(this.totalCoords, cancelTask);
        }
    }

    protected int getTotalCoords() {
        return this.totalCoords;
    }

    protected void promoteGlobalAttributes(DatasetOuterDimension typicalDataset) throws IOException {
        for (CacheVar cv : this.cacheList) {
            if (!(cv instanceof PromoteVar)) continue;
            PromoteVar pv = (PromoteVar)cv;
            Array data = pv.read(typicalDataset);
            if (data == null) {
                throw new IOException("cant read " + typicalDataset);
            }
            pv.dtype = DataType.getType(data.getElementType());
            VariableDS promotedVar = new VariableDS(this.ncDataset, null, null, pv.varName, pv.dtype, this.dimName, null, null);
            this.ncDataset.addVariable(null, promotedVar);
            promotedVar.setProxyReader(this);
            promotedVar.setSPobject(pv);
        }
    }

    @Override
    protected void rebuildDataset() throws IOException {
        this.buildCoords(null);
        Dimension aggDim = this.ncDataset.findDimension(this.dimName);
        aggDim.setLength(this.getTotalCoords());
        VariableDS joinAggCoord = (VariableDS)this.ncDataset.getRootGroup().findVariable(this.dimName);
        joinAggCoord.setDimensions(this.dimName);
        joinAggCoord.invalidateCache();
        for (Variable variable : this.aggVars) {
            variable.resetDimensions();
            variable.invalidateCache();
        }
        Aggregation.Dataset typicalDataset = this.getTypicalDataset();
        for (Variable var : this.ncDataset.getRootGroup().getVariables()) {
            VariableDS varDS = (VariableDS)var;
            if (this.aggVars.contains(varDS) || this.dimName.equals(var.getShortName())) continue;
            Aggregation.DatasetProxyReader proxy = new Aggregation.DatasetProxyReader(typicalDataset);
            var.setProxyReader(proxy);
        }
        for (CacheVar cv : this.cacheList) {
            cv.reset();
        }
    }

    @Override
    public Array reallyRead(Variable mainv, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        long size;
        DataType dtype;
        if (debugConvert && mainv instanceof VariableDS && (dtype = ((VariableDS)mainv).getOriginalDataType()) != null && dtype != mainv.getDataType()) {
            System.out.printf("Original type = %s mainv type= %s%n", new Object[]{dtype, mainv.getDataType()});
        }
        if ((size = section.computeSize()) == mainv.getSize()) {
            return this.reallyRead(mainv, cancelTask);
        }
        DataType dtype2 = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
        Object spObj = mainv.getSPobject();
        if (spObj != null && spObj instanceof CacheVar) {
            CacheVar pv = (CacheVar)spObj;
            Array cacheArray = pv.read(section, cancelTask);
            return MAMath.convert(cacheArray, dtype2);
        }
        Array sectionData = Array.factory(dtype2, section.getShape());
        int destPos = 0;
        List<Range> ranges = section.getRanges();
        Range joinRange = section.getRange(0);
        ArrayList<Range> nestedSection = new ArrayList<Range>(ranges);
        List<Range> innerSection = ranges.subList(1, ranges.size());
        if (debug) {
            System.out.println("   agg wants range=" + mainv.getFullName() + "(" + joinRange + ")");
        }
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        for (Aggregation.Dataset nested : nestedDatasets) {
            Array varData;
            DatasetOuterDimension dod = (DatasetOuterDimension)nested;
            Range nestedJoinRange = dod.getNestedJoinRange(joinRange);
            if (nestedJoinRange == null) continue;
            if (this.type == Aggregation.Type.joinNew || this.type == Aggregation.Type.forecastModelRunCollection) {
                varData = dod.read(mainv, cancelTask, innerSection);
            } else {
                nestedSection.set(0, nestedJoinRange);
                varData = dod.read(mainv, cancelTask, nestedSection);
            }
            if (cancelTask != null && cancelTask.isCancel()) {
                return null;
            }
            varData = MAMath.convert(varData, dtype2);
            Array.arraycopy(varData, 0, sectionData, destPos, (int)varData.getSize());
            destPos = (int)((long)destPos + varData.getSize());
        }
        return sectionData;
    }

    @Override
    public Array reallyRead(Variable mainv, CancelTask cancelTask) throws IOException {
        DataType dtype;
        if (debugConvert && mainv instanceof VariableDS && (dtype = ((VariableDS)mainv).getOriginalDataType()) != null && dtype != mainv.getDataType()) {
            System.out.printf("Original type = %s mainv type= %s%n", new Object[]{dtype, mainv.getDataType()});
        }
        dtype = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
        Object spObj = mainv.getSPobject();
        if (spObj != null && spObj instanceof CacheVar) {
            CacheVar pv = (CacheVar)spObj;
            try {
                Array cacheArray = pv.read(mainv.getShapeAsSection(), cancelTask);
                return MAMath.convert(cacheArray, dtype);
            }
            catch (InvalidRangeException e) {
                logger.error("readAgg " + this.getLocation(), e);
                throw new IllegalArgumentException("readAgg " + this.getLocation(), e);
            }
        }
        Array allData = Array.factory(dtype, mainv.getShape());
        int destPos = 0;
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        if (executor != null) {
            ExecutorCompletionService<Result> completionService = new ExecutorCompletionService<Result>(executor);
            int count = 0;
            for (Aggregation.Dataset vnested : nestedDatasets) {
                completionService.submit(new ReaderTask(vnested, mainv, cancelTask, count++));
            }
            try {
                int n = nestedDatasets.size();
                for (int i = 0; i < n; ++i) {
                    Result r = (Result)completionService.take().get();
                    if (r == null) continue;
                    r.data = MAMath.convert(r.data, dtype);
                    int size = (int)r.data.getSize();
                    Array.arraycopy(r.data, 0, allData, size * r.index, size);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new IOException(e.getMessage());
            }
        } else {
            for (Aggregation.Dataset vnested : nestedDatasets) {
                Array varData = vnested.read(mainv, cancelTask);
                if (cancelTask != null && cancelTask.isCancel()) {
                    return null;
                }
                varData = MAMath.convert(varData, dtype);
                Array.arraycopy(varData, 0, allData, destPos, (int)varData.getSize());
                destPos = (int)((long)destPos + varData.getSize());
            }
        }
        return allData;
    }

    @Override
    protected Aggregation.Dataset makeDataset(String cacheName, String location, String id, String ncoordS, String coordValueS, String sectionSpec, EnumSet<NetcdfDataset.Enhance> enhance, FileFactory reader) {
        return new DatasetOuterDimension(cacheName, location, id, ncoordS, coordValueS, enhance, reader);
    }

    @Override
    protected Aggregation.Dataset makeDataset(MFile dset) {
        return new DatasetOuterDimension(dset);
    }

    @Override
    public void getDetailInfo(Formatter f) {
        super.getDetailInfo(f);
        f.format("  timeUnitsChange=%s%n", this.timeUnitsChange);
        f.format("  totalCoords=%d%n", this.totalCoords);
        if (this.aggVarNames.size() > 0) {
            f.format("  Aggregation Variables specified in NcML%n", new Object[0]);
            for (String vname : this.aggVarNames) {
                f.format("   %s%n", vname);
            }
        }
        f.format("%nAggregation Variables%n", new Object[0]);
        for (VariableDS vds : this.aggVars) {
            f.format("   ", new Object[0]);
            vds.getNameAndDimensions(f, true, false);
            f.format("%n", new Object[0]);
        }
        if (this.cacheList.size() > 0) {
            f.format("%nCache Variables%n", new Object[0]);
            for (CacheVar cv : this.cacheList) {
                f.format("   %s%n", cv);
            }
        }
        f.format("%nVariable Proxies%n", new Object[0]);
        for (Variable v : this.ncDataset.getVariables()) {
            if (v.hasCachedData()) {
                f.format("   %20s cached%n", v.getShortName());
                continue;
            }
            f.format("   %20s proxy %s%n", v.getShortName(), v.getProxyReader().getClass().getName());
        }
    }

    public static void main(String[] args) throws IOException {
        String format = "%04d-%02d-%02dT%02d:%02d:%02.0f";
        Formatter f = new Formatter();
        Object[] vals = new Object[]{new Integer(2002), new Integer(10), new Integer(20), new Integer(23), new Integer(0), new Float(2.1)};
        f.format(format, vals);
        System.out.println(f);
    }

    class PromoteVarCompose
    extends PromoteVar {
        String format;
        String[] gattNames;

        PromoteVarCompose(String varName, String format, String gattNames) {
            super(varName, DataType.STRING);
            this.format = format;
            this.gattNames = gattNames.split(" ");
            if (format == null) {
                throw new IllegalArgumentException("Missing format string (java.util.Formatter)");
            }
        }

        @Override
        protected Array read(DatasetOuterDimension dset, NetcdfFile ncfile) throws IOException {
            Array data = this.getData(dset.getId());
            if (data != null) {
                return data;
            }
            ArrayList<Object> vals = new ArrayList<Object>();
            for (String gattName : this.gattNames) {
                Attribute att = ncfile.findGlobalAttribute(gattName);
                if (att == null) {
                    throw new IllegalArgumentException("Unknown attribute name= " + gattName);
                }
                vals.add(att.getValue(0));
            }
            Formatter f = new Formatter();
            f.format(this.format, vals.toArray());
            String result = f.toString();
            Array allData = Array.factory(this.dtype, new int[]{dset.ncoord});
            for (int i = 0; i < dset.ncoord; ++i) {
                allData.setObject(i, (Object)result);
            }
            this.putData(dset.getId(), allData);
            return allData;
        }
    }

    class PromoteVar
    extends CacheVar {
        String gattName;

        protected PromoteVar(String varName, DataType dtype) {
            super(varName, dtype);
        }

        PromoteVar(String varName, String gattName) {
            super(varName, null);
            this.gattName = gattName != null ? gattName : varName;
        }

        @Override
        protected Array read(DatasetOuterDimension dset, NetcdfFile ncfile) throws IOException {
            Array data = this.getData(dset.getId());
            if (data != null) {
                return data;
            }
            Attribute att = ncfile.findGlobalAttribute(this.gattName);
            if (att == null) {
                throw new IllegalArgumentException("Unknown attribute name= " + this.gattName);
            }
            data = att.getValues();
            if (this.dtype == null) {
                this.dtype = DataType.getType(data.getElementType());
            }
            if (dset.ncoord == 1) {
                this.putData(dset.getId(), data);
            } else {
                Array allData = Array.factory(this.dtype, new int[]{dset.ncoord});
                for (int i = 0; i < dset.ncoord; ++i) {
                    Array.arraycopy(data, 0, allData, i, 1);
                }
                this.putData(dset.getId(), allData);
                data = allData;
            }
            return data;
        }
    }

    class CoordValueVar
    extends CacheVar {
        String units;
        DateUnit du;

        CoordValueVar(String varName, DataType dtype, String units) {
            super(varName, dtype);
            this.units = units;
            try {
                this.du = new DateUnit(units);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        @Override
        protected Array read(DatasetOuterDimension dset) throws IOException {
            Array data = this.readCached(dset);
            if (data != null) {
                return data;
            }
            return super.read(dset);
        }

        @Override
        protected Array read(DatasetOuterDimension dset, NetcdfFile ncfile) throws IOException {
            Array data = this.readCached(dset);
            if (data != null) {
                return data;
            }
            return super.read(dset, ncfile);
        }

        private Array readCached(DatasetOuterDimension dset) throws IOException {
            Array data = this.getData(dset.getId());
            if (data != null) {
                return data;
            }
            data = Array.factory(this.dtype, new int[]{dset.ncoord});
            IndexIterator ii = data.getIndexIterator();
            if (dset.coordValueDate != null) {
                if (this.dtype == DataType.STRING) {
                    ii.setObjectNext(dset.coordValue);
                } else if (this.du != null) {
                    double val = this.du.makeValue(dset.coordValueDate);
                    ii.setDoubleNext(val);
                }
                this.putData(dset.getId(), data);
                return data;
            }
            if (dset.coordValue != null) {
                if (dset.ncoord == 1) {
                    if (this.dtype == DataType.STRING) {
                        ii.setObjectNext(dset.coordValue);
                    } else {
                        double val = Double.parseDouble(dset.coordValue);
                        ii.setDoubleNext(val);
                    }
                } else {
                    int count = 0;
                    StringTokenizer stoker = new StringTokenizer(dset.coordValue, " ,");
                    while (stoker.hasMoreTokens()) {
                        String toke = stoker.nextToken();
                        if (this.dtype == DataType.STRING) {
                            ii.setObjectNext(toke);
                        } else {
                            double val = Double.parseDouble(toke);
                            ii.setDoubleNext(val);
                        }
                        ++count;
                    }
                    if (count != dset.ncoord) {
                        Aggregation.logger.error("readAggCoord incorrect number of coordinates dataset=" + dset.getLocation());
                        throw new IllegalArgumentException("readAggCoord incorrect number of coordinates dataset=" + dset.getLocation());
                    }
                }
                this.putData(dset.getId(), data);
                return data;
            }
            return null;
        }
    }

    class CacheVar {
        String varName;
        DataType dtype;
        private Map<String, Array> dataMap = new HashMap<String, Array>();

        CacheVar(String varName, DataType dtype) {
            this.varName = varName;
            this.dtype = dtype;
            if (varName == null) {
                throw new IllegalArgumentException("Missing variable name on cache var");
            }
        }

        public String toString() {
            return this.varName + " (" + this.getClass().getName() + ")";
        }

        void reset() {
            HashMap<String, Array> newMap = new HashMap<String, Array>();
            for (Aggregation.Dataset ds : AggregationOuterDimension.this.datasets) {
                String id = ds.getId();
                Array data = this.dataMap.get(id);
                if (data == null) continue;
                newMap.put(id, data);
            }
            this.dataMap = newMap;
        }

        Array read(Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
            if (debugCache) {
                System.out.println("caching " + this.varName + " section= " + section);
            }
            Array allData = null;
            List<Range> ranges = section.getRanges();
            Range joinRange = section.getRange(0);
            Section innerSection = null;
            if (section.getRank() > 1) {
                innerSection = new Section(ranges.subList(1, ranges.size()));
            }
            int resultPos = 0;
            List<Aggregation.Dataset> nestedDatasets = AggregationOuterDimension.this.getDatasets();
            for (Aggregation.Dataset vnested : nestedDatasets) {
                Array varData;
                DatasetOuterDimension dod = (DatasetOuterDimension)vnested;
                Range nestedJoinRange = dod.getNestedJoinRange(joinRange);
                if (nestedJoinRange == null) continue;
                if (debugStride) {
                    System.out.printf("%d: %s [%d,%d) (%d) %f for %s%n", resultPos, nestedJoinRange, dod.aggStart, dod.aggEnd, dod.ncoord, (double)dod.aggStart / 8.0, vnested.getLocation());
                }
                if ((varData = this.read(dod)) == null) {
                    throw new IOException("cant read " + dod);
                }
                if ((AggregationOuterDimension.this.type == Aggregation.Type.joinNew || AggregationOuterDimension.this.type == Aggregation.Type.forecastModelRunCollection) && innerSection != null && varData.getSize() != innerSection.computeSize()) {
                    varData = varData.section(innerSection.getRanges());
                } else if (innerSection == null && varData.getSize() != (long)nestedJoinRange.length()) {
                    ArrayList<Range> nestedSection = new ArrayList<Range>(ranges);
                    nestedSection.set(0, nestedJoinRange);
                    varData = varData.section(nestedSection);
                }
                if (this.dtype == null) {
                    this.dtype = DataType.getType(varData.getElementType());
                }
                if (allData == null) {
                    allData = Array.factory(this.dtype, section.getShape());
                    if (debugStride) {
                        System.out.printf("total result section = %s (%d)%n", section, Index.computeSize(section.getShape()));
                    }
                }
                int nelems = (int)varData.getSize();
                Array.arraycopy(varData, 0, allData, resultPos, nelems);
                resultPos += nelems;
                if (cancelTask == null || !cancelTask.isCancel()) continue;
                return null;
            }
            return allData;
        }

        protected void putData(String id, Array data) {
            this.dataMap.put(id, data);
        }

        protected Array getData(String id) {
            return this.dataMap.get(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Array read(DatasetOuterDimension dset) throws IOException {
            Array data = this.getData(dset.getId());
            if (data != null) {
                return data;
            }
            if (AggregationOuterDimension.this.type == Aggregation.Type.joinNew) {
                return null;
            }
            try (NetcdfFile ncfile = null;){
                ncfile = dset.acquireFile(null);
                Array array = this.read(dset, ncfile);
                return array;
            }
        }

        protected Array read(DatasetOuterDimension dset, NetcdfFile ncfile) throws IOException {
            ++invocation;
            Array data = this.getData(dset.getId());
            if (data != null) {
                return data;
            }
            if (AggregationOuterDimension.this.type == Aggregation.Type.joinNew) {
                return null;
            }
            Variable v = ncfile.findVariable(this.varName);
            data = v.read();
            this.putData(dset.getId(), data);
            if (debugCache) {
                System.out.println("caching " + this.varName + " complete data");
            }
            return data;
        }
    }

    class DatasetOuterDimension
    extends Aggregation.Dataset {
        protected int ncoord;
        protected String coordValue;
        protected Date coordValueDate;
        protected boolean isStringValued;
        private int aggStart;
        private int aggEnd;

        protected DatasetOuterDimension(String cacheName, String location, String id, String ncoordS, String coordValueS, EnumSet<NetcdfDataset.Enhance> enhance, FileFactory reader) {
            super(cacheName, location, id, enhance, reader);
            this.isStringValued = false;
            this.aggStart = 0;
            this.aggEnd = 0;
            this.coordValue = coordValueS;
            if (AggregationOuterDimension.this.type == Aggregation.Type.joinNew || AggregationOuterDimension.this.type == Aggregation.Type.joinExistingOne) {
                this.ncoord = 1;
            } else if (ncoordS != null) {
                try {
                    this.ncoord = Integer.parseInt(ncoordS);
                }
                catch (NumberFormatException e) {
                    Aggregation.logger.error("bad ncoord attribute on dataset=" + location);
                }
            }
            if (AggregationOuterDimension.this.type == Aggregation.Type.joinNew || AggregationOuterDimension.this.type == Aggregation.Type.joinExistingOne || AggregationOuterDimension.this.type == Aggregation.Type.forecastModelRunCollection) {
                if (coordValueS == null) {
                    this.coordValue = this.extractCoordNameFromFilename(this.getLocation());
                    this.isStringValued = true;
                } else {
                    try {
                        Double.parseDouble(coordValueS);
                    }
                    catch (NumberFormatException e) {
                        this.isStringValued = true;
                    }
                }
            }
            if (AggregationOuterDimension.this.type == Aggregation.Type.joinExisting && coordValueS != null) {
                StringTokenizer stoker = new StringTokenizer(coordValueS, " ,");
                this.ncoord = stoker.countTokens();
            }
        }

        private String extractCoordNameFromFilename(String loc) {
            int pos = loc.lastIndexOf(47);
            String result = pos < 0 ? loc : loc.substring(pos + 1);
            pos = result.lastIndexOf(35);
            if (pos > 0) {
                result = result.substring(0, pos);
            }
            return result;
        }

        DatasetOuterDimension(MFile cd) {
            super(cd);
            this.isStringValued = false;
            this.aggStart = 0;
            this.aggEnd = 0;
            if (AggregationOuterDimension.this.type == Aggregation.Type.joinNew || AggregationOuterDimension.this.type == Aggregation.Type.joinExistingOne) {
                this.ncoord = 1;
            }
            if (AggregationOuterDimension.this.type == Aggregation.Type.joinNew || AggregationOuterDimension.this.type == Aggregation.Type.joinExistingOne || AggregationOuterDimension.this.type == Aggregation.Type.forecastModelRunCollection) {
                this.coordValue = this.extractCoordNameFromFilename(this.getLocation());
                this.isStringValued = true;
                this.isStringValued = true;
            }
            if (null != AggregationOuterDimension.this.dateFormatMark) {
                String filename = cd.getName();
                this.coordValueDate = DateFromString.getDateUsingDemarkatedCount(filename, AggregationOuterDimension.this.dateFormatMark, '#');
                this.coordValue = AggregationOuterDimension.this.dateFormatter.toDateTimeStringISO(this.coordValueDate);
                if (Aggregation.debugDateParse) {
                    System.out.println("  adding " + cd.getPath() + " date= " + this.coordValue);
                }
            } else if (Aggregation.debugDateParse) {
                System.out.println("  adding " + cd.getPath());
            }
            if (this.coordValue == null && AggregationOuterDimension.this.type == Aggregation.Type.joinNew) {
                this.coordValue = cd.getName();
            }
        }

        public String getCoordValueString() {
            return this.coordValue;
        }

        public Date getCoordValueDate() {
            return this.coordValueDate;
        }

        @Override
        public void show(Formatter f) {
            f.format("   %s", this.getLocation());
            if (this.coordValue != null) {
                f.format(" coordValue='%s'", this.coordValue);
            }
            if (this.coordValueDate != null) {
                f.format(" coordValueDate='%s'", AggregationOuterDimension.this.dateFormatter.toDateTimeString(this.coordValueDate));
            }
            f.format(" range=[%d:%d) (%d)%n", this.aggStart, this.aggEnd, this.ncoord);
        }

        public int getNcoords(CancelTask cancelTask) throws IOException {
            block18: {
                if (this.ncoord <= 0) {
                    try (NetcdfFile ncd = this.acquireFile(cancelTask);){
                        if (cancelTask != null && cancelTask.isCancel()) {
                            int n = 0;
                            return n;
                        }
                        Dimension d = ncd.findDimension(AggregationOuterDimension.this.dimName);
                        if (d != null) {
                            this.ncoord = d.getLength();
                            break block18;
                        }
                        throw new IllegalArgumentException("Dimension not found= " + AggregationOuterDimension.this.dimName);
                    }
                }
            }
            return this.ncoord;
        }

        protected int setStartEnd(int aggStart, CancelTask cancelTask) throws IOException {
            this.aggStart = aggStart;
            this.aggEnd = aggStart + this.getNcoords(cancelTask);
            return this.ncoord;
        }

        protected Range getNestedJoinRange(Range totalRange) throws InvalidRangeException {
            int wantStop;
            int wantStart = totalRange.first();
            if (!this.isNeeded(wantStart, wantStop = totalRange.last() + 1)) {
                return null;
            }
            int firstInInterval = totalRange.getFirstInInterval(this.aggStart);
            if (firstInInterval < 0 || firstInInterval >= this.aggEnd) {
                return null;
            }
            int start = Math.max(firstInInterval, wantStart) - this.aggStart;
            int stop = Math.min(this.aggEnd, wantStop) - this.aggStart;
            return new Range(start, stop - 1, totalRange.stride());
        }

        protected boolean isNeeded(Range totalRange) {
            int wantStart = totalRange.first();
            int wantStop = totalRange.last() + 1;
            return this.isNeeded(wantStart, wantStop);
        }

        private boolean isNeeded(int wantStart, int wantStop) {
            if (wantStart >= wantStop) {
                return false;
            }
            return wantStart < this.aggEnd && wantStop > this.aggStart;
        }

        @Override
        protected void cacheVariables(NetcdfFile ncfile) throws IOException {
            for (CacheVar pv : AggregationOuterDimension.this.cacheList) {
                pv.read(this, ncfile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Array read(Variable mainv, CancelTask cancelTask, List<Range> section) throws IOException, InvalidRangeException {
            NetcdfFile ncd = null;
            try {
                ncd = this.acquireFile(cancelTask);
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                Variable v = this.findVariable(ncd, mainv);
                if (v == null) {
                    Aggregation.logger.error("AggOuterDimension cant find " + mainv.getFullName() + " in " + ncd.getLocation() + "; return all zeroes!!!");
                    Array array = Array.factory(mainv.getDataType(), new Section(section).getShape());
                    return array;
                }
                if (Aggregation.debugRead) {
                    Section want = new Section(section);
                    System.out.printf("AggOuter.read(%s) %s from %s in %s%n", want, mainv.getNameAndDimensions(), v.getNameAndDimensions(), this.getLocation());
                }
                Range fullRange = v.getRanges().get(0);
                Range want = section.get(0);
                if (fullRange.last() < want.last()) {
                    Range limitRange = new Range(want.first(), fullRange.last(), want.stride());
                    section = new ArrayList<Range>(section);
                    section.set(0, limitRange);
                }
                Array array = v.read(section);
                return array;
            }
            finally {
                this.close(ncd);
            }
        }

        @Override
        public int compareTo(Object o) {
            if (this.coordValueDate == null) {
                return super.compareTo(o);
            }
            DatasetOuterDimension other = (DatasetOuterDimension)o;
            return this.coordValueDate.compareTo(other.coordValueDate);
        }
    }

    private static class Result {
        Array data;
        int index;

        Result(Array data, int index) {
            this.data = data;
            this.index = index;
        }
    }

    private static class ReaderTask
    implements Callable<Result> {
        Aggregation.Dataset ds;
        Variable mainv;
        CancelTask cancelTask;
        int index;

        ReaderTask(Aggregation.Dataset ds, Variable mainv, CancelTask cancelTask, int index) {
            this.ds = ds;
            this.mainv = mainv;
            this.cancelTask = cancelTask;
            this.index = index;
        }

        @Override
        public Result call() throws Exception {
            Array data = this.ds.read(this.mainv, this.cancelTask);
            return new Result(data, this.index);
        }
    }
}

