/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.FileWriter2;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.AggregationExisting;
import ucar.nc2.ncml.AggregationFmrc;
import ucar.nc2.ncml.AggregationNew;
import ucar.nc2.ncml.AggregationOuterDimension;
import ucar.nc2.ncml.AggregationTiled;
import ucar.nc2.ncml.AggregationUnion;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.IO;
import ucar.nc2.util.URLnaming;
import ucar.nc2.util.cache.FileFactory;
import ucar.nc2.write.Nc4Chunking;
import ucar.unidata.util.StringUtil2;

public class NcMLReader {
    private static final Namespace ncNS = Catalog.ncmlNS;
    private static Logger log = LoggerFactory.getLogger(NcMLReader.class);
    private static boolean debugURL = false;
    private static boolean debugXML = false;
    private static boolean showParsedXML = false;
    private static boolean debugOpen = false;
    private static boolean debugConstruct = false;
    private static boolean debugCmd = false;
    private static boolean debugAggDetail = false;
    private String location;
    private boolean explicit = false;
    private Formatter errlog = new Formatter();

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugURL = debugFlag.isSet("NcML/debugURL");
        debugXML = debugFlag.isSet("NcML/debugXML");
        showParsedXML = debugFlag.isSet("NcML/showParsedXML");
        debugCmd = debugFlag.isSet("NcML/debugCmd");
        debugOpen = debugFlag.isSet("NcML/debugOpen");
        debugConstruct = debugFlag.isSet("NcML/debugConstruct");
        debugAggDetail = debugFlag.isSet("NcML/debugAggDetail");
    }

    public static void wrapNcMLresource(NetcdfDataset ncDataset, String ncmlResourceLocation, CancelTask cancelTask) throws IOException {
        ClassLoader cl = ncDataset.getClass().getClassLoader();
        try (InputStream is = cl.getResourceAsStream(ncmlResourceLocation);){
            Document doc;
            if (is == null) {
                throw new FileNotFoundException(ncmlResourceLocation);
            }
            if (debugXML) {
                System.out.println(" NetcdfDataset URL = <" + ncmlResourceLocation + ">");
                try (InputStream is2 = cl.getResourceAsStream(ncmlResourceLocation);){
                    System.out.println(" contents=\n" + IO.readContents(is2));
                }
            }
            try {
                SAXBuilder builder = new SAXBuilder();
                if (debugURL) {
                    System.out.println(" NetcdfDataset URL = <" + ncmlResourceLocation + ">");
                }
                doc = builder.build(is);
            }
            catch (JDOMException e) {
                throw new IOException(e.getMessage());
            }
            if (debugXML) {
                System.out.println(" SAXBuilder done");
            }
            if (showParsedXML) {
                XMLOutputter xmlOut = new XMLOutputter();
                System.out.println("*** NetcdfDataset/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
            }
            Element netcdfElem = doc.getRootElement();
            NcMLReader reader = new NcMLReader();
            reader.readNetcdf(ncDataset.getLocation(), ncDataset, ncDataset, netcdfElem, cancelTask);
            if (debugOpen) {
                System.out.println("***NcMLReader.wrapNcML result= \n" + ncDataset);
            }
        }
    }

    public static void wrapNcML(NetcdfDataset ncDataset, String ncmlLocation, CancelTask cancelTask) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            if (debugURL) {
                System.out.println(" NetcdfDataset URL = <" + ncmlLocation + ">");
            }
            doc = builder.build(ncmlLocation);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        if (debugXML) {
            System.out.println(" SAXBuilder done");
        }
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** NetcdfDataset/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        Element netcdfElem = doc.getRootElement();
        NcMLReader reader = new NcMLReader();
        reader.readNetcdf(ncmlLocation, ncDataset, ncDataset, netcdfElem, cancelTask);
        if (debugOpen) {
            System.out.println("***NcMLReader.wrapNcML result= \n" + ncDataset);
        }
    }

    public static NetcdfDataset mergeNcML(NetcdfFile ref, Element parentElem) throws IOException {
        NetcdfDataset targetDS = new NetcdfDataset(ref, null);
        NcMLReader reader = new NcMLReader();
        reader.readGroup(targetDS, targetDS, null, null, parentElem);
        targetDS.finish();
        return targetDS;
    }

    public static NetcdfDataset mergeNcMLdirect(NetcdfDataset targetDS, Element parentElem) throws IOException {
        NcMLReader reader = new NcMLReader();
        reader.readGroup(targetDS, targetDS, null, null, parentElem);
        targetDS.finish();
        return targetDS;
    }

    public static NetcdfDataset readNcML(String ncmlLocation, CancelTask cancelTask) throws IOException {
        return NcMLReader.readNcML(ncmlLocation, (String)null, cancelTask);
    }

    public static NetcdfDataset readNcML(String ncmlLocation, String referencedDatasetUri, CancelTask cancelTask) throws IOException {
        Document doc;
        URL url = new URL(ncmlLocation);
        if (debugURL) {
            System.out.println(" NcMLReader open " + ncmlLocation);
            System.out.println("   URL = " + url.toString());
            System.out.println("   external form = " + url.toExternalForm());
            System.out.println("   protocol = " + url.getProtocol());
            System.out.println("   host = " + url.getHost());
            System.out.println("   path = " + url.getPath());
            System.out.println("  file = " + url.getFile());
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            if (debugURL) {
                System.out.println(" NetcdfDataset URL = <" + url + ">");
            }
            doc = builder.build(url);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        if (debugXML) {
            System.out.println(" SAXBuilder done");
        }
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** NetcdfDataset/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        Element netcdfElem = doc.getRootElement();
        if (referencedDatasetUri == null && (referencedDatasetUri = netcdfElem.getAttributeValue("location")) == null) {
            referencedDatasetUri = netcdfElem.getAttributeValue("url");
        }
        NcMLReader reader = new NcMLReader();
        NetcdfDataset ncd = reader._readNcML(ncmlLocation, referencedDatasetUri, netcdfElem, cancelTask);
        if (debugOpen) {
            System.out.println("***NcMLReader.readNcML result= \n" + ncd);
        }
        return ncd;
    }

    public static NetcdfDataset readNcML(InputStream ins, CancelTask cancelTask) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(ins);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        if (debugXML) {
            System.out.println(" SAXBuilder done");
        }
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** NetcdfDataset/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        Element netcdfElem = doc.getRootElement();
        NetcdfDataset ncd = NcMLReader.readNcML(null, netcdfElem, cancelTask);
        if (debugOpen) {
            System.out.println("***NcMLReader.readNcML (stream) result= \n" + ncd);
        }
        return ncd;
    }

    public static NetcdfDataset readNcML(Reader r, CancelTask cancelTask) throws IOException {
        return NcMLReader.readNcML(r, "NcMLReader", cancelTask);
    }

    public static NetcdfDataset readNcML(Reader r, String ncmlLocation, CancelTask cancelTask) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(r);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        if (debugXML) {
            System.out.println(" SAXBuilder done");
        }
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** NetcdfDataset/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        Element netcdfElem = doc.getRootElement();
        NetcdfDataset ncd = NcMLReader.readNcML(ncmlLocation, netcdfElem, cancelTask);
        if (debugOpen) {
            System.out.println("***NcMLReader.readNcML (stream) result= \n" + ncd);
        }
        return ncd;
    }

    public static NetcdfDataset readNcML(String ncmlLocation, Element netcdfElem, CancelTask cancelTask) throws IOException {
        String referencedDatasetUri = netcdfElem.getAttributeValue("location");
        if (referencedDatasetUri == null) {
            referencedDatasetUri = netcdfElem.getAttributeValue("url");
        }
        NcMLReader reader = new NcMLReader();
        return reader._readNcML(ncmlLocation, referencedDatasetUri, netcdfElem, cancelTask);
    }

    public static NetcdfDataset readNcML(String ncmlLocation, Element netcdfElem, String referencedDatasetUri, CancelTask cancelTask) throws IOException {
        NcMLReader reader = new NcMLReader();
        return reader._readNcML(ncmlLocation, referencedDatasetUri, netcdfElem, cancelTask);
    }

    private NetcdfDataset _readNcML(String ncmlLocation, String referencedDatasetUri, Element netcdfElem, CancelTask cancelTask) throws IOException {
        NetcdfDataset targetDS;
        Element elemE;
        if ((referencedDatasetUri = URLnaming.resolve(ncmlLocation, referencedDatasetUri)) != null && referencedDatasetUri.equals(ncmlLocation)) {
            throw new IllegalArgumentException("NcML location attribute refers to the NcML document itself" + referencedDatasetUri);
        }
        String iospS = netcdfElem.getAttributeValue("iosp");
        Object iospParam = netcdfElem.getAttributeValue("iospParam");
        if (iospParam == null) {
            iospParam = netcdfElem.getChild("iospParam", ncNS);
        }
        String bufferSizeS = netcdfElem.getAttributeValue("buffer_size");
        int buffer_size = -1;
        if (bufferSizeS != null) {
            buffer_size = Integer.parseInt(bufferSizeS);
        }
        NetcdfDataset refds = null;
        if (referencedDatasetUri != null) {
            if (iospS != null) {
                NetcdfFileSubclass ncfile;
                try {
                    ncfile = new NetcdfFileSubclass(iospS, iospParam, referencedDatasetUri, buffer_size, cancelTask);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                refds = new NetcdfDataset((NetcdfFile)ncfile, false);
            } else {
                refds = NetcdfDataset.openDataset(referencedDatasetUri, null, buffer_size, cancelTask, iospParam);
            }
        }
        boolean bl = this.explicit = (elemE = netcdfElem.getChild("explicit", ncNS)) != null;
        if (this.explicit || refds == null) {
            targetDS = new NetcdfDataset();
            if (refds == null) {
                refds = targetDS;
            } else {
                targetDS.setReferencedFile(refds);
            }
        } else {
            targetDS = refds;
        }
        this.readNetcdf(ncmlLocation, targetDS, refds, netcdfElem, cancelTask);
        return targetDS;
    }

    private void readNetcdf(String ncmlLocation, NetcdfDataset targetDS, NetcdfFile refds, Element netcdfElem, CancelTask cancelTask) throws IOException {
        Namespace use;
        this.location = ncmlLocation;
        if (debugOpen) {
            System.out.println("NcMLReader.readNetcdf ncml= " + ncmlLocation + " referencedDatasetUri= " + refds.getLocation());
        }
        if (!(use = netcdfElem.getNamespace()).equals(ncNS)) {
            throw new IllegalArgumentException("Incorrect namespace specified in NcML= " + use.getURI() + "\n   must be=" + ncNS.getURI());
        }
        if (ncmlLocation != null) {
            targetDS.setLocation(ncmlLocation);
        }
        targetDS.setId(netcdfElem.getAttributeValue("id"));
        targetDS.setTitle(netcdfElem.getAttributeValue("title"));
        Element aggElem = netcdfElem.getChild("aggregation", ncNS);
        if (aggElem != null) {
            Aggregation agg = this.readAgg(aggElem, ncmlLocation, targetDS, cancelTask);
            targetDS.setAggregation(agg);
            agg.finish(cancelTask);
        }
        this.readGroup(targetDS, refds, null, null, netcdfElem);
        String errors = this.errlog.toString();
        if (errors.length() > 0) {
            throw new IllegalArgumentException("NcML had fatal errors:" + errors);
        }
        targetDS.finish();
        Set<NetcdfDataset.Enhance> mode = NetcdfDataset.parseEnhanceMode(netcdfElem.getAttributeValue("enhance"));
        targetDS.enhance(mode);
        String addRecords = netcdfElem.getAttributeValue("addRecords");
        if (addRecords != null && addRecords.equalsIgnoreCase("true")) {
            targetDS.sendIospMessage("AddRecordStructure");
        }
    }

    private void readAtt(Object parent, Object refParent, Element attElem) {
        boolean newName;
        String name = attElem.getAttributeValue("name");
        if (name == null) {
            this.errlog.format("NcML Attribute name is required (%s)%n", attElem);
            return;
        }
        String nameInFile = attElem.getAttributeValue("orgName");
        boolean bl = newName = nameInFile != null && !nameInFile.equals(name);
        if (nameInFile == null) {
            nameInFile = name;
        } else if (null == this.findAttribute(refParent, nameInFile)) {
            this.errlog.format("NcML attribute orgName '%s' doesnt exist. att=%s in=%s%n", nameInFile, name, parent);
            return;
        }
        Attribute oldatt = this.findAttribute(refParent, nameInFile);
        if (oldatt == null) {
            if (debugConstruct) {
                System.out.println(" add new att = " + name);
            }
            try {
                Array values = NcMLReader.readAttributeValues(attElem);
                this.addAttribute(parent, new Attribute(name, values));
            }
            catch (RuntimeException e) {
                this.errlog.format("NcML new Attribute Exception: %s att=%s in=%s%n", e.getMessage(), name, parent);
            }
        } else {
            boolean hasValue;
            if (debugConstruct) {
                System.out.println(" modify existing att = " + name);
            }
            boolean bl2 = hasValue = attElem.getAttribute("value") != null;
            if (hasValue) {
                try {
                    Array values = NcMLReader.readAttributeValues(attElem);
                    this.addAttribute(parent, new Attribute(name, values));
                }
                catch (RuntimeException e) {
                    this.errlog.format("NcML existing Attribute Exception: %s att=%s in=%s%n", e.getMessage(), name, parent);
                    return;
                }
            } else {
                Array oldval = oldatt.getValues();
                if (oldval != null) {
                    this.addAttribute(parent, new Attribute(name, oldatt.getValues()));
                } else {
                    String unS = attElem.getAttributeValue("isUnsigned");
                    boolean isUnsigned = unS != null && unS.equalsIgnoreCase("true");
                    String typeS = attElem.getAttributeValue("type");
                    DataType type = typeS == null ? DataType.STRING : DataType.getType(typeS);
                    this.addAttribute(parent, new Attribute(name, type, isUnsigned));
                }
            }
            if (newName && !this.explicit) {
                this.removeAttribute(parent, oldatt);
                if (debugConstruct) {
                    System.out.println(" remove old att = " + nameInFile);
                }
            }
        }
    }

    public static Array readAttributeValues(Element s) throws IllegalArgumentException {
        String sep;
        DataType dtype;
        String valString = s.getAttributeValue("value");
        if (valString != null) {
            valString = StringUtil2.unquoteXmlAttribute(valString);
        }
        if (valString == null) {
            valString = s.getTextNormalize();
        }
        if (valString == null) {
            throw new IllegalArgumentException("No value specified");
        }
        String type = s.getAttributeValue("type");
        DataType dataType = dtype = type == null ? DataType.STRING : DataType.getType(type);
        if (dtype == DataType.CHAR) {
            dtype = DataType.STRING;
        }
        if ((sep = s.getAttributeValue("separator")) == null && dtype == DataType.STRING) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(valString);
            return Array.makeArray(dtype, list);
        }
        if (sep == null) {
            sep = " ";
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        StringTokenizer tokn = new StringTokenizer(valString, sep);
        while (tokn.hasMoreTokens()) {
            stringValues.add(tokn.nextToken());
        }
        return Array.makeArray(dtype, stringValues);
    }

    private Attribute findAttribute(Object parent, String name) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof Group) {
            return ((Group)parent).findAttribute(name);
        }
        if (parent instanceof Variable) {
            return ((Variable)parent).findAttribute(name);
        }
        return null;
    }

    private void addAttribute(Object parent, Attribute att) {
        if (parent instanceof Group) {
            ((Group)parent).addAttribute(att);
        } else if (parent instanceof Variable) {
            ((Variable)parent).addAttribute(att);
        }
    }

    private void removeAttribute(Object parent, Attribute att) {
        if (parent instanceof Group) {
            ((Group)parent).remove(att);
        } else if (parent instanceof Variable) {
            ((Variable)parent).remove(att);
        }
    }

    private void readDim(Group g, Group refg, Element dimElem) {
        Dimension dim;
        String name = dimElem.getAttributeValue("name");
        if (name == null) {
            this.errlog.format("NcML Dimension name is required (%s)%n", dimElem);
            return;
        }
        String nameInFile = dimElem.getAttributeValue("orgName");
        if (nameInFile == null) {
            nameInFile = name;
        }
        Dimension dimension = dim = refg == null ? null : refg.findDimension(nameInFile);
        if (dim == null) {
            String lengthS = dimElem.getAttributeValue("length");
            if (lengthS == null) {
                this.errlog.format("NcML Dimension length is required (%s)%n", dimElem);
                return;
            }
            String isUnlimitedS = dimElem.getAttributeValue("isUnlimited");
            String isSharedS = dimElem.getAttributeValue("isShared");
            String isUnknownS = dimElem.getAttributeValue("isVariableLength");
            boolean isUnlimited = isUnlimitedS != null && isUnlimitedS.equalsIgnoreCase("true");
            boolean isUnknown = isUnknownS != null && isUnknownS.equalsIgnoreCase("true");
            boolean isShared = true;
            if (isSharedS != null && isSharedS.equalsIgnoreCase("false")) {
                isShared = false;
            }
            int len = Integer.parseInt(lengthS);
            if (isUnknown) {
                len = Dimension.VLEN.getLength();
            }
            if (debugConstruct) {
                System.out.println(" add new dim = " + name);
            }
            g.addDimension(new Dimension(name, len, isShared, isUnlimited, isUnknown));
        } else {
            dim.setName(name);
            String lengthS = dimElem.getAttributeValue("length");
            String isUnlimitedS = dimElem.getAttributeValue("isUnlimited");
            String isSharedS = dimElem.getAttributeValue("isShared");
            String isUnknownS = dimElem.getAttributeValue("isVariableLength");
            if (isUnlimitedS != null) {
                dim.setUnlimited(isUnlimitedS.equalsIgnoreCase("true"));
            }
            if (isSharedS != null) {
                dim.setShared(!isSharedS.equalsIgnoreCase("false"));
            }
            if (isUnknownS != null) {
                dim.setVariableLength(isUnknownS.equalsIgnoreCase("true"));
            }
            if (lengthS != null && !dim.isVariableLength()) {
                int len = Integer.parseInt(lengthS);
                dim.setLength(len);
            }
            if (debugConstruct) {
                System.out.println(" modify existing dim = " + name);
            }
            if (g != refg) {
                g.addDimension(dim);
            }
        }
    }

    private void readEnumTypedef(Group g, Group refg, Element etdElem) {
        String name = etdElem.getAttributeValue("name");
        if (name == null) {
            this.errlog.format("NcML enumTypedef name is required (%s)%n", etdElem);
            return;
        }
        String typeS = etdElem.getAttributeValue("type");
        DataType baseType = typeS == null ? DataType.ENUM1 : DataType.getType(typeS);
        HashMap<Integer, String> map = new HashMap<Integer, String>(100);
        for (Element e : etdElem.getChildren("enum", ncNS)) {
            String key = e.getAttributeValue("key");
            String value = e.getTextNormalize();
            if (key == null) {
                this.errlog.format("NcML enumTypedef enum key attribute is required (%s)%n", e);
            }
            if (value == null) {
                this.errlog.format("NcML enumTypedef enum value is required (%s)%n", e);
            }
            try {
                int keyi = Integer.parseInt(key);
                map.put(keyi, value);
            }
            catch (Exception e2) {
                this.errlog.format("NcML enumTypedef enum key attribute not an integer (%s)%n", e);
            }
        }
        EnumTypedef td = new EnumTypedef(name, map, baseType);
        g.addEnumeration(td);
    }

    private void readGroup(NetcdfDataset newds, NetcdfFile refds, Group parent, Group refParent, Element groupElem) throws IOException {
        Group g;
        Group refg = null;
        if (parent == null) {
            g = newds.getRootGroup();
            refg = refds.getRootGroup();
            if (debugConstruct) {
                System.out.println(" root group ");
            }
        } else {
            String name = groupElem.getAttributeValue("name");
            if (name == null) {
                this.errlog.format("NcML Group name is required (%s)%n", groupElem);
                return;
            }
            String nameInFile = groupElem.getAttributeValue("orgName");
            if (nameInFile == null) {
                nameInFile = name;
            }
            if (refParent != null) {
                refg = refParent.findGroup(nameInFile);
            }
            if (refg == null) {
                g = new Group(newds, parent, name);
                parent.addGroup(g);
                if (debugConstruct) {
                    System.out.println(" add new group = " + name);
                }
            } else if (parent != refParent) {
                g = new Group(newds, parent, name);
                parent.addGroup(g);
                if (debugConstruct) {
                    System.out.println(" transfer existing group = " + name);
                }
            } else {
                g = refg;
                if (!nameInFile.equals(name)) {
                    g.setName(name);
                }
                if (debugConstruct) {
                    System.out.println(" modify existing group = " + name);
                }
            }
        }
        List<Element> attList = groupElem.getChildren("attribute", ncNS);
        for (Element attElem : attList) {
            this.readAtt(g, refg, attElem);
        }
        List<Element> etdList = groupElem.getChildren("enumTypedef", ncNS);
        for (Element elem : etdList) {
            this.readEnumTypedef(g, refg, elem);
        }
        List<Element> dimList = groupElem.getChildren("dimension", ncNS);
        for (Element dimElem : dimList) {
            this.readDim(g, refg, dimElem);
        }
        List<Element> varList = groupElem.getChildren("variable", ncNS);
        for (Element varElem : varList) {
            this.readVariable(newds, g, refg, varElem);
        }
        List<Element> removeList = groupElem.getChildren("remove", ncNS);
        for (Element e : removeList) {
            this.cmdRemove(g, e.getAttributeValue("type"), e.getAttributeValue("name"));
        }
        List<Element> groupList = groupElem.getChildren("group", ncNS);
        for (Element gElem : groupList) {
            this.readGroup(newds, refds, g, refg, gElem);
            if (!debugConstruct) continue;
            System.out.println(" add group = " + g.getFullName());
        }
    }

    private void readVariable(NetcdfDataset ds, Group g, Group refg, Element varElem) throws IOException {
        Variable v;
        String typedefS;
        Variable refv;
        String name = varElem.getAttributeValue("name");
        if (name == null) {
            this.errlog.format("NcML Variable name is required (%s)%n", varElem);
            return;
        }
        String nameInFile = varElem.getAttributeValue("orgName");
        if (nameInFile == null) {
            nameInFile = name;
        }
        Variable variable = refv = refg == null ? null : refg.findVariable(nameInFile);
        if (refv == null) {
            if (debugConstruct) {
                System.out.println(" add new var = " + name);
            }
            g.addVariable(this.readVariableNew(ds, g, null, varElem));
            return;
        }
        String typeS = varElem.getAttributeValue("type");
        DataType dtype = typeS != null ? DataType.getType(typeS) : refv.getDataType();
        EnumTypedef typedef = null;
        if (dtype.isEnum() && (typedefS = varElem.getAttributeValue("typedef")) != null) {
            typedef = g.findEnumeration(typedefS);
        }
        String shape = varElem.getAttributeValue("shape");
        if (refg == g) {
            v = refv;
            v.setName(name);
            v.setDataType(dtype);
            if (typedef != null) {
                v.setEnumTypedef(typedef);
            }
            if (shape != null) {
                v.setDimensions(shape);
            }
            if (debugConstruct) {
                System.out.println(" modify existing var = " + nameInFile);
            }
        } else {
            if (refv instanceof Structure) {
                v = new StructureDS(ds, g, null, name, (Structure)refv);
                v.setDimensions(shape);
            } else {
                v = new VariableDS(g, null, name, refv);
                v.setDataType(dtype);
                v.setDimensions(shape);
            }
            if (debugConstruct) {
                System.out.println(" modify explicit var = " + nameInFile);
            }
            g.addVariable(v);
        }
        List<Element> attList = varElem.getChildren("attribute", ncNS);
        for (Element attElem : attList) {
            this.readAtt(v, refv, attElem);
        }
        List<Element> removeList = varElem.getChildren("remove", ncNS);
        for (Element remElem : removeList) {
            this.cmdRemove(v, remElem.getAttributeValue("type"), remElem.getAttributeValue("name"));
        }
        if (v.getDataType() == DataType.STRUCTURE) {
            StructureDS s = (StructureDS)v;
            StructureDS refS = (StructureDS)refv;
            List<Element> varList = varElem.getChildren("variable", ncNS);
            for (Element vElem : varList) {
                this.readVariableNested(ds, s, refS, vElem);
            }
        } else {
            Element valueElem = varElem.getChild("values", ncNS);
            if (valueElem != null) {
                this.readValues(ds, v, varElem, valueElem);
            } else if (v.hasCachedData()) {
                Array data;
                try {
                    data = v.read();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
                if (data.getClass() != v.getDataType().getPrimitiveClassType()) {
                    Array newData = Array.factory(v.getDataType(), v.getShape());
                    MAMath.copy(newData, data);
                    v.setCachedData(newData, false);
                }
            }
        }
        this.processLogicalViews(varElem, v, g);
    }

    private void processLogicalViews(Element varElem, Variable v, Group g) {
        String dimName;
        Variable view;
        String sectionSpec;
        Element viewElem = varElem.getChild("logicalSection", ncNS);
        if (null != viewElem && (sectionSpec = viewElem.getAttributeValue("section")) != null) {
            try {
                Section s = new Section(sectionSpec);
                Section viewSection = Section.fill(s, v.getShape());
                if (!v.getShapeAsSection().contains(viewSection)) {
                    this.errlog.format("Invalid logicalSection on variable=%s section =(%s) original=(%s) %n", v.getFullName(), sectionSpec, v.getShapeAsSection());
                    return;
                }
                view = v.section(viewSection);
                g.removeVariable(v.getShortName());
                g.addVariable(view);
            }
            catch (InvalidRangeException e) {
                this.errlog.format("Invalid logicalSection on variable=%s section=(%s) error=%s %n", v.getFullName(), sectionSpec, e.getMessage());
                return;
            }
        }
        if (null != (viewElem = varElem.getChild("logicalSlice", ncNS))) {
            int index;
            dimName = viewElem.getAttributeValue("dimName");
            if (null == dimName) {
                this.errlog.format("NcML logicalSlice: dimName is required, variable=%s %n", v.getFullName());
                return;
            }
            int dim = v.findDimensionIndex(dimName);
            if (dim < 0) {
                this.errlog.format("NcML logicalSlice: cant find dimension %s in variable=%s %n", dimName, v.getFullName());
                return;
            }
            String indexS = viewElem.getAttributeValue("index");
            if (null == indexS) {
                this.errlog.format("NcML logicalSlice: index is required, variable=%s %n", v.getFullName());
                return;
            }
            try {
                index = Integer.parseInt(indexS);
            }
            catch (NumberFormatException e) {
                this.errlog.format("NcML logicalSlice: index=%s must be integer, variable=%s %n", indexS, v.getFullName());
                return;
            }
            try {
                Variable view2 = v.slice(dim, index);
                g.removeVariable(v.getShortName());
                g.addVariable(view2);
            }
            catch (InvalidRangeException e) {
                this.errlog.format("Invalid logicalSlice (%d,%d) on variable=%s error=%s %n", dim, index, v.getFullName(), e.getMessage());
            }
        }
        if (null != (viewElem = varElem.getChild("logicalReduce", ncNS))) {
            dimName = viewElem.getAttributeValue("dimNames");
            if (null == dimName) {
                this.errlog.format("NcML logicalReduce: dimNames is required, variable=%s %n", v.getFullName());
                return;
            }
            String[] dims = StringUtil2.splitString(dimName);
            ArrayList<Dimension> dimList = new ArrayList<Dimension>();
            for (String s : dims) {
                int idx = v.findDimensionIndex(s);
                if (idx < 0) {
                    this.errlog.format("NcML logicalReduce: cant find dimension %s in variable=%s %n", dimName, v.getFullName());
                    return;
                }
                dimList.add(v.getDimension(idx));
            }
            try {
                view = v.reduce(dimList);
                g.removeVariable(v.getShortName());
                g.addVariable(view);
            }
            catch (InvalidRangeException e) {
                this.errlog.format("Failed logicalReduce (%s) on variable=%s error=%s %n", dimName, v.getFullName(), e.getMessage());
            }
        }
    }

    private Variable readVariableNew(NetcdfDataset ds, Group g, Structure parentS, Element varElem) {
        Variable v;
        String shape;
        String typedefS;
        String name = varElem.getAttributeValue("name");
        if (name == null) {
            this.errlog.format("NcML Variable name is required (%s)%n", varElem);
            return null;
        }
        String type = varElem.getAttributeValue("type");
        if (type == null) {
            throw new IllegalArgumentException("New variable (" + name + ") must have datatype attribute");
        }
        DataType dtype = DataType.getType(type);
        EnumTypedef typedef = null;
        if (dtype.isEnum() && (typedefS = varElem.getAttributeValue("typedef")) != null) {
            typedef = g.findEnumeration(typedefS);
        }
        if ((shape = varElem.getAttributeValue("shape")) == null) {
            shape = "";
        }
        if (dtype == DataType.STRUCTURE) {
            StructureDS s = new StructureDS(ds, g, parentS, name, shape, null, null);
            v = s;
            List<Element> varList = varElem.getChildren("variable", ncNS);
            for (Element vElem : varList) {
                this.readVariableNested(ds, s, s, vElem);
            }
        } else if (dtype == DataType.SEQUENCE) {
            Sequence org = new Sequence(ds, g, parentS, name);
            SequenceDS s = new SequenceDS(g, org);
            v = s;
            List<Element> varList = varElem.getChildren("variable", ncNS);
            for (Element vElem : varList) {
                this.readVariableNested(ds, s, s, vElem);
            }
        } else {
            v = new VariableDS(ds, g, parentS, name, dtype, shape, null, null);
            Element valueElem = varElem.getChild("values", ncNS);
            if (valueElem != null) {
                this.readValues(ds, v, varElem, valueElem);
            }
        }
        List<Element> attList = varElem.getChildren("attribute", ncNS);
        for (Element attElem : attList) {
            this.readAtt(v, null, attElem);
        }
        if (typedef != null) {
            v.setEnumTypedef(typedef);
        }
        return v;
    }

    private void readVariableNested(NetcdfDataset ds, Structure parentS, Structure refStruct, Element varElem) {
        String shape;
        String typeS;
        Variable v;
        Variable refv;
        String name = varElem.getAttributeValue("name");
        if (name == null) {
            this.errlog.format("NcML Variable name is required (%s)%n", varElem);
            return;
        }
        String nameInFile = varElem.getAttributeValue("orgName");
        if (nameInFile == null) {
            nameInFile = name;
        }
        if ((refv = refStruct.findVariable(nameInFile)) == null) {
            Variable nested;
            if (debugConstruct) {
                System.out.println(" add new var = " + name);
            }
            if ((nested = this.readVariableNew(ds, parentS.getParentGroup(), parentS, varElem)) != null) {
                parentS.addMemberVariable(nested);
            }
            return;
        }
        if (parentS == refStruct) {
            v = refv;
            v.setName(name);
        } else {
            if (refv instanceof Structure) {
                v = new StructureDS(parentS.getParentGroup(), (Structure)refv);
                v.setName(name);
                v.setParentStructure(parentS);
            } else {
                v = new VariableDS(parentS.getParentGroup(), refv, false);
                v.setName(name);
                v.setParentStructure(parentS);
            }
            parentS.addMemberVariable(v);
        }
        if (debugConstruct) {
            System.out.println(" modify existing var = " + nameInFile);
        }
        if ((typeS = varElem.getAttributeValue("type")) != null) {
            DataType dtype = DataType.getType(typeS);
            v.setDataType(dtype);
        }
        if ((shape = varElem.getAttributeValue("shape")) != null) {
            v.setDimensions(shape);
        }
        List<Element> attList = varElem.getChildren("attribute", ncNS);
        for (Element attElem : attList) {
            this.readAtt(v, refv, attElem);
        }
        List<Element> removeList = varElem.getChildren("remove", ncNS);
        for (Element remElem : removeList) {
            this.cmdRemove(v, remElem.getAttributeValue("type"), remElem.getAttributeValue("name"));
        }
        if (v.getDataType() == DataType.STRUCTURE || v.getDataType() == DataType.SEQUENCE) {
            StructureDS s = (StructureDS)v;
            StructureDS refS = (StructureDS)refv;
            List<Element> varList = varElem.getChildren("variable", ncNS);
            for (Element vElem : varList) {
                this.readVariableNested(ds, s, refS, vElem);
            }
        } else {
            Element valueElem = varElem.getChild("values", ncNS);
            if (valueElem != null) {
                this.readValues(ds, v, varElem, valueElem);
            }
        }
    }

    private void readValues(NetcdfDataset ds, Variable v, Element varElem, Element valuesElem) {
        try {
            int npts;
            String fromAttribute = valuesElem.getAttributeValue("fromAttribute");
            if (fromAttribute != null) {
                Attribute att;
                int pos = fromAttribute.indexOf(64);
                if (pos > 0) {
                    String varName = fromAttribute.substring(0, pos);
                    String attName = fromAttribute.substring(pos + 1);
                    Variable vFrom = ds.getRootGroup().findVariable(varName);
                    if (vFrom == null) {
                        this.errlog.format("Cant find variable %s %n", fromAttribute);
                        return;
                    }
                    att = vFrom.findAttribute(attName);
                } else {
                    String attName = pos == 0 ? fromAttribute.substring(1) : fromAttribute;
                    att = ds.getRootGroup().findAttribute(attName);
                }
                if (att == null) {
                    this.errlog.format("Cant find attribute %s %n", fromAttribute);
                    return;
                }
                Array data = att.getValues();
                v.setCachedData(data, true);
                return;
            }
            String startS = valuesElem.getAttributeValue("start");
            String incrS = valuesElem.getAttributeValue("increment");
            String nptsS = valuesElem.getAttributeValue("npts");
            int n = npts = nptsS == null ? (int)v.getSize() : Integer.parseInt(nptsS);
            if (startS != null && incrS != null) {
                double start = Double.parseDouble(startS);
                double incr = Double.parseDouble(incrS);
                v.setValues(npts, start, incr);
                return;
            }
            String values = varElem.getChildText("values", ncNS);
            String sep = valuesElem.getAttributeValue("separator");
            if (v.getDataType() == DataType.CHAR) {
                int nhave = values.length();
                int nwant = (int)v.getSize();
                char[] data = new char[nwant];
                int min = Math.min(nhave, nwant);
                for (int i = 0; i < min; ++i) {
                    data[i] = values.charAt(i);
                }
                Array dataArray = Array.factory(DataType.CHAR.getPrimitiveClassType(), v.getShape(), (Object)data);
                v.setCachedData(dataArray, true);
            } else {
                List<String> valList = StringUtil2.getTokens(values, sep);
                v.setValues(valList);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("NCML Reading on " + v.getFullName(), t);
        }
    }

    private Aggregation readAgg(Element aggElem, String ncmlLocation, NetcdfDataset newds, CancelTask cancelTask) throws IOException {
        boolean needMerge;
        String olderS;
        String subdirs;
        String suffix;
        String regexpPatternString;
        String dirLocation;
        Aggregation agg;
        String dimName = aggElem.getAttributeValue("dimName");
        String type = aggElem.getAttributeValue("type");
        String recheck = aggElem.getAttributeValue("recheckEvery");
        if (type.equalsIgnoreCase("joinExisting")) {
            agg = new AggregationExisting(newds, dimName, recheck);
        } else if (type.equalsIgnoreCase("joinNew")) {
            agg = new AggregationNew(newds, dimName, recheck);
        } else if (type.equalsIgnoreCase("tiled")) {
            agg = new AggregationTiled(newds, dimName, recheck);
        } else if (type.equalsIgnoreCase("union")) {
            agg = new AggregationUnion(newds, dimName, recheck);
        } else if (type.equalsIgnoreCase("forecastModelRunCollection") || type.equalsIgnoreCase("forecastModelRunSingleCollection")) {
            AggregationFmrc aggc = new AggregationFmrc(newds, dimName, recheck);
            agg = aggc;
            List<Element> scan2List = aggElem.getChildren("scanFmrc", ncNS);
            for (Element scanElem : scan2List) {
                dirLocation = scanElem.getAttributeValue("location");
                regexpPatternString = scanElem.getAttributeValue("regExp");
                suffix = scanElem.getAttributeValue("suffix");
                subdirs = scanElem.getAttributeValue("subdirs");
                olderS = scanElem.getAttributeValue("olderThan");
                String runMatcher = scanElem.getAttributeValue("runDateMatcher");
                String forecastMatcher = scanElem.getAttributeValue("forecastDateMatcher");
                String offsetMatcher = scanElem.getAttributeValue("forecastOffsetMatcher");
                dirLocation = URLnaming.resolve(ncmlLocation, dirLocation);
                aggc.addDirectoryScanFmrc(dirLocation, suffix, regexpPatternString, subdirs, olderS, runMatcher, forecastMatcher, offsetMatcher);
                if (cancelTask != null && cancelTask.isCancel()) {
                    return null;
                }
                if (!debugAggDetail) continue;
                System.out.println(" debugAgg: nested dirLocation = " + dirLocation);
            }
        } else {
            throw new IllegalArgumentException("Unknown aggregation type=" + type);
        }
        if (agg instanceof AggregationOuterDimension) {
            String varName;
            AggregationOuterDimension aggo = (AggregationOuterDimension)agg;
            String timeUnitsChange = aggElem.getAttributeValue("timeUnitsChange");
            if (timeUnitsChange != null) {
                aggo.setTimeUnitsChange(timeUnitsChange.equalsIgnoreCase("true"));
            }
            List<Element> list = aggElem.getChildren("variableAgg", ncNS);
            for (Element vaggElem : list) {
                varName = vaggElem.getAttributeValue("name");
                aggo.addVariable(varName);
            }
            list = aggElem.getChildren("promoteGlobalAttribute", ncNS);
            for (Element gattElem : list) {
                varName = gattElem.getAttributeValue("name");
                String orgName = gattElem.getAttributeValue("orgName");
                aggo.addVariableFromGlobalAttribute(varName, orgName);
            }
            list = aggElem.getChildren("promoteGlobalAttributeCompose", ncNS);
            for (Element gattElem : list) {
                varName = gattElem.getAttributeValue("name");
                String format = gattElem.getAttributeValue("format");
                String orgName = gattElem.getAttributeValue("orgName");
                aggo.addVariableFromGlobalAttributeCompose(varName, format, orgName);
            }
            list = aggElem.getChildren("cacheVariable", ncNS);
            for (Element gattElem : list) {
                varName = gattElem.getAttributeValue("name");
                aggo.addCacheVariable(varName, null);
            }
        }
        List<Element> ncList = aggElem.getChildren("netcdf", ncNS);
        for (Element netcdfElemNested : ncList) {
            String location = netcdfElemNested.getAttributeValue("location");
            if (location == null) {
                location = netcdfElemNested.getAttributeValue("url");
            }
            String id = netcdfElemNested.getAttributeValue("id");
            String ncoords = netcdfElemNested.getAttributeValue("ncoords");
            String coordValueS = netcdfElemNested.getAttributeValue("coordValue");
            String sectionSpec = netcdfElemNested.getAttributeValue("section");
            NcmlElementReader reader = new NcmlElementReader(ncmlLocation, location, netcdfElemNested);
            String cacheName = location != null ? location : ncmlLocation;
            cacheName = cacheName + "#" + Integer.toString(netcdfElemNested.hashCode());
            String realLocation = URLnaming.resolveFile(ncmlLocation, location);
            agg.addExplicitDataset(cacheName, realLocation, id, ncoords, coordValueS, sectionSpec, reader);
            if (cancelTask != null && cancelTask.isCancel()) {
                return null;
            }
            if (!debugAggDetail) continue;
            System.out.println(" debugAgg: nested dataset = " + location);
        }
        List<Element> dirList = aggElem.getChildren("scan", ncNS);
        for (Element scanElem : dirList) {
            dirLocation = scanElem.getAttributeValue("location");
            regexpPatternString = scanElem.getAttributeValue("regExp");
            suffix = scanElem.getAttributeValue("suffix");
            subdirs = scanElem.getAttributeValue("subdirs");
            olderS = scanElem.getAttributeValue("olderThan");
            String dateFormatMark = scanElem.getAttributeValue("dateFormatMark");
            Set<NetcdfDataset.Enhance> enhanceMode = NetcdfDataset.parseEnhanceMode(scanElem.getAttributeValue("enhance"));
            dirLocation = URLnaming.resolve(ncmlLocation, dirLocation);
            Element cdElement = scanElem.getChild("crawlableDatasetImpl", ncNS);
            agg.addDatasetScan(cdElement, dirLocation, suffix, regexpPatternString, dateFormatMark, enhanceMode, subdirs, olderS);
            if (cancelTask != null && cancelTask.isCancel()) {
                return null;
            }
            if (!debugAggDetail) continue;
            System.out.println(" debugAgg: nested dirLocation = " + dirLocation);
        }
        Element collElem = aggElem.getChild("collection", ncNS);
        if (collElem != null) {
            agg.addCollection(collElem.getAttributeValue("spec"), collElem.getAttributeValue("olderThan"));
        }
        boolean bl = needMerge = aggElem.getChildren("attribute", ncNS).size() > 0;
        if (!needMerge) {
            boolean bl2 = needMerge = aggElem.getChildren("variable", ncNS).size() > 0;
        }
        if (!needMerge) {
            boolean bl3 = needMerge = aggElem.getChildren("dimension", ncNS).size() > 0;
        }
        if (!needMerge) {
            boolean bl4 = needMerge = aggElem.getChildren("group", ncNS).size() > 0;
        }
        if (!needMerge) {
            boolean bl5 = needMerge = aggElem.getChildren("remove", ncNS).size() > 0;
        }
        if (needMerge) {
            agg.setModifications(aggElem);
        }
        return agg;
    }

    private void cmdRemove(Group g, String type, String name) {
        boolean err = false;
        switch (type) {
            case "dimension": {
                Dimension dim = g.findDimension(name);
                if (dim != null) {
                    g.remove(dim);
                    if (!debugCmd) break;
                    System.out.println("CMD remove " + type + " " + name);
                    break;
                }
                err = true;
                break;
            }
            case "variable": {
                Variable v = g.findVariable(name);
                if (v != null) {
                    g.remove(v);
                    if (!debugCmd) break;
                    System.out.println("CMD remove " + type + " " + name);
                    break;
                }
                err = true;
                break;
            }
            case "attribute": {
                Attribute a = g.findAttribute(name);
                if (a != null) {
                    g.remove(a);
                    if (!debugCmd) break;
                    System.out.println("CMD remove " + type + " " + name);
                    break;
                }
                err = true;
            }
        }
        if (err) {
            Formatter f = new Formatter();
            f.format("CMD remove %s CANT find %s location %s%n", type, name, this.location);
            log.info(f.toString());
        }
    }

    private void cmdRemove(Variable v, String type, String name) {
        boolean err = false;
        if (type.equals("attribute")) {
            Attribute a = v.findAttribute(name);
            if (a != null) {
                v.remove(a);
                if (debugCmd) {
                    System.out.println("CMD remove " + type + " " + name);
                }
            } else {
                err = true;
            }
        } else if (type.equals("variable") && v instanceof Structure) {
            Structure s = (Structure)v;
            Variable nested = s.findVariable(name);
            if (nested != null) {
                s.removeMemberVariable(nested);
                if (debugCmd) {
                    System.out.println("CMD remove " + type + " " + name);
                }
            } else {
                err = true;
            }
        }
        if (err) {
            Formatter f = new Formatter();
            f.format("CMD remove %s CANT find %s location %s%n", type, name, this.location);
            log.info(f.toString());
        }
    }

    public static void writeNcMLToFile(String ncmlLocation, String fileOutName) throws IOException {
        NetcdfFile ncd = NetcdfDataset.acquireFile(ncmlLocation, null);
        FileWriter2 writer = new FileWriter2(ncd, fileOutName, NetcdfFileWriter.Version.netcdf3, null);
        NetcdfFile result = writer.write();
        result.close();
        ncd.close();
    }

    public static void writeNcMLToFile(InputStream ncml, String fileOutName) throws IOException {
        NcMLReader.writeNcMLToFile(ncml, fileOutName, NetcdfFileWriter.Version.netcdf3, null);
    }

    public static void writeNcMLToFile(InputStream ncml, String fileOutName, NetcdfFileWriter.Version version, Nc4Chunking chunker) throws IOException {
        NetcdfDataset ncd = NcMLReader.readNcML(ncml, null);
        FileWriter2 writer = new FileWriter2(ncd, fileOutName, version, chunker);
        NetcdfFile result = writer.write();
        result.close();
        ncd.close();
    }

    public static void main(String[] arg) {
        String ncmlFile = "C:/data/AStest/oots/test.ncml";
        String ncmlFileOut = "C:/TEMP/testNcmlOut.nc";
        try {
            FileInputStream in = new FileInputStream(ncmlFile);
            NcMLReader.writeNcMLToFile(in, ncmlFileOut);
        }
        catch (Exception ioe) {
            System.out.println("error = " + ncmlFile);
            ioe.printStackTrace();
        }
    }

    private class NcmlElementReader
    implements FileFactory {
        private Element netcdfElem;
        private String ncmlLocation;
        private String location;

        NcmlElementReader(String ncmlLocation, String location, Element netcdfElem) {
            this.ncmlLocation = ncmlLocation;
            this.location = location;
            this.netcdfElem = netcdfElem;
        }

        @Override
        public NetcdfFile open(String cacheName, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
            if (debugAggDetail) {
                System.out.println(" NcmlElementReader open nested dataset " + cacheName);
            }
            NetcdfDataset result = NcMLReader.this._readNcML(this.ncmlLocation, this.location, this.netcdfElem, cancelTask);
            result.setLocation(this.ncmlLocation + "#" + this.location);
            return result;
        }
    }
}

