/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.color.ColorSpace;

public class TwoChannelColorSpace
extends ColorSpace {
    public static final int CS_2C = -1;
    private static final int NUM_COMPONENTS = 2;

    protected TwoChannelColorSpace(int type, int components) {
        super(type, components);
    }

    public float[] fromCIEXYZ(float[] color) {
        ColorSpace rgb = ColorSpace.getInstance(1000);
        return rgb.fromCIEXYZ(this.toRGB(color));
    }

    public float[] fromRGB(float[] rgb) {
        return new float[]{rgb[0], rgb[1]};
    }

    public static ColorSpace getInstance(int colorSpace) {
        if (colorSpace == -1) {
            return new TwoChannelColorSpace(12, 2);
        }
        return ColorSpace.getInstance(colorSpace);
    }

    public String getName(int idx) {
        return idx == 0 ? "Red" : "Green";
    }

    public int getNumComponents() {
        return 2;
    }

    public int getType() {
        return 12;
    }

    public boolean isCS_sRGB() {
        return false;
    }

    public float[] toCIEXYZ(float[] color) {
        ColorSpace rgb = ColorSpace.getInstance(1000);
        return rgb.toCIEXYZ(this.toRGB(color));
    }

    public float[] toRGB(float[] color) {
        return new float[]{color[0], color[1], 0.0f};
    }
}

