/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import net.jcip.annotations.Immutable;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilder;
import ucar.coord.CoordinateTime2D;
import ucar.coord.Counter;
import ucar.coord.SparseArray;
import ucar.ma2.Section;
import ucar.nc2.util.Indent;

@Immutable
public class CoordinateND<T> {
    private final List<Coordinate> coordinates;
    private final SparseArray<T> sa;

    public CoordinateND(List<Coordinate> coordinates, SparseArray<T> sa) {
        this.coordinates = Collections.unmodifiableList(coordinates);
        this.sa = sa;
    }

    public List<Coordinate> getCoordinates() {
        return this.coordinates;
    }

    public int getNCoordinates() {
        return this.coordinates.size();
    }

    public SparseArray<T> getSparseArray() {
        return this.sa;
    }

    public void showInfo(Formatter info, Counter all) {
        for (Coordinate coord : this.coordinates) {
            coord.showInfo(info, new Indent(2));
        }
        if (this.sa != null) {
            this.sa.showInfo(info, all);
        }
    }

    public static class Builder<T> {
        private List<CoordinateBuilder<T>> builders = new ArrayList<CoordinateBuilder<T>>();
        private List<Coordinate> coordb = new ArrayList<Coordinate>();

        public Builder() {
            this.builders = new ArrayList<CoordinateBuilder<T>>();
        }

        public void addBuilder(CoordinateBuilder<T> builder) {
            this.builders.add(builder);
        }

        public void addRecord(T gr) {
            for (CoordinateBuilder<T> builder : this.builders) {
                builder.addRecord(gr);
            }
        }

        public CoordinateND<T> finish(List<T> records, Formatter info) {
            for (CoordinateBuilder<T> builder : this.builders) {
                Coordinate coord = builder.finish();
                if (coord.getType() == Coordinate.Type.time2D) {
                    this.coordb.add(((CoordinateTime2D)coord).getRuntimeCoordinate());
                }
                this.coordb.add(coord);
            }
            SparseArray<T> sa = this.buildSparseArray(records, info);
            return new CoordinateND<T>(this.coordb, sa);
        }

        public SparseArray<T> buildSparseArray(List<T> records, Formatter info) {
            int[] sizeArray = new int[this.coordb.size()];
            for (int i = 0; i < this.coordb.size(); ++i) {
                Coordinate coord = this.coordb.get(i);
                sizeArray[i] = coord.getType() == Coordinate.Type.time2D ? ((CoordinateTime2D)coord).getNtimes() : this.coordb.get(i).getSize();
            }
            SparseArray.Builder<T> saBuilder = new SparseArray.Builder<T>(sizeArray);
            int[] index = new int[this.coordb.size()];
            for (T gr : records) {
                int count = 0;
                for (CoordinateBuilder<T> builder : this.builders) {
                    if (builder instanceof CoordinateBuilder.TwoD) {
                        CoordinateBuilder.TwoD builder2D = (CoordinateBuilder.TwoD)((Object)builder);
                        int[] coordsIdx = builder2D.getCoordIndices(gr);
                        index[count++] = coordsIdx[0];
                        index[count++] = coordsIdx[1];
                        continue;
                    }
                    index[count++] = builder.getIndex(gr);
                }
                saBuilder.add(gr, info, index);
            }
            return saBuilder.finish();
        }

        public CoordinateND<T> reindex(List<Coordinate> newCoords, CoordinateND<T> prev) {
            SparseArray<T> prevSA = prev.getSparseArray();
            List<Coordinate> prevCoords = prev.getCoordinates();
            int[] sizeArray = new int[newCoords.size()];
            for (int i = 0; i < newCoords.size(); ++i) {
                Coordinate coord = newCoords.get(i);
                sizeArray[i] = coord instanceof CoordinateTime2D ? ((CoordinateTime2D)coord).getNtimes() : coord.getSize();
            }
            SparseArray.Builder workingSAbuilder = new SparseArray.Builder(sizeArray);
            ArrayList<IndexMapIF> indexMaps = new ArrayList<IndexMapIF>();
            int count = 0;
            for (Coordinate curr : newCoords) {
                if (curr.getType() == Coordinate.Type.time2D) {
                    indexMaps.add(new Time2DIndexMap((CoordinateTime2D)curr, (CoordinateTime2D)prevCoords.get(count++)));
                    continue;
                }
                indexMaps.add(new IndexMap(curr, prevCoords.get(count++)));
            }
            int[] currIndex = new int[newCoords.size()];
            int[] prevIndex = new int[newCoords.size()];
            int[] track = new int[SparseArray.calcTotalSize(sizeArray)];
            Section section = new Section(prevSA.getShape());
            Section.Iterator iter = section.getIterator(prevSA.getShape());
            while (iter.hasNext()) {
                int oldTrackIdx = iter.next(prevIndex);
                int oldTrackValue = prevSA.getTrack(oldTrackIdx);
                if (oldTrackValue == 0) continue;
                int coordIdx = 0;
                for (IndexMapIF indexMap : indexMaps) {
                    currIndex[coordIdx] = indexMap.map(prevIndex[coordIdx]);
                    ++coordIdx;
                }
                int trackIdx = workingSAbuilder.calcIndex(currIndex);
                if (trackIdx >= track.length) {
                    System.out.println("HEY CoordinateND trackIdx >= track.length");
                }
                track[trackIdx] = oldTrackValue;
            }
            SparseArray<T> newSA = new SparseArray<T>(sizeArray, track, prevSA.getContent(), prevSA.getNdups());
            return new CoordinateND<T>(newCoords, newSA);
        }

        private static class Time2DIndexMap
        implements IndexMapIF {
            int[] indexMap;

            Time2DIndexMap(CoordinateTime2D curr, CoordinateTime2D prev) {
                assert (curr.getType() == prev.getType()) : (Object)((Object)curr.getType()) + " != " + (Object)((Object)prev.getType());
                int[] index2D = new int[2];
                HashMap<Object, Integer> currValMap = new HashMap<Object, Integer>();
                for (Object object : curr.getValues()) {
                    boolean bl = curr.getIndex((CoordinateTime2D.Time2D)object, index2D);
                    if (!bl) {
                        System.out.println("HEY CoordinateND !ok");
                    }
                    currValMap.put(object, index2D[1]);
                }
                int count = 0;
                this.indexMap = new int[prev.getSize()];
                for (Object object : prev.getValues()) {
                    if (currValMap.get(object) == null) {
                        System.out.printf("HEY Time2DIndexMap %s%n", object);
                        continue;
                    }
                    this.indexMap[count++] = (Integer)currValMap.get(object);
                }
            }

            @Override
            public int map(int oldIndex) {
                return this.indexMap[oldIndex];
            }
        }

        private static class IndexMap
        implements IndexMapIF {
            boolean identity = true;
            int[] indexMap;

            IndexMap(Coordinate curr, Coordinate prev) {
                this.identity = curr.equals(prev);
                if (this.identity) {
                    return;
                }
                assert (curr.getType() == prev.getType()) : (Object)((Object)curr.getType()) + " != " + (Object)((Object)prev.getType());
                int count = 0;
                HashMap<Object, Integer> currValMap = new HashMap<Object, Integer>();
                if (curr.getValues() == null) {
                    System.out.println("HEY CoordinateND curr.getValues() == null");
                }
                for (Object object : curr.getValues()) {
                    currValMap.put(object, count++);
                }
                count = 0;
                this.indexMap = new int[prev.getSize()];
                for (Object object : prev.getValues()) {
                    this.indexMap[count++] = (Integer)currValMap.get(object);
                }
            }

            @Override
            public int map(int oldIndex) {
                if (this.identity) {
                    return oldIndex;
                }
                return this.indexMap[oldIndex];
            }
        }

        private static interface IndexMapIF {
            public int map(int var1);
        }
    }
}

