/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gini;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.ImageIO;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.gini.Giniheader;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Giniiosp
extends AbstractIOServiceProvider {
    protected Giniheader headerParser;
    static final int Z_DEFLATED = 8;
    static final int DEF_WBITS = 15;

    public Array readNestedData(Variable v2, List section) throws IOException, InvalidRangeException {
        throw new UnsupportedOperationException("Gini IOSP does not support nested variables");
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        Giniheader localHeader = new Giniheader();
        return Giniheader.isValidFile(raf);
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.headerParser = new Giniheader();
        this.headerParser.read(raf, ncfile);
        ncfile.finish();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        int[] origin = section.getOrigin();
        int[] shape = section.getShape();
        int[] stride = section.getStride();
        Giniheader.Vinfo vinfo = (Giniheader.Vinfo)v2.getSPobject();
        int[] levels = vinfo.levels;
        if (this.headerParser.gini_GetCompressType() == 0) {
            return this.readData(v2, vinfo.begin, origin, shape, stride, levels);
        }
        if (this.headerParser.gini_GetCompressType() == 2) {
            return this.readCompressedData(v2, vinfo.begin, origin, shape, stride, levels);
        }
        if (this.headerParser.gini_GetCompressType() == 1) {
            return this.readCompressedZlib(v2, vinfo.begin, vinfo.nx, vinfo.ny, origin, shape, stride, levels);
        }
        return null;
    }

    private float[] handleLevels(byte[] data, int[] levels) {
        int i;
        int level = levels[0];
        float[] a = new float[level];
        float[] b = new float[level];
        float[] fdata = new float[data.length];
        int scale = 1;
        for (i = 0; i < level; ++i) {
            int numer = levels[1 + 5 * i] - levels[2 + 5 * i];
            int denom = levels[3 + 5 * i] - levels[4 + 5 * i];
            a[i] = (float)numer * 1.0f / (1.0f * (float)denom);
            b[i] = (float)levels[1 + 5 * i] - a[i] * (float)levels[3 + 5 * i];
        }
        for (i = 0; i < data.length; ++i) {
            short ival = DataType.unsignedByteToShort(data[i]);
            int k = -1;
            for (int j = 0; j < level; ++j) {
                if (levels[3 + j * 5] > ival || ival > levels[4 + j * 5]) continue;
                k = j;
                scale = levels[5 + j * 5];
            }
            fdata[i] = k >= 0 ? (a[k] * (float)ival + b[k]) / (float)scale : 0.0f;
        }
        return fdata;
    }

    private Array makeArray(byte[] data, int[] levels, int[] shape) {
        Object[] store = data;
        Class dt = DataType.BYTE.getPrimitiveClassType();
        if (levels != null) {
            store = this.handleLevels(data, levels);
            dt = DataType.FLOAT.getPrimitiveClassType();
        }
        return Array.factory(dt, shape, (Object)store);
    }

    private Array readData(Variable v2, long dataPos, int[] origin, int[] shape, int[] stride, int[] levels) throws IOException, InvalidRangeException {
        this.raf.seek(dataPos);
        int data_size = (int)(this.raf.length() - dataPos);
        byte[] data = new byte[data_size];
        this.raf.readFully(data);
        Array array = this.makeArray(data, levels, v2.getShape());
        return array.sectionNoReduce(origin, shape, stride);
    }

    public Array readDataOld(Variable v2, long dataPos, int[] origin, int[] shape, int[] stride) throws IOException, InvalidRangeException {
        if (origin == null) {
            origin = new int[v2.getRank()];
        }
        if (shape == null) {
            shape = v2.getShape();
        }
        Giniheader.Vinfo vinfo = (Giniheader.Vinfo)v2.getSPobject();
        int nx = vinfo.nx;
        int ny = vinfo.ny;
        int start_l = origin[0];
        int stride_l = stride[0];
        int stop_l = origin[0] + shape[0] - 1;
        int start_p = origin[1];
        int stride_p = stride[1];
        int stop_p = origin[1] + shape[1] - 1;
        if (start_l + stop_l + stride_l == 0) {
            start_l = 0;
            stride_l = 1;
            stop_l = ny - 1;
        }
        if (start_p + stop_p + stride_p == 0) {
            start_p = 0;
            stride_p = 1;
        }
        int Len = shape[1];
        ArrayByte adata = new ArrayByte(new int[]{shape[0], shape[1]});
        Index indx = adata.getIndex();
        long doff = dataPos + (long)start_p;
        for (int iline = start_l; iline <= stop_l; iline += stride_l) {
            byte[] buf = this.getGiniLine(nx, ny, doff, iline, Len, stride_p);
            for (int i = 0; i < Len; ++i) {
                adata.setByte(indx.set(iline - start_l, i), buf[i]);
            }
        }
        return adata;
    }

    public Array readCompressedData(Variable v2, long dataPos, int[] origin, int[] shape, int[] stride, int[] levels) throws IOException, InvalidRangeException {
        this.raf.seek(dataPos);
        int data_size = (int)(this.raf.length() - dataPos);
        byte[] data = new byte[data_size];
        this.raf.readFully(data);
        ByteArrayInputStream ios = new ByteArrayInputStream(data);
        BufferedImage image = ImageIO.read(ios);
        DataBuffer db = image.getData().getDataBuffer();
        if (db instanceof DataBufferByte) {
            DataBufferByte dbb = (DataBufferByte)db;
            Array array = this.makeArray(dbb.getData(), levels, v2.getShape());
            if (levels == null) {
                v2.setCachedData(array, false);
            }
            return array.sectionNoReduce(origin, shape, stride);
        }
        return null;
    }

    public Array readCompressedZlib(Variable v2, long dataPos, int nx, int ny, int[] origin, int[] shape, int[] stride, int[] levels) throws IOException, InvalidRangeException {
        this.raf.seek(dataPos);
        int data_size = (int)(this.raf.length() - dataPos);
        byte[] data = new byte[data_size];
        this.raf.readFully(data);
        byte[] uncomp = new byte[nx * ny];
        Inflater inflater = new Inflater(false);
        inflater.setInput(data);
        for (int offset = 0; inflater.getRemaining() > 0 && offset < uncomp.length; offset += inflater.inflate(uncomp, offset, uncomp.length - offset)) {
            try {
                continue;
            }
            catch (DataFormatException ex) {
                System.out.println("ERROR on inflation " + ex.getMessage());
                ex.printStackTrace();
                throw new IOException(ex.getMessage());
            }
        }
        inflater.end();
        Array array = this.makeArray(uncomp, levels, v2.getShape());
        if (levels == null && array.getSize() < (long)Variable.defaultSizeToCache) {
            v2.setCachedData(array, false);
        }
        return array.sectionNoReduce(origin, shape, stride);
    }

    private byte[] getGiniLine(int nx, int ny, long doff, int lineNumber, int len, int stride) throws IOException {
        byte[] data = new byte[len];
        this.raf.seek(doff);
        if (lineNumber >= ny) {
            throw new IOException("Try to access the file at line number= " + lineNumber + " larger then last line number = " + ny);
        }
        int offset = lineNumber * nx + (int)doff;
        for (int i = 0; i < len; ++i) {
            this.raf.seek(offset);
            data[i] = this.raf.readByte();
            offset += stride;
        }
        return data;
    }

    static boolean isZlibHed(byte[] buf) {
        short b0 = DataType.unsignedByteToShort(buf[0]);
        short b1 = DataType.unsignedByteToShort(buf[1]);
        return (b0 & 0xF) == 8 && (b0 >> 4) + 8 <= 15 && ((b0 << 8) + b1) % 31 == 0;
    }

    @Override
    public String getFileTypeId() {
        return DataFormatType.GINI.getDescription();
    }

    @Override
    public String getFileTypeDescription() {
        return "GOES Ingest and NOAAPORT Interface";
    }
}

