/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.latch.LatchContext;
import com.sleepycat.je.utilint.LoggerUtils;

class OwnerInfo {
    private final Thread thread = Thread.currentThread();
    private final long acquireTime = System.currentTimeMillis();
    private final Throwable acquireStack;

    OwnerInfo(LatchContext context) {
        this.acquireStack = new Exception("Latch Acquired: " + context.getLatchName());
    }

    void toString(StringBuilder builder) {
        builder.append(" captureThread: ");
        builder.append(this.thread);
        builder.append(" acquireTime: ");
        builder.append(this.acquireTime);
        if (this.acquireStack != null) {
            builder.append("\n");
            builder.append(LoggerUtils.getStackTrace(this.acquireStack));
        } else {
            builder.append(" -no stack-");
        }
    }
}

