/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util.keyrange;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Get;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.util.keyrange.KeyRange;

public class RangeCursor
implements Cloneable {
    private Cursor cursor;
    private SecondaryCursor secCursor;
    private KeyRange range;
    private KeyRange pkRange;
    private boolean sortedDups;
    private DatabaseEntry privKey;
    private DatabaseEntry privPKey;
    private DatabaseEntry privData;
    private boolean initialized;

    public RangeCursor(KeyRange range, KeyRange pkRange, boolean sortedDups, Cursor cursor) {
        if (pkRange != null && !range.singleKey) {
            throw new IllegalArgumentException();
        }
        this.range = range;
        this.pkRange = pkRange;
        this.sortedDups = sortedDups;
        this.cursor = cursor;
        this.init();
        if (pkRange != null && this.secCursor == null) {
            throw new IllegalArgumentException();
        }
    }

    public RangeCursor dup(boolean samePosition) throws DatabaseException {
        try {
            RangeCursor c = (RangeCursor)super.clone();
            c.cursor = this.dupCursor(this.cursor, samePosition);
            c.init();
            return c;
        }
        catch (CloneNotSupportedException neverHappens) {
            return null;
        }
    }

    private void init() {
        this.secCursor = this.cursor instanceof SecondaryCursor ? (SecondaryCursor)this.cursor : null;
        if (this.range.hasBound()) {
            this.privKey = new DatabaseEntry();
            this.privPKey = new DatabaseEntry();
            this.privData = new DatabaseEntry();
        } else {
            this.privKey = null;
            this.privPKey = null;
            this.privData = null;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    private void setParams(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data) {
        this.privKey = key;
        this.privPKey = pKey;
        this.privData = data;
    }

    private Cursor beginOperation() throws DatabaseException {
        Cursor oldCursor = this.cursor;
        if (this.initialized) {
            this.cursor = this.dupCursor(this.cursor, true);
            if (this.secCursor != null) {
                this.secCursor = (SecondaryCursor)this.cursor;
            }
        } else {
            return this.cursor;
        }
        return oldCursor;
    }

    private void endOperation(Cursor oldCursor, DbCompat.OpResult result, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data) throws DatabaseException {
        if (result.isSuccess()) {
            if (oldCursor != null && oldCursor != this.cursor) {
                this.closeCursor(oldCursor);
            }
            if (key != null) {
                RangeCursor.swapData(key, this.privKey);
            }
            if (pKey != null && this.secCursor != null) {
                RangeCursor.swapData(pKey, this.privPKey);
            }
            if (data != null) {
                RangeCursor.swapData(data, this.privData);
            }
            this.initialized = true;
        } else if (oldCursor != null && oldCursor != this.cursor) {
            this.closeCursor(this.cursor);
            this.cursor = oldCursor;
            if (this.secCursor != null) {
                this.secCursor = (SecondaryCursor)this.cursor;
            }
        }
    }

    private static void swapData(DatabaseEntry e1, DatabaseEntry e2) {
        byte[] d1 = e1.getData();
        int o1 = e1.getOffset();
        int s1 = e1.getSize();
        e1.setData(e2.getData(), e2.getOffset(), e2.getSize());
        e2.setData(d1, o1, s1);
    }

    private static void shareData(DatabaseEntry from, DatabaseEntry to) {
        if (from != null) {
            to.setData(from.getData(), from.getOffset(), from.getSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getFirst(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result;
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            DbCompat.OpResult result2 = this.doGetFirst(options);
            this.endOperation(null, result2, null, null, null);
            return result2;
        }
        if (this.pkRange != null && this.pkRange.isSingleKey()) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            KeyRange.copy(this.pkRange.beginKey, this.privPKey);
            DbCompat.OpResult result3 = this.doGetSearchBoth(options);
            this.endOperation(null, result3, key, pKey, data);
            return result3;
        }
        if (this.pkRange != null) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            result = DbCompat.OpResult.FAILURE;
            Cursor oldCursor = this.beginOperation();
            try {
                if (this.pkRange.beginKey == null || !this.sortedDups) {
                    result = this.doGetSearchKey(options);
                } else {
                    KeyRange.copy(this.pkRange.beginKey, this.privPKey);
                    result = this.doGetSearchBothRange(options);
                    if (result.isSuccess() && !this.pkRange.beginInclusive && this.pkRange.compare(this.privPKey, this.pkRange.beginKey) == 0) {
                        result = this.doGetNextDup(options);
                    }
                }
                if (!result.isSuccess() || this.pkRange.check(this.privPKey)) return result;
                result = DbCompat.OpResult.FAILURE;
                return result;
            }
            finally {
                this.endOperation(oldCursor, result, key, pKey, data);
            }
        }
        if (this.range.singleKey) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            result = this.doGetSearchKey(options);
            this.endOperation(null, result, key, pKey, data);
            return result;
        }
        result = DbCompat.OpResult.FAILURE;
        Cursor oldCursor = this.beginOperation();
        try {
            if (this.range.beginKey == null) {
                result = this.doGetFirst(options);
            } else {
                KeyRange.copy(this.range.beginKey, this.privKey);
                result = this.doGetSearchKeyRange(options);
                if (result.isSuccess() && !this.range.beginInclusive && this.range.compare(this.privKey, this.range.beginKey) == 0) {
                    result = this.doGetNextNoDup(options);
                }
            }
            if (!result.isSuccess() || this.range.check(this.privKey)) return result;
            result = DbCompat.OpResult.FAILURE;
            return result;
        }
        finally {
            this.endOperation(oldCursor, result, key, pKey, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getLast(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result = DbCompat.OpResult.FAILURE;
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            result = this.doGetLast(options);
            this.endOperation(null, result, null, null, null);
            return result;
        }
        Cursor oldCursor = this.beginOperation();
        try {
            if (this.pkRange != null) {
                result = this.getLastInPKeyRange(options);
                if (!(!result.isSuccess() || this.range.check(this.privKey) && this.pkRange.check(this.privPKey))) {
                    result = DbCompat.OpResult.FAILURE;
                }
            } else {
                result = this.getLastInKeyRange(options);
                if (result.isSuccess() && !this.range.check(this.privKey)) {
                    result = DbCompat.OpResult.FAILURE;
                }
            }
            DbCompat.OpResult opResult = result;
            return opResult;
        }
        finally {
            this.endOperation(oldCursor, result, key, pKey, data);
        }
    }

    private DbCompat.OpResult getLastInKeyRange(DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result;
        if (this.range.endKey == null) {
            return this.doGetLast(options);
        }
        do {
            KeyRange.copy(this.range.endKey, this.privKey);
            result = this.doGetSearchKeyRange(options);
            if (result.isSuccess()) {
                if (this.range.endInclusive && this.range.compare(this.range.endKey, this.privKey) == 0) {
                    if (!this.sortedDups) {
                        return result;
                    }
                    result = this.doGetNextNoDup(options);
                    result = result.isSuccess() ? this.doGetPrev(options) : this.doGetLast(options);
                } else {
                    result = this.doGetPrev(options);
                }
            } else {
                result = this.doGetLast(options);
            }
            if (result.isSuccess()) continue;
            return result;
        } while (!this.range.checkEnd(this.privKey, true));
        return result;
    }

    private DbCompat.OpResult getLastInPKeyRange(DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result;
        if (this.pkRange.isSingleKey()) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            KeyRange.copy(this.pkRange.beginKey, this.privPKey);
            return this.doGetSearchBoth(options);
        }
        if (!this.sortedDups) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            return this.doGetSearchKey(options);
        }
        while (true) {
            if (this.pkRange.endKey != null) {
                KeyRange.copy(this.range.beginKey, this.privKey);
                KeyRange.copy(this.pkRange.endKey, this.privPKey);
                result = this.doGetSearchBothRange(options);
                if (result.isSuccess()) {
                    if (!this.pkRange.endInclusive || this.pkRange.compare(this.pkRange.endKey, this.privPKey) != 0) {
                        result = this.doGetPrevDup(options);
                        if (!result.isSuccess()) {
                            return result;
                        }
                        if (!this.pkRange.checkEnd(this.privPKey, true)) continue;
                    }
                    return result;
                }
            }
            KeyRange.copy(this.range.beginKey, this.privKey);
            result = this.doGetSearchKey(options);
            if (!result.isSuccess()) {
                return result;
            }
            result = this.doGetNextNoDup(options);
            result = result.isSuccess() ? this.doGetPrev(options) : this.doGetLast(options);
            if (!result.isSuccess()) {
                return result;
            }
            if (this.range.checkEnd(this.privKey, true)) break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getNext(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result;
        if (!this.initialized) {
            return this.getFirst(key, pKey, data, options);
        }
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            DbCompat.OpResult result2 = this.doGetNext(options);
            this.endOperation(null, result2, null, null, null);
            return result2;
        }
        if (this.pkRange != null) {
            if (this.pkRange.endKey == null) {
                result = this.doGetNextDup(options);
                this.endOperation(null, result, key, pKey, data);
                return result;
            } else {
                result = DbCompat.OpResult.FAILURE;
                Cursor oldCursor = this.beginOperation();
                try {
                    result = this.doGetNextDup(options);
                    if (!result.isSuccess() || this.pkRange.checkEnd(this.privPKey, true)) return result;
                    result = DbCompat.OpResult.FAILURE;
                    return result;
                }
                finally {
                    this.endOperation(oldCursor, result, key, pKey, data);
                }
            }
        }
        if (this.range.singleKey) {
            result = this.doGetNextDup(options);
            this.endOperation(null, result, key, pKey, data);
            return result;
        }
        result = DbCompat.OpResult.FAILURE;
        Cursor oldCursor = this.beginOperation();
        try {
            result = this.doGetNext(options);
            if (!result.isSuccess() || this.range.check(this.privKey)) return result;
            result = DbCompat.OpResult.FAILURE;
            return result;
        }
        finally {
            this.endOperation(oldCursor, result, key, pKey, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getNextNoDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result;
        if (!this.initialized) {
            return this.getFirst(key, pKey, data, options);
        }
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            DbCompat.OpResult result2 = this.doGetNextNoDup(options);
            this.endOperation(null, result2, null, null, null);
            return result2;
        }
        if (this.range.singleKey) {
            result = DbCompat.OpResult.FAILURE;
        } else {
            result = DbCompat.OpResult.FAILURE;
            Cursor oldCursor = this.beginOperation();
            try {
                result = this.doGetNextNoDup(options);
                if (result.isSuccess() && !this.range.check(this.privKey)) {
                    result = DbCompat.OpResult.FAILURE;
                }
            }
            finally {
                this.endOperation(oldCursor, result, key, pKey, data);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getPrev(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result;
        if (!this.initialized) {
            return this.getLast(key, pKey, data, options);
        }
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            DbCompat.OpResult result2 = this.doGetPrev(options);
            this.endOperation(null, result2, null, null, null);
            return result2;
        }
        if (this.pkRange != null) {
            if (this.pkRange.beginKey == null) {
                result = this.doGetPrevDup(options);
                this.endOperation(null, result, key, pKey, data);
                return result;
            } else {
                result = DbCompat.OpResult.FAILURE;
                Cursor oldCursor = this.beginOperation();
                try {
                    result = this.doGetPrevDup(options);
                    if (!result.isSuccess() || this.pkRange.checkBegin(this.privPKey, true)) return result;
                    result = DbCompat.OpResult.FAILURE;
                    return result;
                }
                finally {
                    this.endOperation(oldCursor, result, key, pKey, data);
                }
            }
        }
        if (this.range.singleKey) {
            result = this.doGetPrevDup(options);
            this.endOperation(null, result, key, pKey, data);
            return result;
        }
        result = DbCompat.OpResult.FAILURE;
        Cursor oldCursor = this.beginOperation();
        try {
            result = this.doGetPrev(options);
            if (!result.isSuccess() || this.range.check(this.privKey)) return result;
            result = DbCompat.OpResult.FAILURE;
            return result;
        }
        finally {
            this.endOperation(oldCursor, result, key, pKey, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getPrevNoDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result;
        if (!this.initialized) {
            return this.getLast(key, pKey, data, options);
        }
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            DbCompat.OpResult result2 = this.doGetPrevNoDup(options);
            this.endOperation(null, result2, null, null, null);
            return result2;
        }
        if (this.range.singleKey) {
            result = DbCompat.OpResult.FAILURE;
        } else {
            result = DbCompat.OpResult.FAILURE;
            Cursor oldCursor = this.beginOperation();
            try {
                result = this.doGetPrevNoDup(options);
                if (result.isSuccess() && !this.range.check(this.privKey)) {
                    result = DbCompat.OpResult.FAILURE;
                }
            }
            finally {
                this.endOperation(oldCursor, result, key, pKey, data);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getSearchKey(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result;
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            DbCompat.OpResult result2 = this.doGetSearchKey(options);
            this.endOperation(null, result2, null, null, null);
            return result2;
        }
        if (!this.range.check(key)) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.pkRange != null) {
            result = DbCompat.OpResult.FAILURE;
            Cursor oldCursor = this.beginOperation();
            try {
                RangeCursor.shareData(key, this.privKey);
                result = this.doGetSearchKey(options);
                if (!result.isSuccess()) return result;
                if (this.pkRange.check(this.privPKey)) return result;
                result = DbCompat.OpResult.FAILURE;
                return result;
            }
            finally {
                this.endOperation(oldCursor, result, key, pKey, data);
            }
        } else {
            RangeCursor.shareData(key, this.privKey);
            result = this.doGetSearchKey(options);
            this.endOperation(null, result, key, pKey, data);
        }
        return result;
    }

    public DbCompat.OpResult getSearchBoth(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result;
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            DbCompat.OpResult result2 = this.doGetSearchBoth(options);
            this.endOperation(null, result2, null, null, null);
            return result2;
        }
        if (!this.range.check(key) || this.pkRange != null && !this.pkRange.check(pKey)) {
            result = DbCompat.OpResult.FAILURE;
        } else {
            RangeCursor.shareData(key, this.privKey);
            if (this.secCursor != null) {
                RangeCursor.shareData(pKey, this.privPKey);
            } else {
                RangeCursor.shareData(data, this.privData);
            }
            result = this.doGetSearchBoth(options);
            this.endOperation(null, result, key, pKey, data);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getSearchKeyRange(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result = DbCompat.OpResult.FAILURE;
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            result = this.doGetSearchKeyRange(options);
            this.endOperation(null, result, null, null, null);
            return result;
        }
        Cursor oldCursor = this.beginOperation();
        try {
            RangeCursor.shareData(key, this.privKey);
            result = this.doGetSearchKeyRange(options);
            if (result.isSuccess() && (!this.range.check(this.privKey) || this.pkRange != null && !this.pkRange.check(pKey))) {
                result = DbCompat.OpResult.FAILURE;
            }
        }
        finally {
            this.endOperation(oldCursor, result, key, pKey, data);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getSearchBothRange(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result = DbCompat.OpResult.FAILURE;
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            result = this.doGetSearchBothRange(options);
            this.endOperation(null, result, null, null, null);
            return result;
        }
        Cursor oldCursor = this.beginOperation();
        try {
            RangeCursor.shareData(key, this.privKey);
            if (this.secCursor != null) {
                RangeCursor.shareData(pKey, this.privPKey);
            } else {
                RangeCursor.shareData(data, this.privData);
            }
            result = this.doGetSearchBothRange(options);
            if (result.isSuccess() && (!this.range.check(this.privKey) || this.pkRange != null && !this.pkRange.check(pKey))) {
                result = DbCompat.OpResult.FAILURE;
            }
        }
        finally {
            this.endOperation(oldCursor, result, key, pKey, data);
        }
        return result;
    }

    public DbCompat.OpResult getSearchRecordNumber(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result;
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            DbCompat.OpResult result2 = this.doGetSearchRecordNumber(options);
            this.endOperation(null, result2, null, null, null);
            return result2;
        }
        if (!this.range.check(key)) {
            result = DbCompat.OpResult.FAILURE;
        } else {
            RangeCursor.shareData(key, this.privKey);
            result = this.doGetSearchRecordNumber(options);
            this.endOperation(null, result, key, pKey, data);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getNextDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result;
        if (!this.initialized) {
            throw new IllegalStateException("Cursor not initialized");
        }
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            result = this.doGetNextDup(options);
            this.endOperation(null, result, null, null, null);
            return result;
        } else if (this.pkRange != null && this.pkRange.endKey != null) {
            result = DbCompat.OpResult.FAILURE;
            Cursor oldCursor = this.beginOperation();
            try {
                result = this.doGetNextDup(options);
                if (!result.isSuccess() || this.pkRange.checkEnd(this.privPKey, true)) return result;
                result = DbCompat.OpResult.FAILURE;
                return result;
            }
            finally {
                this.endOperation(oldCursor, result, key, pKey, data);
            }
        } else {
            result = this.doGetNextDup(options);
            this.endOperation(null, result, key, pKey, data);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getPrevDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, DbCompat.OpReadOptions options) throws DatabaseException {
        DbCompat.OpResult result;
        if (!this.initialized) {
            throw new IllegalStateException("Cursor not initialized");
        }
        if (!this.range.hasBound()) {
            this.setParams(key, pKey, data);
            result = this.doGetPrevDup(options);
            this.endOperation(null, result, null, null, null);
            return result;
        } else if (this.pkRange != null && this.pkRange.beginKey != null) {
            result = DbCompat.OpResult.FAILURE;
            Cursor oldCursor = this.beginOperation();
            try {
                result = this.doGetPrevDup(options);
                if (!result.isSuccess() || this.pkRange.checkBegin(this.privPKey, true)) return result;
                result = DbCompat.OpResult.FAILURE;
                return result;
            }
            finally {
                this.endOperation(oldCursor, result, key, pKey, data);
            }
        } else {
            result = this.doGetPrevDup(options);
            this.endOperation(null, result, key, pKey, data);
        }
        return result;
    }

    public DbCompat.OpResult getCurrent(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, DbCompat.OpReadOptions options) throws DatabaseException {
        if (!this.initialized) {
            throw new IllegalStateException("Cursor not initialized");
        }
        if (this.secCursor != null && pKey != null) {
            return DbCompat.OpResult.make(this.secCursor.get(key, pKey, data, Get.CURRENT, options.jeOptions));
        }
        return DbCompat.OpResult.make(this.cursor.get(key, data, Get.CURRENT, options.jeOptions));
    }

    public void close() throws DatabaseException {
        this.closeCursor(this.cursor);
    }

    public int count() throws DatabaseException {
        return this.cursor.count();
    }

    public OperationStatus delete() throws DatabaseException {
        return this.cursor.delete();
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return this.cursor.put(key, data);
    }

    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return this.cursor.putNoOverwrite(key, data);
    }

    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return this.cursor.putNoDupData(key, data);
    }

    public OperationStatus putCurrent(DatabaseEntry data) throws DatabaseException {
        return this.cursor.putCurrent(data);
    }

    public OperationStatus putAfter(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return DbCompat.putAfter(this.cursor, key, data);
    }

    public OperationStatus putBefore(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return DbCompat.putBefore(this.cursor, key, data);
    }

    private DbCompat.OpResult doGetFirst(DbCompat.OpReadOptions options) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.get(this.privKey, this.privPKey, this.privData, Get.FIRST, options.jeOptions));
        }
        return DbCompat.OpResult.make(this.cursor.get(this.privKey, this.privData, Get.FIRST, options.jeOptions));
    }

    private DbCompat.OpResult doGetLast(DbCompat.OpReadOptions options) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.get(this.privKey, this.privPKey, this.privData, Get.LAST, options.jeOptions));
        }
        return DbCompat.OpResult.make(this.cursor.get(this.privKey, this.privData, Get.LAST, options.jeOptions));
    }

    private DbCompat.OpResult doGetNext(DbCompat.OpReadOptions options) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.get(this.privKey, this.privPKey, this.privData, Get.NEXT, options.jeOptions));
        }
        return DbCompat.OpResult.make(this.cursor.get(this.privKey, this.privData, Get.NEXT, options.jeOptions));
    }

    private DbCompat.OpResult doGetNextDup(DbCompat.OpReadOptions options) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.get(this.privKey, this.privPKey, this.privData, Get.NEXT_DUP, options.jeOptions));
        }
        return DbCompat.OpResult.make(this.cursor.get(this.privKey, this.privData, Get.NEXT_DUP, options.jeOptions));
    }

    private DbCompat.OpResult doGetNextNoDup(DbCompat.OpReadOptions options) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.get(this.privKey, this.privPKey, this.privData, Get.NEXT_NO_DUP, options.jeOptions));
        }
        return DbCompat.OpResult.make(this.cursor.get(this.privKey, this.privData, Get.NEXT_NO_DUP, options.jeOptions));
    }

    private DbCompat.OpResult doGetPrev(DbCompat.OpReadOptions options) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.get(this.privKey, this.privPKey, this.privData, Get.PREV, options.jeOptions));
        }
        return DbCompat.OpResult.make(this.cursor.get(this.privKey, this.privData, Get.PREV, options.jeOptions));
    }

    private DbCompat.OpResult doGetPrevDup(DbCompat.OpReadOptions options) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.get(this.privKey, this.privPKey, this.privData, Get.PREV_DUP, options.jeOptions));
        }
        return DbCompat.OpResult.make(this.cursor.get(this.privKey, this.privData, Get.PREV_DUP, options.jeOptions));
    }

    private DbCompat.OpResult doGetPrevNoDup(DbCompat.OpReadOptions options) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.get(this.privKey, this.privPKey, this.privData, Get.PREV_NO_DUP, options.jeOptions));
        }
        return DbCompat.OpResult.make(this.cursor.get(this.privKey, this.privData, Get.PREV_NO_DUP, options.jeOptions));
    }

    private DbCompat.OpResult doGetSearchKey(DbCompat.OpReadOptions options) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.get(this.privKey, this.privPKey, this.privData, Get.SEARCH, options.jeOptions));
        }
        return DbCompat.OpResult.make(this.cursor.get(this.privKey, this.privData, Get.SEARCH, options.jeOptions));
    }

    private DbCompat.OpResult doGetSearchKeyRange(DbCompat.OpReadOptions options) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.get(this.privKey, this.privPKey, this.privData, Get.SEARCH_GTE, options.jeOptions));
        }
        return DbCompat.OpResult.make(this.cursor.get(this.privKey, this.privData, Get.SEARCH_GTE, options.jeOptions));
    }

    private DbCompat.OpResult doGetSearchBoth(DbCompat.OpReadOptions options) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.get(this.privKey, this.privPKey, this.privData, Get.SEARCH_BOTH, options.jeOptions));
        }
        return DbCompat.OpResult.make(this.cursor.get(this.privKey, this.privData, Get.SEARCH_BOTH, options.jeOptions));
    }

    private DbCompat.OpResult doGetSearchBothRange(DbCompat.OpReadOptions options) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.get(this.privKey, this.privPKey, this.privData, Get.SEARCH_BOTH_GTE, options.jeOptions));
        }
        return DbCompat.OpResult.make(this.cursor.get(this.privKey, this.privData, Get.SEARCH_BOTH_GTE, options.jeOptions));
    }

    private DbCompat.OpResult doGetSearchRecordNumber(DbCompat.OpReadOptions options) throws DatabaseException {
        if (DbCompat.getRecordNumber(this.privKey) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(DbCompat.getSearchRecordNumber(this.secCursor, this.privKey, this.privPKey, this.privData, options.getLockMode()));
        }
        return DbCompat.OpResult.make(DbCompat.getSearchRecordNumber(this.cursor, this.privKey, this.privData, options.getLockMode()));
    }

    protected Cursor dupCursor(Cursor cursor, boolean samePosition) throws DatabaseException {
        return cursor.dup(samePosition);
    }

    protected void closeCursor(Cursor cursor) throws DatabaseException {
        cursor.close();
    }

    protected boolean checkRecordNumber() {
        return false;
    }
}

