/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.codestream.reader;

import java.io.IOException;
import ucar.jpeg.jj2000.j2k.codestream.reader.PktHeaderBitReader;
import ucar.jpeg.jj2000.j2k.util.ArrayUtil;

public class TagTreeDecoder {
    protected int w;
    protected int h;
    protected int lvls;
    protected int[][] treeV;
    protected int[][] treeS;

    public TagTreeDecoder(int h2, int w) {
        if (w < 0 || h2 < 0) {
            throw new IllegalArgumentException();
        }
        this.w = w;
        this.h = h2;
        if (w == 0 || h2 == 0) {
            this.lvls = 0;
        } else {
            this.lvls = 1;
            while (h2 != 1 || w != 1) {
                w = w + 1 >> 1;
                h2 = h2 + 1 >> 1;
                ++this.lvls;
            }
        }
        this.treeV = new int[this.lvls][];
        this.treeS = new int[this.lvls][];
        w = this.w;
        h2 = this.h;
        for (int i = 0; i < this.lvls; ++i) {
            this.treeV[i] = new int[h2 * w];
            ArrayUtil.intArraySet(this.treeV[i], Integer.MAX_VALUE);
            this.treeS[i] = new int[h2 * w];
            w = w + 1 >> 1;
            h2 = h2 + 1 >> 1;
        }
    }

    public final int getWidth() {
        return this.w;
    }

    public final int getHeight() {
        return this.h;
    }

    public int update(int m3, int n, int t, PktHeaderBitReader in) throws IOException {
        int tv;
        if (m3 >= this.h || n >= this.w || t < 0) {
            throw new IllegalArgumentException();
        }
        int k = this.lvls - 1;
        int tmin = this.treeS[k][0];
        int idx = (m3 >> k) * (this.w + (1 << k) - 1 >> k) + (n >> k);
        while (true) {
            int ts = this.treeS[k][idx];
            tv = this.treeV[k][idx];
            if (ts < tmin) {
                ts = tmin;
            }
            while (t > ts) {
                if (tv >= ts) {
                    if (in.readBit() == 0) {
                        ++ts;
                        continue;
                    }
                    tv = ts++;
                    continue;
                }
                ts = t;
                break;
            }
            this.treeS[k][idx] = ts;
            this.treeV[k][idx] = tv;
            if (k <= 0) break;
            tmin = ts < tv ? ts : tv;
            idx = (m3 >> --k) * (this.w + (1 << k) - 1 >> k) + (n >> k);
        }
        return tv;
    }

    public int getValue(int m3, int n) {
        if (m3 >= this.h || n >= this.w) {
            throw new IllegalArgumentException();
        }
        return this.treeV[0][m3 * this.w + n];
    }
}

