/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribLevelType;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib1.tables.NcepTables;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.Grib2Table;
import ucar.nc2.grib.grib2.table.LocalTables;
import ucar.nc2.grib.grib2.table.NcepLocalParams;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.nc2.time.CalendarPeriod;

public class NcepLocalTables
extends LocalTables {
    private static final Logger logger = LoggerFactory.getLogger(NcepLocalTables.class);
    private static final String defaultResourcePath = "resources/grib2/ncep/v21.0.0/";
    private static NcepLocalTables single;
    protected final NcepLocalParams params;
    private static Map<Integer, String> statName;
    private static Map<Integer, String> genProcessMap;
    private Map<String, String> codeMap = new HashMap<String, String>(400);

    public static Grib2Customizer getCust(Grib2Table table) {
        if (single == null) {
            single = new NcepLocalTables(table);
        }
        return single;
    }

    NcepLocalTables(Grib2Table grib2Table) {
        super(grib2Table);
        if (grib2Table.getPath() == null) {
            grib2Table.setPath(defaultResourcePath);
        }
        this.params = new NcepLocalParams(grib2Table.getPath());
        this.initCodes();
    }

    @Override
    public String getTablePath(int discipline, int category, int number) {
        if (category <= 191 && number <= 191) {
            return super.getTablePath(discipline, category, number);
        }
        return this.params.getTablePath(discipline, category);
    }

    private String[] getResourceListing(String path) throws URISyntaxException, IOException {
        Class<?> clazz = this.getClass();
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL == null) {
            throw new UnsupportedOperationException("Cannot list files for path " + path);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path)) continue;
                String entry = name.substring(path.length());
                int checkSubdir = entry.indexOf("/");
                if (checkSubdir >= 0) {
                    entry = entry.substring(0, checkSubdir);
                }
                result.add(entry);
            }
            return result.toArray(new String[result.size()]);
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }

    @Override
    public List<GribTables.Parameter> getParameters() {
        ArrayList<GribTables.Parameter> allParams = new ArrayList<GribTables.Parameter>(3000);
        try {
            String[] fileNames;
            for (String fileName : fileNames = this.getResourceListing(this.grib2Table.getPath())) {
                File f = new File(fileName);
                if (f.isDirectory() || !f.getName().contains("Table4.2.") || !f.getName().endsWith(".xml")) continue;
                try {
                    NcepLocalParams.Table table = this.params.factory(this.grib2Table.getPath() + f.getPath());
                    if (table == null) continue;
                    allParams.addAll(table.getParameters());
                }
                catch (Exception e) {
                    System.out.printf("Error reading wmo tables = %s%n", e.getMessage());
                }
            }
            return allParams;
        }
        catch (IOException | URISyntaxException e) {
            System.out.println(e);
            return null;
        }
    }

    public void showCfsr(Grib2Pds pds, Formatter f) {
        if (!pds.isTimeInterval()) {
            return;
        }
        if (pds.getRawLength() < 65) {
            return;
        }
        int statType = pds.getOctet(47);
        int statType2 = pds.getOctet(59);
        int ngrids = GribNumbers.int4(pds.getOctet(50), pds.getOctet(51), pds.getOctet(52), pds.getOctet(53));
        int p2 = GribNumbers.int4(pds.getOctet(55), pds.getOctet(56), pds.getOctet(57), pds.getOctet(58));
        int p2mp1 = GribNumbers.int4(pds.getOctet(62), pds.getOctet(63), pds.getOctet(64), pds.getOctet(65));
        f.format("%nCFSR MM special encoding (NCAR)%n", new Object[0]);
        f.format("  (47) Code Table 4.10 = %d%n", statType);
        f.format("  (50-53) N in avg     = %d%n", ngrids);
        f.format("  (55-58) Grib1 P2     = %d%n", p2);
        f.format("  (59) Code Table 4.10 = %d%n", statType2);
        f.format("  (62-65) P2 minus P1  = %d%n", p2mp1);
        f.format("%nCFSR MM special encoding (Swank)%n", new Object[0]);
        f.format("  (55-58) length of avg period per unit                     = %d%n", p2);
        f.format("  (62-65) hours skipped between each calculation component  = %d%n", p2mp1);
        f.format("  nhours in month %d should be  = %d%n", ngrids * p2, 744);
    }

    @Override
    public TimeCoord.TinvDate getForecastTimeInterval(Grib2Record gr) {
        Grib2Pds pds = gr.getPDS();
        if (!pds.isTimeInterval()) {
            return null;
        }
        if (!this.isCfsr(pds)) {
            return super.getForecastTimeInterval(gr);
        }
        CalendarPeriod period = CalendarPeriod.of(6, CalendarPeriod.Field.Hour);
        return new TimeCoord.TinvDate(gr.getReferenceDate(), period);
    }

    @Override
    public double getForecastTimeIntervalSizeInHours(Grib2Pds pds) {
        if (!this.isCfsr(pds)) {
            return super.getForecastTimeIntervalSizeInHours(pds);
        }
        return 6.0;
    }

    private boolean isCfsr(Grib2Pds pds) {
        int genType = pds.getGenProcessId();
        if (genType != 82 && genType != 89) {
            return false;
        }
        Grib2Pds.PdsInterval pdsIntv = (Grib2Pds.PdsInterval)((Object)pds);
        Grib2Pds.TimeInterval[] ti = pdsIntv.getTimeIntervals();
        return ti.length != 1;
    }

    @Override
    public String getVariableName(int discipline, int category, int parameter) {
        if (category <= 191 && parameter <= 191) {
            return super.getVariableName(discipline, category, parameter);
        }
        GribTables.Parameter te = this.getParameter(discipline, category, parameter);
        if (te == null) {
            return super.getVariableName(discipline, category, parameter);
        }
        return te.getName();
    }

    @Override
    public GribTables.Parameter getParameter(int discipline, int category, int number) {
        Grib2Parameter plocal = this.params.getParameter(discipline, category, number);
        if (category <= 191 && number <= 191) {
            WmoCodeTable.TableEntry pwmo = WmoCodeTable.getParameterEntry(discipline, category, number);
            if (plocal == null) {
                return pwmo;
            }
            if (pwmo != null) {
                return new Grib2Parameter(plocal, pwmo.getName(), pwmo.getUnit());
            }
        }
        return plocal;
    }

    @Override
    public GribTables.Parameter getParameterRaw(int discipline, int category, int number) {
        return this.params.getParameter(discipline, category, number);
    }

    @Override
    public String getTableValue(String tableName, int code) {
        if (tableName.equals("ProcessId")) {
            return this.getGeneratingProcessName(code);
        }
        if (code < 192 || code > 254 || tableName.equals("4.0")) {
            return WmoCodeTable.getTableValue(tableName, code);
        }
        return this.codeMap.get(tableName + "." + code);
    }

    @Override
    public VertCoord.VertUnit getVertUnit(int code) {
        switch (code) {
            case 235: {
                return new GribLevelType(code, "0.1 C", null, true);
            }
            case 237: {
                return new GribLevelType(code, "m", null, true);
            }
            case 238: {
                return new GribLevelType(code, "m", null, true);
            }
            case 241: {
                return new GribLevelType(code, "count", null, true);
            }
        }
        return super.getVertUnit(code);
    }

    @Override
    public String getLevelNameShort(int id) {
        switch (id) {
            case 200: {
                return "entire_atmosphere_single_layer";
            }
            case 201: {
                return "entire_ocean_single_layer";
            }
            case 204: {
                return "highest_tropospheric_freezing";
            }
            case 206: {
                return "grid_scale_cloud_bottom";
            }
            case 207: {
                return "grid_scale_cloud_top";
            }
            case 209: {
                return "boundary_layer_cloud_bottom";
            }
            case 210: {
                return "boundary_layer_cloud_top";
            }
            case 211: {
                return "boundary_layer_cloud";
            }
            case 212: {
                return "low_cloud_bottom";
            }
            case 213: {
                return "low_cloud_top";
            }
            case 214: {
                return "low_cloud";
            }
            case 215: {
                return "cloud_ceiling";
            }
            case 220: {
                return "planetary_boundary";
            }
            case 221: {
                return "between_two_hybrids";
            }
            case 222: {
                return "middle_cloud_bottom";
            }
            case 223: {
                return "middle_cloud_top";
            }
            case 224: {
                return "middle_cloud";
            }
            case 232: {
                return "high_cloud_bottom";
            }
            case 233: {
                return "high_cloud_top";
            }
            case 234: {
                return "high_cloud";
            }
            case 235: {
                return "ocean_isotherm";
            }
            case 236: {
                return "layer_between_two_depths_below_ocean";
            }
            case 237: {
                return "bottom_of_ocean_mixed";
            }
            case 238: {
                return "bottom_of_ocean_isothermal";
            }
            case 239: {
                return "ocean_surface_and_26C_isothermal";
            }
            case 240: {
                return "ocean_mixed";
            }
            case 241: {
                return "ordered_sequence_of_data";
            }
            case 242: {
                return "convective_cloud_bottom";
            }
            case 243: {
                return "convective_cloud_top";
            }
            case 244: {
                return "convective_cloud";
            }
            case 245: {
                return "lowest_level_of_the_wet_bulb_zero";
            }
            case 246: {
                return "maximum_equivalent_potential_temperature";
            }
            case 247: {
                return "equilibrium";
            }
            case 248: {
                return "shallow_convective_cloud_bottom";
            }
            case 249: {
                return "shallow_convective_cloud_top";
            }
            case 251: {
                return "deep_convective_cloud_bottom";
            }
            case 252: {
                return "deep_convective_cloud_top";
            }
            case 253: {
                return "lowest_level_water_layer";
            }
            case 254: {
                return "highest_level_water_layer";
            }
        }
        return super.getLevelNameShort(id);
    }

    @Override
    public String getStatisticNameShort(int id) {
        switch (id) {
            case 192: {
                return "ClimatologicalMeanValue";
            }
            case 193: {
                return "AverageNforecasts";
            }
            case 194: {
                return "AverageNanalysis";
            }
            case 195: {
                return "AverageAccum-24hourIntv";
            }
            case 196: {
                return "AverageForecastSuccessiveAccumulations";
            }
            case 197: {
                return "AverageAvg-24hourIntv";
            }
            case 198: {
                return "AverageForecastSuccessiveAverages";
            }
            case 199: {
                return "ClimatologicalAverageNanalysis";
            }
            case 200: {
                return "ClimatologicalAverageNforecasts";
            }
            case 201: {
                return "ClimatologicalRMSdiffNforecasts";
            }
            case 202: {
                return "ClimatologicalStandardDeviationNforecasts";
            }
            case 203: {
                return "ClimatologicalStandardDeviationNanalyses";
            }
            case 204: {
                return "AverageForecastAccumulations-204";
            }
            case 205: {
                return "AverageAvg-6hourIntv";
            }
            case 206: {
                return "AverageForecastAccumulations-206";
            }
            case 207: {
                return "AverageForecastAverages-207";
            }
            case 255: {
                return "Interval";
            }
        }
        return super.getStatisticNameShort(id);
    }

    @Override
    public GribStatType getStatType(int id) {
        if (id < 192) {
            return super.getStatType(id);
        }
        switch (id) {
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                return GribStatType.Average;
            }
            case 201: {
                return GribStatType.RootMeanSquare;
            }
            case 202: 
            case 203: {
                return GribStatType.StandardDeviation;
            }
        }
        return null;
    }

    @Override
    public String getStatisticName(int id) {
        if (id < 192) {
            return super.getStatisticName(id);
        }
        if (statName == null) {
            statName = this.initTable410();
        }
        if (statName == null) {
            return null;
        }
        return statName.get(id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Integer, String> initTable410() {
        String path = this.grib2Table.getPath() + "Table4.10.xml";
        try (InputStream is = GribResourceReader.getInputStream(path);){
            if (is == null) {
                logger.error("Cant find = " + path);
                Map<Integer, String> map = null;
                return map;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            HashMap<Integer, String> result = new HashMap<Integer, String>(200);
            List<Element> params = root.getChildren("parameter");
            for (Element elem1 : params) {
                int code = Integer.parseInt(elem1.getAttributeValue("code"));
                String desc = elem1.getChildText("description");
                result.put(code, desc);
            }
            HashMap<Integer, String> hashMap = result;
            return hashMap;
        }
        catch (IOException ioe) {
            logger.error("Cant read  " + path, ioe);
            return null;
        }
        catch (JDOMException e) {
            logger.error("Cant parse = " + path, e);
            return null;
        }
    }

    @Override
    public String getGeneratingProcessName(int genProcess) {
        if (genProcessMap == null) {
            genProcessMap = NcepTables.getNcepGenProcess();
        }
        if (genProcessMap == null) {
            return null;
        }
        return genProcessMap.get(genProcess);
    }

    @Override
    public String getCategory(int discipline, int category) {
        String catName = this.params.getCategory(discipline, category);
        if (catName != null) {
            return catName;
        }
        return super.getCategory(discipline, category);
    }

    private Map<String, String> initCodes() {
        this.codeMap.put("3.1.204", "Curvilinear_Orthogonal");
        this.codeMap.put("4.3.192", "Forecast Confidence Indicator");
        this.codeMap.put("4.3.193", "Bias Corrected Ensemble Forecast");
        this.codeMap.put("4.5.200", "Entire atmosphere layer");
        this.codeMap.put("4.5.201", "Entire ocean layer");
        this.codeMap.put("4.5.204", "Highest tropospheric freezing level");
        this.codeMap.put("4.5.206", "Grid scale cloud bottom level");
        this.codeMap.put("4.5.207", "Grid scale cloud top level");
        this.codeMap.put("4.5.209", "Boundary layer cloud bottom level");
        this.codeMap.put("4.5.210", "Boundary layer cloud top level");
        this.codeMap.put("4.5.211", "Boundary layer cloud layer");
        this.codeMap.put("4.5.212", "Low cloud bottom level");
        this.codeMap.put("4.5.213", "Low cloud top level");
        this.codeMap.put("4.5.214", "Low cloud layer");
        this.codeMap.put("4.5.215", "Cloud ceiling");
        this.codeMap.put("4.5.220", "Planetary Boundary Layer");
        this.codeMap.put("4.5.221", "Layer Between Two Hybrid Levels");
        this.codeMap.put("4.5.222", "Middle cloud bottom level");
        this.codeMap.put("4.5.223", "Middle cloud top level");
        this.codeMap.put("4.5.224", "Middle cloud layer");
        this.codeMap.put("4.5.232", "High cloud bottom level");
        this.codeMap.put("4.5.233", "High cloud top level");
        this.codeMap.put("4.5.234", "High cloud layer");
        this.codeMap.put("4.5.235", "Ocean isotherm level");
        this.codeMap.put("4.5.236", "Layer between two depths below ocean surface");
        this.codeMap.put("4.5.237", "Bottom of ocean mixed layer");
        this.codeMap.put("4.5.238", "Bottom of ocean isothermal layer");
        this.codeMap.put("4.5.239", "Layer Ocean Surface and 26C Ocean Isothermal Level");
        this.codeMap.put("4.5.240", "Ocean Mixed Layer");
        this.codeMap.put("4.5.241", "Ordered Sequence of Data");
        this.codeMap.put("4.5.242", "Convective cloud bottom level");
        this.codeMap.put("4.5.243", "Convective cloud top level");
        this.codeMap.put("4.5.244", "Convective cloud layer");
        this.codeMap.put("4.5.245", "Lowest level of the wet bulb zero");
        this.codeMap.put("4.5.246", "Maximum equivalent potential temperature level");
        this.codeMap.put("4.5.247", "Equilibrium level");
        this.codeMap.put("4.5.248", "Shallow convective cloud bottom level");
        this.codeMap.put("4.5.249", "Shallow convective cloud top level");
        this.codeMap.put("4.5.251", "Deep convective cloud bottom level");
        this.codeMap.put("4.5.252", "Deep convective cloud top level");
        this.codeMap.put("4.5.253", "Lowest bottom level of supercooled liquid water layer");
        this.codeMap.put("4.5.254", "Highest top level of supercooled liquid water layer");
        this.codeMap.put("4.6.192", "Perturbed Ensemble Member");
        this.codeMap.put("4.7.192", "Unweighted Mode of All Members");
        this.codeMap.put("4.7.193", "Percentile value (10%) of All Members");
        this.codeMap.put("4.7.194", "Percentile value (50%) of All Members");
        this.codeMap.put("4.7.195", "Percentile value (90%) of All Members");
        this.codeMap.put("4.10.192", "Climatological Mean Value");
        this.codeMap.put("4.10.193", "Average of N forecasts");
        this.codeMap.put("4.10.194", "Average of N uninitialized analyses");
        this.codeMap.put("4.10.195", "Average of forecast accumulations");
        this.codeMap.put("4.10.196", "Average of successive forecast accumulations");
        this.codeMap.put("4.10.197", "Average of forecast averages");
        this.codeMap.put("4.10.198", "Average of successive forecast averages");
        this.codeMap.put("4.10.199", "Climatological Average of N analyses, each a year apart");
        this.codeMap.put("4.10.200", "Climatological Average of N forecasts, each a year apart");
        this.codeMap.put("4.10.201", "Climatological Root Mean Square difference between N forecasts and their verifying analyses, each a year apart");
        this.codeMap.put("4.10.202", "Climatological Standard Deviation of N forecasts from the mean of the same N forecasts, for forecasts one year apart");
        this.codeMap.put("4.10.203", "Climatological Standard Deviation of N analyses from the mean of the same N analyses, for analyses one year apart");
        this.codeMap.put("4.10.204", "Average of forecast accumulations");
        this.codeMap.put("4.10.205", "Average of forecast averages");
        this.codeMap.put("4.10.206", "Average of forecast accumulations");
        this.codeMap.put("4.10.207", "Average of forecast averages");
        return this.codeMap;
    }
}

