/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import thredds.client.catalog.Catalog;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CDM;
import ucar.nc2.ncml.NcMLReader;

public class NcmlConstructor {
    private static final boolean validate = false;
    private static final boolean debugConstruct = false;
    private static final boolean showParsedXML = false;
    private Formatter errlog = new Formatter();

    public Formatter getErrlog() {
        return this.errlog;
    }

    public boolean populateFromResource(String resourceLocation, NetcdfFile target) throws IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(resourceLocation);
        if (is == null) {
            throw new FileNotFoundException(resourceLocation);
        }
        return this.populate(is, target);
    }

    public boolean populate(String ncml, NetcdfFile target) throws IOException {
        return this.populate(new ByteArrayInputStream(ncml.getBytes(CDM.utf8Charset)), target);
    }

    public boolean populate(InputStream ncml, NetcdfFile target) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder(false);
            doc = builder.build(ncml);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        Element netcdfElem = doc.getRootElement();
        this.readGroup(target, target.getRootGroup(), netcdfElem);
        return this.errlog.toString().length() == 0;
    }

    private void readGroup(NetcdfFile ncfile, Group parent, Element groupElem) throws IOException {
        Group g2;
        String name = groupElem.getAttributeValue("name");
        if (parent == ncfile.getRootGroup()) {
            Group g22 = parent;
        } else {
            if (name == null) {
                this.errlog.format("NcML Group name is required (%s)%n", groupElem);
                return;
            }
            g2 = new Group(ncfile, parent, name);
            parent.addGroup(g2);
        }
        List<Element> attList = groupElem.getChildren("attribute", Catalog.ncmlNS);
        for (Element element : attList) {
            this.readAtt(g2, element);
        }
        List<Element> dimList = groupElem.getChildren("dimension", Catalog.ncmlNS);
        for (Element element : dimList) {
            this.readDim(g2, element);
        }
        List<Element> list = groupElem.getChildren("variable", Catalog.ncmlNS);
        for (Element varElem : list) {
            this.readVariable(ncfile, g2, null, varElem);
        }
        List<Element> list2 = groupElem.getChildren("group", Catalog.ncmlNS);
        for (Element gElem : list2) {
            this.readGroup(ncfile, g2, gElem);
        }
    }

    private Variable readVariable(NetcdfFile ncfile, Group g2, Structure parentS, Element varElem) {
        List<Element> varList;
        Variable v;
        Structure s2;
        String name = varElem.getAttributeValue("name");
        if (name == null) {
            this.errlog.format("NcML Variable name is required (%s)%n", varElem);
            return null;
        }
        String type = varElem.getAttributeValue("type");
        if (type == null) {
            this.errlog.format("NcML variable (%s) must have type attribute", name);
            return null;
        }
        DataType dtype = DataType.getType(type);
        String shape = varElem.getAttributeValue("shape");
        if (shape == null) {
            shape = "";
        }
        if (dtype == DataType.STRUCTURE) {
            s2 = new Structure(ncfile, g2, parentS, name);
            s2.setDimensions(shape);
            v = s2;
            varList = varElem.getChildren("variable", Catalog.ncmlNS);
            for (Element vElem : varList) {
                this.readVariable(ncfile, g2, s2, vElem);
            }
        } else if (dtype == DataType.SEQUENCE) {
            v = s2 = new Sequence(ncfile, g2, parentS, name);
            varList = varElem.getChildren("variable", Catalog.ncmlNS);
            for (Element vElem : varList) {
                this.readVariable(ncfile, g2, s2, vElem);
            }
        } else {
            v = new Variable(ncfile, g2, parentS, name, dtype, shape);
            Element valueElem = varElem.getChild("values", Catalog.ncmlNS);
            if (valueElem != null) {
                this.readValues(v, varElem, valueElem);
            }
        }
        List<Element> attList = varElem.getChildren("attribute", Catalog.ncmlNS);
        for (Element attElem : attList) {
            this.readAtt(v, attElem);
        }
        if (parentS != null) {
            parentS.addMemberVariable(v);
        } else {
            g2.addVariable(v);
        }
        return v;
    }

    private void readValues(Variable v, Element varElem, Element valuesElem) {
        int npts;
        String startS = valuesElem.getAttributeValue("start");
        String incrS = valuesElem.getAttributeValue("increment");
        String nptsS = valuesElem.getAttributeValue("npts");
        int n = npts = nptsS == null ? (int)v.getSize() : Integer.parseInt(nptsS);
        if (startS != null && incrS != null) {
            double start = Double.parseDouble(startS);
            double incr = Double.parseDouble(incrS);
            v.setValues(npts, start, incr);
            return;
        }
        String values = varElem.getChildText("values", Catalog.ncmlNS);
        String sep = valuesElem.getAttributeValue("separator");
        if (sep == null) {
            sep = " ";
        }
        if (v.getDataType() == DataType.CHAR) {
            int nhave = values.length();
            int nwant = (int)v.getSize();
            char[] data = new char[nwant];
            int min2 = Math.min(nhave, nwant);
            for (int i = 0; i < min2; ++i) {
                data[i] = values.charAt(i);
            }
            Array dataArray = Array.factory(DataType.CHAR.getPrimitiveClassType(), v.getShape(), (Object)data);
            v.setCachedData(dataArray, true);
        } else {
            ArrayList<String> valList = new ArrayList<String>();
            StringTokenizer tokn = new StringTokenizer(values, sep);
            while (tokn.hasMoreTokens()) {
                valList.add(tokn.nextToken());
            }
            v.setValues(valList);
        }
    }

    private void readAtt(Object parent, Element attElem) {
        String name = attElem.getAttributeValue("name");
        if (name == null) {
            this.errlog.format("NcML Attribute name is required (%s)%n", attElem);
            return;
        }
        try {
            Array values = NcMLReader.readAttributeValues(attElem);
            Attribute att = new Attribute(name, values);
            if (parent instanceof Group) {
                ((Group)parent).addAttribute(att);
            } else if (parent instanceof Variable) {
                ((Variable)parent).addAttribute(att);
            }
        }
        catch (RuntimeException e) {
            this.errlog.format("NcML new Attribute Exception: %s att=%s in=%s%n", e.getMessage(), name, parent);
        }
    }

    private void readDim(Group g2, Element dimElem) {
        String name = dimElem.getAttributeValue("name");
        if (name == null) {
            this.errlog.format("NcML Dimension name is required (%s)%n", dimElem);
            return;
        }
        String lengthS = dimElem.getAttributeValue("length");
        String isUnlimitedS = dimElem.getAttributeValue("isUnlimited");
        String isSharedS = dimElem.getAttributeValue("isShared");
        String isUnknownS = dimElem.getAttributeValue("isVariableLength");
        boolean isUnlimited = isUnlimitedS != null && isUnlimitedS.equalsIgnoreCase("true");
        boolean isUnknown = isUnknownS != null && isUnknownS.equalsIgnoreCase("true");
        boolean isShared = true;
        if (isSharedS != null && isSharedS.equalsIgnoreCase("false")) {
            isShared = false;
        }
        int len = Integer.parseInt(lengthS);
        if (isUnknownS != null && isUnknownS.equalsIgnoreCase("false")) {
            len = Dimension.VLEN.getLength();
        }
        Dimension dim = new Dimension(name, len, isShared, isUnlimited, isUnknown);
        g2.addDimension(dim);
    }
}

