/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.codec.PackbitsCodec;

public class PSDReader
extends FormatReader {
    private byte[][] lut;

    public PSDReader() {
        super("Adobe Photoshop", "psd");
    }

    public boolean isThisType(byte[] block) {
        return new String(block).startsWith("8BPS");
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        boolean compressed;
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        if (this.in.getFilePointer() % 2L == 1L) {
            this.in.skipBytes(1);
        }
        this.in.skipBytes(4);
        while (this.in.read() != 56) {
        }
        this.in.skipBytes(7);
        int len = this.in.readInt();
        this.in.skipBytes(len);
        while (this.in.readString(4).equals("8BIM")) {
            this.in.skipBytes(4);
            len = this.in.readInt();
            this.in.skipBytes(len);
        }
        this.in.seek(this.in.getFilePointer() - 4L);
        int plane = this.core.sizeX[0] * this.core.sizeY[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0]);
        int[][] lens = new int[this.core.sizeC[0]][this.core.sizeY[0]];
        boolean bl = compressed = this.in.readShort() == 1;
        if (compressed) {
            int y;
            int c;
            int pt = 0;
            PackbitsCodec codec = new PackbitsCodec();
            for (c = 0; c < this.core.sizeC[0]; ++c) {
                for (y = 0; y < this.core.sizeY[0]; ++y) {
                    lens[c][y] = this.in.readShort();
                }
            }
            for (c = 0; c < this.core.sizeC[0]; ++c) {
                for (y = 0; y < this.core.sizeY[0]; ++y) {
                    byte[] b = new byte[lens[c][y]];
                    this.in.read(b);
                    b = codec.decompress(b);
                    System.arraycopy(b, 0, buf, pt, b.length);
                    pt += b.length;
                }
            }
        } else {
            this.in.read(buf);
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        if (debug) {
            this.debug("PSDReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.core.littleEndian[0] = false;
        if (!this.in.readString(4).equals("8BPS")) {
            throw new FormatException("Not a valid Photoshop file.");
        }
        short version = this.in.readShort();
        this.addMeta("Version", new Integer(version));
        this.in.skipBytes(6);
        this.core.sizeC[0] = this.in.readShort();
        this.core.sizeY[0] = this.in.readInt();
        this.core.sizeX[0] = this.in.readInt();
        short bits = this.in.readShort();
        this.addMeta("Bits per pixel", new Integer(bits));
        switch (bits) {
            case 16: {
                this.core.pixelType[0] = 3;
                break;
            }
            default: {
                this.core.pixelType[0] = 1;
            }
        }
        short colorMode = this.in.readShort();
        String modeString = null;
        switch (colorMode) {
            case 0: {
                modeString = "monochrome";
                break;
            }
            case 1: {
                modeString = "gray-scale";
                break;
            }
            case 2: {
                modeString = "palette color";
                break;
            }
            case 3: {
                modeString = "RGB";
                break;
            }
            case 4: {
                modeString = "CMYK";
                break;
            }
            case 6: {
                modeString = "Duotone";
                break;
            }
            case 7: {
                modeString = "Multichannel color";
                break;
            }
            case 8: {
                modeString = "Duotone";
                break;
            }
            case 9: {
                modeString = "LAB color";
            }
        }
        this.addMeta("Color mode", modeString);
        int modeDataLength = this.in.readInt();
        long fp = this.in.getFilePointer();
        if (modeDataLength != 0) {
            if (colorMode == 2) {
                this.lut = new byte[3][256];
                for (int i2 = 0; i2 < this.lut.length; ++i2) {
                    this.in.read(this.lut[i2]);
                }
            }
            this.in.seek(fp + (long)modeDataLength);
        }
        this.in.skipBytes(4);
        while (this.in.readString(4).equals("8BIM")) {
            int size;
            short tag = this.in.readShort();
            int read = 1;
            while (this.in.read() != 0) {
                ++read;
            }
            if (read % 2 == 1) {
                this.in.skipBytes(1);
            }
            if ((size = this.in.readInt()) % 2 == 1) {
                ++size;
            }
            byte[] data = new byte[size];
            this.in.read(data);
        }
        this.in.seek(this.in.getFilePointer() - 4L);
        int blockLen = this.in.readInt();
        int layerLen = this.in.readInt();
        int layerCount = this.in.readShort();
        int[] w = new int[layerCount];
        int[] h2 = new int[layerCount];
        int[] c = new int[layerCount];
        for (i = 0; i < layerCount; ++i) {
            int top = this.in.readInt();
            int left = this.in.readInt();
            int bottom = this.in.readInt();
            int right = this.in.readInt();
            w[i] = right - left;
            h2[i] = bottom - top;
            c[i] = this.in.readShort();
            this.in.skipBytes(c[i] * 6);
            this.in.skipBytes(12);
            int len = this.in.readInt();
            if (len % 2 == 1) {
                ++len;
            }
            this.in.skipBytes(len);
        }
        for (i = 0; i < layerCount; ++i) {
            int[] lens = new int[h2[i]];
            for (int cc = 0; cc < c[i]; ++cc) {
                int y;
                boolean compressed;
                boolean bl = compressed = this.in.readShort() == 1;
                if (!compressed) {
                    this.in.skipBytes(w[i] * h2[i]);
                    continue;
                }
                for (y = 0; y < h2[i]; ++y) {
                    lens[y] = this.in.readShort();
                }
                for (y = 0; y < h2[i]; ++y) {
                    this.in.skipBytes(lens[y]);
                }
            }
        }
        this.core.sizeZ[0] = 1;
        this.core.sizeT[0] = 1;
        this.core.rgb[0] = modeString.equals("RGB");
        this.core.imageCount[0] = this.core.sizeC[0] / (this.core.rgb[0] ? 3 : 1);
        this.core.indexed[0] = modeString.equals("palette color");
        this.core.falseColor[0] = false;
        this.core.currentOrder[0] = "XYCZT";
        this.core.interleaved[0] = false;
        this.core.littleEndian[0] = true;
        this.core.metadataComplete[0] = true;
        MetadataStore store = this.getMetadataStore();
        FormatTools.populatePixels(store, this);
        store.setImage(this.currentId, null, null, null);
        for (int i3 = 0; i3 < this.core.sizeC[0]; ++i3) {
            store.setLogicalChannel(i3, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

