/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataDeep;
import ucar.ma2.StructureMembers;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.PointFeatureImpl;
import ucar.nc2.ft.point.remote.FeatureMaker;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.stream.NcStream;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.Station;

public class PointStream {
    private static final byte[] MAGIC_StationList = new byte[]{-2, -2, -17, -17};
    private static final byte[] MAGIC_PointFeatureCollection = new byte[]{-6, -6, -81, -81};
    private static final byte[] MAGIC_PointFeature = new byte[]{-16, -16, 15, 15};
    private static final boolean debug = false;

    public static MessageType readMagic(InputStream is) throws IOException {
        byte[] b = new byte[4];
        int done = NcStream.readFully(is, b);
        if (done != 4) {
            return MessageType.Eos;
        }
        if (PointStream.test(b, MAGIC_PointFeature)) {
            return MessageType.PointFeature;
        }
        if (PointStream.test(b, MAGIC_PointFeatureCollection)) {
            return MessageType.PointFeatureCollection;
        }
        if (PointStream.test(b, MAGIC_StationList)) {
            return MessageType.StationList;
        }
        if (PointStream.test(b, NcStream.MAGIC_START)) {
            return MessageType.Start;
        }
        if (PointStream.test(b, NcStream.MAGIC_HEADER)) {
            return MessageType.Header;
        }
        if (PointStream.test(b, NcStream.MAGIC_DATA)) {
            return MessageType.Data;
        }
        if (PointStream.test(b, NcStream.MAGIC_END)) {
            return MessageType.End;
        }
        if (PointStream.test(b, NcStream.MAGIC_ERR)) {
            return MessageType.Error;
        }
        return null;
    }

    public static int writeMagic(OutputStream out, MessageType type) throws IOException {
        switch (type) {
            case PointFeature: {
                return NcStream.writeBytes(out, MAGIC_PointFeature);
            }
            case PointFeatureCollection: {
                return NcStream.writeBytes(out, MAGIC_PointFeatureCollection);
            }
            case StationList: {
                return NcStream.writeBytes(out, MAGIC_StationList);
            }
            case Start: {
                return NcStream.writeBytes(out, NcStream.MAGIC_START);
            }
            case End: {
                return NcStream.writeBytes(out, NcStream.MAGIC_END);
            }
            case Error: {
                return NcStream.writeBytes(out, NcStream.MAGIC_ERR);
            }
        }
        return 0;
    }

    private static boolean test(byte[] b, byte[] m3) {
        if (b.length != m3.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == m3[i]) continue;
            return false;
        }
        return true;
    }

    public static PointStreamProto.PointFeatureCollection encodePointFeatureCollection(String name, String timeUnitString, PointFeature pf) throws IOException {
        PointStreamProto.PointFeatureCollection.Builder builder = PointStreamProto.PointFeatureCollection.newBuilder();
        if (name == null) {
            System.out.printf("HEY null pointstream name%n", new Object[0]);
        }
        builder.setName(name);
        builder.setTimeUnit(timeUnitString);
        StructureData sdata = pf.getData();
        StructureMembers sm = sdata.getStructureMembers();
        for (StructureMembers.Member m3 : sm.getMembers()) {
            PointStreamProto.Member.Builder mbuilder = PointStreamProto.Member.newBuilder();
            mbuilder.setName(m3.getName());
            if (null != m3.getDescription()) {
                mbuilder.setDesc(m3.getDescription());
            }
            if (null != m3.getUnitsString()) {
                mbuilder.setUnits(m3.getUnitsString());
            }
            mbuilder.setDataType(NcStream.encodeDataType(m3.getDataType()));
            mbuilder.setSection(NcStream.encodeSection(new Section(m3.getShape())));
            builder.addMembers(mbuilder);
        }
        return builder.build();
    }

    public static PointStreamProto.PointFeature encodePointFeature(PointFeature pf) throws IOException {
        PointStreamProto.Location.Builder locBuilder = PointStreamProto.Location.newBuilder();
        locBuilder.setTime(pf.getObservationTime());
        if (!Double.isNaN(pf.getNominalTime()) && pf.getNominalTime() != pf.getObservationTime()) {
            locBuilder.setNomTime(pf.getNominalTime());
        }
        EarthLocation loc = pf.getLocation();
        locBuilder.setLat(loc.getLatitude());
        locBuilder.setLon(loc.getLongitude());
        if (!Double.isNaN(loc.getAltitude())) {
            locBuilder.setAlt(loc.getAltitude());
        }
        PointStreamProto.PointFeature.Builder builder = PointStreamProto.PointFeature.newBuilder();
        builder.setLoc(locBuilder);
        StructureData sdata = pf.getData();
        ArrayStructureBB abb = StructureDataDeep.copyToArrayBB(sdata);
        ByteBuffer bb = abb.getByteBuffer();
        builder.setData(ByteString.copyFrom(bb.array()));
        List<Object> heap = abb.getHeap();
        if (heap != null) {
            for (Object ho : heap) {
                if (ho instanceof String) {
                    builder.addSdata((String)ho);
                    continue;
                }
                if (ho instanceof String[]) {
                    builder.addAllSdata(Arrays.asList((String[])ho));
                    continue;
                }
                throw new IllegalStateException("illegal object on heap = " + ho);
            }
        }
        return builder.build();
    }

    public static PointStreamProto.StationList encodeStations(List<Station> stnList) throws IOException {
        PointStreamProto.StationList.Builder stnBuilder = PointStreamProto.StationList.newBuilder();
        for (Station loc : stnList) {
            PointStreamProto.Station.Builder locBuilder = PointStreamProto.Station.newBuilder();
            locBuilder.setId(loc.getName());
            locBuilder.setLat(loc.getLatitude());
            locBuilder.setLon(loc.getLongitude());
            if (!Double.isNaN(loc.getAltitude())) {
                locBuilder.setAlt(loc.getAltitude());
            }
            if (loc.getDescription() != null) {
                locBuilder.setDesc(loc.getDescription());
            }
            if (loc.getWmoId() != null) {
                locBuilder.setWmoId(loc.getWmoId());
            }
            stnBuilder.addStations(locBuilder);
        }
        return stnBuilder.build();
    }

    static class ProtobufPointFeatureMaker
    implements FeatureMaker {
        private DateUnit dateUnit;
        private StructureMembers sm;

        ProtobufPointFeatureMaker(PointStreamProto.PointFeatureCollection pfc) throws IOException {
            try {
                this.dateUnit = new DateUnit(pfc.getTimeUnit());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.dateUnit = DateUnit.getUnixDateUnit();
            }
            this.sm = new StructureMembers(pfc.getName());
            for (PointStreamProto.Member m3 : pfc.getMembersList()) {
                this.sm.addMember(m3.getName(), m3.getDesc(), m3.getUnits(), NcStream.decodeDataType(m3.getDataType()), NcStream.decodeSection(m3.getSection()).getShape());
            }
            ArrayStructureBB.setOffsets(this.sm);
        }

        @Override
        public PointFeature make(byte[] rawBytes) throws InvalidProtocolBufferException {
            PointStreamProto.PointFeature pfp = PointStreamProto.PointFeature.parseFrom(rawBytes);
            PointStreamProto.Location locp = pfp.getLoc();
            EarthLocationImpl location = new EarthLocationImpl(locp.getLat(), locp.getLon(), locp.getAlt());
            return new MyPointFeature(location, locp.getTime(), locp.getNomTime(), this.dateUnit, pfp);
        }

        private class MyPointFeature
        extends PointFeatureImpl {
            PointStreamProto.PointFeature pfp;

            MyPointFeature(EarthLocation location, double obsTime, double nomTime, DateUnit timeUnit, PointStreamProto.PointFeature pfp) {
                super(location, obsTime, nomTime, timeUnit);
                this.pfp = pfp;
            }

            @Override
            public StructureData getFeatureData() throws IOException {
                ByteBuffer bb = ByteBuffer.wrap(this.pfp.getData().toByteArray());
                ArrayStructureBB asbb = new ArrayStructureBB(ProtobufPointFeatureMaker.this.sm, new int[]{1}, bb, 0);
                for (String s2 : this.pfp.getSdataList()) {
                    asbb.addObjectToHeap(s2);
                }
                return asbb.getStructureData(0);
            }

            @Override
            public StructureData getDataAll() throws IOException {
                return this.getFeatureData();
            }

            @Override
            public String toString() {
                return this.location + " obs=" + this.obsTime + " nom=" + this.nomTime;
            }
        }
    }

    public static enum MessageType {
        Start,
        Header,
        Data,
        End,
        Error,
        Eos,
        StationList,
        PointFeatureCollection,
        PointFeature;

    }
}

