/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.Get;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.PreloadStatus;
import com.sleepycat.je.Put;
import com.sleepycat.je.ReadOptions;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.WriteOptions;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.OffHeapCache;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.CmdUtil;
import com.sleepycat.je.utilint.DbCacheSizeRepEnv;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class DbCacheSize {
    private static final NumberFormat INT_FORMAT = NumberFormat.getIntegerInstance();
    private static final String MAIN_HEADER = "   Number of Bytes  Description\n   ---------------  -----------";
    private static final int MIN_COLUMN_WIDTH = 18;
    private static final String COLUMN_SEPARATOR = "  ";
    private static final int DEFAULT_DENSITY = 70;
    private static final int ORDERED_DENSITY = 100;
    private final EnvironmentConfig envConfig = new EnvironmentConfig();
    private final Map<String, String> repParams = new HashMap<String, String>();
    private long records = 0L;
    private int keySize = 0;
    private int dataSize = -1;
    private boolean offHeapCache = false;
    private boolean assumeEvictLN = false;
    private long mainCacheSize = 0L;
    private long mainDataSize = 0L;
    private int nodeMaxEntries = 128;
    private int binMaxEntries = -1;
    private int keyPrefix = 0;
    private boolean orderedInsertion = false;
    private boolean duplicates = false;
    private boolean replicated = false;
    private boolean useTTL = false;
    private boolean outputProperties = false;
    private boolean doMeasure = false;
    private boolean btreeInfo = false;
    private long envOverhead;
    private long uinWithTargets;
    private long uinNoTargets;
    private long uinOffHeapBINIds;
    private long binNoLNsOrVLSNs;
    private long binNoLNsWithVLSNs;
    private long binWithLNsAndVLSNs;
    private long binOffHeapWithLNIds;
    private long binOffHeapNoLNIds;
    private long binOffHeapLNs;
    private long binOffHeapLNIds;
    private long mainMinDataSize;
    private long mainNoLNsOrVLSNs;
    private long mainNoLNsWithVLSNs;
    private long mainWithLNsAndVLSNs;
    private long offHeapNoLNsOrVLSNs;
    private long offHeapWithLNsAndVLSNs;
    private long nMainBINsNoLNsOrVLSNs;
    private long nMainBINsWithLNsAndVLSNs;
    private long nMainLNsWithLNsAndVLSNs;
    private long measuredMainNoLNsOrVLSNs;
    private long measuredMainNoLNsWithVLSNs;
    private long measuredMainWithLNsAndVLSNs;
    private long measuredOffHeapNoLNsOrVLSNs;
    private long measuredOffHeapWithLNsAndVLSNs;
    private long preloadMainNoLNsOrVLSNs;
    private long preloadMainNoLNsWithVLSNs;
    private long preloadMainWithLNsAndVLSNs;
    private int nodeAvg;
    private int binAvg;
    private int btreeLevels;
    private long nBinNodes;
    private long nUinNodes;
    private long nLevel2Nodes;
    private File tempDir;

    DbCacheSize() {
    }

    void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String name = args[i];
            String val = null;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                val = args[++i];
            }
            if (name.equals("-records")) {
                if (val == null) {
                    DbCacheSize.usage("No value after -records");
                }
                try {
                    this.records = Long.parseLong(val);
                }
                catch (NumberFormatException e) {
                    DbCacheSize.usage(val + " is not a number");
                }
                if (this.records > 0L) continue;
                DbCacheSize.usage(val + " is not a positive integer");
                continue;
            }
            if (name.equals("-key")) {
                if (val == null) {
                    DbCacheSize.usage("No value after -key");
                }
                try {
                    this.keySize = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    DbCacheSize.usage(val + " is not a number");
                }
                if (this.keySize > 0) continue;
                DbCacheSize.usage(val + " is not a positive integer");
                continue;
            }
            if (name.equals("-data")) {
                if (val == null) {
                    DbCacheSize.usage("No value after -data");
                }
                try {
                    this.dataSize = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    DbCacheSize.usage(val + " is not a number");
                }
                if (this.dataSize >= 0) continue;
                DbCacheSize.usage(val + " is not a non-negative integer");
                continue;
            }
            if (name.equals("-offheap")) {
                if (val != null) {
                    DbCacheSize.usage("No value allowed after " + name);
                }
                this.offHeapCache = true;
                continue;
            }
            if (name.equals("-maincache")) {
                if (val == null) {
                    DbCacheSize.usage("No value after -maincache");
                }
                try {
                    this.mainCacheSize = Long.parseLong(val);
                }
                catch (NumberFormatException e) {
                    DbCacheSize.usage(val + " is not a number");
                }
                if (this.mainCacheSize > 0L) continue;
                DbCacheSize.usage(val + " is not a positive integer");
                continue;
            }
            if (name.equals("-keyprefix")) {
                if (val == null) {
                    DbCacheSize.usage("No value after -keyprefix");
                }
                try {
                    this.keyPrefix = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    DbCacheSize.usage(val + " is not a number");
                }
                if (this.keyPrefix >= 0) continue;
                DbCacheSize.usage(val + " is not a non-negative integer");
                continue;
            }
            if (name.equals("-orderedinsertion")) {
                if (val != null) {
                    DbCacheSize.usage("No value allowed after " + name);
                }
                this.orderedInsertion = true;
                continue;
            }
            if (name.equals("-duplicates")) {
                if (val != null) {
                    DbCacheSize.usage("No value allowed after " + name);
                }
                this.duplicates = true;
                continue;
            }
            if (name.equals("-ttl")) {
                if (val != null) {
                    DbCacheSize.usage("No value allowed after " + name);
                }
                this.useTTL = true;
                continue;
            }
            if (name.equals("-replicated")) {
                if (val != null) {
                    DbCacheSize.usage("No value allowed after " + name);
                }
                this.replicated = true;
                continue;
            }
            if (name.equals("-nodemax")) {
                if (val == null) {
                    DbCacheSize.usage("No value after -nodemax");
                }
                try {
                    this.nodeMaxEntries = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    DbCacheSize.usage(val + " is not a number");
                }
                if (this.nodeMaxEntries > 0) continue;
                DbCacheSize.usage(val + " is not a positive integer");
                continue;
            }
            if (name.equals("-binmax")) {
                if (val == null) {
                    DbCacheSize.usage("No value after -binmax");
                }
                try {
                    this.binMaxEntries = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    DbCacheSize.usage(val + " is not a number");
                }
                if (this.binMaxEntries > 0) continue;
                DbCacheSize.usage(val + " is not a positive integer");
                continue;
            }
            if (name.equals("-density")) {
                DbCacheSize.usage("-density is no longer supported, see -orderedinsertion");
                continue;
            }
            if (name.equals("-overhead")) {
                DbCacheSize.usage("-overhead is no longer supported");
                continue;
            }
            if (name.startsWith("-je.")) {
                if (val == null) {
                    DbCacheSize.usage("No value after " + name);
                }
                if (name.startsWith("-je.rep.")) {
                    this.repParams.put(name.substring(1), val);
                    continue;
                }
                this.envConfig.setConfigParam(name.substring(1), val);
                continue;
            }
            if (name.equals("-measure")) {
                if (val != null) {
                    DbCacheSize.usage("No value allowed after " + name);
                }
                this.doMeasure = true;
                continue;
            }
            if (name.equals("-outputproperties")) {
                if (val != null) {
                    DbCacheSize.usage("No value allowed after " + name);
                }
                this.outputProperties = true;
                continue;
            }
            if (name.equals("-btreeinfo")) {
                if (val != null) {
                    DbCacheSize.usage("No value allowed after " + name);
                }
                this.btreeInfo = true;
                continue;
            }
            DbCacheSize.usage("Unknown arg: " + name);
        }
        if (this.records == 0L) {
            DbCacheSize.usage("-records not specified");
        }
        if (this.keySize == 0) {
            DbCacheSize.usage("-key not specified");
        }
    }

    void cleanup() {
        if (this.tempDir != null) {
            this.emptyTempDir();
            this.tempDir.delete();
        }
    }

    long getMainNoLNsOrVLSNs() {
        return this.mainNoLNsOrVLSNs;
    }

    long getMainNoLNsWithVLSNs() {
        return this.mainNoLNsWithVLSNs;
    }

    long getOffHeapWithLNsAndVLSNs() {
        return this.offHeapWithLNsAndVLSNs;
    }

    long getOffHeapNoLNsOrVLSNs() {
        return this.offHeapNoLNsOrVLSNs;
    }

    long getMainWithLNsAndVLSNs() {
        return this.mainWithLNsAndVLSNs;
    }

    long getMeasuredMainNoLNsOrVLSNs() {
        return this.measuredMainNoLNsOrVLSNs;
    }

    long getMeasuredMainNoLNsWithVLSNs() {
        return this.measuredMainNoLNsWithVLSNs;
    }

    long getMeasuredMainWithLNsAndVLSNs() {
        return this.measuredMainWithLNsAndVLSNs;
    }

    long getMeasuredOffHeapNoLNsOrVLSNs() {
        return this.measuredOffHeapNoLNsOrVLSNs;
    }

    long getMeasuredOffHeapWithLNsAndVLSNs() {
        return this.measuredOffHeapWithLNsAndVLSNs;
    }

    long getPreloadMainNoLNsOrVLSNs() {
        return this.preloadMainNoLNsOrVLSNs;
    }

    long getPreloadMainNoLNsWithVLSNs() {
        return this.preloadMainNoLNsWithVLSNs;
    }

    long getPreloadMainWithLNsAndVLSNs() {
        return this.preloadMainWithLNsAndVLSNs;
    }

    public static void main(String[] args) throws Throwable {
        DbCacheSize dbCacheSize = new DbCacheSize();
        try {
            dbCacheSize.parseArgs(args);
            dbCacheSize.calculateCacheSizes();
            if (dbCacheSize.outputProperties) {
                dbCacheSize.printProperties(System.out);
            } else {
                dbCacheSize.printCacheSizes(System.out);
            }
            if (dbCacheSize.doMeasure) {
                dbCacheSize.measure(System.out);
            }
        }
        finally {
            dbCacheSize.cleanup();
        }
    }

    private static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println("usage:\njava " + CmdUtil.getJavaCommand(DbCacheSize.class) + "\n   -records <count>\n      # Total records (key/data pairs); required\n   -key <bytes> \n      # Average key bytes per record; required\n  [-data <bytes>]\n      # Average data bytes per record; if omitted no leaf\n      # node sizes are included in the output; required with\n      # -duplicates, and specifies the primary key length\n  [-offheap]\n      # Indicates that an off-heap cache will be used.\n  [-maincache <bytes>]\n      # The size of the main cache (in the JVM heap).\n      # The size of the off-heap cache displayed is the\n      # additional amount needed to hold the data set.\n      # If omitted, the main cache size is implied to\n      # be the amount needed to hold all internal nodes.\n      # Ignored if -offheap is not also specified.\n  [-keyprefix <bytes>]\n      # Expected size of the prefix for the keys in each\n      # BIN; default: zero, key prefixing is not configured;\n      # required with -duplicates\n  [-nodemax <entries>]\n      # Number of entries per Btree node; default: 128\n  [-orderedinsertion]\n      # Assume ordered insertions and no deletions, so BINs\n      # are 100% full; default: unordered insertions and/or\n      # deletions, BINs are 70% full\n  [-duplicates]\n      # Indicates that sorted duplicates are used, including\n      # MANY_TO_ONE and MANY_TO_MANY secondary indices;\n      # default: false\n  [-ttl]\n      # Indicates that TTL is used; default: false\n  [-replicated]\n      # Use a ReplicatedEnvironment; default: false\n  [-ENV_PARAM_NAME VALUE]...\n      # Any number of EnvironmentConfig parameters and\n      # ReplicationConfig parameters (if -replicated)\n  [-btreeinfo]\n      # Outputs additional Btree information\n  [-outputproperties]\n      # Writes Java properties to System.out");
        System.exit(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void calculateCacheSizes() {
        if (this.binMaxEntries <= 0) {
            this.binMaxEntries = this.nodeMaxEntries;
        }
        Environment env = this.openCalcEnvironment(true);
        boolean success = false;
        try {
            IN.ACCUMULATED_LIMIT = 0;
            this.envOverhead = env.getStats(null).getCacheTotalBytes();
            if (this.offHeapCache) {
                boolean bl = this.assumeEvictLN = this.mainCacheSize == 0L;
                if (this.mainCacheSize > 0L && this.mainCacheSize - this.envOverhead <= 0x100000L) {
                    throw new IllegalArgumentException("The -maincache value must be at least 1 MiB larger than the environment overhead (" + INT_FORMAT.format(this.envOverhead) + ')');
                }
            }
            int density = this.orderedInsertion ? 100 : 70;
            this.nodeAvg = this.nodeMaxEntries * density / 100;
            this.binAvg = this.binMaxEntries * density / 100;
            this.calcTreeSizes(env);
            this.calcNNodes();
            this.calcMainCacheSizes();
            if (this.offHeapCache) {
                if (this.mainCacheSize == 0L) {
                    this.mainCacheSize = this.mainNoLNsOrVLSNs + this.envOverhead;
                }
                this.mainDataSize = this.mainCacheSize - this.envOverhead;
                this.mainMinDataSize = this.calcLevel2AndAboveSize();
                if (this.mainMinDataSize > this.mainDataSize) {
                    this.records = (long)((double)this.records * ((double)this.mainDataSize / (double)this.mainMinDataSize));
                    this.calcNNodes();
                    this.calcMainCacheSizes();
                }
                this.calcOffHeapNoLNsOrVLSNs();
                this.calcOffHeapWithLNsAndVLSNs();
            }
            success = true;
        }
        finally {
            block14: {
                IN.ACCUMULATED_LIMIT = 1000;
                try {
                    env.close();
                }
                catch (RuntimeException e) {
                    if (!success) break block14;
                    throw e;
                }
            }
        }
    }

    private long calcLevel2AndAboveSize() {
        assert (this.offHeapCache);
        return (this.nUinNodes - this.nLevel2Nodes) * this.uinWithTargets + this.nLevel2Nodes * (this.uinNoTargets + this.uinOffHeapBINIds);
    }

    private void calcNNodes() {
        this.nBinNodes = (this.records + (long)this.binAvg - 1L) / (long)this.binAvg;
        this.btreeLevels = 1;
        this.nUinNodes = 0L;
        this.nLevel2Nodes = 0L;
        long nodes = this.nBinNodes / (long)this.nodeAvg;
        while (true) {
            if (nodes == 0L) {
                nodes = 1L;
            }
            if (this.btreeLevels == 2) {
                assert (this.nLevel2Nodes == 0L);
                this.nLevel2Nodes = nodes;
            }
            this.nUinNodes += nodes;
            ++this.btreeLevels;
            if (nodes == 1L) break;
            nodes /= (long)this.nodeAvg;
        }
    }

    private void calcMainCacheSizes() {
        long mainUINs = this.nUinNodes * this.uinWithTargets;
        this.mainNoLNsOrVLSNs = this.nBinNodes * this.binNoLNsOrVLSNs + mainUINs;
        this.mainNoLNsWithVLSNs = this.nBinNodes * this.binNoLNsWithVLSNs + mainUINs;
        this.mainWithLNsAndVLSNs = this.nBinNodes * this.binWithLNsAndVLSNs + mainUINs;
    }

    private void calcOffHeapNoLNsOrVLSNs() {
        assert (this.offHeapCache);
        this.mainNoLNsWithVLSNs = 0L;
        if (this.mainNoLNsOrVLSNs <= this.mainDataSize) {
            this.offHeapNoLNsOrVLSNs = 0L;
            this.nMainBINsNoLNsOrVLSNs = this.nBinNodes;
            return;
        }
        this.mainNoLNsOrVLSNs = this.mainDataSize;
        long mainSpare = this.mainDataSize > this.calcLevel2AndAboveSize() ? this.mainDataSize - this.calcLevel2AndAboveSize() : 0L;
        long nMainBINs = mainSpare / this.binNoLNsOrVLSNs;
        long nOffHeapBins = this.nBinNodes - nMainBINs;
        this.offHeapNoLNsOrVLSNs = nOffHeapBins * this.binOffHeapNoLNIds;
        this.nMainBINsNoLNsOrVLSNs = nMainBINs;
    }

    private void calcOffHeapWithLNsAndVLSNs() {
        assert (this.offHeapCache);
        if (this.mainWithLNsAndVLSNs <= this.mainDataSize) {
            this.offHeapWithLNsAndVLSNs = 0L;
            this.nMainBINsWithLNsAndVLSNs = this.nBinNodes;
            this.nMainLNsWithLNsAndVLSNs = this.binOffHeapLNs == 0L ? 0L : this.records;
            return;
        }
        this.mainWithLNsAndVLSNs = this.mainDataSize;
        if (this.binOffHeapLNs == 0L) {
            this.offHeapWithLNsAndVLSNs = this.offHeapNoLNsOrVLSNs;
            this.nMainBINsWithLNsAndVLSNs = this.nMainBINsNoLNsOrVLSNs;
            this.nMainLNsWithLNsAndVLSNs = 0L;
            return;
        }
        long mainWithOffHeapLNIds = this.mainNoLNsOrVLSNs + this.nBinNodes * this.binOffHeapLNIds;
        if (mainWithOffHeapLNIds <= this.mainDataSize) {
            long mainSpare = this.mainDataSize > this.mainNoLNsOrVLSNs ? this.mainDataSize - this.mainNoLNsOrVLSNs : 0L;
            long nBINsWithMainLNs = mainSpare / (this.binWithLNsAndVLSNs - this.binNoLNsOrVLSNs);
            long nBINsWithOffHeapLNs = this.nBinNodes - nBINsWithMainLNs;
            this.offHeapWithLNsAndVLSNs = nBINsWithOffHeapLNs * this.binOffHeapLNs;
            this.nMainBINsWithLNsAndVLSNs = this.nMainBINsNoLNsOrVLSNs;
            this.nMainLNsWithLNsAndVLSNs = nBINsWithMainLNs * (long)this.nodeAvg;
            return;
        }
        long mainSpare = this.mainDataSize > this.calcLevel2AndAboveSize() ? this.mainDataSize - this.calcLevel2AndAboveSize() : 0L;
        long nMainBINs = mainSpare / (this.binNoLNsOrVLSNs + this.binOffHeapLNIds);
        long nOffHeapBins = this.nBinNodes - nMainBINs;
        this.offHeapWithLNsAndVLSNs = nOffHeapBins * this.binOffHeapWithLNIds + this.nBinNodes * this.binOffHeapLNs;
        this.nMainBINsWithLNsAndVLSNs = nMainBINs;
        this.nMainLNsWithLNsAndVLSNs = 0L;
    }

    private void calcTreeSizes(Environment env) {
        if (this.nodeMaxEntries != this.binMaxEntries) {
            throw new IllegalArgumentException("-binmax not currently supported because a per-BIN max is not implemented in the Btree, so we can't measure an actual BIN node with the given -binmax value");
        }
        assert (this.nodeAvg == this.binAvg);
        if (this.nodeAvg > 65535) {
            throw new IllegalArgumentException("Entries per node (" + this.nodeAvg + ") is greater than 0xFFFF");
        }
        EnvironmentImpl envImpl = DbInternal.getNonNullEnvImpl(env);
        byte[] keyBytes = new byte[this.nodeAvg <= 255 ? 1 : 2];
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        WriteOptions options = new WriteOptions();
        if (this.useTTL) {
            options.setTTL(30, TimeUnit.DAYS);
        }
        Database db = this.openDatabase(env, true);
        for (int i = 0; i < this.nodeAvg; ++i) {
            if (keyBytes.length == 1) {
                keyBytes[0] = (byte)i;
            } else {
                assert (keyBytes.length == 2);
                keyBytes[0] = (byte)(i >> 8);
                keyBytes[1] = (byte)i;
            }
            this.setKeyData(keyBytes, this.keyPrefix, keyEntry, dataEntry);
            OperationResult result = db.put(null, keyEntry, dataEntry, this.duplicates ? Put.NO_DUP_DATA : Put.NO_OVERWRITE, options);
            if (result != null) continue;
            throw new IllegalStateException();
        }
        Cursor cursor = db.openCursor(null, null);
        OperationStatus status = cursor.getFirst(keyEntry, dataEntry, null);
        assert (status == OperationStatus.SUCCESS);
        BIN bin = DbInternal.getCursorImpl(cursor).getBIN();
        cursor.close();
        bin.latchNoUpdateLRU();
        bin.recalcKeyPrefix();
        bin.compactMemory();
        this.binWithLNsAndVLSNs = bin.getInMemorySize();
        if (this.offHeapCache) {
            long prevSize = this.getOffHeapCacheSize(envImpl);
            bin.partialEviction();
            this.binOffHeapLNs = 0L;
            for (int i = 0; i < this.nodeAvg; ++i) {
                this.binOffHeapLNs += this.getOffHeapLNSize(bin, 0);
            }
            assert (this.getOffHeapCacheSize(envImpl) - prevSize == this.binOffHeapLNs);
            this.binOffHeapLNIds = bin.getOffHeapLNIdsMemorySize();
        } else {
            bin.partialEviction();
            this.binOffHeapLNs = 0L;
            this.binOffHeapLNIds = 0L;
        }
        assert (!bin.hasCachedChildren());
        this.binNoLNsWithVLSNs = bin.getInMemorySize() - this.binOffHeapLNIds;
        if (this.duplicates || !envImpl.getCacheVLSN()) {
            assert (bin.getVLSNCache().getMemorySize() == 0L);
        } else {
            assert (bin.getVLSNCache().getMemorySize() > 0L);
            bin.partialEviction();
            if (this.dataSize <= bin.getEnv().getMaxEmbeddedLN() ? !$assertionsDisabled && bin.getVLSNCache().getMemorySize() <= 0L : !$assertionsDisabled && bin.getVLSNCache().getMemorySize() != 0L) {
                throw new AssertionError();
            }
        }
        this.binNoLNsOrVLSNs = bin.getInMemorySize() - this.binOffHeapLNIds;
        IN in = DbInternal.getDbImpl(db).getTree().getRootINLatchedExclusive(CacheMode.DEFAULT);
        assert (bin == in.getTarget(0));
        for (int i = 1; i < this.nodeAvg; ++i) {
            int result = in.insertEntry1(bin, bin.getKey(i), null, bin.getLsn(i), false);
            assert ((result & 0x20000) != 0);
            assert (i == (result & 0xFFFDFFFF));
        }
        in.recalcKeyPrefix();
        in.compactMemory();
        this.uinWithTargets = in.getInMemorySize();
        this.uinNoTargets = this.uinWithTargets - in.getTargets().calculateMemorySize();
        if (this.offHeapCache) {
            int i;
            in.releaseLatch();
            long bytesFreed = envImpl.getEvictor().doTestEvict(bin, Evictor.EvictionSource.CACHEMODE);
            assert (bytesFreed > 0L);
            in.latchNoUpdateLRU();
            int binId = in.getOffHeapBINId(0);
            assert (binId >= 0);
            this.binOffHeapWithLNIds = this.getOffHeapBINSize(in, 0);
            bytesFreed = envImpl.getOffHeapCache().stripLNs(in, 0);
            this.binOffHeapNoLNIds = this.getOffHeapBINSize(in, 0);
            assert (bytesFreed == this.binOffHeapLNs + (this.binOffHeapWithLNIds - this.binOffHeapNoLNIds));
            for (i = 1; i < this.nodeAvg; ++i) {
                in.setOffHeapBINId(i, binId, false, false);
            }
            this.uinOffHeapBINIds = in.getOffHeapBINIdsMemorySize();
            for (i = 1; i < this.nodeAvg; ++i) {
                in.clearOffHeapBINId(i);
            }
            in.releaseLatch();
        } else {
            this.binOffHeapWithLNIds = 0L;
            this.uinOffHeapBINIds = 0L;
            bin.releaseLatch();
            in.releaseLatch();
        }
        db.close();
    }

    private long getMainDataSize(Environment env) {
        return DbInternal.getNonNullEnvImpl(env).getMemoryBudget().getTreeMemoryUsage();
    }

    private long getOffHeapCacheSize(EnvironmentImpl envImpl) {
        assert (this.offHeapCache);
        return envImpl.getOffHeapCache().getAllocator().getUsedBytes();
    }

    private long getOffHeapLNSize(BIN bin, int i) {
        assert (this.offHeapCache);
        OffHeapCache ohCache = bin.getEnv().getOffHeapCache();
        long memId = bin.getOffHeapLNId(i);
        if (memId == 0L) {
            return 0L;
        }
        return ohCache.getAllocator().totalSize(memId);
    }

    private long getOffHeapBINSize(IN parent, int i) {
        assert (this.offHeapCache);
        OffHeapCache ohCache = parent.getEnv().getOffHeapCache();
        int lruId = parent.getOffHeapBINId(0);
        assert (lruId >= 0);
        long memId = ohCache.getMemId(lruId);
        assert (memId != 0L);
        return ohCache.getAllocator().totalSize(memId);
    }

    private void setKeyData(byte[] keyBytes, int keyOffset, DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
        byte[] finalData;
        byte[] finalKey;
        byte[] fullKey = this.duplicates ? new byte[this.keySize + this.dataSize] : new byte[this.keySize];
        if (this.keyPrefix + keyBytes.length > fullKey.length) {
            throw new IllegalArgumentException("Key doesn't fit, allowedLen=" + fullKey.length + " keyLen=" + keyBytes.length + " prefixLen=" + this.keyPrefix);
        }
        System.arraycopy(keyBytes, 0, fullKey, keyOffset, keyBytes.length);
        if (this.duplicates) {
            finalKey = new byte[this.keySize];
            finalData = new byte[this.dataSize];
            System.arraycopy(fullKey, 0, finalKey, 0, this.keySize);
            System.arraycopy(fullKey, this.keySize, finalData, 0, this.dataSize);
        } else {
            finalKey = fullKey;
            finalData = new byte[Math.max(0, this.dataSize)];
        }
        keyEntry.setData(finalKey);
        dataEntry.setData(finalData);
    }

    private void printProperties(PrintStream out) {
        out.println("overhead=" + this.envOverhead);
        out.println("internalNodes=" + this.mainNoLNsOrVLSNs);
        out.println("internalNodesAndVersions=" + this.mainNoLNsWithVLSNs);
        if (this.dataSize >= 0) {
            out.println("allNodes=" + this.mainWithLNsAndVLSNs);
        }
        if (this.offHeapCache) {
            out.println("minMainCache=" + (this.mainMinDataSize + this.envOverhead));
            out.println("offHeapInternalNodes=" + this.offHeapNoLNsOrVLSNs);
            if (this.dataSize >= 0) {
                out.println("offHeapAllNodes=" + this.offHeapWithLNsAndVLSNs);
            }
        }
        out.println("# Following are deprecated");
        out.println("minInternalNodes=" + this.mainNoLNsOrVLSNs);
        out.println("maxInternalNodes=" + this.mainNoLNsOrVLSNs);
        if (this.dataSize >= 0) {
            out.println("minAllNodes=" + this.mainWithLNsAndVLSNs);
            out.println("maxAllNodes=" + this.mainWithLNsAndVLSNs);
        }
    }

    void printCacheSizes(PrintStream out) {
        String mainSuffix = this.offHeapCache ? ": MAIN cache" : "";
        String offHeapSuffix = ": OFF-HEAP cache";
        out.println();
        out.println("=== Environment Cache Overhead ===");
        out.println();
        out.print(INT_FORMAT.format(this.envOverhead));
        out.println(" minimum bytes");
        out.println();
        out.println("To account for JE daemon operation, record locks, HA network connections, etc,");
        out.println("a larger amount is needed in practice.");
        out.println();
        out.println("=== Database Cache Size ===");
        out.println();
        out.println(MAIN_HEADER);
        out.println(this.line(this.mainNoLNsOrVLSNs, "Internal nodes only" + mainSuffix));
        if (this.offHeapCache) {
            out.println(this.line(this.offHeapNoLNsOrVLSNs, "Internal nodes only: OFF-HEAP cache"));
        }
        if (this.dataSize >= 0) {
            if (!this.offHeapCache && this.mainNoLNsWithVLSNs != this.mainNoLNsOrVLSNs) {
                out.println(this.line(this.mainNoLNsWithVLSNs, "Internal nodes and record versions" + mainSuffix));
            }
            out.println(this.line(this.mainWithLNsAndVLSNs, "Internal nodes and leaf nodes" + mainSuffix));
            if (this.offHeapCache) {
                out.println(this.line(this.offHeapWithLNsAndVLSNs, "Internal nodes and leaf nodes: OFF-HEAP cache"));
            }
            if (this.mainNoLNsOrVLSNs == this.mainWithLNsAndVLSNs && this.offHeapNoLNsOrVLSNs == this.offHeapWithLNsAndVLSNs) {
                if (this.duplicates) {
                    out.println("\nNote that leaf nodes do not use additional memory because the database is\nconfigured for duplicates. In addition, record versions are not applicable.");
                } else {
                    out.println("\nNote that leaf nodes do not use additional memory because with a small\ndata size, the LNs are embedded in the BINs. In addition, record versions\n(if configured) are always cached in this mode.");
                }
            }
        } else if (!this.duplicates) {
            out.println("\nTo get leaf node sizing specify -data");
        }
        if (this.offHeapCache && this.mainMinDataSize > this.mainDataSize) {
            out.println("\nWARNING: The information above applies to a data set of " + INT_FORMAT.format(this.records) + " records,\nnot the number of records specified, because the main cache size specified is \ntoo small to hold all upper INs. This prevents all internal nodes (or leaf\nnodes) from fitting into cache, and the data set was reduced accordingly. To\nfit all internal nodes in cache with the specified  number of records, specify\na main cache size of at least " + INT_FORMAT.format(this.mainMinDataSize + this.envOverhead) + " bytes.");
        }
        if (this.btreeInfo) {
            out.println();
            out.println("=== Calculated Btree Information ===");
            out.println();
            out.println(this.line(this.btreeLevels, "Btree levels"));
            out.println(this.line(this.nUinNodes, "Upper internal nodes"));
            out.println(this.line(this.nBinNodes, "Bottom internal nodes"));
            if (this.offHeapCache) {
                out.println();
                out.println("--- BINs and LNs in Main Cache vs Off-heap ---");
                out.println();
                out.println(this.line(this.nMainBINsNoLNsOrVLSNs, "Internal nodes only, BINs" + mainSuffix));
                out.println(this.line(this.nBinNodes - this.nMainBINsNoLNsOrVLSNs, "Internal nodes only, BINs: OFF-HEAP cache"));
                out.println(this.line(this.nMainBINsWithLNsAndVLSNs, "Internal nodes and leaf nodes, BINs" + mainSuffix));
                out.println(this.line(this.nBinNodes - this.nMainBINsWithLNsAndVLSNs, "Internal nodes and leaf nodes, BINs: OFF-HEAP cache"));
                out.println(this.line(this.nMainLNsWithLNsAndVLSNs, "Internal nodes and leaf nodes, LNs" + mainSuffix));
                out.println(this.line(this.records - this.nMainLNsWithLNsAndVLSNs, "Internal nodes and leaf nodes, LNs: OFF-HEAP cache"));
            }
        }
        out.println();
        out.println("For further information see the DbCacheSize javadoc.");
    }

    private String line(long num, String comment) {
        StringBuilder buf = new StringBuilder(100);
        this.column(buf, INT_FORMAT.format(num));
        buf.append(COLUMN_SEPARATOR);
        buf.append(comment);
        return buf.toString();
    }

    private void column(StringBuilder buf, String str) {
        int start = buf.length();
        while (buf.length() - start + str.length() < 18) {
            buf.append(' ');
        }
        buf.append(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void measure(PrintStream out) {
        Environment env = this.openMeasureEnvironment(true, false);
        try {
            IN.ACCUMULATED_LIMIT = 0;
            Database db = this.openDatabase(env, true);
            if (out != null) {
                out.println("Measuring with maximum cache size: " + INT_FORMAT.format(env.getConfig().getCacheSize()) + " and (for off-heap) main data size: " + INT_FORMAT.format(this.mainDataSize));
            }
            this.insertRecords(out, env, db);
            if (this.offHeapCache) {
                db.close();
                env.close();
                env = null;
                env = this.openMeasureEnvironment(false, false);
                db = this.openDatabase(env, false);
                this.readRecords(out, env, db, false);
                this.evictMainToDataSize(db, this.mainDataSize);
                this.measuredMainNoLNsOrVLSNs = this.getStats(out, env, "After read keys only, evict main to size");
                this.measuredOffHeapNoLNsOrVLSNs = this.getOffHeapCacheSize(DbInternal.getNonNullEnvImpl(env));
                this.readRecords(out, env, db, true);
                this.evictMainToDataSize(db, this.mainDataSize);
                this.measuredMainWithLNsAndVLSNs = this.getStats(out, env, "After read all, evict main to size");
                this.measuredOffHeapWithLNsAndVLSNs = this.getOffHeapCacheSize(DbInternal.getNonNullEnvImpl(env));
            } else {
                this.measuredMainWithLNsAndVLSNs = this.getStats(out, env, "After insert");
                this.trimLNs(db);
                this.measuredMainNoLNsWithVLSNs = this.getStats(out, env, "After trimLNs");
                this.trimVLSNs(db);
                this.measuredMainNoLNsOrVLSNs = this.getStats(out, env, "After trimVLSNs");
            }
            db.close();
            env.close();
            env = null;
            env = this.openMeasureEnvironment(false, this.offHeapCache);
            db = this.openDatabase(env, false);
            PreloadStatus status = this.preloadRecords(out, db, false);
            this.preloadMainNoLNsOrVLSNs = this.getStats(out, env, "Internal nodes only after preload (" + status + ")");
            if (this.assumeEvictLN) {
                this.preloadMainWithLNsAndVLSNs = this.preloadMainNoLNsOrVLSNs;
            } else {
                status = this.preloadRecords(out, db, true);
                this.preloadMainWithLNsAndVLSNs = this.getStats(out, env, "All nodes after preload (" + status + ")");
            }
            if (!this.offHeapCache) {
                this.trimLNs(db);
                this.preloadMainNoLNsWithVLSNs = this.getStats(out, env, "Internal nodes plus VLSNs after preload (" + status + ")");
            }
            db.close();
            env.close();
            env = null;
        }
        finally {
            IN.ACCUMULATED_LIMIT = 1000;
            if (env != null) {
                try {
                    env.close();
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    private Environment openMeasureEnvironment(boolean createNew, boolean setMainSize) {
        EnvironmentConfig config = this.envConfig.clone();
        if (setMainSize) {
            config.setCacheSize(this.mainCacheSize);
            config.setConfigParam("je.log.totalBufferBytes", String.valueOf(0x300000));
        } else {
            config.setCachePercent(90);
        }
        if (this.offHeapCache) {
            config.setOffHeapCacheSize(0x40000000L);
        } else {
            config.setOffHeapCacheSize(0L);
        }
        return this.openEnvironment(config, createNew);
    }

    private Environment openCalcEnvironment(boolean createNew) {
        EnvironmentConfig config = this.envConfig.clone();
        if (this.offHeapCache) {
            config.setOffHeapCacheSize(0x40000000L);
        } else {
            config.setOffHeapCacheSize(0L);
        }
        config.setConfigParam("je.freeDisk", String.valueOf(0x100000L));
        return this.openEnvironment(config, createNew);
    }

    private Environment openEnvironment(EnvironmentConfig config, boolean createNew) {
        Environment newEnv;
        this.mkTempDir();
        if (createNew) {
            this.emptyTempDir();
        }
        config.setTransactional(true);
        config.setDurability(Durability.COMMIT_NO_SYNC);
        config.setAllowCreate(createNew);
        config.setConfigParam("je.env.runCleaner", "false");
        config.setConfigParam("je.env.runCheckpointer", "false");
        config.setConfigParam("je.env.runINCompressor", "false");
        config.setConfigParam("je.env.runEvictor", "false");
        config.setConfigParam("je.env.runOffHeapEvictor", "false");
        config.setConfigParam("je.env.runVerifier", "false");
        config.setConfigParam(EnvironmentParams.ENV_RUN_EXTINCT_RECORD_SCANNER.getName(), "false");
        config.setConfigParam("je.evictor.evictBytes", "1024");
        if (this.replicated) {
            try {
                Class<?> repEnvClass = Class.forName("com.sleepycat.je.rep.utilint.DbCacheSizeRepEnv");
                DbCacheSizeRepEnv repEnv = (DbCacheSizeRepEnv)repEnvClass.newInstance();
                newEnv = repEnv.open(this.tempDir, config, this.repParams);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        } else {
            if (!this.repParams.isEmpty()) {
                throw new IllegalArgumentException("Cannot set replication params in a standalone environment.  May add -replicated.");
            }
            newEnv = new Environment(this.tempDir, config);
        }
        long fileSize = Integer.parseInt(newEnv.getConfig().getConfigParam("je.log.fileMax"));
        if (fileSize > 0xFFFFFEL || !this.orderedInsertion) {
            IN.disableCompactLsns = true;
        }
        if (this.offHeapCache) {
            DbInternal.getNonNullEnvImpl(newEnv).getOffHeapCache().preallocateLRUEntries();
        }
        return newEnv;
    }

    private void mkTempDir() {
        if (this.tempDir == null) {
            try {
                this.tempDir = File.createTempFile("DbCacheSize", null);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.tempDir.delete();
            this.tempDir.mkdir();
        }
    }

    private void emptyTempDir() {
        if (this.tempDir == null) {
            return;
        }
        File[] children = this.tempDir.listFiles();
        if (children != null) {
            for (File child : children) {
                child.delete();
            }
        }
    }

    private Database openDatabase(Environment env, boolean createNew) {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(createNew);
        dbConfig.setExclusiveCreate(createNew);
        dbConfig.setNodeMaxEntries(this.nodeMaxEntries);
        dbConfig.setKeyPrefixing(this.keyPrefix > 0);
        dbConfig.setSortedDuplicates(this.duplicates);
        return env.openDatabase(null, "foo", dbConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRecords(PrintStream out, Environment env, Database db) {
        int keyOffset;
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        int lastKey = (int)(this.records - 1L);
        byte[] lastKeyBytes = BigInteger.valueOf(lastKey).toByteArray();
        int maxKeyBytes = lastKeyBytes.length;
        if (this.keyPrefix == 0) {
            keyOffset = 0;
        } else {
            int calcPrefix;
            int nodeAvg = this.orderedInsertion ? this.nodeMaxEntries : this.nodeMaxEntries * 70 / 100;
            int prevKey = lastKey - nodeAvg * 2;
            byte[] prevKeyBytes = this.padLeft(BigInteger.valueOf(prevKey).toByteArray(), maxKeyBytes);
            for (calcPrefix = 0; calcPrefix < lastKeyBytes.length && calcPrefix < prevKeyBytes.length && lastKeyBytes[calcPrefix] == prevKeyBytes[calcPrefix]; ++calcPrefix) {
            }
            keyOffset = this.keyPrefix - calcPrefix;
        }
        ArrayList<Integer> rndKeys = null;
        if (!this.orderedInsertion) {
            rndKeys = new ArrayList<Integer>(lastKey + 1);
            for (int i = 0; i <= lastKey; ++i) {
                rndKeys.add(i);
            }
            Collections.shuffle(rndKeys, new Random(123L));
        }
        WriteOptions options = new WriteOptions();
        if (this.useTTL) {
            options.setTTL(30, TimeUnit.DAYS);
        }
        Transaction txn = env.beginTransaction(null, null);
        Cursor cursor = db.openCursor(txn, null);
        boolean success = false;
        try {
            for (int i = 0; i <= lastKey; ++i) {
                int keyVal = this.orderedInsertion ? i : (Integer)rndKeys.get(i);
                byte[] keyBytes = this.padLeft(BigInteger.valueOf(keyVal).toByteArray(), maxKeyBytes);
                this.setKeyData(keyBytes, keyOffset, keyEntry, dataEntry);
                OperationResult result = cursor.put(keyEntry, dataEntry, this.duplicates ? Put.NO_DUP_DATA : Put.NO_OVERWRITE, options);
                if (result == null && !this.orderedInsertion) {
                    --i;
                    continue;
                }
                if (result == null) {
                    throw new IllegalStateException("Could not insert");
                }
                if (i % 10000 != 0) continue;
                this.checkForEviction(env, i);
                if (out == null) continue;
                out.print(".");
                out.flush();
            }
            success = true;
        }
        finally {
            cursor.close();
            if (success) {
                txn.commit();
            } else {
                txn.abort();
            }
        }
        this.checkForEviction(env, lastKey);
        env.checkpoint(new CheckpointConfig().setForce(true));
        this.iterateBINs(db, new BINVisitor(){

            @Override
            public boolean visitBIN(BIN bin) {
                bin.updateMemoryBudget();
                return true;
            }
        });
    }

    private void readRecords(PrintStream out, Environment env, Database db, boolean readData) {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        if (!readData) {
            dataEntry.setPartial(0, 0, true);
        }
        ReadOptions options = new ReadOptions();
        if (this.assumeEvictLN) {
            options.setCacheMode(CacheMode.EVICT_LN);
        }
        try (Cursor cursor = db.openCursor(null, null);){
            while (cursor.get(keyEntry, dataEntry, Get.NEXT, options) != null) {
            }
        }
    }

    private void checkForEviction(Environment env, int recNum) {
        EnvironmentStats stats = env.getStats(null);
        if (stats.getOffHeapNodesTargeted() > 0L) {
            this.getStats(System.out, env, "Out of off-heap cache");
            throw new IllegalStateException("*** Ran out of off-heap cache at record " + recNum + " -- try increasing off-heap cache size ***");
        }
        if (stats.getNNodesTargeted() > 0L) {
            this.getStats(System.out, env, "Out of main cache");
            throw new IllegalStateException("*** Ran out of main cache at record " + recNum + " -- try increasing Java heap size ***");
        }
    }

    private void trimLNs(Database db) {
        this.iterateBINs(db, new BINVisitor(){

            @Override
            public boolean visitBIN(BIN bin) {
                bin.evictLNs();
                bin.updateMemoryBudget();
                return true;
            }
        });
    }

    private void trimVLSNs(Database db) {
        this.iterateBINs(db, new BINVisitor(){

            @Override
            public boolean visitBIN(BIN bin) {
                bin.discardVLSNCache();
                bin.updateMemoryBudget();
                return true;
            }
        });
    }

    private void evictMainToDataSize(final Database db, final long dataSize) {
        if (this.getMainDataSize(db.getEnvironment()) <= dataSize) {
            return;
        }
        boolean keepGoing = this.iterateBINs(db, new BINVisitor(){

            @Override
            public boolean visitBIN(BIN bin) {
                bin.evictLNs();
                bin.discardVLSNCache();
                bin.updateMemoryBudget();
                return DbCacheSize.this.getMainDataSize(db.getEnvironment()) > dataSize;
            }
        });
        if (!keepGoing) {
            return;
        }
        final Evictor evictor = DbInternal.getNonNullEnvImpl(db.getEnvironment()).getEvictor();
        keepGoing = this.iterateBINs(db, new BINVisitor(){

            @Override
            public boolean visitBIN(BIN bin) {
                evictor.doTestEvict(bin, Evictor.EvictionSource.CACHEMODE);
                return DbCacheSize.this.getMainDataSize(db.getEnvironment()) > dataSize;
            }
        });
        assert (!keepGoing);
    }

    private boolean iterateBINs(Database db, BINVisitor visitor) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        data.setPartial(0, 0, true);
        Cursor c = db.openCursor(null, null);
        IN prevBin = null;
        boolean keepGoing = true;
        while (keepGoing && c.getNext(key, data, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) {
            BIN bin = DbInternal.getCursorImpl(c).getBIN();
            if (bin == prevBin) continue;
            if (prevBin != null) {
                prevBin.latch();
                keepGoing = visitor.visitBIN((BIN)prevBin);
                prevBin.releaseLatchIfOwner();
            }
            prevBin = bin;
        }
        c.close();
        if (keepGoing && prevBin != null) {
            prevBin.latch();
            visitor.visitBIN((BIN)prevBin);
            prevBin.releaseLatch();
        }
        return keepGoing;
    }

    private byte[] padLeft(byte[] data, int size) {
        assert (data.length <= size);
        if (data.length == size) {
            return data;
        }
        byte[] b = new byte[size];
        System.arraycopy(data, 0, b, size - data.length, data.length);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreloadStatus preloadRecords(final PrintStream out, Database db, boolean loadLNs) {
        PreloadStats stats;
        Thread thread = null;
        if (out != null) {
            thread = new Thread(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            out.print(".");
                            out.flush();
                            Thread.sleep(5000L);
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            };
            thread.start();
        }
        try {
            stats = db.preload(new PreloadConfig().setLoadLNs(loadLNs));
        }
        finally {
            if (thread != null) {
                thread.interrupt();
            }
        }
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeExceptionWrapper(e);
            }
        }
        Environment env = db.getEnvironment();
        if (this.offHeapCache) {
            env.evictMemory();
            env.getStats(StatsConfig.CLEAR);
        }
        return stats.getStatus();
    }

    private long getStats(PrintStream out, Environment env, String msg) {
        if (out != null) {
            out.println();
            out.println(msg + ':');
        }
        EnvironmentStats stats = env.getStats(null);
        long dataSize = this.getMainDataSize(env);
        if (out != null) {
            out.println("MainCache= " + INT_FORMAT.format(stats.getCacheTotalBytes()) + " Data= " + INT_FORMAT.format(dataSize) + " BINs= " + INT_FORMAT.format(stats.getNCachedBINs()) + " UINs= " + INT_FORMAT.format(stats.getNCachedUpperINs()) + " CacheMiss= " + INT_FORMAT.format(stats.getNCacheMiss()) + " OffHeapCache= " + INT_FORMAT.format(stats.getOffHeapTotalBytes()) + " OhLNs= " + INT_FORMAT.format(stats.getOffHeapCachedLNs()) + " OhBIN= " + INT_FORMAT.format(stats.getOffHeapCachedBINs()) + " OhBINDeltas= " + INT_FORMAT.format(stats.getOffHeapCachedBINDeltas()));
        }
        if (stats.getNNodesTargeted() > 0L) {
            throw new IllegalStateException("*** All records did not fit in the cache ***");
        }
        if (stats.getOffHeapNodesTargeted() > 0L) {
            throw new IllegalStateException("*** All records did not fit in the off-heap cache ***");
        }
        return dataSize;
    }

    private static interface BINVisitor {
        public boolean visitBIN(BIN var1);
    }
}

