/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog.builder;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Documentation;
import thredds.client.catalog.Property;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.ThreddsMetadata;
import thredds.client.catalog.builder.AccessBuilder;
import thredds.client.catalog.builder.CatalogRefBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.util.URLnaming;

public class CatalogBuilder {
    private static Logger logger = LoggerFactory.getLogger(CatalogBuilder.class);
    protected URI docBaseURI;
    private Map<String, Service> serviceMap = new HashMap<String, Service>();
    protected Formatter errlog = new Formatter();
    protected boolean fatalError = false;
    protected String name;
    protected String version;
    protected CalendarDate expires;
    protected URI baseURI;
    protected List<Property> properties;
    protected List<Service> services;
    protected List<DatasetBuilder> datasetBuilders;

    public Catalog buildFromCatref(CatalogRef catref) throws IOException {
        URI catrefURI = catref.getURI();
        if (catrefURI == null) {
            this.errlog.format("Catref doesnt have valid UrlPath=%s%n", catref.getUrlPath());
            this.fatalError = true;
            return null;
        }
        Catalog result = this.buildFromURI(catrefURI);
        catref.setRead(!this.fatalError);
        return result;
    }

    public Catalog buildFromLocation(String location) throws IOException {
        URI uri;
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException e) {
            this.errlog.format("Bad location = '%s' err='%s'%n", location, e.getMessage());
            this.fatalError = true;
            return null;
        }
        return this.buildFromURI(uri);
    }

    public Catalog buildFromURI(URI uri) throws IOException {
        this.setBaseURI(uri);
        this.readXML(this, uri);
        return this.makeCatalog();
    }

    public String getErrorMessage() {
        return this.errlog.toString();
    }

    public String getValidationMessage() {
        return this.errlog.toString();
    }

    public boolean hasFatalError() {
        return this.fatalError;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    public void setExpires(CalendarDate expires) {
        this.expires = expires;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void addProperty(Property p) {
        if (p == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        this.properties.add(p);
    }

    public void addService(Service s2) {
        if (s2 == null) {
            return;
        }
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        this.services.add(s2);
    }

    public void addDataset(DatasetBuilder d) {
        if (d == null) {
            return;
        }
        if (this.datasetBuilders == null) {
            this.datasetBuilders = new ArrayList<DatasetBuilder>();
        }
        this.datasetBuilders.add(d);
    }

    public Catalog makeCatalog() {
        Map<String, Object> flds = this.setFields();
        return new Catalog(this.baseURI, this.name, flds, this.datasetBuilders);
    }

    protected Map<String, Object> setFields() {
        HashMap<String, Object> flds = new HashMap<String, Object>(10);
        if (this.expires != null) {
            flds.put("Expires", this.expires);
        }
        if (this.version != null) {
            flds.put("Version", this.version);
        }
        if (this.services != null) {
            flds.put("Services", this.services);
        }
        if (this.properties != null) {
            flds.put("Properties", this.properties);
        }
        return flds;
    }

    public void readXML(CatalogBuilder catBuilder, URI uri) throws IOException {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setExpandEntities(false);
            Document jdomDoc = saxBuilder.build(uri.toURL());
            this.readCatalog(catBuilder, jdomDoc.getRootElement(), uri);
        }
        catch (Exception e) {
            this.errlog.format("failed to read catalog at '%s' err='%s'%n", uri.toString(), e);
            logger.error("failed to read catalog at {}", (Object)uri.toString(), (Object)e);
            e.printStackTrace();
            this.fatalError = true;
        }
    }

    public void readCatalog(CatalogBuilder catBuilder, Element catalogElem, URI docBaseURI) {
        this.docBaseURI = docBaseURI;
        String name = catalogElem.getAttributeValue("name");
        String catSpecifiedBaseURL = catalogElem.getAttributeValue("base");
        String expiresS = catalogElem.getAttributeValue("expires");
        String version = catalogElem.getAttributeValue("version");
        CalendarDate expires = null;
        if (expiresS != null) {
            try {
                expires = CalendarDateFormatter.isoStringToCalendarDate(null, expiresS);
            }
            catch (Exception e) {
                this.errlog.format("bad expires date '%s' err='%s'%n", expiresS, e.getMessage());
            }
        }
        URI baseURI = docBaseURI;
        if (catSpecifiedBaseURL != null) {
            try {
                baseURI = new URI(catSpecifiedBaseURL);
            }
            catch (URISyntaxException e) {
                this.errlog.format("readCatalog(): bad catalog specified base URI='%s' %n", catSpecifiedBaseURL);
                baseURI = docBaseURI;
            }
        }
        catBuilder.setName(name);
        catBuilder.setBaseURI(baseURI);
        catBuilder.setExpires(expires);
        catBuilder.setVersion(version);
        List<Element> sList = catalogElem.getChildren("service", Catalog.defNS);
        for (Element element : sList) {
            catBuilder.addService(this.readService(element));
        }
        List<Element> pList = catalogElem.getChildren("property", Catalog.defNS);
        for (Element e : pList) {
            catBuilder.addProperty(this.readProperty(e));
        }
        List<Element> list = catalogElem.getChildren();
        for (Element e : list) {
            if (e.getName().equals("dataset")) {
                catBuilder.addDataset(this.readDataset(null, e));
                continue;
            }
            if (e.getName().equals("catalogRef")) {
                catBuilder.addDataset(this.readCatalogRef(null, e));
                continue;
            }
            catBuilder.addDataset(this.buildOtherDataset(null, e));
        }
    }

    protected DatasetBuilder buildOtherDataset(DatasetBuilder parent, Element dsElem) {
        return null;
    }

    protected AccessBuilder readAccess(DatasetBuilder dataset, Element accessElem) {
        String urlPath = accessElem.getAttributeValue("urlPath");
        String serviceName = accessElem.getAttributeValue("serviceName");
        String dataFormat = accessElem.getAttributeValue("dataFormat");
        Service s2 = this.serviceMap.get(serviceName);
        if (s2 == null) {
            this.errlog.format("Cant find service name='%s'%n", serviceName);
        }
        return new AccessBuilder(dataset, urlPath, s2, dataFormat, this.readDataSize(accessElem));
    }

    protected Property readProperty(Element s2) {
        String name = s2.getAttributeValue("name");
        String value = s2.getAttributeValue("value");
        return new Property(name, value);
    }

    protected Service readService(Element s2) {
        String name = s2.getAttributeValue("name");
        String typeS = s2.getAttributeValue("serviceType");
        String serviceBase = s2.getAttributeValue("base");
        String suffix = s2.getAttributeValue("suffix");
        String desc = s2.getAttributeValue("desc");
        ServiceType type = ServiceType.getServiceTypeIgnoreCase(typeS);
        if (type == null) {
            this.errlog.format(" non-standard service type = '%s'%n", typeS);
        }
        ArrayList<Property> properties = null;
        List<Element> propertyList = s2.getChildren("property", Catalog.defNS);
        for (Element e : propertyList) {
            if (properties == null) {
                properties = new ArrayList<Property>();
            }
            properties.add(this.readProperty(e));
        }
        ArrayList<Service> services = null;
        List<Element> serviceList = s2.getChildren("service", Catalog.defNS);
        for (Element e : serviceList) {
            if (services == null) {
                services = new ArrayList<Service>();
            }
            services.add(this.readService(e));
        }
        Service result = new Service(name, serviceBase, typeS, desc, suffix, services, properties);
        this.serviceMap.put(name, result);
        return result;
    }

    protected DatasetBuilder readCatalogRef(DatasetBuilder parent, Element catRefElem) {
        String title = catRefElem.getAttributeValue("title", Catalog.xlinkNS);
        if (title == null) {
            title = catRefElem.getAttributeValue("name");
        }
        String href = catRefElem.getAttributeValue("href", Catalog.xlinkNS);
        CatalogRefBuilder catRef = new CatalogRefBuilder(parent);
        this.readDatasetInfo(catRef, catRefElem);
        catRef.setTitle(title);
        catRef.setHref(href);
        return catRef;
    }

    protected DatasetBuilder readDataset(DatasetBuilder parent, Element dsElem) {
        DatasetBuilder dataset = new DatasetBuilder(parent);
        this.readDatasetInfo(dataset, dsElem);
        List<Element> aList = dsElem.getChildren("access", Catalog.defNS);
        for (Element e : aList) {
            dataset.addAccess(this.readAccess(dataset, e));
        }
        List<Element> allChildren = dsElem.getChildren();
        for (Element e : allChildren) {
            if (e.getName().equals("dataset")) {
                dataset.addDataset(this.readDataset(dataset, e));
                continue;
            }
            if (e.getName().equals("catalogRef")) {
                dataset.addDataset(this.readCatalogRef(dataset, e));
                continue;
            }
            dataset.addDataset(this.buildOtherDataset(dataset, e));
        }
        return dataset;
    }

    protected void readDatasetInfo(DatasetBuilder dataset, Element dsElem) {
        String harvest;
        FeatureType dataType;
        String name = dsElem.getAttributeValue("name");
        if (name == null) {
            if (dsElem.getName().equals("catalogRef")) {
                dataset.setName("");
            } else {
                this.errlog.format(" ** warning: dataset must have a name = '%s'%n", dsElem);
            }
        } else {
            dataset.setName(name);
        }
        dataset.put("Alias", dsElem.getAttributeValue("alias"));
        dataset.put("Authority", dsElem.getAttributeValue("authority"));
        dataset.put("CollectionType", dsElem.getAttributeValue("collectionType"));
        dataset.put("Id", dsElem.getAttributeValue("ID"));
        dataset.putInheritedField("RestrictAccess", dsElem.getAttributeValue("restrictAccess"));
        dataset.put("ServiceName", dsElem.getAttributeValue("serviceName"));
        dataset.put("UrlPath", dsElem.getAttributeValue("urlPath"));
        String dataTypeName = dsElem.getAttributeValue("dataType");
        dataset.put("FeatureType", dataTypeName);
        if (dataTypeName != null && (dataType = FeatureType.getType(dataTypeName.toUpperCase())) == null) {
            this.errlog.format(" ** warning: non-standard data type = '%s'%n", dataTypeName);
        }
        if ((harvest = dsElem.getAttributeValue("harvest")) != null && harvest.equalsIgnoreCase("true")) {
            dataset.put("Harvest", Boolean.TRUE);
        }
        this.readThreddsMetadataGroup(dataset.flds, dataset, dsElem);
    }

    protected void readThreddsMetadataGroup(Map<String, Object> flds, DatasetBuilder dataset, Element parent) {
        ThreddsMetadata.UriResolved mapUri;
        long size;
        String dataFormatTypeName;
        Element dataFormatElem;
        Element dataTypeElem;
        Element authElem;
        Element serviceNameElem;
        DateRange tc;
        List<Element> list = parent.getChildren("creator", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Creators", this.readSource(e));
        }
        list = parent.getChildren("contributor", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Contributors", this.readContributor(e));
        }
        list = parent.getChildren("date", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Dates", this.readDate(e));
        }
        list = parent.getChildren("documentation", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Documentation", this.readDocumentation(e));
        }
        list = parent.getChildren("keyword", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Keywords", this.readControlledVocabulary(e));
        }
        list = parent.getChildren("metadata", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "MetadataOther", this.readMetadata(flds, dataset, e));
        }
        list = parent.getChildren("project", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Projects", this.readControlledVocabulary(e));
        }
        list = parent.getChildren("property", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Properties", this.readProperty(e));
        }
        list = parent.getChildren("publisher", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "Publishers", this.readSource(e));
        }
        list = parent.getChildren("variables", Catalog.defNS);
        for (Element e : list) {
            DatasetBuilder.addToList(flds, "VariableGroups", this.readVariables(e));
        }
        ThreddsMetadata.GeospatialCoverage gc = this.readGeospatialCoverage(parent.getChild("geospatialCoverage", Catalog.defNS));
        if (gc != null) {
            flds.put("GeospatialCoverage", gc);
        }
        if ((tc = this.readTimeCoverage(parent.getChild("timeCoverage", Catalog.defNS))) != null) {
            flds.put("TimeCoverage", tc);
        }
        if ((serviceNameElem = parent.getChild("serviceName", Catalog.defNS)) != null) {
            flds.put("ServiceName", serviceNameElem.getText());
        }
        if ((authElem = parent.getChild("authority", Catalog.defNS)) != null) {
            flds.put("Authority", authElem.getText());
        }
        if ((dataTypeElem = parent.getChild("dataType", Catalog.defNS)) != null) {
            FeatureType dataType;
            String dataTypeName = dataTypeElem.getText();
            flds.put("FeatureType", dataTypeName);
            if (dataTypeName != null && dataTypeName.length() > 0 && (dataType = FeatureType.getType(dataTypeName.toUpperCase())) == null) {
                this.errlog.format(" ** warning: non-standard feature type = '%s'%n", dataTypeName);
            }
        }
        if ((dataFormatElem = parent.getChild("dataFormat", Catalog.defNS)) != null && (dataFormatTypeName = dataFormatElem.getText()) != null && dataFormatTypeName.length() > 0) {
            DataFormatType dataFormatType = DataFormatType.getType(dataFormatTypeName);
            if (dataFormatType == null) {
                this.errlog.format(" ** warning: non-standard dataFormat type = '%s'%n", dataFormatTypeName);
            }
            flds.put("DataFormatType", dataFormatTypeName);
        }
        if ((size = this.readDataSize(parent)) > 0L) {
            flds.put("DataSize", size);
        }
        if ((mapUri = this.readUri(parent.getChild("variableMap", Catalog.defNS), "variableMap")) != null) {
            flds.put("VariableMapLink", mapUri);
        }
    }

    protected ThreddsMetadata.Contributor readContributor(Element elem) {
        if (elem == null) {
            return null;
        }
        return new ThreddsMetadata.Contributor(elem.getText(), elem.getAttributeValue("role"));
    }

    protected long readDataSize(Element parent) {
        double size;
        Element elem = parent.getChild("dataSize", Catalog.defNS);
        if (elem == null) {
            return -1L;
        }
        String sizeS = elem.getText();
        try {
            size = Double.parseDouble(sizeS);
        }
        catch (NumberFormatException e) {
            this.errlog.format(" ** Parse error: Bad double format in size element = '%s'%n", sizeS);
            return -1L;
        }
        String units = elem.getAttributeValue("units");
        char c = Character.toUpperCase(units.charAt(0));
        if (c == 'K') {
            size *= 1000.0;
        } else if (c == 'M') {
            size *= 1000000.0;
        } else if (c == 'G') {
            size *= 1.0E9;
        } else if (c == 'T') {
            size *= 1.0E12;
        } else if (c == 'P') {
            size *= 1.0E15;
        }
        return (long)size;
    }

    protected Documentation readDocumentation(Element s2) {
        String href = s2.getAttributeValue("href", Catalog.xlinkNS);
        String title = s2.getAttributeValue("title", Catalog.xlinkNS);
        String type = s2.getAttributeValue("type");
        String content = s2.getTextNormalize();
        URI uri = null;
        if (href != null) {
            try {
                uri = Catalog.resolveUri(this.baseURI, href);
            }
            catch (Exception e) {
                this.errlog.format(" ** Invalid documentation href = '%s' err='%s'%n", href, e.getMessage());
            }
        }
        return new Documentation(href, uri, title, type, content);
    }

    protected double readDouble(Element elem) {
        if (elem == null) {
            return Double.NaN;
        }
        String text = elem.getText();
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            this.errlog.format(" ** Parse error: Bad double format = '%s'%n", text);
            return Double.NaN;
        }
    }

    protected ThreddsMetadata.GeospatialCoverage readGeospatialCoverage(Element gcElem) {
        if (gcElem == null) {
            return null;
        }
        String zpositive = gcElem.getAttributeValue("zpositive");
        ThreddsMetadata.GeospatialRange northsouth = this.readGeospatialRange(gcElem.getChild("northsouth", Catalog.defNS), "degrees_north");
        ThreddsMetadata.GeospatialRange eastwest = this.readGeospatialRange(gcElem.getChild("eastwest", Catalog.defNS), "degrees_east");
        ThreddsMetadata.GeospatialRange updown = this.readGeospatialRange(gcElem.getChild("updown", Catalog.defNS), "m");
        ArrayList<ThreddsMetadata.Vocab> names = new ArrayList<ThreddsMetadata.Vocab>();
        List<Element> list = gcElem.getChildren("name", Catalog.defNS);
        for (Element e : list) {
            ThreddsMetadata.Vocab name = this.readControlledVocabulary(e);
            names.add(name);
        }
        return new ThreddsMetadata.GeospatialCoverage(eastwest, northsouth, updown, names, zpositive);
    }

    protected ThreddsMetadata.GeospatialRange readGeospatialRange(Element spElem, String defUnits) {
        if (spElem == null) {
            return null;
        }
        double start = this.readDouble(spElem.getChild("start", Catalog.defNS));
        double size = this.readDouble(spElem.getChild("size", Catalog.defNS));
        double resolution = this.readDouble(spElem.getChild("resolution", Catalog.defNS));
        String units = spElem.getChildText("units", Catalog.defNS);
        if (units == null) {
            units = defUnits;
        }
        return new ThreddsMetadata.GeospatialRange(start, size, resolution, units);
    }

    protected ThreddsMetadata.MetadataOther readMetadata(Map<String, Object> flds, DatasetBuilder dataset, Element mdataElement) {
        Map<String, Object> useFlds;
        boolean isThreddsNamespace;
        List<Element> inlineElements = mdataElement.getChildren();
        Namespace namespace = inlineElements.size() > 0 ? inlineElements.get(0).getNamespace() : mdataElement.getNamespace();
        String mtype = mdataElement.getAttributeValue("metadataType");
        String href = mdataElement.getAttributeValue("href", Catalog.xlinkNS);
        String title = mdataElement.getAttributeValue("title", Catalog.xlinkNS);
        String inheritedS = mdataElement.getAttributeValue("inherited");
        boolean inherited = inheritedS != null && inheritedS.equalsIgnoreCase("true");
        boolean bl = isThreddsNamespace = (mtype == null || mtype.equalsIgnoreCase("THREDDS")) && namespace.getURI().equals("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0");
        if (!isThreddsNamespace) {
            if (inlineElements.size() > 0) {
                return new ThreddsMetadata.MetadataOther(mtype, namespace.getURI(), namespace.getPrefix(), inherited, mdataElement);
            }
            return new ThreddsMetadata.MetadataOther(href, title, mtype, namespace.getURI(), namespace.getPrefix(), inherited);
        }
        if (inherited) {
            ThreddsMetadata tmi = (ThreddsMetadata)dataset.get("ThreddsMetadataInheritable");
            if (tmi == null) {
                tmi = new ThreddsMetadata();
                dataset.put("ThreddsMetadataInheritable", tmi);
            }
            useFlds = tmi.getFlds();
        } else {
            useFlds = flds;
        }
        this.readThreddsMetadataGroup(useFlds, dataset, mdataElement);
        if (href != null) {
            try {
                URI xlinkUri = Catalog.resolveUri(this.baseURI, href);
                Element remoteMdata = this.readMetadataFromUrl(xlinkUri);
                return this.readMetadata(useFlds, dataset, remoteMdata);
            }
            catch (Exception ioe) {
                this.errlog.format("Cant read in referenced metadata %s err=%s%n", href, ioe.getMessage());
            }
        }
        return null;
    }

    private Element readMetadataFromUrl(URI uri) throws IOException {
        Document doc;
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setExpandEntities(false);
        try {
            doc = saxBuilder.build(uri.toURL());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return doc.getRootElement();
    }

    protected ThreddsMetadata.Source readSource(Element elem) {
        if (elem == null) {
            return null;
        }
        ThreddsMetadata.Vocab name = this.readControlledVocabulary(elem.getChild("name", Catalog.defNS));
        Element contact = elem.getChild("contact", Catalog.defNS);
        if (contact == null) {
            this.errlog.format(" ** Parse error: Missing contact element in = '%s'%n", elem.getName());
            return null;
        }
        return new ThreddsMetadata.Source(name, contact.getAttributeValue("url"), contact.getAttributeValue("email"));
    }

    protected DateRange readTimeCoverage(Element tElem) {
        if (tElem == null) {
            return null;
        }
        DateType start = this.readDate(tElem.getChild("start", Catalog.defNS));
        DateType end = this.readDate(tElem.getChild("end", Catalog.defNS));
        TimeDuration duration = this.readDuration(tElem.getChild("duration", Catalog.defNS));
        TimeDuration resolution = this.readDuration(tElem.getChild("resolution", Catalog.defNS));
        try {
            return new DateRange(start, end, duration, resolution);
        }
        catch (IllegalArgumentException e) {
            this.errlog.format(" ** warning: TimeCoverage error ='%s'%n", e.getMessage());
            return null;
        }
    }

    protected DateType readDate(Element elem) {
        if (elem == null) {
            return null;
        }
        String format = elem.getAttributeValue("format");
        String type = elem.getAttributeValue("type");
        return this.makeDateType(elem.getText(), format, type);
    }

    protected DateType makeDateType(String text, String format, String type) {
        if (text == null) {
            return null;
        }
        try {
            return new DateType(text, format, type);
        }
        catch (ParseException e) {
            this.errlog.format(" ** Parse error: Bad date format = '%s'%n", text);
            return null;
        }
    }

    protected TimeDuration readDuration(Element elem) {
        if (elem == null) {
            return null;
        }
        String text = null;
        try {
            text = elem.getText();
            return new TimeDuration(text);
        }
        catch (ParseException e) {
            this.errlog.format(" ** Parse error: Bad duration format = '%s'%n", text);
            return null;
        }
    }

    protected ThreddsMetadata.VariableGroup readVariables(Element varsElem) {
        if (varsElem == null) {
            return null;
        }
        String vocab = varsElem.getAttributeValue("vocabulary");
        ThreddsMetadata.UriResolved variableVocabUri = this.readUri(varsElem, "Variables vocabulary");
        List<Element> vlist = varsElem.getChildren("variable", Catalog.defNS);
        ThreddsMetadata.UriResolved variableMap = this.readUri(varsElem.getChild("variableMap", Catalog.defNS), "Variables Map");
        if (variableMap != null && vlist.size() > 0) {
            this.errlog.format(" ** Catalog error: cant have variableMap and variable in same element '%s'%n", varsElem);
        }
        ArrayList<ThreddsMetadata.Variable> variables = new ArrayList<ThreddsMetadata.Variable>();
        for (Element e : vlist) {
            variables.add(CatalogBuilder.readVariable(e));
        }
        return new ThreddsMetadata.VariableGroup(vocab, variableVocabUri, variableMap, variables);
    }

    public static ThreddsMetadata.Variable readVariable(Element varElem) {
        if (varElem == null) {
            return null;
        }
        String name = varElem.getAttributeValue("name");
        String desc = varElem.getText();
        String vocabulary_name = varElem.getAttributeValue("vocabulary_name");
        String units = varElem.getAttributeValue("units");
        String id = varElem.getAttributeValue("vocabulary_id");
        return new ThreddsMetadata.Variable(name, desc, vocabulary_name, units, id);
    }

    protected ThreddsMetadata.Vocab readControlledVocabulary(Element elem) {
        if (elem == null) {
            return null;
        }
        return new ThreddsMetadata.Vocab(elem.getText(), elem.getAttributeValue("vocabulary"));
    }

    private ThreddsMetadata.UriResolved readUri(Element elemWithHref, String what) {
        if (elemWithHref == null) {
            return null;
        }
        String mapHref = elemWithHref.getAttributeValue("href", Catalog.xlinkNS);
        if (mapHref == null) {
            return null;
        }
        try {
            String mapUri = URLnaming.resolve(this.docBaseURI.toString(), mapHref);
            return new ThreddsMetadata.UriResolved(mapHref, new URI(mapUri));
        }
        catch (Exception e) {
            this.errlog.format(" ** Invalid %s URI= '%s' err='%s'%n", what, mapHref, e.getMessage());
            return null;
        }
    }

    public static interface Callback {
        public void setCatalog(Catalog var1);
    }
}

