/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableD;
import ucar.nc2.wmo.Util;
import ucar.unidata.util.StringUtil2;

public class WmoXmlReader {
    static void readWmoXmlTableB(InputStream ios, TableB b) throws IOException {
        Version v;
        List<Element> featList;
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            doc = builder.build(ios);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        Element root = doc.getRootElement();
        String[] elems = null;
        Version[] versionArray = Version.values();
        int n = versionArray.length;
        for (int i = 0; i < n && ((featList = root.getChildren((elems = (v = versionArray[i]).getElemNamesB())[0])) == null || featList.size() <= 0); ++i) {
        }
        if (elems == null) {
            elems = Version.BUFR_WMO.getElemNamesB();
        }
        List<Element> featList2 = root.getChildren();
        for (Element elem : featList2) {
            Element ce = elem.getChild(elems[1]);
            if (ce == null) continue;
            String name = Util.cleanName(elem.getChildTextNormalize(elems[1]));
            String units = WmoXmlReader.cleanUnit(elem.getChildTextNormalize("BUFR_Unit"));
            int x = 0;
            int y = 0;
            int scale = 0;
            int reference = 0;
            int width = 0;
            String fxy = null;
            String s2 = null;
            try {
                fxy = elem.getChildTextNormalize("FXY");
                int xy = Integer.parseInt(WmoXmlReader.cleanNumber(fxy));
                x = xy / 1000;
                y = xy % 1000;
            }
            catch (NumberFormatException e) {
                System.out.printf(" key %s name '%s' fails parsing %n", fxy, name);
            }
            try {
                s2 = elem.getChildTextNormalize("BUFR_Scale");
                scale = Integer.parseInt(WmoXmlReader.cleanNumber(s2));
            }
            catch (NumberFormatException e) {
                System.out.printf(" key %s name '%s' has bad scale='%s'%n", fxy, name, s2);
            }
            try {
                s2 = elem.getChildTextNormalize("BUFR_ReferenceValue");
                reference = Integer.parseInt(WmoXmlReader.cleanNumber(s2));
            }
            catch (NumberFormatException e) {
                System.out.printf(" key %s name '%s' has bad reference='%s' %n", fxy, name, s2);
            }
            try {
                s2 = elem.getChildTextNormalize("BUFR_DataWidth_Bits");
                width = Integer.parseInt(WmoXmlReader.cleanNumber(s2));
            }
            catch (NumberFormatException e) {
                System.out.printf(" key %s name '%s' has bad width='%s' %n", fxy, name, s2);
            }
            b.addDescriptor((short)x, (short)y, scale, reference, width, name, units, null);
        }
        ios.close();
    }

    static String cleanNumber(String s2) {
        return StringUtil2.remove(s2, 32);
    }

    public static String cleanUnit(String unit) {
        String result = StringUtil2.remove(unit, 176);
        return StringUtil2.replace(result, '\ufffd', "2");
    }

    static void readWmoXmlTableD(InputStream ios, TableD tableD) throws IOException {
        Version v;
        List<Element> featList;
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            doc = builder.build(ios);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        int currSeqno = -1;
        TableD.Descriptor currDesc = null;
        Element root = doc.getRootElement();
        String[] elems = null;
        Version[] versionArray = Version.values();
        int n = versionArray.length;
        for (int i = 0; i < n && ((featList = root.getChildren((elems = (v = versionArray[i]).getElemNamesD())[0])) == null || featList.size() <= 0); ++i) {
        }
        if (elems == null) {
            elems = Version.BUFR_WMO.getElemNamesD();
        }
        List<Element> featList2 = root.getChildren();
        for (Element elem : featList2) {
            Element ce = elem.getChild(elems[1]);
            if (ce == null) continue;
            String seqs = elem.getChildTextNormalize("FXY1");
            int seq = Integer.parseInt(seqs);
            if (currSeqno != seq) {
                int y = seq % 1000;
                int w = seq / 1000;
                int x = w % 100;
                String seqName = Util.cleanName(elem.getChildTextNormalize(elems[1]));
                currDesc = tableD.addDescriptor((short)x, (short)y, seqName, new ArrayList<Short>());
                currSeqno = seq;
            }
            String fnos = elem.getChildTextNormalize("FXY2");
            int fno = Integer.parseInt(fnos);
            int y = fno % 1000;
            int w = fno / 1000;
            int x = w % 100;
            int f = w / 100;
            int fxy = (f << 14) + (x << 8) + y;
            currDesc.addFeature((short)fxy);
        }
        ios.close();
    }

    public static enum Version {
        BUFR_14_1_0,
        BUFR_14_2_0,
        BUFR_15_1_1,
        BUFR_16_0_0,
        BUFR_WMO;


        String[] getElemNamesB() {
            if (this == BUFR_14_1_0) {
                return new String[]{"BC_TableB_BUFR14_1_0_CREX_6_1_0", "ElementName_E"};
            }
            if (this == BUFR_14_2_0) {
                return new String[]{"Exporting_BCTableB_E", "ElementName"};
            }
            if (this == BUFR_15_1_1) {
                return new String[]{"Exp_JointTableB_E", "ElementName_E"};
            }
            if (this == BUFR_16_0_0) {
                return new String[]{"Exp_BUFRCREXTableB_E", "ElementName_E"};
            }
            if (this == BUFR_WMO) {
                return new String[]{null, "ElementName_en"};
            }
            return null;
        }

        String[] getElemNamesD() {
            if (this == BUFR_14_1_0) {
                return new String[]{"B_TableD_BUFR14_1_0_CREX_6_1_0", "ElementName1_E"};
            }
            if (this == BUFR_14_2_0) {
                return new String[]{"Exporting_BUFRTableD_E", "ElementName1"};
            }
            if (this == BUFR_15_1_1) {
                return new String[]{"Exp_BUFRTableD_E", "ElementName_E"};
            }
            if (this == BUFR_16_0_0) {
                return new String[]{"Exp_BUFRTableD_E", "ElementName_E"};
            }
            if (this == BUFR_WMO) {
                return new String[]{null, "ElementName_en"};
            }
            return null;
        }
    }
}

