/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.arbiter.impl;

import com.sleepycat.je.rep.arbiter.impl.ArbiterImpl;
import com.sleepycat.je.rep.impl.NodeStateProtocol;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.util.logging.Logger;

public class ArbiterNodeStateService
extends ServiceDispatcher.ExecutingService {
    private final NodeStateProtocol protocol;
    private final Logger logger;
    private final ArbiterImpl arbImpl;
    public static final String SERVICE_NAME = "NodeState";

    public ArbiterNodeStateService(ServiceDispatcher dispatcher, ArbiterImpl arbImpl) {
        super(SERVICE_NAME, dispatcher);
        this.arbImpl = arbImpl;
        this.protocol = new NodeStateProtocol(arbImpl.getGroupName(), arbImpl.getNameIdPair(), arbImpl.getRepImpl(), dispatcher.getChannelFactory());
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    public TextProtocol.ResponseMessage process(NodeStateProtocol.NodeStateRequest stateRequest) {
        NodeStateProtocol nodeStateProtocol = this.protocol;
        nodeStateProtocol.getClass();
        return new NodeStateProtocol.NodeStateResponse(nodeStateProtocol, this.arbImpl.getNameIdPair().getName(), this.arbImpl.getMasterStatus().getNodeMasterNameId().getName(), this.arbImpl.getJoinGroupTime(), this.arbImpl.getNodeState());
    }

    @Override
    public Runnable getRunnable(DataChannel dataChannel) {
        return new NodeStateServiceRunnable(dataChannel, this.protocol);
    }

    class NodeStateServiceRunnable
    extends ServiceDispatcher.ExecutingRunnable {
        NodeStateServiceRunnable(DataChannel dataChannel, NodeStateProtocol protocol) {
            super(dataChannel, protocol, true);
        }

        @Override
        protected TextProtocol.ResponseMessage getResponse(TextProtocol.RequestMessage request) throws IOException {
            return this.protocol.process(ArbiterNodeStateService.this, request);
        }

        @Override
        protected void logMessage(String message) {
            LoggerUtils.warning(ArbiterNodeStateService.this.logger, ArbiterNodeStateService.this.arbImpl.getRepImpl(), message);
        }
    }
}

